﻿# This file is in the public domain. Feel free to modify it as a basis
# for your own screens.

# Note that many of these screens may be given additional arguments in the
# future. The use of **kwargs in the parameter list ensures your code will
# work in the future.
# init python:

    # # Define function to open the menu
    # def scroll_up():
        # if renpy.get_screen("load"):
            # ui.button.FilePagePrevious(max=1)

    # # Add key to 'open_pause_menu', this case is 'a' on keyboard
    # config.keymap["scrollup"] = ["a"]
    
    # # When key is pressed at anytime, open custom screen.
    # config.underlay.append(renpy.Keymap(scrollup=scroll_up))
##############################################################################
# Say
#
# Screen that's used to display adv-mode dialogue.
# http://www.renpy.org/doc/html/screen_special.html#say
screen say(who, what, side_image=None, two_window=True):
    add "gui/textbox.png" xpos 0 ypos 545

    # Decide if we want to use the one-window or two-window variant.
    if not two_window:

        # The one window variant.
        window:
            id "window"

            has vbox:
                style "say_vbox"

            if who:
                text who id "who"

            text what id "what"

    else:

        # The two window variant.
        vbox:
            style "say_two_window_vbox"

            if who:
                window:
                    style "say_who_window"

                    text who:
                        id "who"

            window:
                id "window"

                has vbox:
                    style "say_vbox"

                text what id "what"

    # If there's a side image, display it above the text.
    if side_image:
        add side_image
    else:
        add SideImage() xalign 0.0 yalign 1.0

    # Use the quick menu.
    use quick_menu


##############################################################################
# Choice
#
# Screen that's used to display in-game menus.
# http://www.renpy.org/doc/html/screen_special.html#choice

screen choice(items):
    add "gui/choices.png" xalign 0.5 yalign 0.6
        
    window:
        
        style "menu_window"
        xalign 0.5
        yalign 0.5

        vbox:
            style "menu"
            spacing 2

            for caption, action, chosen in items:

                if action:

                    button:
                        action action
                        style "menu_choice_button"

                        text caption style "menu_choice"

                else:
                    text caption style "menu_caption"

init -2:
    $ config.narrator_menu = True

    style menu_window is default

    style menu_choice is button_text:
        clear

    style menu_choice_button is button:
        idle_background Frame("gui/choice_idle.png", 25, 25)
        hover_background Frame("gui/choice_hover.png", 25, 25)
        xminimum int(config.screen_width * 0.60)
        xmaximum int(config.screen_width * 0.60)

#init -2:
#    style quick_button:
#        is default
#        background None
#        xpadding 5

#    style quick_button_text:
#        is default
#        size 16
#        idle_color "#8888"
#        hover_color "#ccc"
#        selected_idle_color "#cc08"
#        selected_hover_color "#cc0"
#        insensitive_color "#4448"



#    window:
        
#        style "menu_window"
#        xalign 0.5
#        yalign 0.5

#        vbox:
#            style "menu"
#            spacing 2

#            for caption, action, chosen in items:

#                if action:

#                    button:
#                        action action
#                        style "menu_choice_button"

#                        text caption style "menu_choice"

#                else:
#                    text caption style "menu_caption"

#init -2:
#    $ config.narrator_menu = True

#    style menu_window is default

#    style menu_choice is button_text:
#        clear

#    style menu_choice_button is button:
#        xminimum int(config.screen_width * 0.60)
#        xmaximum int(config.screen_width * 0.60)


##############################################################################
# Input
#
# Screen that's used to display renpy.input()
# http://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):

    window style "input_window":
        has vbox

        text prompt style "input_prompt"
        input id "input" style "input_text"

    use quick_menu

##############################################################################
# Nvl
#
# Screen used for nvl-mode dialogue and menus.
# http://www.renpy.org/doc/html/screen_special.html#nvl

screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            style "nvl_vbox"

        # Display dialogue.
        for who, what, who_id, what_id, window_id in dialogue:
            window:
                id window_id

                has hbox:
                    spacing 10

                if who is not None:
                    text who id who_id

                text what id what_id

        # Display a menu, if given.
        if items:

            vbox:
                id "menu"

                for caption, action, chosen in items:

                    if action:

                        button:
                            style "nvl_menu_choice_button"
                            action action

                            text caption style "nvl_menu_choice"

                    else:

                        text caption style "nvl_dialogue"

    add SideImage() xalign 0.0 yalign 1.0

    use quick_menu

##############################################################################
# Main Menu
#
# Screen that's used to display the main menu, when Ren'Py first starts
# http://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    # This ensures that any other menu screen is replaced.
    tag menu

    # The background of the main menu.
    window:
        style "mm_root"
        if persistent.title == 2:
            add "gui/title2t.png"
        else:
            add "gui/title1.png"

    # The main menu buttons.
    imagemap:
        xalign .98
        yalign .98
        ground "gui/main_idle.png"
        hover "gui/main_hover.png"
        
        hotspot (1, 1, 126, 29) clicked Start() focus_mask None
        hotspot (1, 32, 126, 34) clicked ShowMenu("load") focus_mask None
        hotspot (1, 73, 126, 34) clicked ShowMenu("preferences") focus_mask None
        hotspot (1, 110, 126, 34) clicked ShowMenu("cg_gallery") focus_mask None
        hotspot (1, 146, 126, 34) action OpenURL("https://www.patreon.com/sierralee") focus_mask None
        hotspot (1, 180, 126, 34) clicked ShowMenu("credits") focus_mask None
        hotspot (1, 216, 126, 34) clicked Quit(confirm=False) focus_mask None
        
#    frame:
#        style_group "mm"
#        xalign .98
#        yalign .98

#        has vbox

#        textbutton _("Start Game") action Start()
#        textbutton _("Load Game") action ShowMenu("load")
#        textbutton _("Gallery") action ShowMenu("cg_gallery")
#        textbutton _("Patreon") action OpenURL("https://www.patreon.com/sierralee")
#        textbutton _("Credits") action ShowMenu("credits")
#        textbutton _("Options") action ShowMenu("preferences")
#        textbutton _("Quit") action Quit(confirm=False)

init -2:

    # Make all the main menu buttons be the same size.
    style mm_button:
        size_group "mm"



##############################################################################
# Navigation
#
# Screen that's included in other screens to display the game menu
# navigation and background.
# http://www.renpy.org/doc/html/screen_special.html#navigation
screen navigation():

    # The background of the game menu.
    window:
        style "gm_root"

    # The various buttons.
    frame:
        style_group "gm_nav"
        xalign .98
        yalign .98

        has vbox

        textbutton _("Return") action Return()
        textbutton _("Options") action ShowMenu("preferences")
        textbutton _("Save Game") action ShowMenu("save")
        textbutton _("Load Game") action ShowMenu("load")
        textbutton _("Main Menu") action MainMenu()
        #textbutton _("Help") action Help()
        textbutton _("Quit") action Quit()

init -2:

    # Make all game menu navigation buttons the same size.
    style gm_nav_button:
        size_group "gm_nav"


##############################################################################
# Save, Load
#
# Screens that allow the user to save and load the game.
# http://www.renpy.org/doc/html/screen_special.html#save
# http://www.renpy.org/doc/html/screen_special.html#load

# Since saving and loading are so similar, we combine them into
# a single screen, file_picker. We then use the file_picker screen
# from simple load and save screens.

screen file_picker():

    frame:
        style "file_picker_frame"

        has vbox

        # The buttons at the top allow the user to pick a
        # page of files.
        hbox:
            style_group "file_picker_nav"

           

            for i in range(1, 8):
                textbutton str(i):
                    action FilePage(i)

           

        $ columns = 2
        $ rows = 5

        # Display a grid of file slots.
        grid columns rows:
            transpose True
            xfill True
            style_group "file_picker"

            # Display ten file slots, numbered 1 - 10.
            for i in range(1, columns * rows + 1):

                # Each file slot is a button.
                button:
                    action FileAction(i)
                    xfill True

                    has hbox

                    # Add the screenshot.
                    add FileScreenshot(i)

                    $ file_name = FileSlotName(i, columns * rows)
                    $ file_time = FileTime(i, empty=_("Empty Slot."))
                    $ save_name = FileSaveName(i)

                    text "[file_name]. [file_time!t]\n[save_name!t]"  xpos 0.80 ypos 50 size 24 color "#FFF"

                    key "save_delete" action FileDelete(i)



screen save():

    # This ensures that any other menu screen is replaced.
    add "gui/saveback.png"
    modal True

    #use navigation
    #use file_picker



    imagemap:
        ground "gui/loadsave_ground.png"
        idle "gui/loadsave_idle.png"
        hover "gui/loadsave_hover.png"
        selected_idle "gui/loadsave_hover.png"
        cache False

        hotspot (973,390,24,24) clicked FilePage(1) 
        hotspot (973,428,24,24)  clicked FilePage(2) 
        hotspot (973,468,24,24) clicked FilePage(3)
        hotspot (973,505,24,24) clicked FilePage(4)
        hotspot (973,543,24,24) clicked FilePage(5) 
        hotspot (973,583,24,24) clicked FilePage(6)
        hotspot (973,620,24,24) clicked FilePage(7) 
        hotspot (973,660,24,24) clicked FilePage(8)
        hotspot (964,698,35,20) action FilePageNext(max=8)
        hotspot (964,355,35,20) action FilePagePrevious(max=1)
        hotspot (1040,40,42,40) action [Return(), Hide("save"), Show("say")] focus_mask None

        hotspot (190,337,224,176) clicked FileSave(1):
            use load_save_slot(number=1)
        hotspot (440,337,224,176)  clicked FileSave(2):
            use load_save_slot(number=2) 
        hotspot (690,337,224,176)clicked FileSave(3):
            use load_save_slot(number=3)
        hotspot (190,553,224,176) clicked FileSave(4):
            use load_save_slot(number=4)
        hotspot (440,553,224,176)  clicked FileSave(5):
            use load_save_slot(number=5) 
        hotspot (690,553,224,176)clicked FileSave(6):
            use load_save_slot(number=6)

       
        
        hotspot (187, 250, 54, 25) action [ShowMenu("save"), Hide("save")] focus_mask None
        hotspot (300, 250, 55, 24) action [ShowMenu("load"), Hide("save")] focus_mask None
        hotspot (415, 250, 50, 20) action Quit() focus_mask None
        hotspot (525, 250, 90, 21) action [ShowMenu("preferences"), Hide("save")] focus_mask None
        hotspot (675, 250, 125, 21) action [MainMenu(), Hide("save")]   focus_mask None
        hotspot (856, 250, 78, 20) action [Return(), Hide("save"), Show("say")]  focus_mask None
        

screen load():

    # This ensures that any other menu screen is replaced.
    add "gui/loadback.png"
    modal True
    #use navigation
    #use file_picker
    imagemap:
        ground "gui/loadsave_ground.png"
        idle "gui/loadsave_idle.png"
        hover "gui/loadsave_hover.png"
        selected_idle "gui/loadsave_hover.png"

        hotspot (973,390,24,24) clicked FilePage(1) 
        hotspot (973,428,24,24)  clicked FilePage(2) 
        hotspot (973,468,24,24) clicked FilePage(3)
        hotspot (973,505,24,24) clicked FilePage(4)
        hotspot (973,543,24,24) clicked FilePage(5) 
        hotspot (973,583,24,24) clicked FilePage(6)
        hotspot (973,620,24,24) clicked FilePage(7) 
        hotspot (973,660,24,24) clicked FilePage(8)
        hotspot (964,698,35,20) action FilePageNext(max=8)
        hotspot (964,355,35,20) action FilePagePrevious(max=1)
        hotspot (1040,40,42,40) action [Return(), Hide("load")] focus_mask None

        hotspot (190,337,224,176) clicked FileLoad(1):
            use load_save_slot(number=1)
        hotspot (440,337,224,176)  clicked FileLoad(2):
            use load_save_slot(number=2) 
        hotspot (690,337,224,176)clicked FileLoad(3):
            use load_save_slot(number=3)
        hotspot (190,553,224,176) clicked FileLoad(4):
            use load_save_slot(number=4)
        hotspot (440,553,224,176)  clicked FileLoad(5):
            use load_save_slot(number=5) 
        hotspot (690,553,224,176)clicked FileLoad(6):
            use load_save_slot(number=6)



        hotspot (187, 250, 51, 22) action [ShowMenu("save"), Hide("load")] focus_mask None
        hotspot (300, 250, 55, 24) action ShowMenu("load") focus_mask None
        hotspot (415, 250, 50, 20) action Quit() focus_mask None
        hotspot (525, 250, 90, 21) action [ShowMenu("preferences"), Hide("load")] focus_mask None
        hotspot (675, 250, 125, 21) action [MainMenu(), Hide("load")]          focus_mask None
        hotspot (856, 250, 78, 20) action [Return(), Hide("load")] focus_mask None


screen load_save_slot:
    $ file_text = "%2s. %s\n  %s" % (
                        FileSlotName(number, 6),
                        FileTime(number, empty=_("Empty Slot")),
                        FileSaveName(number))
    add FileScreenshot(number) xpos 0 ypos 0 
    text file_text xpos 0.25 ypos 180 size 16 color "#FFF" font "RalewayRegular.ttf"

    add FileScreenshot(number) xpos 0 ypos 0
  
init -2 python:
    config.thumbnail_width = 224
    config.thumbnail_height = 176



#    add "gui/loadback.png"
    
#    imagemap:
#        xpos 154
#        ypos 251
#        ground "gui/menuH_idle.png"
#        hover "gui/menuH_hover.png"
        
#        hotspot (1, 1, 63, 28) clicked ShowMenu("save") focus_mask None
#        hotspot (122, 1, 185, 29) clicked ShowMenu("load") focus_mask None
#        hotspot (246, 1, 306, 29) clicked Quit() focus_mask None
#        hotspot (366, 1, 461, 29) clicked ShowMenu("preferences") focus_mask None
#        hotspot (526, 1, 660, 29) clicked MainMenu() focus_mask None
#        hotspot (720, 1, 807, 29) clicked Return() focus_mask None

#    use navigation
#    use file_picker

init -2:
    style file_picker_frame is menu_frame
    style file_picker_nav_button is small_button
    style file_picker_nav_button_text is small_button_text
    style file_picker_button is large_button
    style file_picker_text is large_button_text


##############################################################################
# Preferences
#
# Screen that allows the user to change the preferences.
# http://www.renpy.org/doc/html/screen_special.html#prefereces

screen preferences():
    #tag menu
    add "gui/optionsbg.png"
    modal True
    imagemap:
            
            ground "nsfwop/options_ground.png"
            idle "nsfwop/options_idle.png"
            hover "gui/options_hover.png"
            selected_idle "gui/options_hover.png"
            alpha True
             
            # hotspot (118,683,113,35) action Preference("skip", "seen")
            # hotspot (265,683,113,35) action Preference("skip", "all")
            # hotspot (441,683,113,35) action Preference("after choices", "stop")
            # hotspot (588,683,113,35) action Preference("after choices", "skip")
            # hotspot (762,683,113,35)  action SetField(persistent, "sfwmode", True)
            # hotspot (910,683,113,35)  action SetField(persistent, "sfwmode", False)

            # hotspot (441,553,113,35)  action Preference("display", "window") focus_mask True
            # hotspot (588,553,113,35)  action Preference("display", "fullscreen") focus_mask True
            # hotspot (762,553,113,35) action Preference("transitions", "all")
            # hotspot (910,553,113,35) action Preference("transitions", "none")    

            hotspot (187, 250, 51, 22) action [ShowMenu("save"), Hide("preferences")] focus_mask None
            hotspot (300, 250, 55, 24) action [ShowMenu("load"), Hide("preferences")]  focus_mask None
            hotspot (415, 250, 50, 20) action Quit()  focus_mask None
            hotspot (525, 250, 90, 21) action ShowMenu("preferences") focus_mask None 
            hotspot (675, 250, 125, 21) action [MainMenu(), Hide("preferences")]         focus_mask None
            hotspot (856, 250, 78, 20) action [Return(), Hide("preferences")] focus_mask None
            hotspot (1040,40,42,40) action [Return(), Hide("preferences")] focus_mask None
        
    imagebutton idle "gui/seen_idle.png" hover "gui/seen_hover.png" selected_idle "gui/seen_hover.png" xpos 135 ypos 683 focus_mask True action Preference("skip", "seen")
    imagebutton idle "gui/all_idle.png" hover "gui/all_hover.png" selected_idle "gui/all_hover.png" xpos 280 ypos 683 focus_mask True action Preference("skip", "all")
    imagebutton idle "gui/windowed_idle.png" hover "gui/windowed_hover.png"selected_idle "gui/windowed_hover.png"  xpos 441 ypos 553 focus_mask True action Preference("display", "window")
    imagebutton idle "gui/fullscreen_idle.png" hover "gui/fullscreen_hover.png" selected_idle "gui/fullscreen_hover.png" xpos 588 ypos 553 focus_mask True action Preference("display", "fullscreen")
    imagebutton idle "gui/stopskip_idle.png" hover "gui/stopskip_hover.png" selected_idle "gui/stopskip_hover.png" xpos 441 ypos 683 focus_mask True action Preference("after choices", "stop")
    imagebutton idle "gui/keepskip_idle.png" hover "gui/keepskip_hover.png" selected_idle "gui/keepskip_hover.png" xpos 588 ypos 683 focus_mask True action Preference("after choices", "skip")
#    imagebutton idle "gui/on_idle.png" hover "gui/on_idle.png" selected_idle "gui/on_idle.png" xpos 762 ypos 683 focus_mask True action SetField(persistent, "sfwmode", True)
#    imagebutton idle "gui/off_idle.png" hover "gui/off_idle.png" selected_idle "gui/off_idle.png" xpos 910 ypos 683 focus_mask True action SetField(persistent, "sfwmode", True)
    imagebutton idle "gui/all_idle.png" hover "gui/all_hover.png" selected_idle "gui/all_hover.png"  xpos 762 ypos 553 focus_mask True action Preference("transitions", "all")
    imagebutton idle "gui/none_idle.png" hover "gui/none_hover.png" selected_idle "gui/none_hover.png" xpos 910 ypos 553 focus_mask True action Preference("transitions", "none")
 

    bar value Preference("sound volume"):
        xpos 105 ypos 410
        style "bar_pref"
       

    bar value Preference("music volume"):
        xpos 105 ypos 540
        style "bar_pref"

    
#    frame:
#        style_group "pref_button"
#        xpos 105 ypos 675
#        text "test"
#        textbutton _("Seen") action Preference("skip", "seen")
#        textbutton _("All") action Preference("skip", "all")

    bar:
        xpos 430 ypos 410
        style "bar_pref"
        value Preference("auto-forward time")
        
    #display
    
    #after choice

    bar:
        xpos 754 ypos 410
        style "bar_pref"
        value Preference("text speed")
    
    #transitions
    
    #adult content
#    textbutton _("On") action SetField(persistent, "sfwmode", False)
#    textbutton _("Off") action SetField(persistent, "sfwmode", True)

   # imagebutton auto "gui/quit_%s.png" action Return() xpos 1015 ypos 42 focus_mask None
        
        
        
    


#    # Include the navigation.
#    use navigation

#    # Put the navigation columns in a three-wide grid.
#    grid 3 1:
#        style_group "prefs"
#        xfill True

#        # The left column.
#        vbox:
#            frame:
#                style_group "pref"
#                has vbox

#                label _("Display")
#                textbutton _("Window") action Preference("display", "window")
#                textbutton _("Fullscreen") action Preference("display", "fullscreen")

#            frame:
#                style_group "pref"
#                has vbox

#                label _("Transitions")
#                textbutton _("All") action Preference("transitions", "all")
#                textbutton _("None") action Preference("transitions", "none")

#            frame:
#                style_group "pref"
#                has vbox

#                label _("Text Speed")
#                bar value Preference("text speed")

#            #frame:
#                #style_group "pref"
#                #has vbox

#                #textbutton _("Joystick...") action Preference("joystick")


#        vbox:
#            frame:
#                style_group "pref"
#                has vbox

#                label _("Skip")
#                textbutton _("Seen Messages") action Preference("skip", "seen")
#                textbutton _("All Messages") action Preference("skip", "all")

#            frame:
#                style_group "pref"
#                has vbox

#                textbutton _("Begin Skipping") action Skip()

#            frame:
#                style_group "pref"
#                has vbox

#                label _("After Choices")
#                textbutton _("Stop Skipping") action Preference("after choices", "stop")
#                textbutton _("Keep Skipping") action Preference("after choices", "skip")

#            frame:
#                style_group "pref"
#                has vbox

#                label _("Auto-Forward Time")
#                bar value Preference("auto-forward time")

#                if config.has_voice:
#                    textbutton _("Wait for Voice") action Preference("wait for voice", "toggle")

#        vbox:
#            frame:
#                style_group "pref"
#                has vbox

#                label _("Music Volume")
#                bar value Preference("music volume")

#            frame:
#                style_group "pref"
#                has vbox

#                label _("Sound Volume")
#                bar value Preference("sound volume")

#                if config.sample_sound:
#                    textbutton _("Test"):
#                        action Play("sound", config.sample_sound)
#                        style "soundtest_button"
                        
#            frame:
#                style_group "pref"
#                has vbox

#                label _("Adult Content")
#                textbutton _("On") action SetField(persistent, "sfwmode", False)
#                textbutton _("Off") action SetField(persistent, "sfwmode", True)

#            if config.has_voice:
#                frame:
#                    style_group "pref"
#                    has vbox

#                    label _("Voice Volume")
#                    bar value Preference("voice volume")

#                    textbutton _("Voice Sustain") action Preference("voice sustain", "toggle")
#                    if config.sample_voice:
#                        textbutton _("Test"):
#                            action Play("voice", config.sample_voice)
#                            style "soundtest_button"

#init -2:
#    style pref_frame:
#        xfill True
#        xmargin 5
#        top_margin 5

#    style pref_vbox:
#        xfill True

#    style pref_button:
#        size_group "pref"
#        xalign 1.0

#    style pref_slider:
#        xmaximum 192
#        xalign 1.0

#    style soundtest_button:
#        xalign 1.0


##############################################################################
# Yes/No Prompt
#
# Screen that asks the user a yes or no question.
# http://www.renpy.org/doc/html/screen_special.html#yesno-prompt

screen yesno_prompt(message, yes_action, no_action):
    
    add "gui/yesnotext.png" xalign 0.0 yalign 0.0
    
    imagemap:
        xalign .50
        yalign .60
        ground "gui/yesno_idle.png"
        hover "gui/yesno_hover.png"
        
        hotspot (1, 1, 101, 44) clicked yes_action focus_mask None
        hotspot (230, 1, 308, 44) clicked [no_action, Return()] focus_mask None
    

#    modal True

#    window:
#        style "gm_root"

#    frame:
#        style_group "yesno"

#        xfill True
#        xmargin .05
#        ypos .1
#        yanchor 0
#        ypadding .05

#        has vbox:
#            xalign .5
#            yalign .5
#            spacing 30

#        label _(message):
#            xalign 0.5

#        hbox:
#            xalign 0.5
#            spacing 100

#            textbutton _("Yes") action yes_action
#            textbutton _("No") action no_action

#    # Right-click and escape answer "no".
#    key "game_menu" action no_action

#init -2:
#    style yesno_button:
#        size_group "yesno"

#    style yesno_label_text:
#        text_align 0.5
#        layout "subtitle"


##############################################################################
# Quick Menu
#
# A screen that's included by the default say screen, and adds quick access to
# several useful functions.
screen quick_menu():

    # Add an in-game quick menu.
    hbox:
        style_group "quick"

        xalign 0.0
        yalign 1.0

        textbutton _("Back") action Rollback()
        textbutton _("Save") action ShowMenu('save')
        textbutton _("Load") action ShowMenu('load')
#        textbutton _("Q.Save") action QuickSave()
#        textbutton _("Q.Load") action QuickLoad()
        textbutton _("Skip") action Skip()
#        textbutton _("F.Skip") action Skip(fast=True, confirm=True)
        textbutton _("Auto") action Preference("auto-forward", "toggle")
        textbutton _("Options") action ShowMenu('preferences')

init -2:
    style quick_button:
        is default
        background None
        xpadding 5

    style quick_button_text:
        is default
        size 16
        idle_color "#8888"
        hover_color "#ccc"
        selected_idle_color "#cc08"
        selected_hover_color "#cc0"
        insensitive_color "#4448"

##############################################################################
# Gallery
# Source: https://lemmasoft.renai.us/forums/viewtopic.php?f=51&t=22465#p283775

init python:
    #Galleries settings - start
    #list the CG gallery images here:
    gallery_cg_items = ["note1g", "love1", "love2", "rooftopcatch", "johndead", "lizziedead", "picture", "action1", "broken1", "broken2", "embrace1", "happy", "bg skyend18"]
    #"note1", "note2", "note3", "note4", "note5", "note6", "gift", 
    #list the BG gallery images here (if a BG includes several variations, such as night version, include only one variation here):
    #gallery_bg_items = ["bg sky", "bg rooftop", "bg classroom", "bg hallway", "bg counselor", "bg bedroom", "bg school", "bg forest", "bg town", "bg park"]
    #how many rows and columns in the gallery screens?
    gal_rows = 3
    gal_cols = 2
    #thumbnail size in pixels:
    thumbnail_x = 220
    thumbnail_y = 165
    #the setting above (267x150) will work well with 16:9 screen ratio. Make sure to adjust it, if your are using 4:3 or something else.
    #Galleries settings - end
   
    gal_cells = gal_rows * gal_cols   
    g_cg = Gallery()
    for gal_item in gallery_cg_items:
        g_cg.button(gal_item + " butt")
        g_cg.image(gal_item)
        g_cg.unlock(gal_item)
        if gal_item == "note1g":
            g_cg.image("note2")
            g_cg.unlock("note2")
            g_cg.image("note3")
            g_cg.unlock("note3")
            g_cg.image("note4")
            g_cg.unlock("note4")
            g_cg.image("note5")
            g_cg.unlock("note5")
            g_cg.image("note6")
            g_cg.unlock("note6")
            g_cg.image("gift")
            g_cg.unlock("gift")
        if gal_item == "embrace1":
            g_cg.image("embrace2")
            g_cg.unlock("embrace2")
            g_cg.image("embrace3")
            g_cg.unlock("embrace3")
        if gal_item == "sex1":
            g_cg.image("sex1c")
            g_cg.unlock("sex1c")
        if gal_item == "sex2":
            g_cg.image("sex2c")
            g_cg.unlock("sex2c")
        if gal_item == "titfuck21blur":
            g_cg.image("titfuck21")
            g_cg.unlock("titfuck21")
            g_cg.image("titfuck22")
            g_cg.unlock("titfuck22")
            g_cg.image("titfuck23")
            g_cg.unlock("titfuck23")
            g_cg.image("titfuck24")
            g_cg.unlock("titfuck24")
        if gal_item == "titfuck11blur":
            g_cg.image("titfuck11")
            g_cg.unlock("titfuck11")
            g_cg.image("titfuck12")
            g_cg.unlock("titfuck12")
            g_cg.image("titfuck13")
            g_cg.unlock("titfuck13")
            g_cg.image("titfuck14")
            g_cg.unlock("titfuck14")
        if gal_item == "titfuck21b":
            g_cg.image("titfuck24b")
            g_cg.unlock("titfuck24b")
    g_cg.transition = fade
    cg_page=0

#    g_bg = Gallery()
#    for gal_item in gallery_bg_items:
#        g_bg.button(gal_item + " butt")
#        g_bg.image(gal_item)
#        g_bg.unlock(gal_item)
        #if BGs have variations, such as night version, uncomment the lines below and include the code for each BG with variations
#        if gal_item == "bg kitchen":
#            g_bg.image("bg kitchen dining")
#            g_bg.unlock("bg kitchen dining")
#    g_bg.transition = fade
#    bg_page=0
   
init +1 python:
    #Here we create the thumbnails. We create a grayscale thumbnail image for BGs, but we use a special "locked" image for CGs to prevent spoilers.
    for gal_item in gallery_cg_items:
        renpy.image (gal_item + " butt", im.Scale(ImageReference(gal_item), thumbnail_x, thumbnail_y))
#    for gal_item in gallery_bg_items:
#        renpy.image (gal_item + " butt", im.Scale(ImageReference(gal_item), thumbnail_x, thumbnail_y))
#        renpy.image (gal_item + " butt dis", im.Grayscale(ImageReference(gal_item + " butt")))
       
screen cg_gallery:
    $ next_cg_page = cg_page + 1   
    $ prev_cg_page = cg_page - 1
    tag menu
    
    imagemap:
        ground "gui/gallery-idle.jpg"
        idle "gui/gallery-idle.jpg"
        hover "gui/gallery-hover.jpg"
        selected_idle "gui/gallery-hover.jpg"
        
        hotspot (1025,40,48,48) action Return() 
       # hotspot (175,305,220,168) action NullAction()
        hotspot (959,438,24,24)  action [SetVariable('cg_page', 0), ShowMenu("cg_gallery"), SelectedIf(cg_page == 0)]
        hotspot (959,478,24,24)  action [SetVariable('cg_page', 1), ShowMenu("cg_gallery"),SelectedIf(cg_page == 1)]
        hotspot (959,519,24,24)  action [SetVariable('cg_page', 2), ShowMenu("cg_gallery"), SelectedIf(cg_page == 2)]
        if len(gallery_cg_items)>gal_cells:
            if cg_page > 0:
                hotspot (954,398,33,22) action [SetVariable('cg_page', prev_cg_page), ShowMenu("cg_gallery")]
            else:
                hotspot (954,398,33,22) action [SetVariable('cg_page', 2), ShowMenu("cg_gallery")]
        if len(gallery_cg_items)>gal_cells:
            if cg_page < 2:
                hotspot (954,565,33,22) action [SetVariable('cg_page', next_cg_page), ShowMenu("cg_gallery")]
            else:
                hotspot (954,565,33,22) action [SetVariable('cg_page', 0), ShowMenu("cg_gallery")]
    #frame background None xpos 10:
    frame background None:
        
        grid gal_rows gal_cols:
            xpos 138
            ypos 280
            spacing 19
            $ i = 0
                   
            if next_cg_page > int(len(gallery_cg_items)/gal_cells):
                $ next_cg_page = 0
            for gal_item in gallery_cg_items:
                $ i += 1
                if i <= (cg_page+1)*gal_cells and i>cg_page*gal_cells:
                    add g_cg.make_button(gal_item + " butt", gal_item + " butt", im.Scale("gallocked.png", thumbnail_x, thumbnail_y, bottom_margin=40), xalign=0.5, yalign=0.5, hover_border="gui/rollover.png", background=None, bottom_margin=28)
            for j in range(i, (cg_page+1)*gal_cells): #we need this to fully fill the grid
                null
        # frame background None:
            # yalign 0.94
            # vbox:
                # if len(gallery_cg_items)>gal_cells:
                    # textbutton _("Next Page") action [SetVariable('cg_page', next_cg_page), ShowMenu("cg_gallery")]

#        frame:
#            yalign 0.90
#            vbox:
#                if len(gallery_cg_items)>gal_cells:
#                    textbutton _("Return") action Return() 

screen bg_gallery:
#The BG gallery screen is more or less copy pasted from the CG screen above, I only changed "make_button" to include a grayscale thumbnail for locked items
    tag menu
    use navigation
    imagemap:
        
        idle "gui/gallery_idle.png"
        hover "gui/gallery_hover.png"
       
    frame background None xpos 10:
        grid gal_rows gal_cols:
            ypos 10
            $ i = 0
            $ next_bg_page = bg_page + 1
            if next_bg_page > int(len(gallery_bg_items)/gal_cells):
                $ next_bg_page = 0
            for gal_item in gallery_bg_items:
                $ i += 1
                if i <= (bg_page+1)*gal_cells and i>bg_page*gal_cells:
                    add g_bg.make_button(gal_item + " butt", gal_item + " butt", gal_item + " butt dis", xalign=0.5, yalign=0.5, idle_border=None, background=None, bottom_margin=24)
            for j in range(i, (bg_page+1)*gal_cells):
                null
        frame:
            yalign 0.97
            vbox:
                if len(gallery_bg_items)>gal_cells:
                    textbutton _("Next Page") action [SetVariable('bg_page', next_bg_page), ShowMenu("bg_gallery")]

                    
screen credits():
    tag menu
    frame:
        background "gui/credits.jpg"
    imagebutton auto "gui/quit_%s.png" action Return() xpos 1015 ypos 42 focus_mask None

