os_api=dvm.GetSharedObject("OSAPI");
os_api.operator_static_cast();

function GetWindowText(hWnd)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AllocAsciiStringBuffer(260);
 param.AppendUnsignedLong(260);

 os_api.CallOSAPI(null,"GetWindowTextA",param);
 ret=param.ReadAsciiString(4);
 param=null;
 return ret;
}

function MessageBox(hWnd,lpText,lpCaption,uType)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendWideString(lpText);
 param.AppendWideString(lpCaption);
 param.AppendUnsignedLong(uType);

 ret=os_api.CallOSAPI(null,"MessageBoxW",param);
 param=null;
 return ret;
}

function SendMessage(hWnd,Msg,wParam,lParam)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendUnsignedLong(Msg);
 param.AppendUnsignedLong(wParam);
 param.AppendUnsignedLong(lParam);

 ret=os_api.CallOSAPI("User32.DLL","SendMessageW",param);
 param=null;
 return ret;
}

function RegisterClassEx(lpwcx)
{
 return os_api.CallOSAPI(null,"RegisterClassExA",lpwcx);
}

function CreateWindow(lpClassName,lpWindowName,dwStyle,x,y,nWidth,nHeight,hWndParent,hMenu,hInstance,lpParam)
{
 /*
 HWND
 WINAPI
 CreateWindowExA(
 DWORD dwExStyle,
 LPCSTR lpClassName,
 LPCSTR lpWindowName,
 DWORD dwStyle,
 int X,
 int Y,
 int nWidth,
 int nHeight,
 HWND hWndParent,
 HMENU hMenu,
 HINSTANCE hInstance,
 LPVOID lpParam);
 */
 var param=new dobject("ApiParams");
 param.AppendSignedLong(0);
 param.AppendAsciiString(lpClassName);
 param.AppendAsciiString(lpWindowName);
 param.AppendSignedLong(dwStyle);
 param.AppendSignedLong(x);
 param.AppendSignedLong(y);
 param.AppendSignedLong(nWidth);
 param.AppendSignedLong(nHeight);
 param.AppendHandlePointer(hWndParent);
 param.AppendHandlePointer(hMenu);
 param.AppendHandlePointer(hInstance);
 param.AppendHandlePointer(lpParam);

 ret=os_api.CallOSAPI(null,"CreateWindowExA",param);
 param=null;
 return ret;
}

function GetDC(hWnd)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);

 ret=os_api.CallOSAPI(null,"GetDC",param);
 param=null;
 return ret;
}

function ReleaseDC(hWnd,hDC)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendHandlePointer(hDC);

 ret=os_api.CallOSAPI(null,"ReleaseDC",param);
 param=null;
 return ret;
}

function TextOut(
  hdc,           // handle to DC
  nXStart,       // x-coordinate of starting position
  nYStart,       // y-coordinate of starting position
  lpString,      // character string
  cbString       // number of characters
)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hdc);
 param.AppendSignedInt(nXStart);
 param.AppendSignedInt(nYStart);
 param.AppendWideString(lpString);
 param.AppendSignedInt(cbString);

 ret=os_api.CallOSAPI("GDI32.DLL","TextOutW",param);
 param=null;
 return ret;
}

function CreateSolidBrush(
  crColor   // brush color value
)
{
 var param=new dobject("ApiParams");

 param.AppendUnsignedLong(crColor);

 ret=os_api.CallOSAPI("GDI32.DLL","CreateSolidBrush",param);
 param=null;
 return ret;
}

function DeleteObject(hObject)
{
 var param=new dobject("ApiParams");

 param.AppendUnsignedLong(hObject);

 ret=os_api.CallOSAPI("GDI32.DLL","DeleteObject",param);
 param=null;
 return ret;
}

function BuildGDIRect(
  left,
  top,
  right,
  bottom)
{
 var param=new dobject("ApiParams");

 param.AppendUnsignedLong(left);
 param.AppendUnsignedLong(top);
 param.AppendUnsignedLong(right);
 param.AppendUnsignedLong(bottom);

 return param;
}


function FillRect(
  hDC,   // handle to DC
  lprc,  // rectangle
  hbr    // handle to brush
)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hDC);
 param.AppendStructurePointer(lprc);
 param.AppendUnsignedLong(hbr);

 ret=os_api.CallOSAPI("USER32.DLL","FillRect",param);
 param=null;
 return ret;
}

function SetBkMode(
  hdc,      // handle to DC
  iBkMode   // background mode
)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hdc);
 param.AppendSignedInt(iBkMode);

 ret=os_api.CallOSAPI("GDI32.DLL","SetBkMode",param);
 param=null;
 return ret;
}

function ShellExecute(hWnd,lpOperation,lpFile,lpParameters,lpDirectory,nShowCmd)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendWideString(lpOperation);
 param.AppendWideString(lpFile);
 param.AppendWideString(lpParameters);
 param.AppendWideString(lpDirectory);
 param.AppendSignedInt(nShowCmd);

 ret=os_api.CallOSAPI("shell32.dll","ShellExecuteW",param);
 param=null;
 return ret;
}

function Sleep(dwMilliseconds)
{
 var param=new dobject("ApiParams");

 param.AppendUnsignedLong(dwMilliseconds);

 ret=os_api.CallOSAPI("Kernel32.DLL","Sleep",param);
 param=null;
 return ret;
}

function SetWindowPos(hWnd,hWndInsertAfter,X,Y,cx,cy,uFlags)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendHandlePointer(hWndInsertAfter);
 param.AppendSignedLong(X);
 param.AppendSignedLong(Y);
 param.AppendSignedLong(cx);
 param.AppendSignedLong(cy);
 param.AppendUnsignedLong(uFlags);

 ret=os_api.CallOSAPI("USER32.DLL","SetWindowPos",param);
 param=null;
 return ret;
}

function MoveWindow(hWnd,X,Y,nWidth,nHeight,bRepaint)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendSignedLong(X);
 param.AppendSignedLong(Y);
 param.AppendSignedLong(nWidth);
 param.AppendSignedLong(nHeight);
 param.AppendUnsignedLong(bRepaint);

 ret=os_api.CallOSAPI("USER32.DLL","MoveWindow",param);
 param=null;
 return ret;
}

function GetWindowLong(hWnd,nIndext)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendSignedLong(nIndext);

 ret=os_api.CallOSAPI("USER32.DLL","GetWindowLong",param);
 param=null;
 return ret;
}

function SetWindowLong(hWnd,nIndext,dwNewLong)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendSignedLong(nIndext);
 param.AppendUnsignedLong(dwNewLong);

 ret=os_api.CallOSAPI("USER32.DLL","SetWindowLong",param);
 param=null;
 return ret;
}

function FindWindowEx(hwndParent,hwndChildAfter,lpszClass,lpszWindow)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hwndParent);
 param.AppendHandlePointer(hwndChildAfter);
 param.AppendWideString(lpszClass);
 param.AppendWideString(lpszWindow);

 ret=os_api.CallOSAPI("USER32.DLL","FindWindowExW",param);
 param=null;
 return ret;
}

function GetDesktopWindow()
{
 var param=new dobject("ApiParams");
 ret=os_api.CallOSAPI("USER32.DLL","GetDesktopWindow",param);
 param=null;
 return ret;
}

function GetCursorPos(mouse)
{
 var param=new dobject("ApiParams");

 point=new dobject("ApiParams");
 point.AppendUnsignedLong(0);
 point.AppendUnsignedLong(0);

 param.AppendStructurePointer(point);

 ret=os_api.CallOSAPI("USER32.DLL","GetCursorPos",param);
 mouse.x=0+point.ReadUnsignedLong(0);
 mouse.y=0+point.ReadUnsignedLong(4);

 param=null;
 point=null;
 return ret;
}

function GetWindowRect(hWnd,lpRect)
{
 var param=new dobject("ApiParams");

 rect=new dobject("ApiParams");
 rect.AppendUnsignedLong(0);
 rect.AppendUnsignedLong(0);
 rect.AppendUnsignedLong(0);
 rect.AppendUnsignedLong(0);

 param.AppendHandlePointer(hWnd);
 param.AppendStructurePointer(rect);

 ret=os_api.CallOSAPI("USER32.DLL","GetWindowRect",param);

 lpRect.left=0+rect.ReadUnsignedLong(0);
 lpRect.top=0+rect.ReadUnsignedLong(4);
 lpRect.right=0+rect.ReadUnsignedLong(8);
 lpRect.bottom=0+rect.ReadUnsignedLong(12);

 param=null;
 rect=null;
 return ret;
}
function BringWindowToTop(hWnd)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);

 ret=os_api.CallOSAPI("USER32.DLL","BringWindowToTop",param);

 param=null;
 return ret;
}

function CreateThread(
  lpThreadAttributes,
  dwStackSize,
  lpStartAddress,
  lpParameter,
  dwCreationFlags,
  lpThreadId)
{
 var param=new dobject("ApiParams");

 callback_param=new dobject("ApiParams");
 callback_param.AppendHandlePointer(0);
 stdcall_callback=os_api.ApplyCallbackFunction(lpStartAddress,callback_param);

 param.AppendHandlePointer(lpThreadAttributes);
 param.AppendUnsignedLong(dwStackSize);
 param.AppendHandlePointer(stdcall_callback);
 param.AppendHandlePointer(lpParameter);
 param.AppendUnsignedLong(dwCreationFlags);

 thread_id=new dobject("ApiParams");
 thread_id.AppendUnsignedLong(0);
 param.AppendStructurePointer(thread_id);

 ret=os_api.CallOSAPI("Kernel32.DLL","CreateThread",param);
 lpThreadId.Id=thread_id.ReadUnsignedLong(0);
 param=null;
 return ret;
}

function DeleteFile(lpFileName)
{
 var param=new dobject("ApiParams");

 param.AppendWideString(lpFileName);

 ret=os_api.CallOSAPI("Kernel32.dll","DeleteFileW",param);
 param=null;
 return ret;
}

function GetFileAttributes(lpFileName)
{
 var param=new dobject("ApiParams");

 param.AppendWideString(lpFileName);

 ret=os_api.CallOSAPI("Kernel32.dll","GetFileAttributesW",param);
 param=null;
 return ret;
}

function GetFileSize(hFile,lpFileSizeHigh)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hFile);
 param.AppendHandlePointer(lpFileSizeHigh);

 ret=os_api.CallOSAPI("Kernel32.dll","GetFileSize",param);
 param=null;
 return ret;
}

function SetParent(hWndChild,hWndNewParent)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWndChild);
 param.AppendHandlePointer(hWndNewParent);

 ret=os_api.CallOSAPI("USER32.DLL","SetParent",param);
 param=null;
 return ret;
}

function PostMessage(hWnd,Msg,wParam,lParam)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendUnsignedLong(Msg);
 param.AppendUnsignedLong(wParam);
 param.AppendUnsignedLong(lParam);

 ret=os_api.CallOSAPI("USER32.DLL","PostMessageW",param);
 param=null;
 return ret;
}
function ReleaseCapture()
{
 var param=new dobject("ApiParams");
 ret=os_api.CallOSAPI("USER32.DLL","ReleaseCapture",param);
 param=null;
 return ret;
}
function CreateRoundRectRgn(nLeftRect,nTopRect,nRightRect,nBottomRect,nWidthEllipse,nHeightEllipse)
{
 var param=new dobject("ApiParams");

 param.AppendSignedLong(nLeftRect);
 param.AppendSignedLong(nTopRect);
 param.AppendSignedLong(nRightRect);
 param.AppendSignedLong(nBottomRect);
 param.AppendSignedLong(nWidthEllipse);
 param.AppendSignedLong(nHeightEllipse);

 ret=os_api.CallOSAPI("Gdi32.DLL","CreateRoundRectRgn",param);
 param=null;
 return ret;
}

function SetWindowRgn(hWnd,hRgn,bRedraw)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hWnd);
 param.AppendHandlePointer(hRgn);
 param.AppendUnsignedLong(bRedraw);

 ret=os_api.CallOSAPI("USER32.DLL","SetWindowRgn",param);
 param=null;
 return ret;
}

function SetLayeredWindowAttributes(hwnd,crKey,bAlpha,dwFlags)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hwnd);
 param.AppendUnsignedLong(crKey);
 param.AppendUnsignedLong(bAlpha);
 param.AppendUnsignedLong(dwFlags);

 ret=os_api.CallOSAPI("USER32.DLL","SetLayeredWindowAttributes",param);
 param=null;
 return ret;
}

function CreateFile(lpFileName,dwDesiredAccess,dwShareMode,lpSecurityAttributes,dwCreationDisposition,dwFlagsAndAttributes,hTemplateFile)
{
 var param=new dobject("ApiParams");

 param.AppendWideString(lpFileName);
 param.AppendUnsignedLong(dwDesiredAccess);
 param.AppendUnsignedLong(dwShareMode);
 param.AppendStructurePointer(lpSecurityAttributes);
 param.AppendUnsignedLong(dwCreationDisposition);
 param.AppendUnsignedLong(dwFlagsAndAttributes);
 param.AppendHandlePointer(hTemplateFile);

 ret=os_api.CallOSAPI("Kernel32.DLL","CreateFileW",param);
 param=null;
 return ret;
}

function CreateDirectory(lpFileName,lpSecurityAttributes)
{
 var param=new dobject("ApiParams");

 param.AppendWideString(lpFileName);
 param.AppendStructurePointer(lpSecurityAttributes);

 ret=os_api.CallOSAPI("Kernel32.DLL","CreateDirectoryW",param);
 param=null;
 return ret;
}

function CloseHandle(hObject)
{
 var param=new dobject("ApiParams");

 param.AppendHandlePointer(hObject);

 ret=os_api.CallOSAPI("Kernel32.DLL","CloseHandle",param);
 param=null;
 return ret;
}

function RegOpenKey(hKey,lpSubKey)
{
 var param=new dobject("ApiParams");

 param.AppendUnsignedLong(hKey);
 param.AppendWideString(lpSubKey);
 param.AllocAsciiStringBuffer(4);

 os_api.CallOSAPI("Advapi32.DLL","RegOpenKeyW",param);
 ret=param.ReadHandlePointer(8);//read from 8 offset
 param=null;
 return ret;
}

function FindFirstFile(lpFileName,lpFindFileData)
{
 var param=new dobject("ApiParams");
 param.AppendWideString(lpFileName);
 param.AppendStructurePointer(lpFindFileData);

 ret=os_api.CallOSAPI("Kernel32.dll","FindFirstFileW",param);
 param=null;
 return ret;
}
function FindNextFile(hFindFile,lpFindFileData)
{
 var param=new dobject("ApiParams");
 param.AppendHandlePointer(hFindFile);
 param.AppendStructurePointer(lpFindFileData);

 ret=os_api.CallOSAPI("Kernel32.dll","FindNextFileW",param);
 param=null;
 return ret;
}
function FindClose(hFindFile)
{
 var param=new dobject("ApiParams");
 param.AppendHandlePointer(hFindFile);

 ret=os_api.CallOSAPI("Kernel32.dll","FindClose",param);
 param=null;
 return ret;
}

function Make_WIN32_FIND_DATA()
{
 var param=new dobject("ApiParams");
 var dt=Make_FILETIME(0,0);
 /*
 typedef struct _WIN32_FIND_DATA {
 	DWORD dwFileAttributes;
 	FILETIME ftCreationTime;
 	FILETIME ftLastAccessTime;
 	FILETIME ftLastWriteTime;
 	DWORD nFileSizeHigh;
 	DWORD nFileSizeLow;
 	DWORD dwReserved0;
 	DWORD dwReserved1;
 	TCHAR cFileName[MAX_PATH];
 	TCHAR cAlternateFileName[14];
 } WIN32_FIND_DATA, *PWIN32_FIND_DATA;*/
 
 param.AppendUnsignedLong(0);
 param.AppendStructure(dt);
 param.AppendStructure(dt);
 param.AppendStructure(dt);
 param.AppendUnsignedLong(0);
 param.AppendUnsignedLong(0);
 param.AppendUnsignedLong(0);
 param.AppendUnsignedLong(0);
 param.AppendBufferBlock(260*2);
 param.AppendBufferBlock(14*2);
 
 dt.operator_delete();
 
 return param;
}

function Make_FILETIME(dwLowDateTime,dwHighDateTime)
{
 var param=new dobject("ApiParams");
 /*
 typedef struct _FILETIME
 {
	DWORD dwLowDateTime;
	DWORD dwHighDateTime;
 }FILETIME;
 */
 param.AppendUnsignedLong(dwLowDateTime);
 param.AppendUnsignedLong(dwHighDateTime);
 return param;
}

function FileTimeToSystemTime(lpFileTime,lpSystemTime)
{
 var param=new dobject("ApiParams");
 
 var param_for_out=new dobject("ApiParams");
 /*
 typedef struct _SYSTEMTIME {  
 	WORD wYear;  
 	WORD wMonth;  
 	WORD wDayOfWeek;  
 	WORD wDay;  
 	WORD wHour;  
 	WORD wMinute;  
 	WORD wSecond;  
 	WORD wMilliseconds;
 } SYSTEMTIME;
 */
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);
 param_for_out.AppendSignedShort(0);

 param.AppendStructurePointer(lpFileTime);
 param.AppendStructurePointer(param_for_out);

 os_api.CallOSAPI("Kernel32.dll","FileTimeToSystemTime",param);
 lpSystemTime.wYear=param_for_out.ReadSignedShort(0);
 lpSystemTime.wMonth=param_for_out.ReadSignedShort(2);
 lpSystemTime.wDayOfWeek=param_for_out.ReadSignedShort(4);
 lpSystemTime.wDay=param_for_out.ReadSignedShort(6);
 lpSystemTime.wHour=param_for_out.ReadSignedShort(8);
 lpSystemTime.wMinute=param_for_out.ReadSignedShort(10);
 lpSystemTime.wSecond=param_for_out.ReadSignedShort(12);
 lpSystemTime.wMilliseconds=param_for_out.ReadSignedShort(14);
}

function GetTickCount()
{
 var param=new dobject("ApiParams");

 ret=os_api.CallOSAPI("Kernel32.dll","GetTickCount",param);
 param=null;
 return ret;
}

// - - -- - - - -  -- - - - - - - - - - - - - -- - - -

WM_CREATE=0x0001;
WM_PAINT=0x000F;
WM_DESTROY=0x0002;
WM_LBUTTONDOWN=0x0201;
WM_MOUSEMOVE=0x0200;
WM_PAINT=0x000F;
WM_SYSCOMMAND=0x0112;
SC_MOVE=0xF010;
HTCAPTION=2;

TRANSPARENT=1;
SW_SHOWNORMAL=0x00000001;

SW_SHOW=5;
MB_OK=0x00000000;

SWP_NOSIZE         = 0x0001;
SWP_NOMOVE         = 0x0002;
SWP_NOZORDER       = 0x0004;
SWP_NOREDRAW       = 0x0008;
SWP_NOACTIVATE     = 0x0010;

HWND_TOP        = 0;
HWND_BOTTOM     = 1;
HWND_TOPMOST    =-1;
HWND_NOTOPMOST  =-2;

GWL_STYLE       = (-16);
GWL_EXSTYLE     = (-20)
WS_EX_LAYERED   = 0x00080000;
WS_EX_TOPMOST   = 0x00000008;

WS_EX_APPWINDOW = 0x00040000;

// - - -- - - - -  -- - - - - - - - - - - - - -- - - -

FILE_GENERIC_WRITE = 0x00120116;
FILE_GENERIC_READ  = 0x00120089;
FILE_SHARE_READ    = 0x00000001;
FILE_SHARE_WRITE   = 0x00000002;
CREATE_NEW         = 1;
CREATE_ALWAYS      = 2;
OPEN_EXISTING      = 3;
OPEN_ALWAYS        = 4;
TRUNCATE_EXISTING  = 5;

HKEY_CLASSES_ROOT          = 0x80000000;
HKEY_CURRENT_USER          = 0x80000001;
HKEY_LOCAL_MACHINE         = 0x80000002;
HKEY_USERS                 = 0x80000003;
HKEY_PERFORMANCE_DATA      = 0x80000004;
HKEY_CURRENT_CONFIG        = 0x80000005;
HKEY_DYN_DATA              = 0x80000006;

FILE_ATTRIBUTE_DIRECTORY   = 0x00000010;
