/**
 * popup.html 弹出框本身作为一个页面，通过js动态改变页面内容
 * 不同内容在popup.html中以模版形式
 * uc-template  uc弹窗显示内容
 * general-template 通用插件弹窗内容
 * payed-login-template 登录
 * payed-logout-template 登出
 */
window.onload = function() {
    var jsonArray = ['manifest.json', 'def.json'];
    var getJsonSuccess = false,
        extensionType = 1;

    function ajax(option){
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
                if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
                    option.success && option.success(xhr.responseText, xhr.responseXML);
                }
            }
        }
        xhr.open(option.type, option.url, true);
        if(option.type.toUpperCase() == 'GET'){
            xhr.send(null);
        }else if(option.type.toUpperCase() == 'POST'){
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.send(option.params);
        }

    }

    function renderContent(extensionType) {
        var contentTemplate = '',
            token,
            contentElement;
        chrome.runtime.sendMessage({ type: 'getLoginToken' }, function(response) {
            token = response.token;
            if(token === null || token === "null"){
                contentTemplate = document.getElementById('payed-login-template').innerHTML;
            }else{
                contentTemplate = document.getElementById('payed-logout-template').innerHTML;
            }
            contentElement = document.createElement('div');
            contentElement.className = 'content-wrap-payed';
            contentElement.innerHTML = contentTemplate;
            document.body.appendChild(contentElement);
            addEvents3();
        });
    }
}
