//获得一个指定位数的随机数
function randomInt(digit) {
    return Math.floor(Math.random() * digit / 10);
}
//获得一个随机数
function randomNum() {
    return Math.random();
}
function connectError(url, cb) {
    cb({
        errorMessage: url + ': connection error'
    });
}
function connectTimeout(url, cb) {
    cb({
        errorMessage: url + ': connection timeout'
    });
}
var httpRequestAjax = function(options, cb) {
    var request = $.ajax(Object.assign(options, {
        traditional: true
    }))
    request.done(function(res) {
        cb && cb(res);
    })
};
function params(data) {
	var returnStr = '';
	if (typeof data !== 'object') {
		return '';
	}
	for (var i in data) {
		returnStr += i + '=' + data[i] + '&';
	}

	if (returnStr.lastIndexOf('&') == returnStr.length - 1) {
		returnStr = returnStr.substr(0, returnStr.length - 1);
	}

	return returnStr;
}
var httpRequest = {
	get: function (options, cb, timeout) {
		var xhr = new XMLHttpRequest(),
		async = true;

		if (options.hasOwnProperty('async')) {
			async = options.async;
		}

		//format url with function params
		options.url += params(options.data);

		xhr.onreadystatechange = function () {
			if (xhr.readyState === 4) {
				if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
					var response;
					try {
						if (xhr.responseText) {
							if (typeof xhr.responseText == "string") {
	                            response = JSON.parse(xhr.responseText);
	                        } else {
	                            response = JSON.parse(JSON.stringify(xhr.responseText));
	                        }
						} else {
							//如果没有返回数据，则给回调函数传一个空对象的字符串
							response = options.type && options.type.toUpperCase() === 'JSONP' ? 'callback({})' : '{}';
						}
					} catch (e) {
						var data = xhr.responseText;
						var respon = data.substring(data.indexOf('(') + 1, data.lastIndexOf(')'));
						try {
						    if (typeof data == "string") {
						        response = JSON.parse(respon);
						    } else {
						        response = JSON.parse(JSON.stringify(data));
						    }

						} catch (e) {
						    response = data;
						    console.info('get:cannot parse to JSONP and JSON');
						}
					}
					cb(response);
				} else {
					connectError(options.url, cb);
				}
			}
		}
		if(!options.url){
			console.log('url error');
			return;
		}
		xhr.open('get', options.url, async);

		if(timeout){
			setTimeout(function(){
				xhr.abort();
				connectTimeout(options.url, cb);
			}, timeout);
		}

		try {
			xhr.send(null);
		} catch (e) {
			cb({
				msg: 'request error',
				err: e
			});
		}
	},

	post: function (options, cb, timeout) {
		var xhr = new XMLHttpRequest(),
		async = true;

		if (options.hasOwnProperty('async')) {
			async = options.async;
		}

		xhr.onreadystatechange = function () {
			if (xhr.readyState === 4) {
				if ((xhr.status >= 200 && xhr.status < 300) || xhr.status === 304) {
					var response;
					try {
						if (xhr.responseText) {
							if (typeof xhr.responseText == "string") {
	                            response = JSON.parse(xhr.responseText);
	                        } else {
	                            response = JSON.parse(JSON.stringify(xhr.responseText));
	                        }
						} else {
							//如果没有返回数据，则给回调函数传一个空对象的字符串
							response = options.type && options.type.toUpperCase() === 'JSONP' ? 'callback({})' : '{}';
						}
					} catch (e) {
						var data = xhr.responseText;
						var respon = data.substring(data.indexOf('(') + 1, data.lastIndexOf(')'));
						try {
						    if (typeof data == "string") {
						        response = JSON.parse(respon);
						    } else {
						        response = JSON.parse(JSON.stringify(data));
						    }

						} catch (e) {
						    response = data;
						    console.dir(response);
						    console.info('get:cannot parse to JSONP and JSON');
						}
					}
					cb(response);
				} else {
					connectError(options.url, cb);
				}
			}
		}
		if(!options.url){
			console.log('url error');
			return;
		}
        xhr.open('post', options.url, async);
        this.setXMLHttpRequestHeaders(xhr, options.headers)

		if(timeout){
			setTimeout(function(){
				xhr.abort();
				connectTimeout(options.url, cb);
			}, timeout);
		}

		try {
			xhr.send(params(options.data));
		} catch (e) {
			cb({
				msg: 'request error',
				err: e
			});
		}
	},

	getHTML: function (options, cb) {
		if (!window.XMLHttpRequest) {
			window.setTimeout(function () {
				cb(false);
			}, 0);
			return;
		}

		//format url with function params
		options.url += params(options.data);

		var done = false;
		var xhr = new window.XMLHttpRequest();
		xhr.onreadystatechange = function () {
			if (this.readyState == 4 && !done) {
				done = true;
				cb(new XMLSerializer().serializeToString(this.responseXML));
			}
		}
		xhr.onabort = xhr.onerror = function () {
			if (!done) {
				done = true;
				cb(false);
			}
		}
		try {
			if(!options.url){
				console.log('url error');
				return;
			}
			xhr.open("GET", options.url);
			xhr.responseType = "document";
			xhr.send();
		} catch (e) {
			window.setTimeout(function () {
				if (!done) {
					done = true;
					cb(false);
				}
			}, 0);
		}
	},

	setXMLHttpRequestHeaders: function (xhr, headers) {
		if (xhr.setRequestHeader) {
            for (var key in headers) {
                xhr.setRequestHeader(key, headers[key]);
            }
		}
    },

	formatXMLHttpRequestHeaders: function (attributes) {
		var forbidHeaders = ['Accept-Charset', 'Accept-Encoding', 'Access-Control-Request-Headers', 'Access-Control-Request-Method',
			'Connection', 'Content-Length', 'Cookie', 'Cookie2', 'Date', 'DNT', 'Expect', 'Host', 'Keep-Alive', 'Origin', 'Referer', 'TE', 'Trailer'
			, 'Transfer-Encoding', 'Upgrade', 'Via'];

		for (var i in attributes) {
			if (forbidHeaders.indexOf(i) > 0) {
				delete attributes[i];
			}
		}
	}
};

chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
    // 回调函数sendResponse 默认是同步的，所以会返回undefined,如果要异步执行，该监听器需要return true
    // guid, shopId为必传字段
    chrome.storage.local.get(['guid', 'shopId'], function(data) {
        console.log(data);
        request.data = request.data || {};
        if (request.url && !request.url.match(/wmsGet/) && !request.url.match(/(\.js|.css)/)) request.data.token = data.guid && data.shopId ? data.shopId + '@' + data.guid: '';
        request.type = request.type ? request.type.toUpperCase() : 'GET';
        var requestType = (request.type || 'get').toUpperCase();
        switch (requestType) {
            case 'GET':
                httpRequest.get(request, function (data) {
                    sendResponse(data);
                });
                break;
            case 'POST':
                httpRequestAjax(request, function (data) {
                    sendResponse(data);
                });
                break;
    
            case 'GETLOGINTOKEN':
                chrome.storage.local.get(['guid', 'shopId'], function(data) {
                    sendResponse(data);
                })
                break;
            case 'CREATE_GUID':
                console.log(request);
                var cryptoShopId = CryptoJS.MD5(request.data.shopId + '').toString().toUpperCase();
                console.log('cryptoShopId', cryptoShopId);
                chrome.storage.local.set({
                    guid: cryptoShopId, 
                    shopId: request.data.shopId,
                    shopName: request.data.shopName,
                    shopCatId: request.data.shopCatId
                }, function() {
                    sendResponse(cryptoShopId);
                });
                break;
        }
    })
    return true;
});

if (chrome.runtime.onInstalled && chrome.runtime.onInstalled.addListener instanceof Function) {
    chrome.runtime.onInstalled.addListener(function (detail) {
        if (detail) {
            switch (detail.reason) {
                case 'install':
                    var statUrl = 'http://dclog.weiyoucrm.com/statistics.do?systemName=zhishu99_plugin_install&';
                    chrome.storage.local.get(null, function(data) {
                        httpRequest.get({
                            url: statUrl,
                            type: 'get',
                            data,
                        }, function () {});
                    })
                    break;

                case 'update':
                    var statUrl = 'http://dclog.weiyoucrm.com/statistics.do?systemName=zhishu99_plugin_update&';
                    chrome.storage.local.get(null, function(data) {
                        httpRequest.get({
                            url: statUrl,
                            type: 'get',
                            data,
                        }, function () {});
                    })
                    break;

                default:
                    break;
            }
        }
    });
}