<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//后台系统信息类
class SysinfoModel extends Model{
	private $gd;
	private $host;
	private $server;
	private $phpver;
	private $mysqliver;
	private $gdver;
	private $fileup;
	private $allowurl;
	private $maxexetime;
	private $dbsize;
	private $gdinfo;

	public function __construct(){
		parent::__construct();
		$this->host = $this->gethost();
		$this->server = $this->getserver();
		$this->phpver = $this->getphpver();
		$this->gdinfo = $this->getgdinfo();
		$this->mysqliver = $this->getmysqliver();
		$this->allowurl = $this->getallowurl();
		$this->fileup = $this->getfileup();
		$this->dbsize = $this->getdbsize();
		$this->maxexetime = $this->getmaxexetime();
	}

	private function getserver(){
		return PHP_OS. ' | '.$_SERVER['SERVER_SOFTWARE'];
	}

	private function gethost(){
		return $_SERVER['SERVER_NAME'];
	}

	private function getphpver(){
		return PHP_VERSION;
	}

	private function getgdinfo(){
		if(function_exists('gd_info')){
			$this->gd = gd_info();
			$gdinfo = $this->gd['GD Version'];
		}else{
			$gdinfo = '<span style="color:red">未知</span>';
		}

		return $gdinfo;
	}

	private function getmysqliver(){
		return $this->mysqli->server_info;
	}

	private function getallowurl(){
		if(ini_get('allow_url_fopen')){
			return '支持';
		}else{
			return '<span style="color:red">不支持</span>';
		}
	}

	private function getfileup(){
		if(ini_get('file_uploads')){
			$umfs = ini_get('upload_max_filesize');
			$pms = ini_get('post_max_size');
			return '允许 | 文件:'.$umfs.' | 表单: '.$pms;
		}else{
			return '<span style="color:red">禁止</span>';
		}
	}

	private function getdbsize(){
		return $this->dbsize();
	}

	private function getmaxexetime(){
		return ini_get('max_execution_time').'秒';
	}

	public function sysinfo(){
		$info = array(
			"server"=>$this->server,
			"host"=>$this->host,
			"phpver"=>$this->phpver,
			"gdinfo"=>$this->gdinfo,
			"mysqliver"=>$this->mysqliver,
			"allowurl"=>$this->allowurl,
			"fileup"=>$this->fileup,
			"dbsize"=>$this->dbsize,
			"exemaxtime"=>$this->maxexetime
		);
		
		return $info;
	}


}

?>