<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//栏目模型类
class NavModel extends Model{
		//成员初始化
	public function __construct(){
		parent::__construct();
		$this->tabname = TAB_FIX."nav";
	    $this->tabkey = array("id", "pid", "path", "title", "description", "ord");
	}

	public function colsmenu($pid){
		$path = $this->path($pid);
		return $this->field("id, title, description")->where(str_replace('-', ',', $path['path']).','.$pid)->all();
	}

	public function path($id){
		return $this->field("id, path")->where(array("id"=>$id))->one();
	}

	public function getpid($pid){
		$id= $this->navpid($pid);
		return $navid = val::offstr($id, 'id', $pid);
	}

	//获取首页四个菜单
	public function fournav(){
		return $this->field("id, title")->where(array('pid' => 0))->order("ord asc")->limit(4)->all();
	}

	//获取菜单子类
	public function navpid($pid){
		return $this->field("id")->where(array("pid"=>$pid))->all();
	}

	//输出菜单列表
	public function menu($pid = 0){
		return $this->field("id, title, description")->where(array("pid"=>$pid))->order("ord asc")->all();
	}

	//删除栏目
	public function delete($id){
		if($this->total(array("pid"=>$id))){
			val::mess('该父类下面有子类，不能删除');
			return false;
		}else if(D("article")->total(array("pid"=>$id)) > 0){
			val::mess('该栏目下面有文章，请先删除文章');
			return false;
		}else{
			return $this->del($id);
		}

	}

	//排序栏目
	public function ord($post){
		$num = 0;
		for ($i=0; $i<count($post['id']); $i++) { 
			$data['id'] = $post['id'][$i];
			$data['ord'] = $post['ord'][$i];
			if(!is_numeric($data['ord'])) continue;
			$num+=$this->mod($data);
			
		}

		return $num;
	}

	//获取总数
	public function nav_total(){
		return $this->total();
	}

	//显示栏目列表
	public function shownav($limit){
		$list = $this->field("id, pid, title, description, ord, concat(path, '-', id) as abspath")->order("abspath, id asc")->limit($limit)->all();
		$html = '<tr>';
		foreach ($list as $val) {
			if($val['pid'] == "0"){
				$html.='<td height="25" bgcolor="#FFFFFF" class="STYLE19"><div align="left"><input type="text" style="width:20px;height:18px;margin:0px 3px;text-align:center;border:1px solid #B6B3AF;" name="ord[]" value="'.$val['ord'].'"></div></td>';
				$html.='<input type="hidden" name="id[]" value="'.$val['id'].'">';
			}else{
				$html.='<td>&nbsp;</td>';
			}

			$title = str_repeat('&nbsp;&nbsp;&nbsp;', count(explode('-', $val['abspath']))-2).'|- <a href="'.B_APP.'/article/index/pid/'.$val['id'].'">'.$val['title'].'</a>';
			$html .='<td height="25" bgcolor="#FFFFFF" class="STYLE19"><div align="left">'.$title.'</div></td>';
			$html .='<td height="25" bgcolor="#FFFFFF" class="STYLE19"><div align="center">'.$val['description'].'</div></td>';
		    $html .='<td height="25" bgcolor="#FFFFFF"><div align="center" class="STYLE21"><a class="blues" href="'.B_URL.'/mod/id/'.$val['id'].'">修改</a> | <a class="blues" onclick=\'return confirm("确定要删除该条栏目吗？")\' href="'.B_URL.'/del/id/'.$val['id'].'"> 删除</a></div></td>';
		    $html .='</tr>';
		}
		return $html;
	}

	//获取父类栏目
	public function getpath($pid){
		$row=$this->field("path")->where(array("id"=>$pid))->one();

		if($pid == 0){
			$path = "0";
		}else{
			$path = $row['path'].'-'.$pid;
		}

		return $path;
	}

	//修改栏目
	public function update($post){
		$post['path'] = $this->getpath($post['pid']);
		if(in_array($post['id'], explode("-", $post['path']))){
			val::mess('不能移动到自己的子栏目中');
			return false;
		}

		return $this->mod($post);
	}

	//添加栏目
	public function insert($post){
		return $this->add($post);
	}

	//通过传递进来的ID获取一条数据
	public function get_one($id){
		return $this->field()->where(array("id"=>$id))->one();
	}

	//栏目下拉框
	public function select($root= "顶级栏目", $name = "pid", $value = "0", $change =""){
		$data = $this->field('id, pid, title, concat(path, "-", id) as abspath')->order("abspath, id asc")->all();
		$html = '<select '.$change.' id="sel" name="'.$name.'">';
		$html.='<option  value="0">'.$root.'</option>';
		foreach ($data as $val) {
			if($value == $val['id'])
				$html.='<option selected value="'.$val['id'].'">';
			else
				$html.='<option value="'.$val['id'].'">';

			$num = count(explode("-", $val['abspath'])) - 2;
			$space = str_repeat("|&nbsp;&nbsp;&nbsp;", $num);
			$name = $val['title'];
			$html.=$space."|-".$name;
			$html.='</option>';
		}

		$html.='</select>';
		return $html;
	}



}

?>