<?php

/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//文章Model类

class ArticleModel extends Model{

	//数据初始化
	public function __construct(){
		parent::__construct();
		$this->tabname = TAB_FIX."article";
		$this->tabkey = array("id", "title", "pid", "thumb", "keyword", "source", "author", "paly", "info", "content", "attr", "commend", "count", "views", "nums", "posttime");
	}

	//显示标题文章
	public function showtit($id){
		return $this->field("id, title, commend")->where(array("id"=>$id))->one();
	}

	//显示文章内容
	public function viewcent($id){
		return $this->field("id, title, pid, keyword, source, author, info, content, commend, count, nums, posttime")->where(array("id"=>$id, "views"=>0))->one();
	}

	//显示热门文章
	public function hostpid($pid){
		return $this->field("id, title, posttime")->where(array("pid"=>$pid, "views"=>0))->limit(16)->order("count desc")->all();
	}

	//获取文章总数
	public function arttotal($where){
		return $this->where($where)->total();
	}

	//设置文章评论数
	public function setnums($id, $mod = 'add'){
		if($mod == 'add'){
			$data = $this->where(array("id"=>$id))->mod("nums=nums+1");
		}else if($mod == 'del'){
			$data = $this->where(array("id"=>$id))->mod("nums=nums-1");
		}else{
			return false;
		}

		return $data;
	}

	//设置文章点击率
	public function setcount($id){
		return $this->where(array("id"=>$id))->mod("count=count+1");
	}

	//搜索文章
	public function search($where, $limit){
		return $this->field("id, pid, title, thumb, keyword, info, count, nums, posttime")->where($where)->order("id desc")->limit($limit)->multi(array("nav", 'title as ntitle', 'id', 'pid'));
	}

	//文章列表显示
	public function all_list($pid, $limit){
		return $this->field("id, pid, title, thumb, keyword, info, count, nums, posttime")->where(array("pid"=>$pid, "views"=>0))->order("id desc")->limit($limit)->multi(array("nav", 'title as ntitle', 'id', 'pid'));
	}

	//通过传递进来的参数显示文章
	public function art_list($find, $limit, $where = null, $order=null){
		$order = isset($order) ? $order : "id desc";
		return $this->field($find)->where($where)->limit($limit)->order($order)->all();
	}

	//显示文章标题
	public function getart($id){
		$id = isset($id) ? $id : null;
		$art = $this->cols(val::offstr(D("nav")->navpid($id), 'id', $id));
		$html = '<ul>';
		if(isset($art)){
			foreach ($art as $val) {
				$html .='<li class="li"><em>'.date('m-d', $val['posttime']).'</em><a target="_blank" title='.$val['title'].' href="'.B_APP.'/article/index/id/'.$val['id'].'">'.val::substr($val['title'], 'title', 23).'</a></li>';
			}
		}
		$html .= '</ul>';
		return $html;

	}

	//通过传递进来的PID获取文章标题
	public function cols($pid){
		return $this->field("id, title, posttime")->where(array("pid"=>$pid, "views"=>0))->order("id desc")->limit(11)->all();
	}

	//删除文章
	public function delete($id){
		if(!empty($id)){
			$this->getimg($id);
			$this->del($id);
			return true;
		}else{
			return false;
		}
	}

	//通过传递进来的ID得到图片，如果有就进行删除
	public function getimg($id){
		$img = $this->field("thumb, paly, content")->where(array("id"=>$id))->all();
		if(!empty($img)){
			foreach ($img as $val) {
				$this->checkimg($val['thumb']);
				$this->checkimg($val['paly']);
				$this->checkimg(val::getimgbody(val::unhtml($val['content']), 2));
			}
		}
	}

	//检测图片是否存在
	public function checkimg($file){
		if(!empty($file)){
			if(is_string($file)){
				$this->delimg($file);
			}else if(is_array($file)){
				foreach ($file as $val) {
					$file = "uploads/".$val;
					$this->delimg($file);
				}
			}
		}else{
			return null;
		}
	}

	//删除图片
	public function delimg($file){
		$dirfile = ZH_PATH.$file;

		if(file_exists($dirfile)){
			unlink($dirfile);
		}

		if(!file_exists($dirfile)){
			return true;
		}else{
			return false;
		}
	}

	//通过传递进来的ID获取一条数据
	public function list_one($id){
		return $this->where(array("id"=>$id))->one();
	}

	//修改文章
	public function update($post){
		$post['author'] = !empty($post['author']) ? $post['author'] : $_SESSION['user'];
		return $this->mod($post);
	}
	
	public function setviews($post){
		return $this->mod($post);
	}

	//对文章批量操作
	public function fpro($id, $post){
		return $this->where($id)->mod($post);
	}

	//获取文章总数
	public function list_total($where){
		return $this->total($where);
	}

	//显示文章列表
	public function show_list($where, $limit){
		return $this->field("id, pid, title, attr, author, posttime, count, views")->where($where)->order("id desc")->limit($limit)->multi(array('nav', 'title as ntitle', 'id', 'pid'));
	}

	//添加文章
	public function insert($post){
		$post['posttime'] = time();
		$post['author'] = !empty($post['author']) ? $post['author'] : $_SESSION['user'];
		$post['attr']=isset($post['attr']) ? implode(",", $post['attr']) : '无';
		return $this->add($post);
	}

	//上传图片
	public function upload(){
		if(isset($_FILES['thumb'])){
			$img = $this->fileup($_FILES['thumb'], 150, 110);
			val::opener('上传缩略图成功', "uploads/".$img, 'thumb');
		}else if(isset($_FILES['paly'])){
			$img = $this->fileup($_FILES['paly'], 370, 350);
			val::opener('上传首页大图成功', "uploads/".$img, 'paly');
		}else if(isset($_FILES['imgFile'])){
			$set = D("set")->list_one("width, height");
			$img = $this->fileup($_FILES['imgFile'], $set['width'], $set['height']);
			$save_url = B_ROOT."/uploads/".$img;
			echo json_encode(array('error' => 0, 'url' => $save_url));
		}else{
			val::mess('操作错误');
		}
	}

	//上传图片
	public function fileup($img, $width, $height, $newname ='_new'){
		$upload = new Fileupload();
		if(is_array($img)){
			if($upload->upload($img, $width, $height)){
				echo $upload->error();
			}else{
				$image = $upload->newfilename();
			}
		}else if(is_string($img)){
			$image = str_replace('.', $newname.'.', $img);
	    	$upload->kindthumb($img, $width, $height, $image);
		}else{
			$image = '';
		}

		return $image;
	}

}

?>