<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */
 
//验证码类

class Vcode{
	private $width;
	private $height;
	private $codenum;
	private $dispurbcolornum;
	private $checkcode;
	private $image;



	public function __construct($width = 66, $height = 29, $codenum = 4){
		$this->width = $width;
		$this->height = $height;
		$this->codenum = $codenum;
		$number = floor($height * $codenum / 15);
		if($number > 200 - $codenum)
			$this->dispurbcolornum = 200 - $codenum;
		else
			$this->dispurbcolornum = $number;

		$this->checkcode = $this->createcheckcode();

	}

	public function __toString(){
		$_SESSION['code'] = strtoupper($this->checkcode);
		$this->outimg();
		return '';
	}

	private function outimg(){
		$this->getcreateimage();
		$this->setdisturbcolor();
		$this->outputtext();
		$this->outputimage();
	}

	private function getcreateimage(){
		$this->image = imagecreatetruecolor($this->width, $this->height);

		$backcolor = imagecolorallocate($this->image, rand(225, 255), rand(225, 255), rand(225, 255));
		imagefill($this->image, 0, 0, $backcolor);

		$border = imagecolorallocate($this->image, 0, 0, 0);
		imagerectangle($this->image, 0, 0, $this->width-1, $this->height-1, $border);
	}

	private function createcheckcode(){
		$code="3456789abcedfghijkmnpqrstuvwxyABCDEFGHIJKMNPQRSTUVWXY";
		for ($i=0; $i <$this->codenum; $i++) { 
			$char=$code{rand(0, strlen($code)-1)};

			@$ascii.=$char;
		}
		return $ascii;
	}

	private function setdisturbcolor(){
		for ($i=0; $i < $this->dispurbcolornum ; $i++) { 
			$color = imagecolorallocate($this->image, rand(0, 255), rand(0, 255), rand(0, 255));
			imagesetpixel($this->image, rand(1, $this->width-2), rand(1, $this->height-2), $color);
		}

		for ($i=0; $i <3 ; $i++) { 
			$color =imagecolorallocate($this->image, rand(0, 255), rand(0, 255), rand(0, 255));
			imagearc($this->image, rand(-10, $this->width), rand(-10, $this->height), rand(30, 300), rand(20, 200), 55, 44, $color);
		}
	}

	private function outputtext(){
		for ($i=0; $i < $this->codenum; $i++) { 
			$fontcolor=imagecolorallocate($this->image, rand(0, 128), rand(0, 128), rand(0, 128));
			$fontsize=rand(5, 7);
			$x = floor($this->width / $this->codenum) * $i + 3;
			$y = rand(0, $this->height - imagefontheight($fontsize));
			imagechar($this->image, 5, $x, $y, $this->checkcode{$i}, $fontcolor);
		}
	}

	private function outputimage(){
		ob_end_clean();
		if(imagetypes() & IMG_GIF){
			header("Content-type:image/gif");
			imagegif($this->image);
		}else if(imagetypes() & IMG_JPG){
			header("Content-type:image/jpeg");
			imagejpeg($this->image, "", 0.5);
		}else if(imagetypes() & IMG_PNG){
			header("Content-type:image/png");
			imagepng($this->image);
		}else if(imagetypes() & IMG_WBMP){
			header("Content-type:image/vnd.wap.wbmp");
			imagewbmp($this->image);
		}else{
			die("PHP不支持图像创建");
		}
	}

	public function __destruce(){
		imagedestroy($this->image);
	}
}


?>