<?php

/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//分页类

class Page{
	private $total;
	private $listrow;
	private $limit;
	private $url;
	private $pagenum;
	private $page;
	private $config = array('head'=>"条记录", 'prev'=>"上一页", 'next'=>"下一页", 'first'=>"首页", 'last'=>"尾页");
	private $listnum = 10;

	public function __construct($total, $listrow = 25, $pa = "", $ord=true){
		$this->total = $total;
		$this->listrow = $listrow;
		$this->url = $this->geturl($pa);
		$this->pagenum = ceil($this->total / $this->listrow);
		if(!empty($_GET['page'])){
			$page = $_GET['page'];
		}else{
			if($ord)
				$page = 1;
			else
				$page = $this->pagenum;
		}

		if($total > 0){
			if(preg_match('/\D/', $page)){
				$this->page = 1;
			}else{
				$this->page = $page;
			}
		}else{
			$this->page = 0;
		}

		$this->limit = $this->setlimit();
	}

	private function set($param, $value){
		if(array_key_exists($param, $this->config)){
			$this->config[$param] = $value;
		}

		return $this;
	}

	private function setlimit(){
		if($this->page > 0)
			return ($this->page - 1) * $this->listrow.", {$this->listrow}";
		else
			return 0;
	}

	private function geturl($pa){
		if($pa == "")
			return B_URL.'/'.$_GET['a'].'/';
		else
			return B_URL.'/'.$_GET['a'].'/'.trim($pa, "/").'/';
	}

	public function __get($args){
		if($args == "limit" || $args == "page")
			return $this->$args;
		else
			return null;
	}

	private function start(){
		if($this->total == 0)
			return 0;
		else
			return ($this->page - 1) * $this->listrow+1;
	}

	private function end(){
		return min($this->page * $this->listrow, $this->total);
	}

	private function firstprev(){
		if($this->page > 1){
			$str = "&nbsp;<a style='text-decoration: none;' href='{$this->url}page/1'>{$this->config["first"]}</a>";
			$str.= "&nbsp;<a style='text-decoration: none;' href='{$this->url}page/".($this->page - 1)."'>{$this->config["prev"]}</a>&nbsp;";
			return $str;
		}
	}

	private function pagelist(){
		$linkpage = "&nbsp;<b>";
		$inum=floor($this->listnum / 2);

		for ($i=$inum; $i>=1; $i--) {
			$page = $this->page - $i;

			if($page >= 1)
				$linkpage.="<a style='text-decoration: none;' href='{$this->url}page/{$page}'>{$page}</a>&nbsp;";
		}

		if($this->pagenum > 1)
			$linkpage.="<span style='padding:1px 2px;background:#ccc;color:white'>{$this->page}</span>&nbsp;";

		for ($i=1; $i<=$inum; $i++) {
			$page = $this->page + $i;
			if($page<=$this->pagenum)
				$linkpage.="<a style='text-decoration: none;' href='{$this->url}page/{$page}'>{$page}</a>&nbsp;";
			else
				break;
		}

		$linkpage.='</b>';
		return $linkpage;
	}

	private function nextlast(){
		if($this->page != $this->pagenum){
			$str ="&nbsp;<a style='text-decoration: none;' href='{$this->url}page/".($this->page+1)."'>{$this->config["next"]}</a>&nbsp;";
			$str.="&nbsp;<a style='text-decoration: none;' href='{$this->url}page/".($this->pagenum)."'>{$this->config["last"]}</a>&nbsp;";
			return $str;
		}
	}

	private function gopage(){
		if($this->pagenum > 1){
			return '&nbsp;<input style="margin:0 5px 0 0;width:20px;height:13px;line-height:13px;text-align:Center; !important;border:1px solid #7aaebd;" type="text" onkeydown="javascript:if(event.keyCode==13){var page=(this.value>'.$this->pagenum.')?'.$this->pagenum.':this.value;location=\''.$this->url.'page/\'+page+\'\'}" value="'.$this->page.'"><input style="font-size:10px;cursor:pointer;width:30px;height:20px;line-height:20px;border:1px solid #cccccc;" type="button" value="GO" onclick="javascript:var page=(this.previousSibling.value>'.$this->pagenum.')?'.$this->pagenum.':this.previousSibling.value;location=\''.$this->url.'page/\'+page+\'\'">&nbsp;';
		}
	}

	private function disnum(){
		if($this->total > 0){
			return $this->end() - $this->start() + 1;
		}else{
			return 0;
		}
	}

	public function pageinfo(){
		$arr = func_get_args();

		$html[0]="&nbsp;共<b> {$this->total} </b>{$this->config["head"]}&nbsp";
		$html[1]="&nbsp;本页 <b>".$this->disnum()."</b> 条&nbsp;";
		$html[2]="&nbsp;<b>{$this->page} / {$this->pagenum} </b>页&nbsp;";
		$html[3]=$this->firstprev();
		$html[4]=$this->pagelist();
		$html[5]=$this->nextlast();
		$html[6]=$this->gopage();

		$fpage = '<div style="font:12px \'\5B8B\4F53\', san-serif;">';
		if(count($arr) < 1)
			$arr = array(0, 1, 2, 3, 4, 5, 6);

		for ($i=0; $i<count($arr); $i++) 
		 	$fpage.=$html[$arr[$i]];	

	 	$fpage.='</div>';
	 	return $fpage;
	}
}



?>