<?php

/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//文件上传类

class Fileupload extends Image{
	protected $filepath;
	protected $filename;
	protected $errornum = 0;
	protected $orfile;
	protected $tmpfile;
	protected $filetype;
	protected $maxsize = 2000000;
	protected $filesize;
	protected $allowtype;
	protected $newname;
	protected $randname;


	public function __construct($filepath = '', $randname = true, $allowtype = array("jpg", "gif", "png")){
		$this->allowtype = $allowtype;
		$this->randname = $randname;

		if($filepath == '')
			$this->filepath = ZH_PATH."uploads/";
		else
		 	$this->filepath = $filepath;
		 
	}

	public function upload($file, $width=0, $height=0){
		$this->setoption('errornum', 0);
		$this->setoption('filename', $file);
		$this->setfiles();
		$this->check();
		if($this->errornum < 0)
			return $this->errornum;
			return $this->copyfile($width, $height);
	}

	public function newfilename(){
		return $this->newname;
	}

	protected function check(){
		$this->makepath();
		$this->checktype();
		$this->checksize();
	}

	protected function checktype(){
		if(!empty($this->filetype)){
			if(!in_array($this->filetype, $this->allowtype)){
				$this->setoption('errornum', -2);
				return $this->errornum;
			}
		}
	}

	protected function checksize(){
		if($this->filesize > $this->maxsize)
			$this->setoption('errornum', -3);
		return $this->errornum;
	}

	protected function setoption($key, $val){
		$this->$key = $val;
	}

	protected function setfiles(){
		if($this->getfileerror() != 0){
			$this->setoption('errornum', -1);
			return $this->errornum;
		}

		$this->setoption('orfile', $this->getfilename());
		$this->setoption('tmpfile', $this->gettmpfile());
		$this->setoption('filetype', $this->getfiletype());
		$this->setoption('filesize', $this->getfilesize());
	}

	protected function copyfile($width, $height){
		$path = $this->filepath;
		if($this->randname == true){
			$this->newname = $this->israndname();
		}else{
			$this->newname = $this->orfile;
		}

		if($path[strlen($path)-1] != '/'){
			$path .='/';
		}

		$path .=$this->newname;
		if(!move_uploaded_file($this->tmpfile, $path)){
			$this->setoption('errornum', -5);
		}

		$this->getimage($path);
		$newfile = "uploads/".$this->newname;
		$this->kindthumb($newfile, $width, $height, $newfile);
		
		return $this->errornum;

	}

	protected function israndname(){
		$name = date('YmdHis').'_'.rand(100, 999);
		return $name.'.'.$this->filetype;
	}

	protected function makepath(){
		if(!file_exists($this->filepath)){
			if(!mkdir($this->filepath, 0755)){
				$this->setoption('errornum', -7);
				return false;
			}
		}
	}

	protected function getfiletype(){
		$type = explode(".", $this->filename['name']);
		$type = $type[count($type) -1];
		$type = strtolower($type);
		return $type;
	}

	protected function getfileerror(){
		return $this->filename['error'];
	}

	protected function getfilename(){
		return $this->filename['name'];
	}

	protected function gettmpfile(){
		return $this->filename['tmp_name'];
	}

	protected function getfilesize(){
		return $this->filename['size'];
	}

	public function error(){
		switch ($this->errornum) {
			case -1:
				val::mess('未知错误');
				break;
			case -2:
				val::mess('该类型不允许上传');
				break;
			case -3:
				val::mess('文件过大');
				break;
			case -4:
				val::mess('产生文件名出错');
				break;
			case -5:
				val::mess('上传失败');
				break;
			case -6:
				val::mess('目录不存在');
				break;
			case -7:
				val::mess('建立目录失败');
				break;	
		}
	}
}


?>