<?php
class Install{
    private $process;
    private $installfrom;
    private $messlist;
    private $includefile;
	
    public function __construct(){
        $this->includefile=dirname(dirname(__FILE__))."/zh/include.php";
        $this->process=new process($this->includefile, "zhcms.sql");
        $this->Installfrom=new Installfrom();
        $this->messlist="";
    }
		
    public function exestep($step){
		switch($step){
			case 1:
				echo $this->Installfrom->getagreement();
				break;
			case 2:
				$this->messlist='请在下面的表单中正确填写数据库连接的配置信息';
                $input=array(
                    "DB_HOST"=>DB_HOST,
					"DB_USER"=>DB_USER,
					"DB_PWD"=>DB_PWD,
					"DB_NAME"=>DB_NAME,
					"TAB_FIX"=>TAB_FIX
				);
				echo $this->Installfrom->getdbfrom($this->messlist, $input);
				break;
			case 3:
				if(!$this->validatedbfrom($_POST)){
					echo $this->Installfrom->getdbfrom($this->messlist, $_POST, "error");
				}else{
					if($this->process->configsys($_POST)){
						$this->messalist='请在下面的表单中正确填写管理员账号信息';
						$input=array(
							"ADMIN_USER"=>"admin",
							"ADMIN_PWD"=>"",
                            "ADMIN_REPWD"=>""
						);
						echo $this->Installfrom->getadminfrom($this->messlist, $input);
					}else{
						echo "写入配置文件失败!!";
					}
				}
				break;
			case 4:
				if(!$this->validateadminfrom($_POST)){
					echo $this->Installfrom->getadminfrom($this->messlist, $_POST, "error");
				}else{
					if($this->process->createdb($_POST)){
						$installstats=true;
					}else{
						$installstats=false;
					}
					echo $this->Installfrom->getinstallmessage($this->process->getinstallinfo(), $installstats);
				}
				break;
			case 5:
				if(file_put_contents("../Public/install_lock", "恭喜您，安装中环网站成功...")){
					echo '<script>window.location="../index.php"</script>';
				}
				break;
		}

	}
		
	public function validatedbfrom($post){
		$rs=true;
		if(trim($post['DB_HOST']=='')){
			$this->messlist.='数据库主机名不能为空</br>';
			$rs=false;
		}
		if(trim($post['DB_USER']=='')){
			$this->messlist.='数据库用户不能为空</br>';
			$rs=false;
		}
		if(trim($post['DB_NAME']=='')){
			$this->messlist.='数据库名称不能为空</br>';
			$rs=false;
		}
		if(trim($post['TAB_FIX']=='')){
			$this->messlist.='表名前缀不能为空</br>';
			$rs=false;
		}
		if(!$rs){
			return false;
		}
		if(!@mysql_connect($post['DB_HOST'], $post['DB_USER'], $post['DB_PWD'])){
			$this->messlist.='数据库链接失败，请检查用户名，密码</br>';
			$rs=false;
		}
		return $rs;
	
	
    }

    public function validateadminfrom($post){
        $rs=true;
        if(trim($post['ADMIN_USER']=='')){
            $this->messlist.='管理员账号不能为空</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_PWD']=='')){
            $this->messlist.='管理员密码不能为空</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_REPWD']=='')){
            $this->messlist.='重复输出的密码不能为空</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_PWD']) !=trim($post['ADMIN_REPWD'])){
            $this->messlist.='输入的两次密码不一致</br>';
            $rs=false;
        }
        if(trim($post['ADMIN_MAIL']=='')){
            $this->messlist.='管理员邮箱不能为空</br>';
            $rs=false;
        }else if(!preg_match("/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $post['ADMIN_MAIL'])){
            $this->messlist.='不是合法的电子邮箱格式</br>';
            $rs=false;
        }
        return $rs;
    }
}
?>
