<?php
/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//栏目控制类
class NavAction extends CommonAction{
	private $nav;
	//数据初始化
	public function __construct(){
		parent::__construct();
		$this->nav = new NavModel();
	}
	//检测数据是否合法
	public function check($nav){
		if(!val::check($nav)){
			$this->msg('栏目标题不能为空');
		}
		return $nav;
	}
	//删除栏目
	public function del(){
		if($this->nav->delete($_GET['id'])){
			$this->msg('删除栏目成功');
		}else{
			$this->msg('删除栏目失败');
		}
	}
	//获取栏目ID并修改
	public function mod(){
		if(isset($_GET['id'])){
			$data = $this->nav->get_one($_GET['id']);
			if(!$data){
				$this->msg('该栏目不存在，或者已被删除');
			}
		}

		$this->assign("data", $data);
		$this->assign("select", $this->nav->select($root= "顶级栏目", "pid", $data['pid']));
		$this->display();
	}
	//修改栏目
	public function update(){
		if($this->check($_POST['title'])){
			if($this->nav->update($_POST)){
				$this->msg('栏目修改成功');
			}else{
				$this->msg('数据保持原样');
			}
		}
	}
	//栏目排序
	public function ord(){
		if(isset($_POST['sub'])){
			if($this->nav->ord($_POST)){
				$this->msg('栏目排序成功');
			}else{
				$this->msg('数据保持原样');
			}
		}
	}
	//显示栏目列表
	public function index(){
		$page = new Page($this->nav->nav_total(), 15);
		$this->assign("page", $page->pageinfo());
		$this->assign("list", $this->nav->shownav($page->limit));
		$this->display();
	}
	//添加栏目
	public function add(){
		if(isset($_POST['sub'])){
			$_POST['path'] = $this->nav->getpath($_POST['pid']);
			if($this->check($_POST['title'])){
				if($this->nav->insert($_POST)){
					$this->msg('栏目添加成功');
				}else{
					$this->msg('栏目添加失败');
				}
			}
		}
		$this->assign("select", $this->nav->select());
		$this->display();
	}

}


?>