<?php

/*
'#################################################################
'# 程序名称：中环CMSV2.0
'# 授权方式：免费软件
'# 作者：善
'# 联系QQ:9118847
'# 作者网站:http://www.ps173.com
'# 发布时间：2015-6-10
'# 声明：欢迎广大的PHP爱好者一起共同探讨
'# 声明：各种用途均可免费使用、自由传播，但必须保留程序代码中的版权信息。
'#################################################################
 */

//文章控制类
class ArticleAction extends CommonAction{
	private $article;

		//初据初始化
	public function __construct(){
		parent::__construct();
		$this->article = new ArticleModel();
	}
		//检测数据是否合法
	public function check($post){
		$rs = true;

		if($post['pid'] == 0 ){
			$this->msg('栏目不能为空');
			$rs = false;
		}

		if(!val::check($post['title'])){
			$this->msg('标题不能为空');
			$rs = false;
		}

		if(val::length($post['title'], 30, 'max')){
			$this->msg('标题不能超过30个字');
			$rs = false;
		}

		if(val::length($post['info'], 300, 'max')){
			$this->msg('内容摘要不能超过300个字');
			$rs = false;
		}

		if(!val::check($post['content'])){
			$this->msg('文章内容不能为空');
			$rs = false;
		}

		return $rs;
	}
		//删除文章
	public function del(){
		if(isset($_GET['id'])){
			if($this->article->delete($_GET['id'])){
				$book = D("book");
				$book->artdel(array("aid"=>$_GET['id']));
				$this->msg('删除文章成功');
			}else{
				$this->msg('删除文章失败');
			}
		}
	}
		//列出文章属性
	public function attr($attr){
		$arr = array("大图", "推荐", "头条");
		$attrs = explode(',', $attr);
		$attrno = array_diff($arr, $attrs);
		if($attrs[0] != '无'){
			foreach ($attrs as $val) {
				@$html .='<input type="checkbox" checked="checked" name="attr[]" value="'.$val.'"/>'.$val;
			}
		}

		foreach ($attrno as $val) {
			@$html .='<input type="checkbox" name="attr[]" value="'.$val.'"/>'.$val;
		}

		return $html;
	}
		//修改文章
	public function update(){
		if(isset($_POST['sub'])){
			if(empty($_POST['thumb']) && @$_POST['pic_thumb'] == 1){
				$_POST['thumb'] = $this->article->fileup(val::getimgbody($_POST['content']), 150, 110, "_thumb");
			}

			if(empty($_POST['paly']) && @$_POST['pic_paly'] == 1){
				$_POST['paly'] = $this->article->fileup(val::getimgbody($_POST['content']), 370, 350, "_paly");
			}

			if($this->check($_POST)){
				$_POST['attr']=isset($_POST['attr']) ? implode(",", $_POST['attr']) : '无';
				if($this->article->update($_POST)){
					$this->msg('恭喜你，文章修改成功');
				}else{
					$this->msg('很遗憾，文章修改失败');
				}
			}
		}
	}
		//或许修改文章的ID
	public function mod(){
		if(isset($_GET['id'])){
			$list = $this->article->list_one($_GET['id']);
			if(!$list){
				$this->msg('该文章不存在，或者已经被删除');
			}

			$list['attr'] = $this->attr($list['attr']);
			$this->assign("select", D("nav")->select($root= "请选择栏目", "pid", $list['pid']));
	    	$this->assign("editor", val::editor("content", $list['content']));
		}
		$this->assign("list", $list);
		$this->display();
	}
		//设置显示或隐藏
	public function setviews(){
		$this->article->setviews(array("id"=>$_GET['id'], "views"=>$_GET['views']));
	}
		//批量操作文章
	public function fpro(){
		if(isset($_POST['id'])){
			if(isset($_POST['audits'])){
				if($this->article->fpro($_POST['id'], "views='0'")){
			 	  $this->msg('批量审核成功');
				}else{
				  $this->msg('批量审核失败');
				}
			}else if(isset($_POST['locks'])){
				if($this->article->fpro($_POST['id'], "views='1'")){
				  $this->msg('批量锁定成功');
				}else{
				  $this->msg('批量锁定失败');
				}
			}else if(isset($_POST['dels'])){
				if($this->article->delete($_POST['id'])){
					foreach($_POST['id'] as $id){
						$book = D("book");
						$book->artdel(array("aid"=>$id));
					}
					$this->msg('批量删除成功');
				}else{
					$this->msg('批量删除失败');
				}
			}
		}else{
			$this->msg('请选择你要操作的文章');
		}
	}
		//显示文章列表
	public function index(){
		if(@$_GET['views'] == "0"){
			$where["views"] = "0";
			$ipage = "views/{$_GET['views']}";
		}else if(@$_GET['views'] == "1"){
			$where["views"] = "1";
			$ipage = "views/{$_GET['views']}";
		}

		if(@$_GET['attr'] == "大图"){
			$where['attr'] = "%大图%";
			$ipage = "attr/{$_GET['attr']}";
		}else if(@$_GET['attr'] == "推荐"){
			$where['attr'] = "%推荐%";
			$ipage = "attr/{$_GET['attr']}";
		}else if(@$_GET['attr'] == "头条"){
			$where['attr'] = "%头条%";
			$ipage = "attr/{$_GET['attr']}";
		}

		if(isset($_GET['pid'])){
			$where['pid'] = $_GET['pid'];
			$ipage = "pid/{$_GET['pid']}";
		}

		$page = new Page($this->article->list_total(@$where), 15, @$ipage);
		$this->assign("fpage", $page->page);
		$this->assign("page", $page->pageinfo());
		$this->assign("list", $this->article->show_list(@$where, $page->limit));
		$this->display();
	}
		//添加文章
	public function add(){
		if(isset($_POST['sub'])){
			if(empty($_POST['thumb']) && @$_POST['pic_thumb'] == 1){
				$_POST['thumb'] = $this->article->fileup(val::getimgbody($_POST['content']), 150, 110, "_thumb");
			}

			if(empty($_POST['paly']) && @$_POST['pic_paly'] == 1){
				$_POST['paly'] = $this->article->fileup(val::getimgbody($_POST['content']), 370, 350, "_paly");
			}

			if($this->check($_POST)){
				if($this->article->insert($_POST)){
					$this->msg('恭喜你，文章发布成功');
				}else{
					$this->msg('很遗憾，文章发布失败');
				}
			}
		}

		$this->assign("commt", D("set")->list_one("commt"));
		$this->assign("select", D("nav")->select($root= "请选择栏目"));
	    $this->assign("editor", val::editor("content"));
		$this->display();
	}
		//上传图片
	public function upload(){
		if(isset($_FILES)){
			return $this->article->upload($_FILES);
		}
	}
		//修传缩略图
	public function thumb(){

		$this->display();
	}
		//上传首页大图
	public function paly(){

		$this->display();
	}


} 


?>