<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class StartWebBehavior extends Behavior {
    public function run(&$content) {
    	$this->_checkSiteStatus();  //检查网站状态
    	$this->_clearLog();
    	$this->_makeSitemap();  //生成网站地图
    	make_secure_file(array(APP_DATA_PATH, APP_DATA_PATH.'zip/', APP_DATA_PATH.'sql/', RUNTIME_PATH) ); //生成安全文件
    	$this->_saveHistory();
    	$this->_wapAutoRedirect(); //是否自动跳转到Wap网站判断
    	$this->_wapPcAccess();       //是否禁止电脑访问手机网站
    }
    
    //保存信息浏览记录到cookie里
    private function _saveHistory(){
    	if( MODULE_NAME == 'Info' && ACTION_NAME == 'read' && is_numeric($_GET['id'])){
    		//存在小bug 不是商品的ID，也加入进去了
    		$h = YdHistory::getInstance();
    		$h->push( $_GET['id'] );
    	}
    }
    
    //清除runtime下面的日志文件，防止充满空间
    private function _clearLog(){
    	//仅在调试模式下清除
    	$logDir = RUNTIME_PATH."Logs";
    	if( APP_DEBUG && is_dir($logDir) ){
    		$max = 50; //50M字节
    		$size = getdirsize( $logDir ) / (1024*1024);
    		if( $size > $max){
    			//不能直接删除log目录，thinkphp不会重新生成
    			foreach (glob($logDir.'/*.log') as $filename) {
    				@unlink($filename);
    			}
    		}
    	}
    }
    
    /**
     * 检查网站状态
     */
    private function _checkSiteStatus(){
    	$gn = strtolower(GROUP_NAME); //当前分组名称
    	//启动时判断网站是否关闭==========================================================
    	if( $gn != 'admin' ){
    		if( $GLOBALS['Config']['WEB_STATUS'] == 0 ){
    			$tip = $GLOBALS['Config']['WEB_CLOSE_REASON'];
    			$html = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
    			<html xmlns=\"http://www.w3.org/1999/xhtml\">
    			<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />
    			<style>#tip{font-size:16px;color:#FF0000;width:650px;text-align:center;}</style>
    			</head><body style='text-align:center'><div id='tip'>$tip</div></body></html>";
    			exit($html);
    		}
    	}
    }
    
    /**
     * 是否自动跳转到Wap网站判断
     */
    private function _wapAutoRedirect(){
    	if(IS_API) return;
    	$gn = strtolower(GROUP_NAME); //当前分组名称
    	//自动跳转到Wap网站判断
    	//只有Home分组才自动跳转到Wap
    	if( $gn == 'home' ){
    		$wapAutoRedirect = $GLOBALS['Config']['WAP_AUTO_REDIRECT'];
    		if($wapAutoRedirect == 1){
    			/*
    			 import("@.Common.MobileDetect");
    			$d= new Mobile_Detect;
    			if( $d->isMobile() ){ //终端设备是Mobile
    			redirect(__APP__.'/Wap'); //自动跳转到Wap分组
    			}
    			*/
    			if( yd_is_mobile() ){ //终端设备是Mobile
    				$list = array('Channel', 'Info'); //只有这2个模块才自动跳转
    				$wapDomain = get_wap_domain();
    				$redirectUrl = ($_SERVER["HTTPS"] == "on") ? 'https://' : 'http://';
    				if(  in_array(MODULE_NAME, $list) && !empty($wapDomain) ){
						if ($_SERVER["SERVER_PORT"] != "80") {
							$redirectUrl .= $wapDomain.":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
						} else {
							$redirectUrl .= $wapDomain.$_SERVER["REQUEST_URI"];
						}
    				}else{
    					$redirectUrl = !empty($wapDomain) ? $redirectUrl.$wapDomain : __APP__.'/Wap';
    				}
    				redirect( $redirectUrl );
    			}
    		}
    	}
    }
    
    /**
     * 是否禁止电脑访问手机网站
     */
    private function _wapPcAccess(){
    	if(IS_API) return;
    	$gn = strtolower(GROUP_NAME); //当前分组名称
    	//是否禁止电脑访问手机网站（1：禁止，0：允许）================
    	//只有wap分组才有效
    	if( $gn == 'wap' ){
    		$wapPcAccess = $GLOBALS['Config']['WAP_PC_ACCESS'];
    		if($wapPcAccess == 1){
    			/*
    			 import("@.Common.MobileDetect");
    			$d= new Mobile_Detect;
    			if( !$d->isMobile() ){
    			$url = (__APP__=='')? '/' : __APP__;
    			redirect($url); //自动跳转到Home分组首页
    			}
    			*/
    			if( !yd_is_mobile() ){
    				$url = (__APP__=='')? '/' : __APP__;
    				redirect($url); //自动跳转到Home分组首页
    			}
    		}
    	}
    }
    
    /**
     * 生成网站地图
     */
    private function _makeSitemap(){
    	$files = array('./sitemap.xml', './sitemap.txt', './sitemap.html');
    	if( $GLOBALS['Config']['SITEMAP_ENABLE'] == 1){
    		$cacheTime = $GLOBALS['Config']['SITEMAP_TIME'];
    		foreach ($files as $f){
    			//只要有一个地图文件不存在或过期，就全部重新生成
    			if( !file_exists($f) || time() > filemtime($f) + $cacheTime ){
    				makeSitemap();
    				break;
    			}
    		}
    	}else{
    		foreach ($files as $f){
    			//只要有一个地图文件不存在或过期，就全部重新生成
    			if( file_exists($f) ){
    				@unlink($f);
    			}
    		}
    	}
    }
    
}