
DROP TABLE IF EXISTS `youdian_ad`;
CREATE TABLE `youdian_ad` (
  `AdID` int(11) NOT NULL AUTO_INCREMENT,
  `AdTypeID` tinyint(4) DEFAULT NULL,
  `AdName` varchar(50) DEFAULT NULL,
  `AdContent` text,
  `AdUrl` varchar(255) DEFAULT NULL,
  `AdDescription` varchar(255) DEFAULT NULL,
  `AdTime` datetime DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `AdGroupID` int(11) DEFAULT NULL,
  `AdOrder` int(11) DEFAULT '0',
  PRIMARY KEY (`AdID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_group`;
CREATE TABLE `youdian_ad_group` (
  `AdGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `AdGroupName` varchar(50) DEFAULT NULL,
  `AdGroupDescription` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AdGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_type`;
CREATE TABLE `youdian_ad_type` (
  `AdTypeID` tinyint(4) NOT NULL,
  `AdTypeName` char(20) DEFAULT NULL,
  PRIMARY KEY (`AdTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin`;
CREATE TABLE `youdian_admin` (
  `AdminID` int(11) NOT NULL AUTO_INCREMENT,
  `AdminName` varchar(50) DEFAULT NULL,
  `MemberID` int(11) DEFAULT NULL,
  `AdminGroupID` int(11) DEFAULT NULL,
  `AdminPassword` varchar(64) DEFAULT NULL,
  `LastLoginTime` datetime DEFAULT NULL,
  `LastLoginIP` varchar(15) DEFAULT NULL,
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `LoginFailCount` tinyint(4) NOT NULL DEFAULT '0',
  `LoginCount` int(11) DEFAULT '0',
  PRIMARY KEY (`AdminID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin_group`;
CREATE TABLE `youdian_admin_group` (
  `AdminGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `AdminGroupName` varchar(50) DEFAULT NULL,
  `AdminGroupRemark` varchar(255) DEFAULT NULL,
  `MenuPurview` text,
  `MenuTopPurview` varchar(512) DEFAULT NULL,
  `MenuGroupPurview` varchar(512) DEFAULT NULL,
  `ChannelPurviewcn` text,
  `ChannelPurviewen` text,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`AdminGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_active`;
CREATE TABLE `youdian_app_active` (
  `AppActiveID` int(11) NOT NULL AUTO_INCREMENT,
  `Uuid` varchar(20) DEFAULT '',
  `StartTime` datetime DEFAULT NULL,
  `Ip` varchar(20) DEFAULT '',
  PRIMARY KEY (`AppActiveID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_feedback`;
CREATE TABLE `youdian_app_feedback` (
  `AppFeedbackID` int(11) NOT NULL AUTO_INCREMENT,
  `AppFeedbackContent` varchar(512) DEFAULT '',
  `AppFeedbackImage` varchar(200) DEFAULT '',
  `AppFeedbackContact` varchar(50) DEFAULT '',
  `MemberID` int(11) DEFAULT '0',
  `Uuid` varchar(50) DEFAULT '',
  `AppFeedbackIp` varchar(20) DEFAULT '',
  `AppFeedbackTime` datetime DEFAULT NULL,
  PRIMARY KEY (`AppFeedbackID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_message`;
CREATE TABLE `youdian_app_message` (
  `AppMessageID` int(11) NOT NULL AUTO_INCREMENT,
  `AppMessageType` tinyint(4) DEFAULT '1',
  `AppMessageTitle` varchar(255) DEFAULT '',
  `AppMessageContent` text,
  `AppMessageParameter` varchar(255) DEFAULT '',
  `AppMessageTime` datetime DEFAULT NULL,
  PRIMARY KEY (`AppMessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_app_stat`;
CREATE TABLE `youdian_app_stat` (
  `Uuid` varchar(100) NOT NULL,
  `Platform` varchar(20) DEFAULT '',
  `Model` varchar(50) DEFAULT '',
  `Manufacturer` varchar(50) DEFAULT '',
  `Ip` varchar(20) DEFAULT '',
  `Time` datetime DEFAULT NULL,
  PRIMARY KEY (`Uuid`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_attribute`;
CREATE TABLE `youdian_attribute` (
  `AttributeID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelModelID` int(11) DEFAULT NULL,
  `FieldName` varchar(50) DEFAULT NULL,
  `FieldType` varchar(20) DEFAULT NULL,
  `DisplayName` varchar(255) DEFAULT NULL,
  `DisplayType` varchar(20) DEFAULT NULL,
  `DisplayOrder` int(11) DEFAULT '0',
  `DisplayWidth` varchar(10) DEFAULT NULL,
  `DisplayHeight` varchar(10) DEFAULT NULL,
  `DisplayClass` varchar(20) DEFAULT NULL,
  `DisplayValue` varchar(255) DEFAULT NULL,
  `DisplayHelpText` varchar(255) DEFAULT NULL,
  `IsValidate` tinyint(4) DEFAULT NULL,
  `ValidateRule` varchar(255) DEFAULT NULL,
  `GroupID` int(4) DEFAULT NULL,
  `IsRequire` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`AttributeID`)
) AUTO_INCREMENT=632 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner`;
CREATE TABLE `youdian_banner` (
  `BannerID` int(11) NOT NULL AUTO_INCREMENT,
  `BannerName` varchar(50) DEFAULT NULL,
  `BannerGroupID` int(11) NOT NULL DEFAULT '1',
  `BannerImage` varchar(512) DEFAULT NULL,
  `BannerThumbnail` varchar(512) DEFAULT NULL,
  `BannerUrl` varchar(512) DEFAULT NULL,
  `BannerOrder` int(11) NOT NULL DEFAULT '0',
  `BannerDescription` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`BannerID`)
) AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner_group`;
CREATE TABLE `youdian_banner_group` (
  `BannerGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `BannerGroupName` char(50) DEFAULT NULL,
  `BannerGroupOrder` int(11) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`BannerGroupID`)
) AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_cart`;
CREATE TABLE `youdian_cart` (
  `CartID` int(11) NOT NULL AUTO_INCREMENT,
  `ProductID` int(11) DEFAULT NULL,
  `ProductQuantity` int(11) DEFAULT '1',
  `MemberID` int(11) DEFAULT '0',
  `LanguageID` tinyint(4) DEFAULT '1',
  `AttributeValueID` varchar(200) DEFAULT '',
  PRIMARY KEY (`CartID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_cash`;
CREATE TABLE `youdian_cash` (
  `CashID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) NOT NULL DEFAULT '0',
  `CashQuantity` double DEFAULT '0',
  `CashType` tinyint(4) DEFAULT '1',
  `CashStatus` tinyint(4) DEFAULT '2',
  `CashTime` datetime DEFAULT NULL,
  `PayID` int(11) DEFAULT '0',
  `CashRemark` varchar(256) DEFAULT '',
  PRIMARY KEY (`CashID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel`;
CREATE TABLE `youdian_channel` (
  `ChannelID` int(11) NOT NULL AUTO_INCREMENT,
  `Parent` int(11) DEFAULT NULL,
  `HasChild` tinyint(4) DEFAULT NULL,
  `ChannelName` varchar(50) DEFAULT NULL,
  `ChannelSName` varchar(20) DEFAULT NULL,
  `ChannelContent` longtext,
  `ChannelSContent` text,
  `ChannelModelID` int(11) DEFAULT NULL,
  `ChannelTarget` varchar(10) DEFAULT NULL,
  `LinkUrl` varchar(512) DEFAULT NULL,
  `HasPicture` tinyint(4) DEFAULT '0',
  `ChannelPicture` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Keywords` varchar(255) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `Html` varchar(50) DEFAULT NULL,
  `ReadLevel` varchar(255) DEFAULT NULL,
  `PageSize` int(11) DEFAULT '20',
  `ChannelOrder` int(11) NOT NULL DEFAULT '0',
  `IndexTemplate` varchar(50) DEFAULT NULL,
  `ReadTemplate` varchar(50) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsShow` tinyint(4) NOT NULL DEFAULT '1',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsHtml` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `ChannelIcon` varchar(255) DEFAULT NULL,
  `ChannelStyle` tinyint(4) DEFAULT '0',
  `ChannelAlbum` text,
  `ChannelRelation` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ChannelID`)
) AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel_model`;
CREATE TABLE `youdian_channel_model` (
  `ChannelModelID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelModelName` varchar(50) DEFAULT NULL,
  `ChannelModelOrder` int(11) NOT NULL DEFAULT '0',
  `ChannelModelTable` varchar(50) DEFAULT NULL,
  `ChannelModelDescription` varchar(255) DEFAULT NULL,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IndexTemplate` varchar(50) DEFAULT NULL,
  `ReadTemplate` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ChannelModelID`)
) AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_collect`;
CREATE TABLE `youdian_collect` (
  `CollectID` int(11) NOT NULL AUTO_INCREMENT,
  `CollectName` varchar(255) DEFAULT NULL,
  `ChannelID` int(11) DEFAULT NULL,
  `ListUrlPara` text,
  `DetailUrlPara` text,
  `FieldPara` text,
  `ReplacePara` text,
  `OtherPara` text,
  `CreateTime` datetime DEFAULT NULL,
  `CollectDescription` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`CollectID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_comment`;
CREATE TABLE `youdian_comment` (
  `CommentID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL,
  `GuestID` int(11) DEFAULT '0',
  `GuestName` varchar(50) DEFAULT '',
  `GuestIP` varchar(20) DEFAULT '',
  `CommentContent` text,
  `CommentTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `CommentRank` tinyint(4) DEFAULT '3',
  `Parent` int(11) DEFAULT '0',
  `CommentPicture` varchar(512) DEFAULT '',
  PRIMARY KEY (`CommentID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_config`;
CREATE TABLE `youdian_config` (
  `ConfigID` int(11) NOT NULL AUTO_INCREMENT,
  `ConfigName` varchar(50) DEFAULT NULL,
  `ConfigValue` text,
  `ConfigDescription` varchar(255) DEFAULT NULL,
  `ConfigFile` varchar(20) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ConfigID`)
) AUTO_INCREMENT=239 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_customer`;
CREATE TABLE `youdian_customer` (
  `CustomerID` int(11) NOT NULL AUTO_INCREMENT,
  `Host` varchar(50) NOT NULL,
  `OS` varchar(20) DEFAULT NULL,
  `Version` varchar(10) DEFAULT NULL,
  `Edition` varchar(20) DEFAULT NULL,
  `Name` varchar(50) DEFAULT NULL,
  `Contact` varchar(20) DEFAULT NULL,
  `Telephone` varchar(20) DEFAULT NULL,
  `Mobile` varchar(20) DEFAULT NULL,
  `QQ` varchar(20) DEFAULT NULL,
  `TaoBao` varchar(20) DEFAULT NULL,
  `Email` varchar(20) DEFAULT NULL,
  `Date` date DEFAULT NULL,
  `Remark` varchar(255) DEFAULT NULL,
  `IsAuthorize` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`CustomerID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_delivery_time`;
CREATE TABLE `youdian_delivery_time` (
  `DeliveryTimeID` int(11) NOT NULL DEFAULT '0',
  `DeliveryTimeName` varchar(100) DEFAULT NULL,
  `DeliveryTimeOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`DeliveryTimeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_favorite`;
CREATE TABLE `youdian_favorite` (
  `FavoriteID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL,
  `MemberID` int(11) NOT NULL,
  `FavoriteTime` datetime DEFAULT NULL,
  PRIMARY KEY (`FavoriteID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_guestbook`;
CREATE TABLE `youdian_guestbook` (
  `MessageID` int(11) NOT NULL AUTO_INCREMENT,
  `GuestID` int(11) DEFAULT '0',
  `GuestName` varchar(50) DEFAULT NULL,
  `GuestIP` varchar(20) DEFAULT NULL,
  `Contact` text,
  `MessageTitle` text,
  `MessageContent` text,
  `MessageTime` datetime DEFAULT NULL,
  `AnswerContent` text,
  `AnswerTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `Email` text,
  `Address` text,
  `Gender` text,
  `QQ` text,
  PRIMARY KEY (`MessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_history`;
CREATE TABLE `youdian_history` (
  `HistoryID` int(11) NOT NULL AUTO_INCREMENT,
  `InfoID` int(11) NOT NULL DEFAULT '0',
  `MemberID` int(11) NOT NULL DEFAULT '0',
  `HistoryTime` datetime DEFAULT NULL,
  PRIMARY KEY (`HistoryID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_info`;
CREATE TABLE `youdian_info` (
  `InfoID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelID` int(11) DEFAULT NULL,
  `SpecialID` varchar(512) DEFAULT NULL,
  `MemberID` int(11) DEFAULT NULL,
  `InfoTitle` varchar(100) DEFAULT NULL,
  `InfoSContent` text,
  `InfoContent` longtext,
  `HasPicture` tinyint(4) NOT NULL DEFAULT '0',
  `InfoPicture` varchar(255) DEFAULT NULL,
  `ReadLevel` varchar(255) DEFAULT NULL,
  `InfoAttachment` varchar(255) DEFAULT NULL,
  `HasAttachment` tinyint(4) NOT NULL DEFAULT '0',
  `IsLinkUrl` tinyint(4) NOT NULL DEFAULT '0',
  `LinkUrl` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Keywords` varchar(255) DEFAULT NULL,
  `Description` varchar(512) DEFAULT NULL,
  `InfoOrder` int(11) NOT NULL DEFAULT '0',
  `InfoTime` datetime DEFAULT NULL,
  `InfoAuthor` varchar(50) DEFAULT NULL,
  `InfoHit` int(11) DEFAULT '0',
  `InfoFrom` varchar(50) DEFAULT NULL,
  `LabelID` varchar(512) DEFAULT NULL,
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `IsHtml` tinyint(4) NOT NULL DEFAULT '1',
  `Html` varchar(50) DEFAULT NULL,
  `InfoAlbum` text,
  `InfoRelation` varchar(255) DEFAULT NULL,
  `Tag` varchar(255) DEFAULT '',
  `InfoPrice` double DEFAULT '0',
  `ChannelIDEx` varchar(255) DEFAULT '',
  `TypeID` int(11) DEFAULT '0',
  PRIMARY KEY (`InfoID`)
) AUTO_INCREMENT=183 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_job`;
CREATE TABLE `youdian_job` (
  `JobID` int(11) NOT NULL AUTO_INCREMENT,
  `JobName` varchar(50) DEFAULT NULL,
  `Education` varchar(50) DEFAULT NULL,
  `Gender` varchar(10) DEFAULT NULL,
  `Age` varchar(50) DEFAULT NULL,
  `Salary` varchar(50) DEFAULT NULL,
  `Language` varchar(20) DEFAULT NULL,
  `Number` varchar(20) DEFAULT NULL,
  `Workplace` varchar(50) DEFAULT NULL,
  `Expiration` varchar(20) DEFAULT NULL,
  `Requirement` text,
  `JobOrder` int(11) DEFAULT '0',
  `Time` datetime DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`JobID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_label`;
CREATE TABLE `youdian_label` (
  `LabelID` int(11) NOT NULL AUTO_INCREMENT,
  `LabelName` char(20) DEFAULT NULL,
  `ChannelModelID` int(11) DEFAULT NULL,
  `LabelOrder` int(11) DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LabelID`)
) AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_language`;
CREATE TABLE `youdian_language` (
  `LanguageID` int(11) NOT NULL AUTO_INCREMENT,
  `LanguageName` varchar(20) DEFAULT NULL,
  `LanguageMark` varchar(10) DEFAULT NULL,
  `LanguageIcon` varchar(255) DEFAULT NULL,
  `LanguageOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LanguageID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_link`;
CREATE TABLE `youdian_link` (
  `LinkID` int(11) NOT NULL AUTO_INCREMENT,
  `LinkClassID` int(11) DEFAULT NULL,
  `LinkName` varchar(50) DEFAULT NULL,
  `LinkType` tinyint(4) DEFAULT '0',
  `LinkUrl` varchar(255) DEFAULT NULL,
  `LinkLogo` varchar(255) DEFAULT NULL,
  `LinkOrder` int(11) NOT NULL DEFAULT '0',
  `LinkDescription` varchar(512) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LinkID`)
) AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_link_class`;
CREATE TABLE `youdian_link_class` (
  `LinkClassID` int(11) NOT NULL AUTO_INCREMENT,
  `LinkClassName` varchar(50) DEFAULT NULL,
  `LinkClassOrder` int(11) NOT NULL DEFAULT '0',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LinkClassID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_log`;
CREATE TABLE `youdian_log` (
  `LogID` int(11) NOT NULL AUTO_INCREMENT,
  `LogType` tinyint(4) DEFAULT '1',
  `UserAction` varchar(255) DEFAULT NULL,
  `UserName` varchar(100) DEFAULT NULL,
  `UserIP` varchar(50) DEFAULT NULL,
  `UserCity` varchar(50) DEFAULT NULL,
  `LogTime` datetime DEFAULT NULL,
  `LogDescription` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`LogID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_mail`;
CREATE TABLE `youdian_mail` (
  `MailID` int(11) NOT NULL AUTO_INCREMENT,
  `MailClassID` int(11) DEFAULT NULL,
  `MailAccount` varchar(50) DEFAULT NULL,
  `Name` varchar(50) DEFAULT NULL,
  `Telephone` varchar(20) DEFAULT NULL,
  `Address` varchar(1024) DEFAULT NULL,
  `AddTime` datetime DEFAULT NULL,
  `Remark` varchar(1024) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_class`;
CREATE TABLE `youdian_mail_class` (
  `MailClassID` int(11) NOT NULL AUTO_INCREMENT,
  `MailClassName` varchar(50) DEFAULT NULL,
  `MailClassOrder` int(11) NOT NULL DEFAULT '0',
  `MailClassDescription` varchar(1024) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailClassID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_send`;
CREATE TABLE `youdian_mail_send` (
  `MailSendID` int(11) NOT NULL AUTO_INCREMENT,
  `MailTitle` varchar(255) DEFAULT NULL,
  `MailContent` text,
  `AddTime` datetime DEFAULT NULL,
  `SendTime` datetime DEFAULT NULL,
  `SendLog` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MailSendID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_member`;
CREATE TABLE `youdian_member` (
  `MemberID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberGroupID` int(11) DEFAULT '1',
  `MemberName` varchar(50) DEFAULT NULL,
  `MemberGender` tinyint(4) DEFAULT '1',
  `MemberRealName` varchar(50) DEFAULT NULL,
  `MemberPassword` varchar(64) DEFAULT NULL,
  `MemberBirthday` date DEFAULT NULL,
  `MemberAddress` varchar(100) DEFAULT NULL,
  `MemberPostCode` varchar(6) DEFAULT NULL,
  `MemberEmail` varchar(50) DEFAULT NULL,
  `MemberTelephone` varchar(20) DEFAULT NULL,
  `MemberMobile` varchar(20) DEFAULT NULL,
  `MemberQQ` varchar(20) DEFAULT NULL,
  `MemberQuestion` varchar(50) DEFAULT NULL,
  `MemberAnswer` varchar(50) DEFAULT NULL,
  `LastLoginTime` datetime DEFAULT NULL,
  `LastLoginIP` varchar(15) DEFAULT NULL,
  `RegisterTime` datetime DEFAULT NULL,
  `IsCheck` tinyint(4) NOT NULL DEFAULT '0',
  `IsLock` tinyint(4) NOT NULL DEFAULT '0',
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `WxID` varchar(50) DEFAULT NULL,
  `WxName` varchar(50) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `Position` varchar(100) DEFAULT NULL,
  `CardNumber` varchar(20) DEFAULT NULL,
  `CardTime` datetime DEFAULT NULL,
  `InviterID` int(11) DEFAULT '0',
  `MemberAvatar` varchar(200) DEFAULT NULL,
  `OpenID` varchar(200) DEFAULT NULL,
  `LoginCount` int(11) DEFAULT '0',
  `LoginFailCount` tinyint(4) DEFAULT '0',
  `RegisterIP` varchar(15) DEFAULT '',
  PRIMARY KEY (`MemberID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_member_group`;
CREATE TABLE `youdian_member_group` (
  `MemberGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberGroupName` varchar(50) DEFAULT NULL,
  `MemberGroupRemark` varchar(512) DEFAULT NULL,
  `MenuTopPurview` varchar(512) DEFAULT NULL,
  `MenuGroupPurview` varchar(512) DEFAULT NULL,
  `MenuPurview` text,
  `ChannelPurviewen` text,
  `ChannelPurviewcn` text,
  `IsSystem` tinyint(4) NOT NULL DEFAULT '0',
  `DiscountRate` double DEFAULT '1',
  PRIMARY KEY (`MemberGroupID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu`;
CREATE TABLE `youdian_menu` (
  `MenuID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuGroupID` int(6) DEFAULT NULL,
  `MenuName` char(20) DEFAULT NULL,
  `MenuContent` char(255) DEFAULT NULL,
  `MenuType` tinyint(4) DEFAULT '0',
  `MenuOrder` int(11) NOT NULL DEFAULT '0',
  `SubMenu` char(255) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuID`)
) AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_group`;
CREATE TABLE `youdian_menu_group` (
  `MenuGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuTopID` int(11) DEFAULT NULL,
  `MenuGroupName` char(20) DEFAULT NULL,
  `MenuGroupOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuGroupID`)
) AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_operation`;
CREATE TABLE `youdian_menu_operation` (
  `MenuOperationID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuID` int(11) DEFAULT NULL,
  `MenuOperationName` char(40) DEFAULT NULL,
  `ActionName` char(25) DEFAULT NULL,
  `ModuleName` char(25) DEFAULT NULL,
  `GroupName` char(25) DEFAULT 'Admin',
  `MenuOperationOrder` int(11) DEFAULT '0',
  `LogType` tinyint(4) DEFAULT '1',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`MenuOperationID`)
) AUTO_INCREMENT=532 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_top`;
CREATE TABLE `youdian_menu_top` (
  `MenuTopID` int(11) NOT NULL AUTO_INCREMENT,
  `MenuTopName` char(20) DEFAULT NULL,
  `MenuTopUrl` char(255) DEFAULT NULL,
  `MenuTopTarget` char(20) DEFAULT NULL,
  `MenuTopOrder` int(11) NOT NULL DEFAULT '0',
  `MenuOwner` tinyint(4) unsigned zerofill NOT NULL DEFAULT '0000',
  `IsActive` tinyint(4) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`MenuTopID`)
) AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_oauth`;
CREATE TABLE `youdian_oauth` (
  `OauthID` int(11) NOT NULL AUTO_INCREMENT,
  `OauthName` varchar(50) DEFAULT NULL,
  `OauthOrder` int(11) DEFAULT '0',
  `OauthAppID` varchar(200) DEFAULT '',
  `OauthAppKey` varchar(200) DEFAULT '',
  `OauthAppUrl` varchar(200) DEFAULT NULL,
  `OauthMark` varchar(20) DEFAULT '',
  `OauthAppRemark` varchar(255) DEFAULT '',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`OauthID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order`;
CREATE TABLE `youdian_order` (
  `OrderID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) NOT NULL,
  `OrderNumber` varchar(50) DEFAULT '1',
  `ShippingPrice` double DEFAULT '0',
  `PayPrice` double DEFAULT '0',
  `DiscountPrice` double DEFAULT '0',
  `TotalPrice` double DEFAULT '0',
  `OrderIntegral` int(11) DEFAULT '0',
  `PayID` int(11) NOT NULL,
  `ShippingID` int(11) NOT NULL,
  `OrderStatus` tinyint(4) DEFAULT '1',
  `PayStatus` tinyint(4) DEFAULT '2',
  `ShippingStatus` tinyint(4) DEFAULT '2',
  `OrderTime` datetime DEFAULT NULL,
  `OrderRemark` text,
  `ConsigneeRealName` varchar(20) DEFAULT NULL,
  `ConsigneeGender` tinyint(4) DEFAULT NULL,
  `ConsigneeEmail` varchar(20) DEFAULT NULL,
  `ConsigneePostcode` varchar(20) DEFAULT NULL,
  `ConsigneeMobile` varchar(20) DEFAULT NULL,
  `ConsigneeTelephone` varchar(20) DEFAULT NULL,
  `ConsigneeAddress` varchar(50) DEFAULT NULL,
  `ConsigneeRemark` varchar(255) DEFAULT NULL,
  `DeliveryTimeID` int(11) DEFAULT NULL,
  `LanguageID` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`OrderID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order_log`;
CREATE TABLE `youdian_order_log` (
  `OrderLogID` int(11) NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) DEFAULT NULL,
  `OrderLogType` tinyint(4) DEFAULT '1',
  `Operator` varchar(50) DEFAULT '0',
  `PayPrice` double DEFAULT '0',
  `ShippingNumber` varchar(50) DEFAULT '',
  `OrderLogTime` datetime DEFAULT NULL,
  `OrderLogRemark` text,
  PRIMARY KEY (`OrderLogID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order_product`;
CREATE TABLE `youdian_order_product` (
  `OrderProductID` int(11) NOT NULL AUTO_INCREMENT,
  `OrderID` int(11) DEFAULT NULL,
  `ProductID` int(11) DEFAULT NULL,
  `ProductName` varchar(255) DEFAULT NULL,
  `ProductPrice` double DEFAULT '0',
  `ProductQuantity` int(11) DEFAULT '1',
  `ProductAttribute` varchar(512) DEFAULT '',
  `AttributeValueID` varchar(200) DEFAULT '',
  PRIMARY KEY (`OrderProductID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_pay`;
CREATE TABLE `youdian_pay` (
  `PayID` int(11) NOT NULL AUTO_INCREMENT,
  `PayTypeID` int(11) DEFAULT '1',
  `PayName` varchar(100) DEFAULT NULL,
  `PayOrder` int(11) DEFAULT '0',
  `AccountName` varchar(100) DEFAULT NULL,
  `AccountPassword` varchar(100) DEFAULT NULL,
  `AccountKey` varchar(100) DEFAULT NULL,
  `AccountID` varchar(100) DEFAULT NULL,
  `PayRate` double DEFAULT '0',
  `PayCurrency` varchar(50) DEFAULT NULL,
  `p1` text,
  `p2` text,
  `PayInterface` tinyint(4) DEFAULT '1',
  `PayDescription` varchar(500) DEFAULT NULL,
  `SiteType` varchar(20) DEFAULT '2',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`PayID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_pay_type`;
CREATE TABLE `youdian_pay_type` (
  `PayTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `PayTypeName` varchar(255) DEFAULT NULL,
  `PayTypeOrder` int(11) DEFAULT '0',
  `IsOnline` tinyint(4) DEFAULT '1',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`PayTypeID`)
) AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_resume`;
CREATE TABLE `youdian_resume` (
  `ResumeID` int(11) NOT NULL AUTO_INCREMENT,
  `JobID` int(11) NOT NULL,
  `GuestID` int(11) DEFAULT NULL,
  `GuestName` varchar(20) DEFAULT NULL,
  `Gender` varchar(20) DEFAULT NULL,
  `Birthday` date DEFAULT NULL,
  `Ethnic` varchar(20) DEFAULT NULL,
  `Salary` varchar(20) DEFAULT NULL,
  `Political` varchar(20) DEFAULT NULL,
  `Education` varchar(20) DEFAULT NULL,
  `Telephone` varchar(50) DEFAULT NULL,
  `Email` varchar(50) DEFAULT NULL,
  `Address` varchar(50) DEFAULT NULL,
  `Time` datetime DEFAULT NULL,
  `Birthplace` varchar(20) DEFAULT NULL,
  `Specialty` varchar(20) DEFAULT NULL,
  `School` varchar(20) DEFAULT NULL,
  `Detail` text,
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ResumeID`)
) AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_secret`;
CREATE TABLE `youdian_secret` (
  `SecretID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` varchar(20) DEFAULT '',
  `AppSecret` varchar(64) DEFAULT '',
  `SecretTime` datetime DEFAULT NULL,
  `ApiList` varchar(255) DEFAULT '',
  `SecretRemark` varchar(100) DEFAULT '',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`SecretID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_shipping`;
CREATE TABLE `youdian_shipping` (
  `ShippingID` int(11) NOT NULL AUTO_INCREMENT,
  `ShippingName` varchar(100) DEFAULT NULL,
  `ShippingOrder` int(11) DEFAULT '0',
  `ShippingDescription` text,
  `ShippingPrice` double DEFAULT '0',
  `ShippingInsureRate` double DEFAULT '0',
  `IsCod` tinyint(4) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`ShippingID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_special`;
CREATE TABLE `youdian_special` (
  `SpecialID` int(11) NOT NULL AUTO_INCREMENT,
  `ChannelID` int(11) DEFAULT NULL,
  `SpecialName` char(50) DEFAULT NULL,
  `SpecialDescription` char(255) DEFAULT NULL,
  `SpecialOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  `SpecialPicture` char(255) DEFAULT '',
  PRIMARY KEY (`SpecialID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support`;
CREATE TABLE `youdian_support` (
  `SupportID` int(11) NOT NULL AUTO_INCREMENT,
  `SupportName` char(50) DEFAULT NULL,
  `SupportTypeID` int(11) DEFAULT NULL,
  `SupportNumber` text,
  `SupportOrder` int(11) NOT NULL DEFAULT '0',
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`SupportID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support3`;
CREATE TABLE `youdian_support3` (
  `Support3ID` int(11) NOT NULL AUTO_INCREMENT,
  `Support3Js` text,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`Support3ID`)
) AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support_type`;
CREATE TABLE `youdian_support_type` (
  `SupportTypeID` int(11) NOT NULL AUTO_INCREMENT,
  `SupportTypeName` char(20) DEFAULT NULL,
  `SupportTypeOrder` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`SupportTypeID`)
) AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_tag`;
CREATE TABLE `youdian_tag` (
  `TagID` int(11) NOT NULL AUTO_INCREMENT,
  `TagName` varchar(50) DEFAULT NULL,
  `TagContent` text,
  `TagDescription` varchar(255) DEFAULT NULL,
  `IsEnable` tinyint(4) NOT NULL DEFAULT '1',
  `LanguageID` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`TagID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_type`;
CREATE TABLE `youdian_type` (
  `TypeID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeName` varchar(100) DEFAULT '',
  `TypeOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  `LanguageID` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_attribute`;
CREATE TABLE `youdian_type_attribute` (
  `TypeAttributeID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeID` int(11) DEFAULT '0',
  `TypeGroupID` int(11) DEFAULT '0',
  `TypeAttributeName` varchar(100) DEFAULT '',
  `TypeAttributeOrder` int(11) DEFAULT '0',
  `ValueType` tinyint(4) DEFAULT '1',
  `InputType` tinyint(4) DEFAULT '1',
  `InputValue` varchar(255) DEFAULT '',
  `IsSearch` tinyint(4) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeAttributeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_attribute_value`;
CREATE TABLE `youdian_type_attribute_value` (
  `AttributeValueID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeAttributeID` int(11) DEFAULT '0',
  `InfoID` int(11) DEFAULT '0',
  `AttributeValue` text,
  `AttributePicture` varchar(255) DEFAULT '',
  `AttributePrice` double DEFAULT '0',
  PRIMARY KEY (`AttributeValueID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_type_group`;
CREATE TABLE `youdian_type_group` (
  `TypeGroupID` int(11) NOT NULL AUTO_INCREMENT,
  `TypeID` int(11) DEFAULT '0',
  `TypeGroupName` varchar(100) DEFAULT '',
  `TypeGroupOrder` int(11) DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_app`;
CREATE TABLE `youdian_wx_app` (
  `AppID` int(11) NOT NULL AUTO_INCREMENT,
  `AppName` varchar(100) DEFAULT NULL,
  `AppTypeID` tinyint(4) DEFAULT '1',
  `AppKeyword` varchar(50) DEFAULT NULL,
  `AppOrder` int(11) DEFAULT '99',
  `AppParameter` text,
  `AppDescription` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AppID`)
) AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_apptype`;
CREATE TABLE `youdian_wx_apptype` (
  `AppTypeID` int(11) NOT NULL DEFAULT '0',
  `AppTypeName` varchar(50) DEFAULT NULL,
  `AppTypeOrder` int(11) DEFAULT '99',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`AppTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_award`;
CREATE TABLE `youdian_wx_award` (
  `AwardID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `AwardNumber` tinyint(4) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `Mobile` varchar(50) DEFAULT NULL,
  `AwardSN` varchar(50) DEFAULT NULL,
  `AwardTime` datetime DEFAULT NULL,
  `AwardStatus` tinyint(4) DEFAULT '0',
  `IsCheck` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`AwardID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_consume`;
CREATE TABLE `youdian_wx_consume` (
  `ConsumeID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT NULL,
  `ConsumeType` tinyint(4) DEFAULT NULL,
  `ConsumeMoney` int(11) DEFAULT NULL,
  `ConsumeTime` datetime DEFAULT NULL,
  `RelationID` int(11) DEFAULT NULL,
  `Remark` text,
  PRIMARY KEY (`ConsumeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_coupon`;
CREATE TABLE `youdian_wx_coupon` (
  `CouponID` int(11) NOT NULL AUTO_INCREMENT,
  `CouponName` varchar(50) DEFAULT NULL,
  `CouponOrder` int(11) DEFAULT '99',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `CouponNumber` int(11) DEFAULT '100',
  `Remark` text,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`CouponID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_gift`;
CREATE TABLE `youdian_wx_gift` (
  `GiftID` int(11) NOT NULL AUTO_INCREMENT,
  `GiftName` varchar(50) DEFAULT NULL,
  `GiftOrder` int(11) DEFAULT '99',
  `StartTime` datetime DEFAULT NULL,
  `EndTime` datetime DEFAULT NULL,
  `Score` int(11) DEFAULT '100',
  `GiftPicture` varchar(255) DEFAULT NULL,
  `Remark` text,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`GiftID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_menu`;
CREATE TABLE `youdian_wx_menu` (
  `MenuID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `Parent` tinyint(4) DEFAULT NULL,
  `MenuName` varchar(50) DEFAULT NULL,
  `TypeID` tinyint(4) DEFAULT NULL,
  `MenuOrder` int(11) DEFAULT '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`MenuID`)
) AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_message`;
CREATE TABLE `youdian_wx_message` (
  `MessageID` int(4) NOT NULL AUTO_INCREMENT,
  `MsgID` varchar(50) DEFAULT NULL,
  `MsgType` varchar(10) DEFAULT NULL,
  `FromUserName` varchar(50) DEFAULT '3',
  `ToUserName` varchar(50) DEFAULT NULL,
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `CreateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`MessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_notify`;
CREATE TABLE `youdian_wx_notify` (
  `NotifyID` int(11) NOT NULL AUTO_INCREMENT,
  `NotifyName` varchar(255) DEFAULT NULL,
  `NotifyContent` text,
  `NotifyTime` datetime DEFAULT NULL,
  PRIMARY KEY (`NotifyID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_question`;
CREATE TABLE `youdian_wx_question` (
  `QuestionID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `QuestionOrder` int(11) DEFAULT '99',
  `QuestionName` varchar(255) DEFAULT NULL,
  `QuestionItem` text,
  `IsMultiple` tinyint(4) DEFAULT NULL,
  `IsEnable` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`QuestionID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_reply`;
CREATE TABLE `youdian_wx_reply` (
  `ReplyID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `ReplyTypeID` tinyint(4) DEFAULT '3',
  `Keyword` varchar(50) DEFAULT NULL,
  `Priority` int(11) DEFAULT '0',
  `TypeID` tinyint(4) DEFAULT NULL,
  `Count` int(11) DEFAULT '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`ReplyID`)
) AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_research`;
CREATE TABLE `youdian_wx_research` (
  `ResearchID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `QuestionID` int(11) DEFAULT NULL,
  `ItemID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `ResearchTime` datetime DEFAULT NULL,
  PRIMARY KEY (`ResearchID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_score`;
CREATE TABLE `youdian_wx_score` (
  `ScoreID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(11) DEFAULT NULL,
  `ScoreNumber` int(11) DEFAULT NULL,
  `ScoreTime` datetime DEFAULT NULL,
  `ScoreType` tinyint(4) DEFAULT NULL,
  `RelationID` int(11) DEFAULT NULL,
  `Remark` text,
  PRIMARY KEY (`ScoreID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_suggest`;
CREATE TABLE `youdian_wx_suggest` (
  `SuggestID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `SuggestContent` text,
  `SuggestTime` datetime DEFAULT NULL,
  PRIMARY KEY (`SuggestID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_type`;
CREATE TABLE `youdian_wx_type` (
  `TypeID` tinyint(4) NOT NULL AUTO_INCREMENT,
  `TypeName` varchar(50) DEFAULT NULL,
  `IsReply` tinyint(11) DEFAULT '1',
  `TypeOrder` tinyint(4) unsigned DEFAULT '0',
  `IsEnable` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`TypeID`)
) AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_vote`;
CREATE TABLE `youdian_wx_vote` (
  `VoteID` int(11) NOT NULL AUTO_INCREMENT,
  `AppID` int(11) DEFAULT NULL,
  `ItemID` int(11) DEFAULT NULL,
  `FromUser` varchar(50) DEFAULT NULL,
  `VoteTime` datetime DEFAULT NULL,
  PRIMARY KEY (`VoteID`)
) DEFAULT CHARSET=utf8;


INSERT INTO `youdian_ad_group` VALUES
('1','默认广告分组',NULL,'1','1'),
('2','default ad group',NULL,'1','2');

INSERT INTO `youdian_ad_type` VALUES
('1','图片广告'),
('2','文字广告'),
('3','动画/视频广告'),
('4','代码广告');

INSERT INTO `youdian_admin` VALUES
('1','admin','1','1','af7f2e404c296b7cc394a388c6caf497','2017-03-08 14:30:48','192.168.1.107','0','1','0','79');

INSERT INTO `youdian_admin_group` VALUES
('1','超级管理组','超级管理组拥有所有权限',NULL,NULL,NULL,NULL,NULL,'1'),
('2','频道管理员',NULL,'8,74','1,2,3,8','5,3','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29,32,30,31,53','34,35,37,40,41,43,47,48,50,51,52,54','0');

INSERT INTO `youdian_attribute` VALUES
('2','1','Parent','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'22','0','1','1'),
('3','1','Child','varchar','子类频道','select','50','270px',NULL,NULL,NULL,NULL,NULL,NULL,'22','0','0','0'),
('4','1','ChannelName','varchar','频道名称','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'22','1','1','0'),
('5','1','ChannelSName','varchar','简短名称','text','8','270px',NULL,'textinput',NULL,'如：新闻、图片、文章等','0',NULL,'22','0','1','0'),
('6','1','ChannelContent','text','详细内容','editor','5','100%','300px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('7','1','ChannelSContent','text','简短内容','textarea','4','100%','65px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('8','1','ChannelModelID','int','频道模型','modelselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'22','0','1','0'),
('9','1','ChannelTarget','varchar','链接目标','select','7',NULL,NULL,NULL,'_self|当前窗口_self\r\n_blank|新窗口_blank',NULL,NULL,NULL,'22','0','1','0'),
('10','1','HasPicture','int','是否启用代表图片','radio','2',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'24','0','0','0'),
('11','1','ChannelPicture','varchar','频道代表图片','image','2','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'24','0','1','0'),
('12','1','Keywords','varchar','页面关键词Keywords','text','12','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'23','0','1','1'),
('13','1','Description','varchar(512)','页面描述Description','textarea','13','100%',NULL,NULL,NULL,'设置页面描述，留空表示继承上级频道设置！建议不要超过200个字符！',NULL,NULL,'23','0','1','1'),
('14','1','PageSize','int','分页条数','text','10','270px',NULL,'textinput','20',NULL,NULL,NULL,'22','0','1','0'),
('15','1','ChannelOrder','int','频道排序','text','9','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'22','0','1','0'),
('16','1','IndexTemplate','varchar','频道首页模板','text','5','270px',NULL,'textinput','article.html','请输入模板文件名称，以html为扩展名！如：article.html',NULL,NULL,'22','0','1','0'),
('17','1','ReadTemplate','varchar','频道阅读模板','text','6','270px',NULL,'textinput','showarticle.html','请输入模板文件名称，以html为扩展名！如：showarticle.html',NULL,NULL,'22','0','1','0'),
('18','1','IsEnable','int','是否启用频道','radio','18',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'22','0','1','0'),
('19','1','IsLock','int','频道是否锁定','radio','17',NULL,NULL,NULL,'1|锁定\r\n0|不锁定|1',NULL,NULL,NULL,'22','0','1','0'),
('20','1','IsShow','int','频道是否显示','radio','16',NULL,NULL,NULL,'1|显示|1\r\n0|隐藏',NULL,NULL,NULL,'22','0','1','0'),
('21','1','IsSystem','int','是否是系统频道','radio','21',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'22','0','0','0'),
('22','1',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('23','1',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('24','1',NULL,NULL,'频道内容',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('25','2','SpecialID','int','专题编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','0','2','0'),
('26','2','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,'所有频道',NULL,NULL,NULL,'30','0','1','0'),
('27','2','SpecialName','varchar','专题名称','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','1','1','0'),
('28','2','SpecialDescription','varchar','专题描述','textarea','5','100%','100px',NULL,NULL,NULL,NULL,NULL,'30','0','1','0'),
('29','2','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'30','0','1','0'),
('30','2',NULL,NULL,'专题信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('31','2','SpecialOrder','int','专题排序','text','4',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'30','0','1','0'),
('32','30','InfoID','int','信息ID','text','1',NULL,NULL,'textinput',NULL,NULL,'0',NULL,'54','0','0','1'),
('33','30','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('34','30','SpecialID','varchar','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('35','30','InfoTitle','varchar','文章标题','text','4','50%',NULL,'textinput',NULL,NULL,'0',NULL,'54','1','1','1'),
('36','30','InfoSContent','varchar','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('37','30','InfoContent','varchar','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('38','30','HasPicture','int','是否启用代表图片','radio','5',NULL,NULL,NULL,'1|启用\n0|禁用|1',NULL,'0',NULL,'54','0','0','0'),
('39','30','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'54','0','1','0'),
('40','30','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','20',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0',NULL,'55','0','1','1'),
('41','30','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('42','30','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\n0|禁用|1',NULL,'0',NULL,'55','0','0','0'),
('43','30','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\n0|否|1',NULL,'0',NULL,'55','0','0','1'),
('44','30','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.cn','0',NULL,'55','0','1','0'),
('45','30','Keywords','varchar','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'56','0','1','1'),
('46','30','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'56','0','1','1'),
('47','30','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'55','0','1','1'),
('48','30','InfoTime','datetime','发表时间','datetime','19',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('49','30','InfoAuthor','varchar','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','0','0'),
('51','30','InfoHit','int','点击次数','text','19',NULL,NULL,'textinput','0',NULL,NULL,NULL,'55','0','1','1'),
('52','30','InfoFrom','varchar','来源','text','18',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('53','30','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'55','0','1','1'),
('54','30',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('55','30',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('56','30',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('57','32',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('58','32',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('59','32','ChannelContent','varchar','详细内容','editor','3','100%','300px',NULL,NULL,NULL,NULL,NULL,'57','0','1','0'),
('60','32','Keywords','varchar','页面关键字Keywords','text','2','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'58','0','1','1'),
('61','32','Description','varchar(512)','页面描述Description','textarea','3','100%',NULL,'textinput',NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'58','0','1','1'),
('62','32','HasPicture','int','是否启用代表图片','radio','2',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'57','0','0','0'),
('63','32','ChannelPicture','varchar','代表图片','image','1','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'57','0','1','0'),
('64','31',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('65','31',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('66','31',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('67','31','InfoID','int','信息ID','text','1',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'64','0','0','1'),
('68','31','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'64','0','1','1'),
('69','31','SpecialID','varchar','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'64','0','1','1'),
('70','31','InfoTitle','varchar','图片标题','text','4','50%',NULL,'textinput',NULL,NULL,'0',NULL,'64','1','1','1'),
('71','31','InfoSContent','varchar','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,'0',NULL,'64','0','1','0'),
('72','31','InfoContent','varchar','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'64','0','1','0'),
('73','31','HasPicture','int','是否启用代表图片','radio','5',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'64','0','0','0'),
('74','31','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'64','0','1','0'),
('75','31','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0',NULL,'66','0','1','1'),
('76','31','InfoAttachment','varchar(255)','附件','attachment','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'66','0','1','0'),
('77','31','HasAttachment','int','是否启用附件','radio','1',NULL,NULL,NULL,'1|启用|1\n0|禁用',NULL,'0',NULL,'66','0','0','0'),
('78','31','InfoAuthor','varchar','作者','text','4','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'66','0','0','0'),
('79','31','IsLinkUrl','int','是否是转向链接','radio','2',NULL,NULL,NULL,'1|是\n0|否|1',NULL,'0',NULL,'66','0','0','1'),
('80','31','InfoHit','int','点击次数','text','5',NULL,NULL,'textinput','0',NULL,NULL,NULL,'66','0','1','1'),
('81','31','LinkUrl','varchar(255)','转向链接','text','2','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com','0',NULL,'66','0','1','0'),
('82','31','Keywords','varchar','页面关键词 Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'65','0','1','1'),
('83','31','Description','varchar(512)','页面描述 Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'65','0','1','1'),
('85','31','InfoTime','datetime','发表时间','datetime','6',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'66','0','1','0'),
('86','31','IsEnable','int','是否启用','radio','29',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'66','0','1','1'),
('87','31','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'66','0','1','1'),
('88','30','LabelID','varchar','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'55','0','1','1'),
('89','31','LabelID','varchar','属性','labelcheckbox','8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'66','0','1','1'),
('90','1','LinkUrl','varchar(255)','转向链接','text','14','270px',NULL,'textinput',NULL,'如：http://www.baidu.com。频道模型为\"链接模型\"时有效！',NULL,NULL,'22','0','1','0'),
('91','33','ChannelTarget','varchar','链接目标','select','2',NULL,NULL,NULL,'_self|当前窗口_self\r\n_blank|新窗口_blank',NULL,NULL,NULL,'93','0','1','0'),
('92','33','LinkUrl','varchar(255)','转向链接','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'93','0','1','0'),
('93','33',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('94','33','ChannelName','varchar','频道名称','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'93','1','1','0'),
('95','3','BannerID','int','幻灯片编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','0','0'),
('96','3','BannerName','varchar','幻灯片名称','text','2','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('97','3','BannerImage','varchar','幻灯图片','image','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('98','3','BannerUrl','varchar','链接地址','text','5','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('99','3','BannerOrder','int','幻灯片排序','text','6','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'101','0','1','0'),
('100','3','IsEnable','int','是否启用','radio','7',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'101','0','1','0'),
('101','3',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('102','4',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('103','4','SupportID','int','客服编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','0','0'),
('104','4','SupportName','varchar','客服名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','1','1','0'),
('105','4','SupportTypeID','int','客服类型','supporttypeselect','3',NULL,NULL,NULL,NULL,'选择自定义类型，填写自定义客服HTML代码，可实现一键加QQ群、自定义QQ图标、发邮件等高级功能',NULL,NULL,'102','0','1','0'),
('106','4','SupportNumber','varchar','客服号码','textarea','4','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','1','0'),
('107','4','SupportOrder','int','客服排序','text','5','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'102','0','1','0'),
('108','4','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'102','0','1','0'),
('109','5',NULL,NULL,'基本信息','text',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('110','5','Support3ID','text','第三方客服编号','text','1',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'109','0','0','0'),
('111','5','Support3Js','int','第三方客服Js脚本','textarea','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'109','0','1','0'),
('112','5','IsEnable','int','是否启用','radio','3',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'109','0','1','0'),
('113','9','LinkClassID','int','友情链接分类编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','0','0','0'),
('114','9','LinkClassName','varchar','友情链接分类名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','1','1','0'),
('115','9','LinkClassOrder','int','友情链接分类排序','text','3','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'117','0','1','0'),
('117','9',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('118','10',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('119','10','LinkID','int','友情链接编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','0','0'),
('120','10','LinkClassID','int','链接分类','linkclassselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'118','0','1','0'),
('121','10','LinkType','int','链接类型','radio','1',NULL,NULL,NULL,'1|文字|1\r\n2|图片',NULL,NULL,NULL,'118','0','1','0'),
('122','10','LinkUrl','varchar(255)','链接地址','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('123','10','LinkOrder','int','链接排序','text','7','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'118','0','1','0'),
('124','10','IsEnable','int','是否启用','radio','9',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'118','0','1','0'),
('125','10','LinkName','varchar','链接名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','1','1','0'),
('126','10','LinkLogo','varchar','链接Logo','image','4','420px',NULL,'textinput',NULL,'鼠标移动到文本框可以预览Logo',NULL,NULL,'118','0','1','0'),
('127','10','LinkDescription','varchar','链接描述','textarea','8','100%','100px','textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('128','7',NULL,NULL,'招聘信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('129','7','JobID','int','招聘编号','text','1','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','0','0'),
('130','7','JobName','varchar','职位名称','text','2','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','1','1','0'),
('131','7','Education','varchar','学位要求','text','3','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('132','7','Gender','varchar','性别要求','text','4','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('133','7','Age','varchar','年龄要求','text','5','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('134','7','Salary','varchar','薪水','text','6','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('135','7','Language','varchar','语言要求','text','7','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('136','7','Number','varchar','招聘人数','text','8','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('137','7','Workplace','varchar','工作地点','text','9','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('138','7','Expiration','varchar','截至日期','text','10','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('139','7','Requirement','varchar','详细要求','editormini','11','100%','250px','textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('140','7','JobOrder','int','职位排序','text','12','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'128','0','1','0'),
('141','7','IsEnable','int','是否启用','radio','14',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'128','0','1','0'),
('142','7','Time','datetime','发布时间','datetime','13','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('143','8','CommentID','int','评论编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('144','8','InfoID','int','信息ID','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','0','1'),
('145','8','GuestID','int','评论人ID','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('146','8','GuestName','varchar','评论人','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('147','8','GuestIP','varchar','评论人IP','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('148','8','CommentContent','varchar','评论内容','textarea','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('149','8','CommentTime','datetime','评论时间','datetime','7','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('150','8','IsCheck','int','是否审核','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'151','0','1','0'),
('151','8',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('152','11',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('153','11','AdID','int','广告编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','0','0'),
('154','11','AdTypeID','int','广告类型','adtyperadio','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'152','0','1','0'),
('155','11','AdName','varchar','广告名称','text','3','550px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('156','11','AdContent','varchar','广告内容','image','4','100%','100px','textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('157','11','AdUrl','varchar','广告地址','text','5','550px',NULL,'textinput',NULL,'广告地址以http://开头，如：http://www.xx.com',NULL,NULL,'152','0','1','0'),
('158','11','AdDescription','varchar','广告描述','textarea','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('159','11','AdTime','datetime','发布时间','datetime','7','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('160','11','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'152','0','1','0'),
('161','12',NULL,NULL,'添加会员分组',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('162','12','MemberGroupID','int','会员分组ID','text','1','200px',NULL,NULL,NULL,NULL,NULL,NULL,'161','0','0','0'),
('163','12','MemberGroupName','varchar','会员分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'161','1','1','0'),
('164','12','MemberGroupRemark','varchar','会员分组备注','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'161','0','1','0'),
('165','12','IsSystem','int','是否是系统分组','radio','4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'161','0','0','0'),
('166','13',NULL,NULL,'会员信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('167','13','MemberID','int','会员编号','text','1','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('168','13','MemberGroupID','int','会员分组','membergroupselect','2',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('169','13','MemberName','varchar','会员名称','text','3','120px',NULL,'textinput',NULL,NULL,'0',NULL,'166','1','1','1'),
('170','13','MemberGender','int','性别','radio','4',NULL,NULL,NULL,'1|女\r\n0|男|1',NULL,NULL,NULL,'166','0','1','1'),
('171','13','MemberRealName','varchar','真实姓名','text','5','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('172','13','MemberPassword','varchar','密码','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('173','13','MemberBirthday','date','生日','date','7','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('174','13','MemberAddress','varchar','联系地址','text','15','280px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('175','13','MemberPostCode','varchar','邮政编码','text','9','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('176','13','MemberEmail','varchar','电子邮件','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('177','13','MemberTelephone','varchar','电话','text','11','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('178','13','MemberMobile','varchar','移动电话','text','12','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('179','13','MemberQQ','varchar','QQ','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('180','13','MemberQuestion','varchar','密保问题','text','17','280px',NULL,'textinput',NULL,'如：我初中地理老师是谁？我爸爸叫什么名字？',NULL,NULL,'166','0','1','1'),
('181','13','MemberAnswer','varchar','密保答案','text','18','280px',NULL,'textinput',NULL,'找回密码的重要依据，认真填写并记牢！',NULL,NULL,'166','0','1','1'),
('182','13','IsCheck','int','是否审核','radio','41',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'166','0','1','1'),
('183','13','LastLoginTime','datetime','最后登录时间','label','21','150px',NULL,NULL,NULL,NULL,NULL,NULL,'166','0','1','1'),
('184','13','LastLoginIP','varchar','最后登录IP','label','20','150px',NULL,NULL,NULL,NULL,NULL,NULL,'166','0','1','1'),
('185','13','RegisterTime','datetime','注册时间','label','22','150px',NULL,NULL,NULL,NULL,NULL,NULL,'166','0','1','1'),
('186','13','IsLock','int','是否锁定','radio','40',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'166','0','1','1'),
('187','13','IsSystem','int','是否系统','radio','42',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'166','0','0','1'),
('188','15','AdminGroupID','int','管理组ID','text','1','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('189','15','AdminGroupName','varchar','管理组名称','text','2','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','1','1','0'),
('190','15','AdminGroupRemark','varchar','管理组备注','text','3','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','1','0'),
('191','15','MenuPurview','varchar','管理组权限','text','4','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('192','15','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'193','0','0','0'),
('193','15',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('194','14',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('195','14','AdminID','int',NULL,'text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('196','14','AdminName','varchar','管理员名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'194','1','1','0'),
('197','14','MemberID','int',NULL,'text','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('198','14','AdminGroupID','int','管理组','admingroupselect','4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','1','0'),
('199','14','AdminPassword','varchar','密码','text','5',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'194','0','0','0'),
('200','14','LastLoginTime','varchar','最后登录时间','label','6','200px',NULL,NULL,NULL,NULL,NULL,NULL,'194','0','1','0'),
('201','14','LastLoginIP','varchar','最后登录IP','label','7','200px',NULL,NULL,NULL,NULL,NULL,NULL,'194','0','1','0'),
('202','14','IsLock','int','是否锁定','radio','8',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','1','0'),
('203','14','IsSystem','int','是否是系统','radio','9',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','0','0'),
('204','16',NULL,NULL,'模板文件',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('205','16','FileName','varchar','文件名称','label','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('206','16','FileContent','varchar','文件内容','editor','2','100%','500px',NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('207','1','Title','varchar','页面标题Title','text','11','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'23','0','1','1'),
('208','30','Title','varchar','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'56','0','1','1'),
('209','31','Title','varchar','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'65','0','1','1'),
('210','32','Title','varchar','页面标题Title','text','1','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'58','0','1','1'),
('211','17','TagID','int','自定义标签ID','text','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'215','0','0','0'),
('212','17','TagName','varchar','自定义标签名称','text','1','250px',NULL,'textinput',NULL,'名称只能使用英文字母、数字，并且必须以英文字母开头，不能与系统标签同名，否则会覆盖系统标签。在前台通过{$标签名称}调用！',NULL,NULL,'215','1','1','0'),
('213','17','TagDescription','varchar','自定义标签描述','text','2','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'215','0','1','0'),
('214','17','TagContent','varchar','自定义标签内容','editormini','3','100%','315px','textinput',NULL,NULL,NULL,NULL,'215','0','1','0'),
('215','17',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('216','17','IsEnable','int','是否启用自定义标签','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'215','0','1','0'),
('217','18','LabelID','int','属性标记编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('218','18','LabelName','varchar','属性标记名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'223','1','1','0'),
('219','18','ChannelModelID','int','所属频道模型','modelselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','1','0'),
('220','18','LabelOrder','int','属性标记排序','text','4','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'223','0','1','0'),
('221','18','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('222','18','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'223','0','1','0'),
('223','18',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('224','32','ChannelSContent','varchar','简短内容','textarea','2','100%','70px','textinput',NULL,NULL,NULL,NULL,'57','0','1','0'),
('225','1','Html','varchar','静态页面名称','text','1','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'23','0','1','0'),
('226','19','ChannelModelID','int','频道模型编号','text','0','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('227','19','ChannelModelName','varchar','频道模型名称','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','1','1','0'),
('228','19','ChannelModelOrder','int','频道模型排序','text','2','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'233','0','1','0'),
('229','19','ChannelModelTable','varchar','表名','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('230','19','ChannelModelDescription','varchar','频道模型描述','textarea','4','100%','80px','textinput',NULL,NULL,NULL,NULL,'233','0','1','0'),
('231','19','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'233','0','0','0'),
('232','19','IsEnable','int','是否是启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'233','0','1','0'),
('233','19',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('234','20',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('235','20','AttributeID','int','属性编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','0','0'),
('236','20','ChannelModelID','int','所属频道模型','label','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('237','20','FieldName','varchar','字段名称','label','4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('238','20','FieldType','varchar','字段类型','label','5','200px',NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('239','20','DisplayName','varchar','显示名称','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('240','20','DisplayType','varchar','显示类型','displaytypeselect','7',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('241','20','DisplayOrder','int','排序','text','8','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'234','0','1','0'),
('242','20','DisplayWidth','varchar','宽度','text','9','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('243','20','DisplayHeight','varchar','高度','text','10','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('244','20','DisplayClass','varchar','样式表类','text','11','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('245','20','DisplayValue','varchar','默认值','textarea','12','280px','85px','textinput',NULL,'格式：值|文本|是否选中(1:表示选中，不填表示未选中)，每项回车分开！例如：1|启用|1',NULL,NULL,'234','0','1','0'),
('246','20','DisplayHelpText','varchar','帮助文字','text','13','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('247','20','IsValidate','int','是否验证','radio','14',NULL,NULL,NULL,'1|启用验证\r\n0|禁用验证|1',NULL,NULL,NULL,'234','0','1','0'),
('248','20','ValidateRule','varchar','验证正则表达式','text','15','300px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('249','20','GroupID','int','所属分组','attributegroupselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('250','20','IsEnable','int','是否启用','radio','17',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'234','0','1','0'),
('251','20','IsSystem','int','是否是系统','radio','18',NULL,NULL,NULL,'1|系统|1\r\n0|自定义',NULL,NULL,NULL,'234','0','0','0'),
('252','21',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('253','21','AttributeID','int','字段分组编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'252','0','0','0'),
('254','21','DisplayName','varchar','字段分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'252','1','1','0'),
('255','21','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'252','0','1','0'),
('256','21','DisplayOrder','int','排序','text','3','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'252','0','1','0'),
('257','30','f1','varchar','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('258','30','f2','varchar','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('259','30','f3','varchar','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('260','30','f4','varchar','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('261','30','f5','varchar','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('262','30',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('263','30',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('264','31','f1','varchar','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,'0',NULL,'269','0','0','0'),
('265','31','f2','varchar','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'269','0','0','0'),
('266','31','f3','varchar','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,'0',NULL,'269','0','0','0'),
('267','31','f4','varchar','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,'0',NULL,'269','0','0','0'),
('268','31','f5','varchar','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,'0',NULL,'269','0','0','0'),
('269','31',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('270','31',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('271','34',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('272','34',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('273','34',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('274','34',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('275','34',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('276','34','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'271','0','1','1'),
('277','34','SpecialID','varchar(512)','所属专题','specialselect','2',NULL,NULL,NULL,NULL,NULL,'0',NULL,'271','0','1','1'),
('278','34','InfoTitle','varchar','视频标题','text','3','50%',NULL,'textinput',NULL,NULL,'0',NULL,'271','1','1','1'),
('279','34','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,'0',NULL,'271','0','1','0'),
('280','34','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,'0',NULL,'271','0','1','0'),
('281','34','HasPicture','int','是否启用代表图片','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('282','34','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,'0',NULL,'271','0','1','0'),
('283','34','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','8',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'272','0','1','1'),
('284','34','InfoAttachment','varchar(255)','视频文件','attachment','4','100%',NULL,'textinput',NULL,'超过5M的视频文件请使用FTP上传！推荐使用<span style=\'color:blue\'>H.264编码的mp4格式</span>，它能在电脑、平板、手机上播放！<a href=\'http://jingyan.baidu.com/article/c1465413b5ebc40bfdfc4c7a.html\' target=\'_blank\'>点击查看：如何转化为H.264编码的mp4格式？</a><br/>推荐将视频上传到第三方视频平台（如：优酷、土豆、搜狐视频等），然后再填写通用代码中的地址','0',NULL,'271','0','1','0'),
('285','34','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('286','34','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'272','0','0','1'),
('287','34','LinkUrl','varchar(255)','转向链接','text','2','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com','0',NULL,'272','0','1','0'),
('288','34','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'273','0','1','1'),
('289','34','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'273','0','1','1'),
('290','34','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'273','0','1','1'),
('291','34','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'272','0','1','1'),
('292','34','InfoTime','datetime','时间','datetime','7',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','1','1'),
('293','34','InfoAuthor','varchar(50)','作者','text','6','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','0','0'),
('294','34','InfoHit','int','点击次数','text','5',NULL,NULL,'textinput','0',NULL,NULL,NULL,'272','0','1','1'),
('295','34','InfoFrom','varchar(50)','来源','text','4',NULL,NULL,'textinput',NULL,NULL,'0',NULL,'272','0','1','0'),
('296','34','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'272','0','1','1'),
('297','34','LabelID','varchar(512)','属性','labelcheckbox','9',NULL,NULL,NULL,NULL,NULL,'0',NULL,'272','0','1','1'),
('298','34','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('299','34','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('300','34','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('301','34','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('302','34','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('303','35',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('304','35',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('305','35',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('306','35',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('307','35',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('308','35','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'303','0','1','1'),
('309','35','SpecialID','varchar(512)','所属专题','specialselect','1',NULL,NULL,NULL,NULL,NULL,'0',NULL,'303','0','1','1'),
('310','35','InfoTitle','varchar','下载标题','text','2','50%',NULL,'textinput',NULL,NULL,'0',NULL,'303','1','1','1'),
('311','35','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,'0',NULL,'303','0','0','0'),
('312','35','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,'0',NULL,'303','0','1','0'),
('313','35','HasPicture','int','是否启用代表图片','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('314','35','InfoPicture','varchar(255)','缩略图','image','4','100%',NULL,'textinput',NULL,NULL,'0',NULL,'303','0','1','0'),
('315','35','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','6',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0',NULL,'304','0','1','1'),
('316','35','InfoAttachment','varchar(255)','附件','attachment','3','50%',NULL,'textinput',NULL,NULL,'0',NULL,'303','0','1','0'),
('317','35','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('318','35','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\n0|否|1',NULL,'0',NULL,'303','0','0','1'),
('319','35','LinkUrl','varchar(255)','转向链接','text','1','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com','0',NULL,'304','0','1','0'),
('320','35','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'305','0','1','1'),
('321','35','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'305','0','1','1'),
('322','35','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'305','0','1','1'),
('323','35','InfoOrder','int','排序','text','2',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！','0',NULL,'304','0','1','1'),
('324','35','InfoTime','datetime','时间','datetime','5',NULL,NULL,'textinput',NULL,NULL,'0',NULL,'304','0','1','1'),
('325','35','InfoAuthor','varchar(50)','作者','text','3','270px',NULL,'textinput',NULL,NULL,'0',NULL,'304','0','1','0'),
('326','35','InfoHit','int','点击次数','text','4',NULL,NULL,'textinput','0',NULL,'0',NULL,'304','0','1','1'),
('327','35','InfoFrom','varchar(50)','来源','text','3',NULL,NULL,'textinput',NULL,NULL,'0',NULL,'304','0','1','0'),
('328','35','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,'0',NULL,'304','0','1','1'),
('329','35','LabelID','varchar(512)','属性','labelcheckbox','7',NULL,NULL,NULL,NULL,NULL,'0',NULL,'304','0','1','1'),
('330','35','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('331','35','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('332','35','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('333','35','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('334','35','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('335','36',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('336','36',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('337','36',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('338','36',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('339','36',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('340','36','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'335','0','1','1'),
('341','36','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'336','0','0','1'),
('342','36','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'335','1','1','1'),
('343','36','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,'0',NULL,'336','0','0','0'),
('344','36','InfoContent','text','产品详情','editor','8','100%','400px',NULL,NULL,NULL,'0',NULL,'335','0','1','0'),
('345','36','HasPicture','int','是否启用代表图片','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('346','36','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,'0',NULL,'335','0','1','0'),
('347','36','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0',NULL,'336','0','1','1'),
('348','36','InfoAttachment','varchar(255)','附件','attachment','1','50%',NULL,'textinput',NULL,'启用附件后有效！','0',NULL,'336','0','1','0'),
('349','36','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('350','36','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'336','0','0','1'),
('351','36','LinkUrl','varchar(255)','转向链接','text','2','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com','0',NULL,'336','0','1','0'),
('352','36','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'337','0','1','1'),
('353','36','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'337','0','1','1'),
('354','36','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'337','0','1','1'),
('355','36','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'336','0','1','1'),
('356','36','InfoTime','datetime','时间','datetime','6',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','1','1'),
('357','36','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('358','36','InfoHit','int','点击次数','text','5','270px',NULL,'textinput','0',NULL,NULL,NULL,'336','0','1','1'),
('359','36','InfoFrom','varchar(50)','来源','text','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('360','36','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'336','0','1','1'),
('361','36','LabelID','varchar(512)','属性','labelcheckbox','8',NULL,NULL,NULL,NULL,NULL,'0',NULL,'336','0','1','1'),
('362','36','f1','varchar(255)','扩展字段1','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'338','0','0','0'),
('363','36','f2','varchar(255)','编号','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'335','0','1','0'),
('364','36','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'338','0','0','0'),
('365','36','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('366','36','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('367','37',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('368','37',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('369','37',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','1'),
('370','37',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('371','37',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('372','37','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,'0',NULL,'368','0','1','1'),
('373','37','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('374','37','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'367','1','1','1'),
('375','37','InfoSContent','text','内容','textarea','7','100%','70px',NULL,NULL,NULL,'0',NULL,'367','0','1','0'),
('376','37','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,'0',NULL,'368','0','0','0'),
('377','37','HasPicture','int','是否启用代表图片','radio','5',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('378','37','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('379','37','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'368','0','1','1'),
('380','37','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'368','0','0','0'),
('381','37','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('382','37','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'368','0','0','1'),
('383','37','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'368','0','0','0'),
('384','37','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'369','0','1','1'),
('385','37','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'369','0','1','1'),
('386','37','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'369','0','1','1'),
('387','37','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！','0',NULL,'368','0','1','1'),
('388','37','InfoTime','datetime','时间','datetime','17',NULL,NULL,'textinput',NULL,NULL,'0',NULL,'368','0','1','1'),
('389','37','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('390','37','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,'0',NULL,'368','0','1','1'),
('391','37','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('392','37','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,'0',NULL,'368','0','1','1'),
('393','37','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('394','37','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('395','37','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('396','37','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('397','37','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('398','37','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('399','38',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('400','38',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('401','38',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('402','38',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('403','38',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('404','38','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'399','0','1','1'),
('405','38','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('406','38','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'399','1','1','1'),
('407','38','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('408','38','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('409','38','HasPicture','int','是否启用代表图片','radio','5',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('410','38','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('411','38','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'400','0','1','1'),
('412','38','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'400','0','0','0'),
('413','38','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('414','38','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'400','0','0','1'),
('415','38','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'400','0','0','0'),
('416','38','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'401','0','1','1'),
('417','38','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'401','0','1','1'),
('418','38','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'401','0','1','1'),
('419','38','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'399','0','1','1'),
('420','38','InfoTime','datetime','时间','datetime','17',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'399','0','1','1'),
('421','38','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('422','38','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','1','1'),
('423','38','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('424','38','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'399','0','1','1'),
('425','38','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('426','38','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('427','38','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('428','38','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('429','38','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('430','38','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('431','39',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('432','39',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('433','39',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('434','39',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('435','39',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('436','39','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'431','0','1','1'),
('437','39','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('438','39','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'431','1','1','1'),
('439','39','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('440','39','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('441','39','HasPicture','int','是否启用代表图片','radio','5',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('442','39','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('443','39','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'432','0','1','1'),
('444','39','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'432','0','0','0'),
('445','39','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('446','39','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'432','0','0','1'),
('447','39','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'432','0','0','0'),
('448','39','Title','varchar(255)','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0',NULL,'433','0','1','1'),
('449','39','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'433','0','1','1'),
('450','39','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'433','0','1','1'),
('451','39','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'431','0','1','1'),
('452','39','InfoTime','datetime','时间','datetime','17',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'431','0','1','1'),
('453','39','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('454','39','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','1','1'),
('455','39','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('456','39','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'431','0','1','1'),
('457','39','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('458','39','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('459','39','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('460','39','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('461','39','f4','text','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('462','39','f5','text','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('463','30','IsCheck','int','是否审核','radio','22',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'55','0','1','1'),
('464','31','IsCheck','int','是否审核','radio','28',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'66','0','1','1'),
('465','38','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'399','0','1','1'),
('466','39','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'431','0','1','1'),
('467','34','IsCheck','int','是否审核','radio','22',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,'0',NULL,'272','0','1','1'),
('468','35','IsCheck','int','是否审核','radio','22',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,'0',NULL,'304','0','1','1'),
('469','36','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,'0',NULL,'336','0','1','1'),
('470','37','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,'0',NULL,'368','0','1','1'),
('471','22','BannerGroupID','int','幻灯分组编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','0','0','0'),
('472','22','BannerGroupName','varchar(50)','幻灯分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','1','1','0'),
('473','22','IsSystem','int','是否是系统','radio','4',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'474','0','0','0'),
('474','22','BannerGroupID','int','基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('475','3','BannerGroupID','int','所属幻灯分组','bannergroupselect','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('476','22','BannerGroupOrder','int','幻灯分组排序','text','3','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'474','0','1','0'),
('477','1','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','15',NULL,NULL,'textinput',NULL,'不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效','0',NULL,'22','0','1','1'),
('478','13','f1','text','扩展字段1','text','25','200px',NULL,'textinput',NULL,NULL,'0',NULL,'483','0','0','0'),
('479','13','f2','text','扩展字段2','text','26','200px',NULL,'textinput',NULL,NULL,'0',NULL,'483','0','0','0'),
('480','13','f3','text','扩展字段3','text','27','200px',NULL,'textinput',NULL,NULL,'0',NULL,'483','0','0','0'),
('481','13','f4','text','扩展字段4','text','28','200px',NULL,'textinput',NULL,NULL,'0',NULL,'483','0','0','0'),
('482','13','f5','text','扩展字段5','text','29','200px',NULL,'textinput',NULL,NULL,'0',NULL,'483','0','0','0'),
('483','13',NULL,NULL,'其它信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('484','32','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效',NULL,NULL,'57','0','1','1'),
('485','20','IsRequire','int','是否是必填字段','radio','16',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'234','0','1','0'),
('486','1','IsHtml','int','是否启用Html静态缓存','radio','19',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成频道Html静态缓存',NULL,NULL,'22','0','1','0'),
('487','30','IsHtml','int','是否启用Html静态缓存','radio','24',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'55','0','1','0'),
('488','31','IsHtml','int','是否启用Html静态缓存','radio','30',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0',NULL,'66','0','1','0'),
('489','34','IsHtml','int','是否启用Html静态缓存','radio','24',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0',NULL,'272','0','1','0'),
('490','35','IsHtml','int','是否启用Html静态缓存','radio','24',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0',NULL,'304','0','1','0'),
('491','36','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0',NULL,'336','0','1','0'),
('492','37','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0',NULL,'368','0','1','0'),
('493','38','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'399','0','1','0'),
('494','39','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'431','0','1','0'),
('495','30','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'56','0','1','0'),
('496','31','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'65','0','1','0'),
('497','34','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'273','0','1','0'),
('498','35','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'305','0','1','0'),
('499','36','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'337','0','1','0'),
('500','37','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'369','0','1','0'),
('501','38','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'401','0','1','0'),
('502','39','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'433','0','1','0'),
('503','32','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'58','0','1','0'),
('504','1',NULL,NULL,'其它信息',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('505','1','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('506','1','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('507','1','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('508','23','MailClassName','varchar','邮件订阅分类名称','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('509','23','MailClassOrder','int','邮件订阅分类排序','text','2','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'512','0','1','0'),
('510','23','MailClassDescription','varchar','邮件订阅分类描述','textarea','3','100%','80px','textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('511','23','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'512','0','1','0'),
('512','23',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('513','24','MailClassID','int','所属订阅分类','mailclassselect','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'521','0','1','0'),
('514','24','MailAccount','varchar','邮箱帐号','text','2','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','1','1','0'),
('515','24','Name','varchar','姓名','text','3','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('516','24','Telephone','varchar','电话','text','4','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('517','24','Address','varchar','地址','text','5','370px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('518','24','AddTime','datetime','添加时间','datetime','6',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('519','24','Remark','varchar','备注','textarea','7','100%','80px','textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('520','24','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'521','0','1','0'),
('521','24',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('522','25',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('523','25','MailTitle','varchar','邮件主题','text','1','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'522','1','1','0'),
('524','25','MailContent','varchar','邮件内容','editormini','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('525','25','AddTime','datetime','添加时间','datetime','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('526','1','ChannelIcon','varchar','频道图标','imageex','4','500px',NULL,'textinput',NULL,'设置手机/微信网站频道图标，建议图片尺寸不大于64x64',NULL,NULL,'504','0','1','0'),
('527','1','ChannelStyle','varchar','频道首页模板排版样式','radio','5',NULL,NULL,NULL,'0|默认|1\r\n1|图文\r\n2|文字\r\n3|橱窗\r\n4|相册','设置手机/微信网站频道首页模板样式，是否有效取决于模板是否实现当前功能',NULL,NULL,'504','0','1','0'),
('528','6',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('529','6','GuestName','varchar','姓名,name','text','14','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('530','6','Contact','varchar','电话,telephone','text','15','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('531','6','MessageTitle','varchar','标题,Title','text','5','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','1','0'),
('532','6','MessageContent','text','内容,content','textarea','10','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','1','0'),
('533','6','f1','text','字段1','textarea','30','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','0','0'),
('534','6','f2','text','字段2','textarea','30','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','0','0'),
('535','6','f3','text','字段3','textarea','30','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','0','0'),
('536','6','f4','text','字段4','textarea','30','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','0','0'),
('537','6','f5','text','字段5','text','30','100%',NULL,NULL,NULL,NULL,'0',NULL,'528','0','1','0'),
('540','6','Email','text','Email','text','29','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('541','6','Address','text','地址,address','text','29','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('542','6','Gender','text','性别,gender','text','29','100%',NULL,NULL,NULL,NULL,'1',NULL,'528','1','0','0'),
('543','6','QQ','text','QQ','text','20','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('544','26',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('545','26','GuestName','text','姓名,name','text','1','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('546','26','Quantity','text','订购数量,number','text','2','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','1','0'),
('547','26','Telephone','text','电话,telephone','text','3','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','1','0'),
('548','26','QQ','text','QQ','text','4','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('549','26','Email','text','Email','text','5','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('550','26','Address','text','地址,address','text','6','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('551','26','Remark','text','备注,remark','textarea','7','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('552','26','f1','text','字段1','textarea','8','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','0','0'),
('553','26','f2','text','字段2','textarea','9','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','0','0'),
('554','26','f3','text','字段3','textarea','10','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','0','0'),
('555','26','f4','text','字段4','textarea','11','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','0','0'),
('556','26','f5','text','字段5','textarea','12','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','0','0'),
('557','26','ProductName','text','订购产品,Product','text','0','100%',NULL,NULL,NULL,NULL,'0',NULL,'544','0','1','0'),
('558','3','BannerThumbnail','varchar','缩略图','imageex','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('559','3','BannerDescription','text','幻灯片说明','textarea','6','100%','80px','textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('560','19','IndexTemplate','varchar','默认首页模板','text','3','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：article.html',NULL,NULL,'233','0','1','0'),
('561','19','ReadTemplate','varchar','默认阅读模板','text','4','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：showarticle.html',NULL,NULL,'233','0','1','0'),
('562','11','AdGroupID','int','所属广告位','adgroupselect','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('563','11','AdOrder','int','广告排序','text','5','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'152','0','1','0'),
('564','30',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('565','31',NULL,NULL,'相册/相关信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('566','34',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('567','35',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('568','36',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('569','37',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('570','38',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('571','39',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('572','30','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('573','30','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('574','31','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('575','31','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('576','34','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('577','34','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('578','35','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('579','35','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('580','36','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('581','36','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('582','37','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('583','37','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('584','38','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('585','38','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('586','39','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('587','39','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('588','39','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'433','0','1','1'),
('589','38','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'401','0','1','1'),
('590','37','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'369','0','1','1'),
('591','36','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'337','0','1','1'),
('592','35','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'305','0','1','1'),
('593','34','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'273','0','1','1'),
('594','31','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'65','0','1','1'),
('595','30','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'56','0','1','1'),
('596','39','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'432','0','0','0'),
('597','38','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'400','0','0','0'),
('598','37','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'368','0','0','0'),
('599','36','InfoPrice','double','价格','text','3','200px',NULL,'textinput','0',NULL,NULL,NULL,'335','0','1','0'),
('600','35','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'304','0','0','0'),
('601','34','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'272','0','0','0'),
('602','31','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'66','0','0','0'),
('603','30','InfoPrice','double','价格','text','0','200px',NULL,'textinput','0',NULL,NULL,NULL,'55','0','0','0'),
('604','1',NULL,NULL,'相册/相关信息',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('605','1','ChannelAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'604','0','1','0'),
('606','1','ChannelRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'604','0','1','0'),
('607','39','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'431','0','1','0'),
('608','38','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'399','0','1','0'),
('609','37','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'368','0','1','0'),
('610','36','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'335','0','1','0'),
('611','35','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'303','0','1','0'),
('612','34','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','1',NULL,NULL,NULL,'0',NULL,NULL,NULL,'271','0','1','0'),
('613','31','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','3',NULL,NULL,NULL,'0',NULL,NULL,NULL,'64','0','1','0'),
('614','30','ChannelIDEx','varchar(255)','所属扩展频道','channelexselect','3',NULL,NULL,NULL,'0',NULL,NULL,NULL,'54','0','1','0'),
('615','13','MemberAvatar','varchar','头像','image','4','400px',NULL,'textinput',NULL,'头像尺寸建议为80 x 80',NULL,NULL,'166','0','1','0'),
('616','30',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('617','31',NULL,NULL,'属性规格',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('618','34',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('619','35',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('620','36',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('621','37',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('622','38',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('623','39',NULL,NULL,'属性规格',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('624','39','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'623','0','1','1'),
('625','38','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'622','0','1','1'),
('626','37','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'621','0','1','1'),
('627','36','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'620','0','1','1'),
('628','35','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'619','0','1','1'),
('629','34','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'618','0','1','1'),
('630','31','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'617','0','1','1'),
('631','30','TypeID','int','信息类型','typeselect','1',NULL,NULL,'textinput','0','请选择所属类型，进而完善相应的属性',NULL,NULL,'616','0','1','1');

INSERT INTO `youdian_banner` VALUES
('3',NULL,'1','/Upload/banner/2.jpg',NULL,NULL,'1',NULL,'1','1'),
('4',NULL,'1','/Upload/banner/1.jpg',NULL,NULL,'2',NULL,'1','1'),
('5',NULL,'2','/Upload/banner/1.jpg',NULL,NULL,'0',NULL,'1','2'),
('6',NULL,'2','/Upload/banner/2.jpg',NULL,NULL,'0',NULL,'1','2'),
('7',NULL,'3','/Upload/banner/10.jpg',NULL,NULL,'0',NULL,'1','1'),
('8',NULL,'3','/Upload/banner/11.jpg',NULL,NULL,'0',NULL,'1','1'),
('9',NULL,'4','/Upload/banner/10.jpg',NULL,NULL,'0',NULL,'1','2'),
('10',NULL,'4','/Upload/banner/11.jpg',NULL,NULL,'0',NULL,'1','2');

INSERT INTO `youdian_banner_group` VALUES
('1','首页幻灯分组','4','1','1'),
('2','banner group of home','0','1','2'),
('3','手机幻灯片分组','0','0','1'),
('4','banner grounp of mobile','0','0','2');

INSERT INTO `youdian_channel` VALUES
('1','0','0','网站首页',NULL,NULL,NULL,'33','_self',NULL,'1',NULL,NULL,NULL,NULL,'index',NULL,'20','0','index.html',NULL,'1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/public/logo.png','0',NULL,NULL),
('2','0','0','Home',NULL,NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'index',NULL,'20','0','index.html','read.html','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/public/logo.png','0',NULL,NULL),
('4','0','0','Job','job',NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'job',NULL,'20','7','job.html',NULL,'1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/icon/4.jpg','0',NULL,NULL),
('5','0','0','Guestbook',NULL,NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'guestbook',NULL,'20','8','guestbook.html',NULL,'1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/icon/5.jpg','0',NULL,NULL),
('6','0','0','在线订购',NULL,NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'order',NULL,'20','7','order.html',NULL,'1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/6.jpg','0',NULL,NULL),
('7','0','0','Order',NULL,NULL,NULL,'33','_self',NULL,'1',NULL,NULL,NULL,NULL,'order',NULL,'20','6','order.html','read.html','1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/7.jpg','0',NULL,NULL),
('8','0','0','人才招聘','招聘',NULL,NULL,'33','_self',NULL,'1',NULL,NULL,NULL,NULL,'job',NULL,'20','6','job.html',NULL,'1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/icon/8.jpg','0',NULL,NULL),
('9','0','0','在线留言',NULL,NULL,NULL,'33','_self',NULL,'1',NULL,NULL,NULL,NULL,'guestbook',NULL,'10','18','guestbook.html',NULL,'1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/icon/9.jpg','0',NULL,NULL),
('10','0','0','投递简历',NULL,NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'resume',NULL,'20','20','resume.html',NULL,'1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/10.jpg','0',NULL,NULL),
('11','0','0','Resume',NULL,NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'resume',NULL,'20','20','resume.html',NULL,'1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/11.jpg','0',NULL,NULL),
('15','0','1','关于我们',NULL,'<p style=\"text-align: left\">\r\n	<img alt=\"\" src=\"/Upload/public/c1.jpg\" style=\"border-bottom: 0px solid; border-left: 0px solid; padding-bottom: 5px; padding-left: 5px; width: 189px; padding-right: 5px; float: left; height: 120px; border-top: 0px solid; margin-right: 5px; border-right: 0px solid; padding-top: 5px\" />某某电子技术有限公司成立于1998年，是国内最早从事&ldquo;感应智能门禁系统&rdquo;的企业之一。自1997年开始门禁系统的研发生产，逐渐形成涵盖门禁、停车场、电梯控制、巡更、考勤、会议签到、图书借阅、消费、水控、电控等的智能一卡通管理系统，并成为消防通道逃生设备的领先供应商，为客户提供集软硬件研发、生产、销售、服务与咨询于一体的定制化服务。<br />\r\n	公司致力于为客户提供精益求精的产品与服务，在业界树立了良好的信誉，目前在国内拥有二十多个分支机构，为各地的用户提供销售和服务网络。科松连续数年被评为&ldquo;中国安防十大品牌&rdquo;、&ldquo;中国安防十大民族品牌&rdquo;、&ldquo;平安城市建设优秀安防产品&rdquo;，并入选&ldquo;中国安防100强企业&rdquo;。公司将秉承创新求变、服务社会的宗旨，从&ldquo;智能门禁及一卡通&rdquo;产业实际需求出发，依托自身和中安消技术有限公司强大的科研技术平台，不断实现&ldquo;智能门禁及一卡通&rdquo;的技术突破，引领和推动中国智能门禁及一卡通产业的发展。</p>\r\n',NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'aboutus',NULL,'20','1','page.html',NULL,'1','1','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/15.jpg','3',NULL,NULL),
('17','15','0','企业文化',NULL,'<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<span style=\"font-size: 20px\"><span style=\"color: #ff0000\"><strong>公司口号：</strong></span></span><br />\r\n	省时、省心、省力，助你有效进行网络营销。</p>\r\n<p>\r\n	<br />\r\n	<span style=\"font-size: 20px\"><span style=\"color: #ff0000\"><strong>公司目标：</strong></span></span><br />\r\n	打造国内网络营销软件第一品牌。</p>\r\n<p>\r\n	<br />\r\n	<span style=\"font-size: 20px\"><span style=\"color: #ff0000\"><strong>公司宗旨：</strong></span></span><br />\r\n	客户利益、员工利益、股东利益的最大化，即公司价值的最大化；<br />\r\n	客户利益：使用优质的软件、周到的服务和专业的咨询，提高了竞争能力，提升了个人和企业的形象；<br />\r\n	员工利益：荣誉感，工作满意度，水平、技能和经验的不断提高和积累，同行业中上水平的收入，广阔的发展空间；<br />\r\n	股东利益：有形的和无形的投资收益。</p>\r\n<p>\r\n	<br />\r\n	<span style=\"color: #ff0000\"><span style=\"font-size: 20px\"><strong>企业精神：</strong></span></span><br />\r\n	敬业、诚信、尽责、创新；<br />\r\n	敬业：用优质的软件和服务，提高用户网络营销水平，我们珍惜这个机遇，我们敬重这份职业，我们以此为荣；<br />\r\n	诚信：以诚待人，以信服人，以用户利益保证公司利益，以社会效益实现经济效益；<br />\r\n	尽责：我们的软件设计、开发、测试、实施、服务的各个环节都兢兢业业、一丝不苟；<br />\r\n	创新：创新的本质就是创造性的破坏。创新的途径就是创造性的思考和探索。只有通过不断的自我否定、自我完善，才能创造出有价值的产品、市场、服务。</p>\r\n<p>\r\n	<br />\r\n	<strong><span style=\"color: #ff0000\"><span style=\"font-size: 20px\">人才观：</span></span></strong><br />\r\n	态度决定一切，细节决定成败；<br />\r\n	以人为本。尊重知识，尊重个性；<br />\r\n	唯业绩，不唯学历、不唯资历、不唯过去的功劳；<br />\r\n	提供足够的资源，使所有员工都能按最适合自己的方向发展；<br />\r\n	鼓励创新，提倡&ldquo;表现&rdquo;。健全制度、规范，由向人负责进步到对事负责；<br />\r\n	鼓励&ldquo;琢磨事&rdquo;，反对&ldquo;琢磨人&rdquo;，决不允许任何形式的&ldquo;办公室政治&rdquo;。<br />\r\n	<br />\r\n	&nbsp;</p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/wenhua.jpg',NULL,NULL,NULL,'culture',NULL,'20','0','page.html',NULL,'1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/wenhua.png','0',NULL,NULL),
('18','15','0','资质荣誉',NULL,'<p style=\"padding-left: 60px\">\r\n	<br />\r\n	<span style=\"color: #ff0000\"><span style=\"font-size: 20px\"><strong>重要资质</strong></span></span><br />\r\n	计算机信息系统集成一级资质<br />\r\n	国家规划布局内重点软件企业<br />\r\n	高新技术企业<br />\r\n	通过CMMIv1.2五级<br />\r\n	ISO9001：2008质量管理体系认证<br />\r\n	ISO20000 IT服务管理体系认证<br />\r\n	企业管理信息系统（劳动99三版）前台技术支持商</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<br />\r\n	&nbsp;</p>\r\n<p style=\"padding-left: 60px\">\r\n	<strong><span style=\"color: #ff0000\"><span style=\"font-size: 20px\">重要荣誉</span></span></strong><br />\r\n	信息产业科技创新先进集体<br />\r\n	国家高技术产业化示范工程<br />\r\n	全国科技创新质量管理先进单位<br />\r\n	国家火炬计划软件产业基地骨干企业<br />\r\n	2013十大创新软件企业<br />\r\n	国家第四批创新型试点企业<br />\r\n	2014中国企业信息化杰出服务商<br />\r\n	2013中国年度创新软件企业<br />\r\n	2013年软件信息技术金鼎奖<br />\r\n	国家认定企业技术中心<br />\r\n	科技局信息工程技术研究中心<br />\r\n	2013年守合同重信用企业</p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/rongyu.jpg',NULL,NULL,NULL,'honor',NULL,'20','0','page.html',NULL,'1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/rongyu.png','0',NULL,NULL),
('19','15','0','组织机构',NULL,'<div style=\"text-align: center\">\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj1.png\" style=\"width: 100%;\" /></p>\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj.png\" style=\"width: 100%;\" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/jg.png',NULL,NULL,NULL,'organization',NULL,'20','0','page.html',NULL,'1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/zzjj1.png','0',NULL,NULL),
('20','0','1','新闻资讯','新闻',NULL,NULL,'30','_self',NULL,'0',NULL,NULL,NULL,NULL,'news',NULL,'20','2','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/20.jpg','0',NULL,NULL),
('21','20','0','公司新闻','新闻',NULL,NULL,'30','_self',NULL,'0','/Upload/public/gsxw.jpg',NULL,NULL,NULL,'companynews',NULL,'20','0','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/gsxw.png','0',NULL,NULL),
('22','20','0','行业动态','新闻',NULL,NULL,'30','_self',NULL,'0','/Upload/public/hyxw.jpg',NULL,NULL,NULL,'industrytrends',NULL,'20','0','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/hyxw.png','0',NULL,NULL),
('23','0','1','产品展示','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'product',NULL,'20','3','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','3',NULL,NULL),
('24','23','0','水质测试仪','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class1',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('25','23','0','风速风量计','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class2',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('26','23','0','温湿度记录仪','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class3',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('27','23','0','记录器打打印系列','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class4',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','3',NULL,NULL),
('28','23','0','气体检测仪','产品',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class41',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('30','0','0','下载中心','下载',NULL,NULL,'35','_self',NULL,'0',NULL,NULL,NULL,NULL,'download',NULL,'20','5','download.html','showdownload.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/30.jpg','0',NULL,NULL),
('31','0','0','联系我们',NULL,'<!--引用百度地图API-->\r\n<style type=\"text/css\">\r\n.iw_poi_title {color:#CC5522;font-size:14px;font-weight:bold;overflow:hidden;padding-right:13px;white-space:nowrap}\r\n    .iw_poi_content {font:12px arial,sans-serif;overflow:visible;padding-top:4px;white-space:-moz-pre-wrap;word-wrap:break-word}</style>\r\n<script type=\"text/javascript\" src=\"http://api.map.baidu.com/api?key=&v=1.1&services=true\"></script><!--百度地图容器-->\r\n<div id=\"dituContent\" style=\"width:100%;height:450px;border:#ccc solid 1px;float:right\">\r\n	&nbsp;</div>\r\n<script type=\"text/javascript\">\r\n    //创建和初始化地图函数：\r\n    function initMap(){\r\n        createMap();//创建地图\r\n        setMapEvent();//设置地图事件\r\n        addMapControl();//向地图添加控件\r\n    }\r\n    \r\n    //创建地图函数：\r\n    function createMap(){\r\n        var map = new BMap.Map(\"dituContent\");//在百度地图容器中创建一个地图\r\n        var point = new BMap.Point(116.395645,39.929986);//定义一个中心点坐标\r\n        map.centerAndZoom(point,12);//设定地图的中心点和坐标并将地图显示在地图容器中\r\n        window.map = map;//将map变量存储在全局\r\n    }\r\n    \r\n    //地图事件设置函数：\r\n    function setMapEvent(){\r\n        map.enableDragging();//启用地图拖拽事件，默认启用(可不写)\r\n        map.enableScrollWheelZoom();//启用地图滚轮放大缩小\r\n        map.enableDoubleClickZoom();//启用鼠标双击放大，默认启用(可不写)\r\n        map.enableKeyboard();//启用键盘上下左右键移动地图\r\n    }\r\n    \r\n    //地图控件添加函数：\r\n    function addMapControl(){\r\n        //向地图中添加缩放控件\r\n	var ctrl_nav = new BMap.NavigationControl({anchor:BMAP_ANCHOR_TOP_LEFT,type:BMAP_NAVIGATION_CONTROL_LARGE});\r\n	map.addControl(ctrl_nav);\r\n        //向地图中添加缩略图控件\r\n	var ctrl_ove = new BMap.OverviewMapControl({anchor:BMAP_ANCHOR_BOTTOM_RIGHT,isOpen:1});\r\n	map.addControl(ctrl_ove);\r\n        //向地图中添加比例尺控件\r\n	var ctrl_sca = new BMap.ScaleControl({anchor:BMAP_ANCHOR_BOTTOM_LEFT});\r\n	map.addControl(ctrl_sca);\r\n    }\r\n    \r\n    \r\n    initMap();//创建和初始化地图\r\n</script>',NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'contactus',NULL,'20','20','page.html',NULL,'1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/31.jpg','0',NULL,NULL),
('32','0','0','解决方案','案例',NULL,NULL,'31','_self',NULL,'0',NULL,NULL,NULL,NULL,'case',NULL,'20','4','picture.html','showpicture.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/32.jpg','0',NULL,NULL),
('33','0','0','网站公告','公告',NULL,NULL,'30','_self',NULL,'0',NULL,NULL,NULL,NULL,'annnouncement',NULL,'20','0','article.html','showarticle.html','1','0','0','0','1','1',NULL,NULL,NULL,'/Upload/icon/33.jpg','0',NULL,NULL),
('34','0','0','Announcement',NULL,NULL,NULL,'30','_self',NULL,'0',NULL,NULL,NULL,NULL,'annnouncement',NULL,'20','0','article.html','showarticle.html','1','0','0','0','1','2',NULL,NULL,NULL,NULL,'0',NULL,NULL),
('35','0','1','About Us',NULL,'<p>\r\n	<span><img alt=\"\" src=\"/Upload/public/c1.jpg\" style=\"border-bottom: 0px solid; border-left: 0px solid; padding-bottom: 5px; padding-left: 5px; width: 173px; padding-right: 5px; float: left; height: 110px; border-top: 0px solid; margin-right: 5px; border-right: 0px solid; padding-top: 5px\" />XX Software Technology Co., Ltd. of&nbsp; Xingsha Economic Development Zone is located , the technology research and development of a set of large sites, network marketing software R &amp; D as well as the network marketing service in one of the high-tech software companies </span><span>is one of a handful of domestic enterprises to master the core technology in the field of network marketing software, bulk software, web crawler, a large construction site. </span><span>Relying on the company&#39;s core technology, products for different industries, different sizes, different applications and solutions. </span><span>At the same time, we have the perfect network infrastructure services, to businesses or individuals to provide domain name registration, web hosting, business offices, website acceleration, database, cloud host network infrastructure services.</span><br />\r\n	<br />\r\n	<span>The company has an extremely rich passion, technical top team, composed of a number of years of software development experience and network marketing experience in the professional and technical personnel. </span><span>Companies adhering to the &quot;state-of-the-art technology, sincere service, cooperation and win-win&quot; business philosophy, by virtue of its powerful software technical strength, rich network planning experience, comprehensive concept of network marketing, as well as improve the operational mode, is committed to providing our customers with the most </span><span>quality of service, and received wide acclaim from all sectors of society.</span><br />\r\n	<br />\r\n	&nbsp;</p>\r\n',NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'aboutus',NULL,'20','0','page.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/35.jpg','3',NULL,NULL),
('37','35','0','Culture',NULL,'<p>\r\n	<strong><span closure_uid_503514901=\"1114\" wd=\"null\">Company slogan:</span></strong><br closure_uid_503514901=\"1358\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1115\" wd=\"null\">Save time, worry</span><span closure_uid_503514901=\"1116\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1117\" wd=\"null\">and effort</span> <span class=\"hps\" closure_uid_503514901=\"1118\" wd=\"null\">to help</span> <span class=\"hps\" closure_uid_503514901=\"1119\" wd=\"null\">you</span> <span class=\"hps\" closure_uid_503514901=\"1120\" wd=\"null\">effectively</span> <span class=\"hps\" closure_uid_503514901=\"1121\" wd=\"null\">network</span> <span class=\"hps\" closure_uid_503514901=\"1122\" wd=\"null\">marketing</span><span closure_uid_503514901=\"1123\" wd=\"null\">.</span><br closure_uid_503514901=\"1359\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1360\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1361\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1124\" wd=\"null\">Company</span> <span class=\"hps\" closure_uid_503514901=\"1125\" wd=\"null\">goals:</span></strong><br closure_uid_503514901=\"1362\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1126\" wd=\"null\">To</span> <span class=\"hps\" closure_uid_503514901=\"1127\" wd=\"null\">create</span> <span class=\"hps\" closure_uid_503514901=\"1128\" wd=\"null\">the first brand</span> <span class=\"hps\" closure_uid_503514901=\"1129\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1130\" wd=\"null\">domestic</span> <span class=\"hps\" closure_uid_503514901=\"1131\" wd=\"null\">marketing software</span><span closure_uid_503514901=\"1132\" wd=\"null\">.</span><br closure_uid_503514901=\"1363\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1364\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1365\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1133\" wd=\"null\">Company aim:</span></strong><br closure_uid_503514901=\"1366\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1134\" wd=\"null\">The interests of customers</span><span closure_uid_503514901=\"1135\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1136\" wd=\"null\">employees&#39; interests</span><span closure_uid_503514901=\"1137\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1138\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1139\" wd=\"null\">maximize</span> <span class=\"hps\" closure_uid_503514901=\"1140\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1141\" wd=\"null\">interests of shareholders</span><span closure_uid_503514901=\"1142\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1143\" wd=\"null\">that</span> <span class=\"hps\" closure_uid_503514901=\"1144\" wd=\"null\">maximize</span> <span class=\"hps\" closure_uid_503514901=\"1145\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1146\" wd=\"null\">value of the company</span><span closure_uid_503514901=\"1147\" wd=\"null\">;</span><br closure_uid_503514901=\"1367\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1148\" wd=\"null\">The interests of customers</span><span closure_uid_503514901=\"1149\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1150\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1151\" wd=\"null\">use of</span> <span class=\"hps\" closure_uid_503514901=\"1152\" wd=\"null\">high-quality</span> <span class=\"hps\" closure_uid_503514901=\"1153\" wd=\"null\">software</span><span closure_uid_503514901=\"1154\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1155\" wd=\"null\">attentive service and</span> <span class=\"hps\" closure_uid_503514901=\"1156\" wd=\"null\">professional</span> <span class=\"hps\" closure_uid_503514901=\"1157\" wd=\"null\">consultation</span> <span class=\"hps\" closure_uid_503514901=\"1158\" wd=\"null\">to improve</span> <span class=\"hps\" closure_uid_503514901=\"1159\" wd=\"null\">competitiveness</span><span closure_uid_503514901=\"1160\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1161\" wd=\"null\">enhance</span> <span class=\"hps\" closure_uid_503514901=\"1162\" wd=\"null\">the image</span> <span class=\"hps\" closure_uid_503514901=\"1163\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1164\" wd=\"null\">individuals and businesses</span><span closure_uid_503514901=\"1165\" wd=\"null\">;</span><br closure_uid_503514901=\"1368\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1166\" wd=\"null\">Employee</span> <span class=\"hps\" closure_uid_503514901=\"1167\" wd=\"null\">benefits:</span> <span class=\"hps\" closure_uid_503514901=\"1168\" wd=\"null\">pride,</span> <span class=\"hps\" closure_uid_503514901=\"1169\" wd=\"null\">job satisfaction,</span> <span class=\"hps\" closure_uid_503514901=\"1170\" wd=\"null\">the level of</span> <span class=\"hps\" closure_uid_503514901=\"1171\" wd=\"null\">skills</span> <span class=\"hps\" closure_uid_503514901=\"1172\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1173\" wd=\"null\">experience</span> <span class=\"hps\" closure_uid_503514901=\"1174\" wd=\"null\">to continuously improve and</span> <span class=\"hps\" closure_uid_503514901=\"1175\" wd=\"null\">accumulation</span> <span class=\"hps\" closure_uid_503514901=\"1176\" wd=\"null\">on the</span> <span class=\"hps\" closure_uid_503514901=\"1177\" wd=\"null\">level</span> <span class=\"hps\" closure_uid_503514901=\"1178\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1179\" wd=\"null\">income</span> <span class=\"hps\" closure_uid_503514901=\"1180\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"1181\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1182\" wd=\"null\">same industry</span><span closure_uid_503514901=\"1183\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1184\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"1185\" wd=\"null\">broad space for development</span><span closure_uid_503514901=\"1186\" wd=\"null\">;</span><br closure_uid_503514901=\"1369\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1187\" wd=\"null\">Shareholders</span><span closure_uid_503514901=\"1188\" wd=\"null\">&#39;</span> <span class=\"hps\" closure_uid_503514901=\"1189\" wd=\"null\">interests</span><span closure_uid_503514901=\"1190\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1191\" wd=\"null\">tangible</span> <span class=\"hps\" closure_uid_503514901=\"1192\" wd=\"null\">and intangible</span> <span class=\"hps\" closure_uid_503514901=\"1193\" wd=\"null\">investment income</span><span closure_uid_503514901=\"1194\" wd=\"null\">.</span><br closure_uid_503514901=\"1370\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1371\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1372\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1195\" wd=\"null\">Enterprise spirit:</span></strong><br closure_uid_503514901=\"1373\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1196\" wd=\"null\">Dedication, integrity</span><span closure_uid_503514901=\"1197\" wd=\"null\">, responsibility</span><span closure_uid_503514901=\"1198\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1199\" wd=\"null\">innovation</span><span closure_uid_503514901=\"1200\" wd=\"null\">;</span><br closure_uid_503514901=\"1374\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1201\" wd=\"null\">Dedication</span><span closure_uid_503514901=\"1202\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1203\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1204\" wd=\"null\">quality</span> <span class=\"hps\" closure_uid_503514901=\"1205\" wd=\"null\">of the</span> <span class=\"hps\" closure_uid_503514901=\"1206\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"1207\" wd=\"null\">and services</span><span closure_uid_503514901=\"1208\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1209\" wd=\"null\">to improve</span> <span class=\"hps\" closure_uid_503514901=\"1210\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1211\" wd=\"null\">level</span> <span class=\"hps\" closure_uid_503514901=\"1212\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1213\" wd=\"null\">user</span> <span class=\"hps\" closure_uid_503514901=\"1214\" wd=\"null\">network</span> <span class=\"hps\" closure_uid_503514901=\"1215\" wd=\"null\">marketing</span><span closure_uid_503514901=\"1216\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1217\" wd=\"null\">we</span> <span class=\"hps\" closure_uid_503514901=\"1218\" wd=\"null\">cherish</span> <span class=\"hps\" closure_uid_503514901=\"1219\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"1220\" wd=\"null\">opportunity</span><span closure_uid_503514901=\"1221\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1222\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1223\" wd=\"null\">we</span> <span class=\"hps\" closure_uid_503514901=\"1224\" wd=\"null\">respect</span> <span class=\"hps\" closure_uid_503514901=\"1225\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"1226\" wd=\"null\">profession</span><span closure_uid_503514901=\"1227\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1228\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1229\" wd=\"null\">we are</span> <span class=\"hps\" closure_uid_503514901=\"1230\" wd=\"null\">proud of</span><span closure_uid_503514901=\"1231\" wd=\"null\">;</span><br closure_uid_503514901=\"1375\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1232\" wd=\"null\">Honesty:</span> <span class=\"hps\" closure_uid_503514901=\"1233\" wd=\"null\">Sincerity</span> <span class=\"hps\" closure_uid_503514901=\"1234\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1235\" wd=\"null\">convince people</span><span closure_uid_503514901=\"1236\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1237\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1238\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1239\" wd=\"null\">interests of the user</span> <span class=\"hps\" closure_uid_503514901=\"1240\" wd=\"null\">to ensure</span> <span class=\"hps\" closure_uid_503514901=\"1241\" wd=\"null\">the interests of the company</span> <span class=\"hps\" closure_uid_503514901=\"1242\" wd=\"null\">to achieve</span> <span class=\"hps\" closure_uid_503514901=\"1243\" wd=\"null\">economic benefits</span><span closure_uid_503514901=\"1244\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1245\" wd=\"null\">social benefits</span><span closure_uid_503514901=\"1246\" wd=\"null\">;</span><br closure_uid_503514901=\"1376\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1247\" wd=\"null\">Diligence</span><span closure_uid_503514901=\"1248\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1249\" wd=\"null\">our software</span> <span class=\"hps\" closure_uid_503514901=\"1250\" wd=\"null\">design</span><span closure_uid_503514901=\"1251\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1252\" wd=\"null\">development</span><span closure_uid_503514901=\"1253\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1254\" wd=\"null\">testing,</span> <span class=\"hps\" closure_uid_503514901=\"1255\" wd=\"null\">implementation,</span> <span class=\"hps\" closure_uid_503514901=\"1256\" wd=\"null\">all aspects of the</span> <span class=\"hps\" closure_uid_503514901=\"1257\" wd=\"null\">service</span> <span class=\"hps\" closure_uid_503514901=\"1258\" wd=\"null\">are</span> <span class=\"hps\" closure_uid_503514901=\"1259\" wd=\"null\">diligent attention to detail</span><span closure_uid_503514901=\"1260\" wd=\"null\">;</span><br closure_uid_503514901=\"1377\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1261\" wd=\"null\">Innovation:</span> <span class=\"hps\" closure_uid_503514901=\"1262\" wd=\"null\">Innovation</span> <span class=\"hps\" closure_uid_503514901=\"1263\" wd=\"null\">is the essence of</span> <span class=\"hps\" closure_uid_503514901=\"1264\" wd=\"null\">creative destruction</span><span closure_uid_503514901=\"1265\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1266\" wd=\"null\">Innovative</span> <span class=\"hps\" closure_uid_503514901=\"1267\" wd=\"null\">ways to</span> <span class=\"hps\" closure_uid_503514901=\"1268\" wd=\"null\">think creatively</span> <span class=\"hps\" closure_uid_503514901=\"1269\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1270\" wd=\"null\">explore</span><span closure_uid_503514901=\"1271\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1272\" wd=\"null\">Only</span> <span class=\"hps\" closure_uid_503514901=\"1273\" wd=\"null\">by</span> <span class=\"hps\" closure_uid_503514901=\"1274\" wd=\"null\">constant</span> <span class=\"hps\" closure_uid_503514901=\"1275\" wd=\"null\">self-denial</span><span closure_uid_503514901=\"1276\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1277\" wd=\"null\">self-improvement</span><span closure_uid_503514901=\"1278\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1279\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1280\" wd=\"null\">create a</span> <span class=\"hps\" closure_uid_503514901=\"1281\" wd=\"null\">valuable product</span><span closure_uid_503514901=\"1282\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1283\" wd=\"null\">market</span><span closure_uid_503514901=\"1284\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1285\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1286\" wd=\"null\">service</span><span closure_uid_503514901=\"1287\" wd=\"null\">.</span><br closure_uid_503514901=\"1378\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1379\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1380\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1288\" wd=\"null\">Talent:</span></strong><br closure_uid_503514901=\"1381\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1289\" wd=\"null\">Attitude is everything</span><span closure_uid_503514901=\"1290\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1291\" wd=\"null\">details</span> <span class=\"hps\" closure_uid_503514901=\"1292\" wd=\"null\">determine success or failure</span><span closure_uid_503514901=\"1293\" wd=\"null\">;</span><br closure_uid_503514901=\"1382\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1294\" wd=\"null\">People-oriented</span><span closure_uid_503514901=\"1295\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1296\" wd=\"null\">Respecting knowledge and</span> <span class=\"hps\" closure_uid_503514901=\"1297\" wd=\"null\">personality</span><span closure_uid_503514901=\"1298\" wd=\"null\">;</span><br closure_uid_503514901=\"1383\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1299\" wd=\"null\">CD</span> <span class=\"hps\" closure_uid_503514901=\"1300\" wd=\"null\">performance</span><span closure_uid_503514901=\"1301\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1302\" wd=\"null\">not</span> <span class=\"hps\" closure_uid_503514901=\"1303\" wd=\"null\">only academic</span><span closure_uid_503514901=\"1304\" wd=\"null\">, not</span> <span class=\"hps\" closure_uid_503514901=\"1305\" wd=\"null\">only</span> <span class=\"hps\" closure_uid_503514901=\"1306\" wd=\"null\">qualifications</span><span closure_uid_503514901=\"1307\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1308\" wd=\"null\">not</span> <span class=\"hps\" closure_uid_503514901=\"1309\" wd=\"null\">the only</span> <span class=\"hps\" closure_uid_503514901=\"1310\" wd=\"null\">past</span> <span class=\"hps\" closure_uid_503514901=\"1311\" wd=\"null\">the credit</span><span closure_uid_503514901=\"1312\" wd=\"null\">;</span><br closure_uid_503514901=\"1384\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1313\" wd=\"null\">Provide sufficient</span> <span class=\"hps\" closure_uid_503514901=\"1314\" wd=\"null\">resources</span> <span class=\"hps\" closure_uid_503514901=\"1315\" wd=\"null\">so</span> <span class=\"hps\" closure_uid_503514901=\"1316\" wd=\"null\">that</span> <span class=\"hps\" closure_uid_503514901=\"1317\" wd=\"null\">all</span> <span class=\"hps\" closure_uid_503514901=\"1318\" wd=\"null\">employees</span> <span class=\"hps\" closure_uid_503514901=\"1319\" wd=\"null\">can</span> <span class=\"hps\" closure_uid_503514901=\"1320\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"1321\" wd=\"null\">most suited to their</span> <span class=\"hps\" closure_uid_503514901=\"1322\" wd=\"null\">direction of</span> <span class=\"hps\" closure_uid_503514901=\"1323\" wd=\"null\">development</span><span closure_uid_503514901=\"1324\" wd=\"null\">;</span><br closure_uid_503514901=\"1385\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1325\" wd=\"null\">Encourage innovation</span><span closure_uid_503514901=\"1326\" wd=\"null\">,</span> <span class=\"hps atn\" closure_uid_503514901=\"1327\" wd=\"null\">promote &quot;</span><span closure_uid_503514901=\"1328\" wd=\"null\">performance</span><span closure_uid_503514901=\"1329\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1330\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1331\" wd=\"null\">A sound system</span><span closure_uid_503514901=\"1332\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1333\" wd=\"null\">norms</span><span closure_uid_503514901=\"1334\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1335\" wd=\"null\">from</span> <span class=\"hps\" closure_uid_503514901=\"1336\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1337\" wd=\"null\">person</span> <span class=\"hps\" closure_uid_503514901=\"1338\" wd=\"null\">responsible for the</span> <span class=\"hps\" closure_uid_503514901=\"1339\" wd=\"null\">progress</span> <span class=\"hps\" closure_uid_503514901=\"1340\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1341\" wd=\"null\">be responsible</span><span closure_uid_503514901=\"1342\" wd=\"null\">;</span><br closure_uid_503514901=\"1386\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1343\" wd=\"null\">Encourage</span> <span class=\"hps\" closure_uid_503514901=\"1344\" wd=\"null\">pondering</span> <span class=\"hps\" closure_uid_503514901=\"1345\" wd=\"null\">things</span> <span class=\"hps atn\" closure_uid_503514901=\"1346\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1347\" wd=\"null\">oppose</span><span closure_uid_503514901=\"1348\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"1349\" wd=\"null\">pondering</span> <span class=\"hps atn\" closure_uid_503514901=\"1350\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1351\" wd=\"null\">will never allow</span> <span class=\"hps\" closure_uid_503514901=\"1352\" wd=\"null\">any form of</span><span closure_uid_503514901=\"1353\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"1354\" wd=\"null\">office politics</span> <span class=\"hps atn\" closure_uid_503514901=\"1355\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1356\" wd=\"null\">.</span></p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/wenhua.jpg',NULL,NULL,NULL,'culture',NULL,'20','0','page.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/wenhua.png','0',NULL,NULL),
('38','35','0','Honor',NULL,'<p>\r\n	<span style=\"font-size: 16px\"><span style=\"color: #ff0000\"><strong>Important qualification</strong></span></span><br />\r\n	Computer information system integration qualification<br />\r\n	State planning key software enterprises<br />\r\n	High-tech enterprises<br />\r\n	CMMIv1.2 five<br />\r\n	ISO9001: 2008 quality management system certification<br />\r\n	The ISO20000 IT service management system certification<br />\r\n	Enterprise management information system 99 Third Edition (labor) front desk technical support providers</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong><span style=\"color: #ff0000\"><span style=\"font-size: 16px\">Important honor</span></span></strong><br />\r\n	Information Industry Technology Innovation Advanced Collective<br />\r\n	National high-tech industrialization demonstration project<br />\r\n	National science and technology innovation and advanced quality management unit<br />\r\n	Backbone enterprises of National Torch Program Software Industrial Base<br />\r\n	2013 top ten innovative software companies<br />\r\n	The country fourth installment innovative pilot enterprises<br />\r\n	2013 China Outstanding service provider of enterprise information<br />\r\n	2013 China Annual Innovation software companies<br />\r\n	2013 Software IT Golden Tripod<br />\r\n	China validated enterprise technical centers<br />\r\n	Science and Technology Bureau of Information Engineering Technology Research Center<br />\r\n	The 2013 older Shashi keep credit business contracts</p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/rongyu.jpg',NULL,NULL,NULL,'honor',NULL,'20','0','page.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/rongyu.png','0',NULL,NULL),
('39','35','0','Organization',NULL,'<div style=\"text-align: center\">\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj1en.png\" style=\"width: 99%;\" /></p>\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjjen.png\" style=\"width: 99%;\" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>\r\n',NULL,'32','_self',NULL,'0','/Upload/public/jg.png',NULL,NULL,NULL,'organization',NULL,'20','0','page.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/zzjj1en.png','0',NULL,NULL),
('40','0','1','News','news',NULL,NULL,'30','_self',NULL,'0',NULL,NULL,NULL,NULL,'news',NULL,'20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/40.jpg','0',NULL,NULL),
('41','40','0','Company News',NULL,NULL,NULL,'30','_self',NULL,'0','/Upload/public/gsxw.jpg',NULL,NULL,NULL,'companynews',NULL,'20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/gsxw.png','0',NULL,NULL),
('42','40','0','Industry Trends',NULL,NULL,NULL,'30','_self',NULL,'0','/Upload/public/hyxw.jpg',NULL,NULL,NULL,'industrytrends',NULL,'20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/hyxw.png','0',NULL,NULL),
('43','0','1','Product','product',NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'product',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/43.jpg','3',NULL,NULL),
('44','43','0','Water quality testing',NULL,NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class1',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('45','43','0','Wind volume meter',NULL,NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class2',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('46','43','0','Temperate recorder',NULL,NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class3',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0',NULL,NULL),
('47','43','0','Recorder  printing',NULL,NULL,NULL,'36','_self',NULL,'0',NULL,NULL,NULL,NULL,'class4',NULL,'20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','3',NULL,NULL),
('50','0','0','Solution','case',NULL,NULL,'31','_self',NULL,'0',NULL,NULL,NULL,NULL,'case',NULL,'20','0','picture.html','showpicture.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/50.jpg','0',NULL,NULL),
('51','0','0','Download','download',NULL,NULL,'35','_self',NULL,'0',NULL,NULL,NULL,NULL,'download',NULL,'20','0','download.html','showdownload.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/51.jpg','0',NULL,NULL),
('52','0','0','Contact Us',NULL,'<!--引用百度地图API-->\r\n<style type=\"text/css\">\r\n.iw_poi_title {color:#CC5522;font-size:14px;font-weight:bold;overflow:hidden;padding-right:13px;white-space:nowrap}\r\n    .iw_poi_content {font:12px arial,sans-serif;overflow:visible;padding-top:4px;white-space:-moz-pre-wrap;word-wrap:break-word}</style>\r\n<script type=\"text/javascript\" src=\"http://api.map.baidu.com/api?key=&v=1.1&services=true\"></script><!--百度地图容器-->\r\n<div id=\"dituContent\" style=\"width:100%;height:550px;border:#ccc solid 1px;float:right\">\r\n	&nbsp;</div>\r\n<script type=\"text/javascript\">\r\n    //创建和初始化地图函数：\r\n    function initMap(){\r\n        createMap();//创建地图\r\n        setMapEvent();//设置地图事件\r\n        addMapControl();//向地图添加控件\r\n    }\r\n    \r\n    //创建地图函数：\r\n    function createMap(){\r\n        var map = new BMap.Map(\"dituContent\");//在百度地图容器中创建一个地图\r\n        var point = new BMap.Point(116.395645,39.929986);//定义一个中心点坐标\r\n        map.centerAndZoom(point,12);//设定地图的中心点和坐标并将地图显示在地图容器中\r\n        window.map = map;//将map变量存储在全局\r\n    }\r\n    \r\n    //地图事件设置函数：\r\n    function setMapEvent(){\r\n        map.enableDragging();//启用地图拖拽事件，默认启用(可不写)\r\n        map.enableScrollWheelZoom();//启用地图滚轮放大缩小\r\n        map.enableDoubleClickZoom();//启用鼠标双击放大，默认启用(可不写)\r\n        map.enableKeyboard();//启用键盘上下左右键移动地图\r\n    }\r\n    \r\n    //地图控件添加函数：\r\n    function addMapControl(){\r\n        //向地图中添加缩放控件\r\n	var ctrl_nav = new BMap.NavigationControl({anchor:BMAP_ANCHOR_TOP_LEFT,type:BMAP_NAVIGATION_CONTROL_LARGE});\r\n	map.addControl(ctrl_nav);\r\n        //向地图中添加缩略图控件\r\n	var ctrl_ove = new BMap.OverviewMapControl({anchor:BMAP_ANCHOR_BOTTOM_RIGHT,isOpen:1});\r\n	map.addControl(ctrl_ove);\r\n        //向地图中添加比例尺控件\r\n	var ctrl_sca = new BMap.ScaleControl({anchor:BMAP_ANCHOR_BOTTOM_LEFT});\r\n	map.addControl(ctrl_sca);\r\n    }\r\n    \r\n    \r\n    initMap();//创建和初始化地图\r\n</script>',NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'contacts',NULL,'20','20','page.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/52.jpg','0',NULL,NULL),
('55','15','0','宣传视频','视频',NULL,NULL,'34','_self',NULL,'0','/Upload/public/sp.jpg',NULL,NULL,NULL,'video',NULL,'20','0','video.html','showvideo.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/sp.png','0',NULL,NULL),
('56','35','0','Video','video',NULL,NULL,'34','_self',NULL,'0','/Upload/public/sp.jpg',NULL,NULL,NULL,'video',NULL,'20','0','video.html','showvideo.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/sp.png','0',NULL,NULL),
('57','0','0','网站地图',NULL,NULL,NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'sitemap',NULL,'20','19','sitemap.html',NULL,'1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/14.jpg','0',NULL,NULL),
('58','0','0','Sitemap',NULL,NULL,NULL,'32','_self',NULL,'0',NULL,NULL,NULL,NULL,'sitemap',NULL,'20','19','sitemap.html',NULL,'1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/3.jpg','0',NULL,NULL);

INSERT INTO `youdian_channel_model` VALUES
('1','频道信息','1','youdian_channel',NULL,'0','1',NULL,NULL),
('2','专题信息','2','youdian_special',NULL,'1','1',NULL,NULL),
('3','幻 灯 片','3','youdian_banner',NULL,'1','1',NULL,NULL),
('4','在线客服','4','youdian_support',NULL,'1','1',NULL,NULL),
('5','第三方在线客服','5','youdian_support3',NULL,'1','1',NULL,NULL),
('6','在线留言','6','youdian_guestbook',NULL,'1','1',NULL,NULL),
('7','人才招聘','7','youdian_recruit',NULL,'1','1',NULL,NULL),
('8','信息评论','8','youdian_comment',NULL,'1','1',NULL,NULL),
('9','友情链接分类','5','youdian_link_class',NULL,'1','1',NULL,NULL),
('10','友情链接','9','youdian_link',NULL,'1','1',NULL,NULL),
('11','广告信息','10','youdian_ad',NULL,'1','1',NULL,NULL),
('12','会员分组','11','youdian_member_group',NULL,'1','1',NULL,NULL),
('13','会员信息','13','youdian_member',NULL,'0','1',NULL,NULL),
('14','管理员信息','14','youdian_admin',NULL,'1','1',NULL,NULL),
('15','管理员组','15','youdian_admin_group',NULL,'1','1',NULL,NULL),
('16','修改模板','16',NULL,NULL,'1','1',NULL,NULL),
('17','自定义标签','17','youdian_tag',NULL,'1','1',NULL,NULL),
('18','属性标记','18','youdian_label',NULL,'1','1',NULL,NULL),
('19','模型管理','19','youdian_channel_model',NULL,'1','1',NULL,NULL),
('20','字段管理','20','youdian_attribute',NULL,'1','1',NULL,NULL),
('21','字段分组管理','21','youdian_attribute',NULL,'1','1',NULL,NULL),
('22','幻灯分组管理','22','youdian_banner_group',NULL,'1','1',NULL,NULL),
('23','邮件订阅分类','23','youdian_mail_class',NULL,'1','1',NULL,NULL),
('24','邮件管理','24','youdian_mail',NULL,'1','1',NULL,NULL),
('25','邮件群发管理','25','youdian_mail_send',NULL,'1','1',NULL,NULL),
('26','订单模型','26','youdian_order',NULL,'1','1',NULL,NULL),
('30','文章模型','30','youdian_info',NULL,'0','1','article.html','showarticle.html'),
('31','图片模型','31','youdian_info',NULL,'0','1','picture.html','showpicture.html'),
('32','单页模型','32','youdian_channel',NULL,'0','1','page.html',NULL),
('33','链接模型','33','youdian_info',NULL,'0','1',NULL,NULL),
('34','视频模型','34','youdian_info',NULL,'0','1','video.html','showvideo.html'),
('35','下载模型','35','youdian_info',NULL,'0','1','download.html','showdownload.html'),
('36','产品模型','36','youdian_info',NULL,'0','1','product.html','showproduct.html'),
('37','反馈模型','37',NULL,NULL,'0','1','feedback.html','showfeedback.html'),
('38','保留模型3','38',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL),
('39','保留模型4','39',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL);

INSERT INTO `youdian_config` VALUES
('1','WEB_NAME','某某公司',NULL,'basic','1','1'),
('2','WEB_URL','http://www.xx.com',NULL,'basic','1','0'),
('3','WEB_ICP','ICP备888888888号',NULL,'basic','1','1'),
('4','WEB_STATUS','1',NULL,'basic','1','0'),
('5','WEB_CLOSE_REASON','抱歉，网站正在维护中，给您带来不便深表歉意！',NULL,'basic','1','1'),
('6','WEB_BAD_WORDS','他妈的=***',NULL,'basic','1','0'),
('7','TITLE','website|cms|wap website|finished website',NULL,'seo','1','2'),
('8','CONTACT','Miss Cheng',NULL,'contact','1','2'),
('9','COMPANY','某某公司',NULL,'contact','1','1'),
('10','CONTACT','陈小姐',NULL,'contact','1','1'),
('11','ADDRESS','北京市海淀区学院路春天花园8栋906',NULL,'contact','1','1'),
('12','TELEPHONE','010-12345678',NULL,'contact','1','1'),
('13','MOBILE',NULL,NULL,'contact','1','1'),
('14','FAX','010-12345678',NULL,'contact','1','1'),
('15','EMAIL','12345@qq.com',NULL,'contact','1','1'),
('16','POSTCODE','400000',NULL,'contact','1','1'),
('17','ONLINE_ENABLE','1',NULL,'online','1','0'),
('18','ONLINE_STYLE','blue',NULL,'online','1','1'),
('19','ONLINE_POSITION','0',NULL,'online','1','0'),
('20','UPLOAD','./Upload/',NULL,'upload','1','0'),
('21','UPLOAD_FILE_TYPE','rar|zip|doc|docx|ppt|pptx|pdf|jpg|xls|png|gif|mp3|jpeg|bmp|swf|flv|ico',NULL,'upload','1','0'),
('22','MAX_UPLOAD_SIZE','5242880',NULL,'upload','1','0'),
('23','GUEST_BOOK_ALLOW','1',NULL,'guestbook','1','0'),
('24','GUEST_BOOK_CHECK','1',NULL,'guestbook','1','0'),
('25','GUEST_BOOK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('26','GUEST_BOOK_PAGESIZE','10',NULL,'guestbook','1','0'),
('27','COMMENT_ENABLE','1',NULL,'comment','1','0'),
('28','COMMENT_CHECK','1',NULL,'comment','1','0'),
('29','COMMENT_VERIFYCODE','1',NULL,'comment','1','0'),
('30','MEMBER_REG_ENABLE','1',NULL,'reg','1','0'),
('31','MEMBER_REG_CHECK','1',NULL,'reg','1','0'),
('32','MEMBER_REG_VERIFYCODE','1',NULL,'reg','1','0'),
('40','QQ',NULL,NULL,'contact','1','1'),
('41','APP_GROUP_LIST','Home,Admin,Install',NULL,'config','1','0'),
('42','DEFAULT_GROUP','Home',NULL,'config','1','0'),
('43','DEFAULT_MODULE','Index',NULL,'config','1','0'),
('44','DEFAULT_ACTION','Index',NULL,'config','1','0'),
('45','URL_MODEL','1',NULL,'config','1','0'),
('46','DEFAULT_THEME','Default',NULL,'config','1','0'),
('47','URL_CASE_INSENSITIVE','true',NULL,'config','1','0'),
('48','TMPL_ACTION_ERROR','APP_PATH.\'tpl/admin/default/public/error.html\'',NULL,'config','0','0'),
('49','TMPL_ACTION_SUCCESS','APP_PATH.\'tpl/admin/default/public/success.html\' ',NULL,'config','0','0'),
('50','TAGLIB_PRE_LOAD','YouDian',NULL,'config','1','0'),
('51','DEFAULT_THEME','Default',NULL,'home/config','1','0'),
('52','WATER_PIC',NULL,NULL,'water','1','0'),
('53','WATER_OFFSET_X','0',NULL,'water','1','0'),
('54','WATER_OFFSET_Y','0',NULL,'water','1','0'),
('55','WATER_TRANS','60',NULL,'water','1','0'),
('56','TITLE','企业网站管理系统|微网站建设|手机网站建设|中英文网站建设',NULL,'seo','1','1'),
('57','KEYWORDS','企业网站管理系统,微网站建设,手机网站建设,中英文网站建设',NULL,'seo','1','1'),
('58','DESCRIPTION','本系统集手机站、微信站、电脑站三站合一，各站数据同步、只需一个空间,维护更方便！订购热线：010-88888888',NULL,'seo','1','1'),
('59','ONLINE_TOP','180',NULL,'online','1','0'),
('60','ONLINE_EFFECT','1',NULL,'online','1','0'),
('61','ONLINE_WIDTH','160',NULL,'online','1','0'),
('62','ONLINE_OPEN','1',NULL,'online','1','0'),
('63','ONLINE_TELEPHONE',NULL,NULL,'online','1','0'),
('64','ONLINE_FOOTER_TEXT','<img alt=\"微信扫一扫 关注我们\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"微信扫一扫 关注微信公众号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>扫一扫，关注微信公众号</strong>',NULL,'online','1','1'),
('65','ONLINE_TITLE','在线客服',NULL,'online','1','1'),
('66','URL_MODEL','1',NULL,'core','1','0'),
('67','URL_HTML_SUFFIX','html',NULL,'core','1','0'),
('68','WEB_NAME',' web name',NULL,'basic','1','2'),
('69','WEB_ICP','ICP 123456789',NULL,'basic','1','2'),
('70','WEB_CLOSE_REASON','Sorry, the website is maintenance!',NULL,'basic','1','2'),
('71','COMPANY','your company',NULL,'contact','1','2'),
('72','DESCRIPTION','this product include pc site、mobile site、weixin site，Data synchronization, one virtual host, more convenient maintenance. Order hotline: +86-010-88888888',NULL,'seo','1','2'),
('73','KEYWORDS','website,cms,wap website',NULL,'seo','1','2'),
('74','ADDRESS','Room 906, 8th Building Spring Garden, XueYuan Road HaiDian District Beijing China',NULL,'contact','1','2'),
('76','ONLINE_TITLE','online services',NULL,'online','1','2'),
('77','ONLINE_FOOTER_TEXT','<img alt=\"\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>wechat</strong>',NULL,'online','1','2'),
('78','ORDER_ALLOW','1','订单权限','order','1','0'),
('79','ORDER_PAGESIZE','10','每页显示订单数','order','1','0'),
('80','STAT_USERNAME',NULL,'统计帐号','stat','1','0'),
('81','STAT_USERPWD',NULL,'登录密码','stat','1','0'),
('82','STAT_CODE',NULL,'统计代码','stat','1','0'),
('83','STAT_ENABLE','1','是否启用统计','stat','1','0'),
('84','SHARE_STYLE','0',NULL,'baidushare','1','0'),
('85','SHARE_TOP','333',NULL,'baidushare','1','0'),
('86','SHARE_POS','right',NULL,'baidushare','1','0'),
('87','SHARE_SIZE','0',NULL,'baidushare','1','0'),
('88','SHARE_ENABLE','0',NULL,'baidushare','1','0'),
('89','MOBILE','86-13512345678',NULL,'contact','1','2'),
('90','TELEPHONE','86-010-12345678',NULL,'contact','1','2'),
('91','FAX','86-010-12345678',NULL,'contact','1','2'),
('92','EMAIL','12345@qq.com',NULL,'contact','1','2'),
('93','QQ',NULL,NULL,'contact','1','2'),
('94','POSTCODE','400000',NULL,'contact','1','2'),
('95','LINK_ENABLE','0','是否启用生成关键词内链','link','1','0'),
('96','LINK_KEYWORD',NULL,'关键词对应链接设置','link','1','0'),
('97','WEB_BAD_IP',NULL,NULL,'basic','1','0'),
('98','WAP_URL',NULL,'手机网站域名','domain','1','0'),
('99','WEB_LOGO','/Upload/public/logo.png',NULL,'basic','1','1'),
('100','WEB_LOGO','/Upload/public/logoen.png',NULL,'basic','1','2'),
('101','MEMBER_ADD_CHECK','1',NULL,'reg','1','0'),
('102','DEFAULT_THEME','Default',NULL,'wap/config','1','0'),
('103','ONLINE_STYLE','blue_en',NULL,'online','1','2'),
('104','HTML_ENABLE','0',NULL,'html','1','0'),
('105','INDEX_CACHE_TIME','604800',NULL,'html','1','0'),
('106','CHANNEL_CACHE_TIME','1296000',NULL,'html','1','0'),
('107','INFO_CACHE_TIME','0',NULL,'html','1','0'),
('108','AUTO_DEL_ENABLE','0',NULL,'other','1','0'),
('109','AUTO_UPLOAD_ENABLE','1',NULL,'other','1','0'),
('110','DEL_LINK_ENABLE','0',NULL,'other','1','0'),
('111','ALLOW_LINK',NULL,NULL,'other','1','0'),
('112','WATER_ENABLE','0',NULL,'water','1','0'),
('113','MEMBER_LOGIN_VERIFYCODE','1',NULL,'reg','1','0'),
('114','ORDER_VERIFYCODE','1',NULL,'order','1','0'),
('115','THUMB_ENABLE','0',NULL,'thumb','1','0'),
('116','THUMB_WATER_ENABLE','0',NULL,'thumb','1','0'),
('117','THUMB_TYPE','2',NULL,'thumb','1','0'),
('118','THUMB_WIDTH','160',NULL,'thumb','1','0'),
('119','THUMB_HEIGHT','160',NULL,'thumb','1','0'),
('120','WATER_TYPE','2',NULL,'water','1','0'),
('121','WATER_TEXT',NULL,NULL,'water','1','0'),
('122','WATER_FONT','simkai.ttf',NULL,'water','1','0'),
('123','WATER_TEXT_SIZE','12',NULL,'water','1','0'),
('124','WATER_TEXT_COLOR','#FF0000',NULL,'water','1','0'),
('125','WATER_TEXT_ANGLE','0',NULL,'water','1','0'),
('126','WATER_POSITION','9',NULL,'water','1','0'),
('127','THUMB_FIRST','1',NULL,'thumb','1','0'),
('128','WAP_AUTO_REDIRECT','0',NULL,'wap','1','0'),
('129','WAP_PC_ACCESS','0',NULL,'wap','1','0'),
('130','WAP_LOGO',NULL,NULL,'wap','1','0'),
('131','LANG_AUTO_DETECT','1',NULL,'core','1','0'),
('132','DEFAULT_LANG','cn',NULL,'core','1','0'),
('133','EMAIL_SENDER',NULL,NULL,'basic','1','1'),
('134','EMAIL_ACCOUNT',NULL,NULL,'basic','1','1'),
('135','EMAIL_SMTP',NULL,NULL,'basic','1','1'),
('136','EMAIL_PASSWORD',NULL,NULL,'basic','1','1'),
('137','EMAIL_BODY','您好，{$MemberName}!感谢您注册成为{$WebName}会员。\r\n请点击以下链接激活会员帐号:\r\n{$Activate}',NULL,'reg','1','1'),
('138','EMAIL_BODY','Hello，{$MemberName}!Welcome to register the member of {$WebName}.\r\nplease click the following url to activate:{$Activate}',NULL,'reg','1','2'),
('139','EMAIL_SENDER',NULL,NULL,'basic','1','2'),
('140','EMAIL_ACCOUNT',NULL,NULL,'basic','1','2'),
('141','EMAIL_SMTP',NULL,NULL,'basic','1','2'),
('142','EMAIL_PASSWORD',NULL,NULL,'basic','1','2'),
('143','ORDER_EMAIL','0',NULL,'order','1','0'),
('144','ORDER_EMAIL_BODY',NULL,NULL,'order','1','0'),
('146','MEMBER_ENABLE','1',NULL,'reg','1','0'),
('147','GUEST_BOOK_SENDEMAIL','0',NULL,'guestbook','1','0'),
('148','WX_TOKEN',NULL,NULL,'wx','1','0'),
('149','WX_APP_ID',NULL,NULL,'wx','1','0'),
('150','WX_APP_SECRET',NULL,NULL,'wx','1','0'),
('151','COMMENT_PAGE_SIZE','10',NULL,'comment','1','0'),
('152','WX_LOGO',NULL,NULL,'wx','1','0'),
('153','WX_NAME',NULL,NULL,'wx','1','0'),
('154','WX_ORIGINAL_ID',NULL,NULL,'wx','1','0'),
('155','WX_ID',NULL,NULL,'wx','1','0'),
('156','WX_DESCRIPTION',NULL,NULL,'wx','1','0'),
('157','WX_QRCODE',NULL,NULL,'wx','1','0'),
('158','WAP_STATUS','1',NULL,'wap','1','0'),
('159','WX_SAVE_MSG','0',NULL,'wx','1','0'),
('160','GUEST_BOOK_EMAIL',NULL,NULL,'guestbook','1','0'),
('161','GUEST_BOOK_EMAIL_TITLE','网站留言提醒',NULL,'guestbook','1','0'),
('162','GUEST_BOOK_EMAIL_BODY',NULL,NULL,'guestbook','1','0'),
('163','ORDER_EMAIL_TITLE','订购通知',NULL,'order','1','0'),
('164','FEEDBACK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('165','FEEDBACK_SENDEMAIL','0',NULL,'guestbook','1','0'),
('166','FEEDBACK_EMAIL',NULL,NULL,'guestbook','1','0'),
('167','FEEDBACK_EMAIL_TITLE','网站反馈通知邮件',NULL,'guestbook','1','0'),
('168','FEEDBACK_CHECK','0',NULL,'guestbook','1','0'),
('169','WEB_ICON',NULL,NULL,'basic','1','0'),
('170','BAIDU_TRANSLATE_APIKEY','RTpNxxuIuLhDsylsFZIa27GI',NULL,'other','1','0'),
('171','EMAIL_PORT','25',NULL,'basic','1','1'),
('172','EMAIL_PORT','25',NULL,'basic','1','2'),
('173','EMAIL_WAY','tls',NULL,'basic','1','1'),
('174','EMAIL_WAY','tls',NULL,'basic','1','2'),
('175','LOG_STATUS','0',NULL,'basic','1','0'),
('176','LOGTYPE_ALLOW','2,3,4,5,6,7,8,1',NULL,'basic','1','0'),
('177','ORDER_EMAIL_TO',NULL,NULL,'order','1','0'),
('178','ADMIN_PAGE_SIZE','20',NULL,'other','1','0'),
('179','ADMIN_ROLL_PAGE','30',NULL,'other','1','0'),
('180','SITEMAP_ENABLE','1',NULL,'other','1','0'),
('181','SITEMAP_TIME','86400',NULL,'other','1','0'),
('182','ASYNC_STAT_CODE',NULL,NULL,'stat','1','1'),
('183','BAIDU_TRANSLATE_APPID',NULL,NULL,'other','1','0'),
('184','ORDER_PREFIX','SN',NULL,'order','1','0'),
('185','SMS_TYPE','Huyi',NULL,'other','1','0'),
('186','SMS_ACCOUNT',NULL,NULL,'other','1','0'),
('187','SMS_PASSWORD',NULL,NULL,'other','1','0'),
('188','MOBILE_REG_TEMPLATE','您的验证码是：【{$Code}】。请不要把验证码泄露给其他人。',NULL,'reg','1','1'),
('190','ORDER_SMS','0',NULL,'order','1','0'),
('191','ORDER_SMS_TO',NULL,NULL,'order','1','0'),
('192','ORDER_SMS_TEMPLATE','您有新的订单：订单编号【{$OrderNumber}】，订单金额【{$TotalOrderPrice}】，下单时间【{$OrderTime}】，请及时处理！',NULL,'order','1','0'),
('193','GUEST_BOOK_SMS','0',NULL,'guestbook','1','0'),
('194','GUEST_BOOK_SMS_TO',NULL,NULL,'guestbook','1','0'),
('195','GUEST_BOOK_SMS_TEMPLATE',NULL,NULL,'guestbook','1','0'),
('196','FEEDBACK_SMS','0',NULL,'guestbook','1','0'),
('197','FEEDBACK_SMS_TO',NULL,NULL,'guestbook','1','0'),
('198','FEEDBACK_SMS_TEMPLATE',NULL,NULL,'guestbook','1','0'),
('199','SMS_IP_MAX','20',NULL,'other','1','0'),
('200','SMS_NUM_MAX','60',NULL,'other','1','0'),
('201','WX_CUSTOMER_SERVICE','0',NULL,'wx','1','0'),
('202','COMMENT_BUY','1',NULL,'comment','1','0'),
('203','COMMENT_TIP','评论事项：有什么问题, 满意, 或者不不满, 都可以在这里评论出来, 这里评论全部源于真实的评论',NULL,'comment','1','1'),
('204','COMMENT_TIP',NULL,NULL,'comment','1','2'),
('205','APP_LOGO','',NULL,'other','1','1'),
('206','APP_LOGO','',NULL,'other','1','2'),
('207','APP_THEME_COLOR','#FF3300',NULL,'other','1','0'),
('208','APP_VERSION','1.0.0',NULL,'other','1','0'),
('209','APP_APK_URL','',NULL,'other','1','0'),
('210','APP_APK_QRCODE','',NULL,'other','1','0'),
('211','APP_IPA_URL','',NULL,'other','1','0'),
('212','APP_IPA_QRCODE','',NULL,'other','1','0'),
('213','APP_TAB2_CHANNELID','21',NULL,'other','1','1'),
('214','APP_TAB2_CHANNELID','40',NULL,'other','1','2'),
('215','APP_TAB2_ICON','ion-ios-book',NULL,'other','1','0'),
('216','APP_TAB3_CHANNELID','55',NULL,'other','1','1'),
('217','APP_TAB3_CHANNELID','43',NULL,'other','1','2'),
('218','APP_TAB3_ICON','ion-ios-videocam',NULL,'other','1','0'),
('219','APP_ABOUT','',NULL,'other','1','1'),
('220','APP_ABOUT','',NULL,'other','1','2'),
('221','APP_TAB2_TITLE','新闻',NULL,'other','1','1'),
('222','APP_TAB2_TITLE','News',NULL,'other','1','2'),
('223','APP_TAB3_TITLE','视频',NULL,'other','1','1'),
('224','APP_TAB3_TITLE','Product',NULL,'other','1','2'),
('225','APP_TAB2_ICON_ACTIVE','ion-ios-book-outline',NULL,'other','1','0'),
('226','APP_TAB3_ICON_ACTIVE','ion-ios-videocam-outline',NULL,'other','1','0'),
('227','APP_VERSION_DESCRIPTION','',NULL,'other','1','1'),
('228','APP_VERSION_DESCRIPTION','',NULL,'other','1','2'),
('229','APP_APK_SIZE','2.8M',NULL,'other','1','0'),
('230','APP_KEY_JIGUANG','',NULL,'other','1','0'),
('231','APP_MASTER_SECRET_JIGUANG','',NULL,'other','1','0'),
('232','WAP_QRCODE','',NULL,'wap','1','0'),
('233','APP_SHARE_TITLE','某某系统App下载',NULL,'other','1','1'),
('234','APP_SHARE_TITLE','App',NULL,'other','1','2'),
('235','APP_SHARE_DESCRIPTION','',NULL,'other','1','1'),
('236','APP_SHARE_DESCRIPTION','',NULL,'other','1','2'),
('237','APP_APK_SHARE_URL','',NULL,'other','1','1'),
('238','APP_APK_SHARE_URL','',NULL,'other','1','2');

INSERT INTO `youdian_delivery_time` VALUES
('1','工作日、双休日与假日均可送货 ','1','1','1'),
('2','只双休日、假日送货(工作日不用送) ','2','1','1'),
('3','只工作日送货(双休日、假日不用送)','3','1','1'),
('4','尽量安排其他时间送货,请备注说明','4','1','1'),
('5','Working day, weekend and holiday delivery available','1','1','2'),
('6','Only weekends, holidays and delivery (working days do not send)','2','1','2'),
('7','Only working days delivery (weekends, holidays do not send)','3','1','2'),
('8','Try to arrange delivery time, please Remarks','4','1','2');

INSERT INTO `youdian_info` VALUES
('4','21',NULL,'1','热烈祝某某网站管理系统3.0正式发布',NULL,'<p>\r\n	新版增加了手机网站、子域名绑定、网站优化等功能。</p>\r\n<p>\r\n	系统采用PHP+MySQL进行开发，它具有操作简单、功能强大、稳定性好、易扩展、安全性强、后期维护方便等特点，可以帮您迅速、轻松地构建起一个强大专业的企业网站。系统支持手机网站、多语言、自定义模型、SEO优化、静态页生成、评论留言、订购、会员、广告、招聘、统计、自助表单等常见企业网站基本功能，通过灵活的插件机制还能扩展更多应用。凭借公司团队长期积累的丰富的Web开发经验和勇于创新追求完美的设计理念，使得产品得到了许多企业的认可，并且越来越多地被应用到大中型商业网站。</p>\r\n','0','/Upload/news/2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 11:55:23',NULL,'9',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('5','21',NULL,'1','2013年公司将研发云计算平台企业网站管理系统',NULL,'<p>\r\n	<span style=\"color: #0000ff\"><b>2013年公司将研发云计算平台企业网站管理系统</b></span></p>\r\n<p>\r\n	<b>云计算</b>如今发展的额相当迅速，因为在企业发展中如果使用云计算将会帮你获得更大的竞争优势。在商业竞争中，如果让竞争对手占了先机，那么企业将会受到威胁。下面介绍下，基于云计算的企业网站管理系统将给我们带来的3点便利：<br />\r\n	&nbsp;</p>\r\n<p align=\"left\">\r\n	&nbsp;<strong> &nbsp; 1.节约成本，降低IT管理费用，创造价格优势。</strong></p>\r\n<p align=\"left\">\r\n	有的企业能够按成本价出售产品，却依然能盈利，这是为什么呢？通过使用基于云计算的服务，可以把成本降低了一半，而之前企业每年要在IT领域投资5000万美元。或者可以抛弃了原先投资建设新数据中心的计划，但企业通过使用云计算，节约成本、降低售价，从而扩大销量，获取更高的利润。</p>\r\n<p align=\"left\">\r\n	&nbsp;</p>\r\n<p align=\"left\">\r\n	<strong>&nbsp; &nbsp; 2.更好地使用商业数据。</strong></p>\r\n<p align=\"left\">\r\n	云计算使大数据的处理成为变得简单，而传统方法通常要付出很高的成本。有了云计算，许多企业广泛地获取信息，决定企业的发展方向并发现各种机会，而之前他们往往苦于信息的匮乏。通过基于云技术的大型数据系统，他们能够更加理智地收集各种资源，并利用他们创造收益。如果你的企业正在这样做，可以给你的竞争对手带来更大的威胁。</p>\r\n<p align=\"left\">\r\n	&nbsp;</p>\r\n<p align=\"left\">\r\n	<strong>&nbsp; &nbsp; 3.充分利用IT技术新的灵活性扩大企业规模。</strong></p>\r\n<p align=\"left\">\r\n	现如今，许多企业希望通过合并或者收购来扩大企业规模，但由于转变现有的IT设施所需的时间太长而不得不放弃。这是相当令人扫兴的。而云计算有着更好的灵活性，可以快速构建基础设施、应用程序以及商业数据。利用这一点，企业可以更快的扩大规模，而且成本会更低，风险也会更小。更加有利于企业的发展。</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 11:55:23',NULL,'33',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('6','21',NULL,'1','成功研发手机版网站',NULL,'<p>\r\n	<br />\r\n	手机网站目前已成为通过移动电话或其他无线终端访问无线信息服务的全球事实标准。它的发展与应用是无可限量的，可以说唯一的限制就是你的想像力，手机网站不但使现有的许多应用得到了突飞猛进的改变，同时也催生出更多崭新的增值业务。</p>\r\n<p>\r\n	工信部数据显示，截至2011年5月底，我国手机用户总数突破9亿，3G网络、智能手机、移动互联网成为推动手机用户增长的一个主要因素；同时，我国网民规模已达4.57亿，手机网民约为3亿，智能终端和手机上网的数量已经超越了笔记本和固定PC机上网的数量。<br />\r\n	&nbsp;</p>\r\n<p style=\"text-align: center\">\r\n	&nbsp;</p>\r\n<div class=\"feature-desc feature-left\">\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>手机网站五大优势:</strong></span></p>\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>1.跨平台，节省开发成本</strong><br />\r\n		不需要为苹果、安卓、微软Windows、黑莓等不同移动平台单独开发，一次开发，所有平台都能使用。</span></p>\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>2.无需下载，即刻浏览</strong><br />\r\n		用户可瞬间打开手机网站，无需耗费大量时间、流量从APP商店下载，大大降低使用门槛。</span></p>\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>3.有效利用搜索引擎推广</strong><br />\r\n		手机网站可被百度、谷歌等搜索引擎检索，导入大量流量。</span></p>\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>4.便于网络营销推广</strong><br />\r\n		网页可通过链接形式在短信、微博、论坛、邮件等多种渠道推广，聚集多方流量。</span></p>\r\n	<p>\r\n		<span style=\"font-size: 14px\"><strong>5.方便访问</strong><br />\r\n		随时随地，只要有手机就能访问。</span></p>\r\n	<h3>\r\n		<span style=\"font-size: 14px\"><span style=\"color: #ff0000\"><span style=\"font-size: 20px\">4亿人都在用手机浏览网页，您的网站准备好了吗？</span></span></span></h3>\r\n	<p>\r\n		<br />\r\n		&nbsp;</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 11:55:23',NULL,'37',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('7','21',NULL,'1','独立IP虚拟主机上线',NULL,'<p>\r\n	近日，本司独立IP虚拟主机产品正式上线，每个IP只需要相当低的价格即可申请！传统虚拟主机，有数百用户共同使用同壹台服务器的资源，包含硬件、网络等资源，每台服务器被分配了一个IP地址。由于IPv4地址资源并不是用之不竭，多用户共享一个IP地址的虚拟主机产品，成为有效控制成本的最佳产品。但随着网络的快速发展，网站主对资源需求的增加，独立IP地址的需求也更加迫切。2012年初，IPv4地址池已经没有可再分配的资源，所以IP地址变得更为紧俏。</p>\r\n<p>\r\n	　　目前，行业独立IP地址成本已达到300元/年。即便现在已经涨到如此高的价格，但很多IDC企业亦到了无资源可售的现状。</p>\r\n<p>\r\n	　　在当今的网络环境中，独立IP地址与共享IP地址在网站运行过程中，分别会有那些方面的区别呢？</p>\r\n<p>\r\n	　　独立IP就是一个IP对应一个网站，这样搜索引擎会评定该网站质量更高，更容易抓取到该网站的页面，从而提高其收录级别，利于SEO，网站宣传和网络营销成本不仅降低，其效果也将更有保证，而共享IP条件下则会降低网站收录级别。独立IP虚拟主机除了能提高网站的收录级别，还有重要一点是规避连带风险。当同台服务器的其他网站因受攻击、因违规内容被封IP等情况下，采用独立IP的网站均可以避免被牵连。</p>\r\n<p>\r\n	　　百度百科里面关于&ldquo;IP地址&rdquo;用这样一个例子来理解：在电话通讯中，电话用户是靠电话号码来识别的。同样，在网络中为了区别不同的计算机，也需要给计算机指定一个连网专用号码，这个号码就是&ldquo;IP地址&rdquo;。</p>\r\n<p>\r\n	　　目前IP地址资源非常稀缺，业界只有少数几家服务商提供独立IP的虚拟主机，且IP地址收费较贵。此次西部数码大规模推出价格便宜的独立IP主机，可以让广大站长以低成本获得众多的IP资源，同时也彰显了西部数码的行业地位和资源储备实力。</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 11:55:23',NULL,'163',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('8','22',NULL,'1','奇虎360与谷歌达成搜索合作协议',NULL,'<p>\r\n	网易科技讯 1月4日消息，据国外媒体报道，之前有消息称奇虎360与谷歌有望达成搜索合作协议，可能对中国搜索巨头百度形成威胁，而奇虎方面已经向ZDNet正式确认了这一消息，表示与谷歌的合作协议确实存在，但拒绝透露更多细节。</p>\r\n<p>\r\n	彭博社于本周早些时候援引投资公司WedgePartners的分析表示，奇虎与谷歌将于2013年年初展开合作。奇虎首席执行官周鸿祎之前也曾表示，奇虎愿意与谷歌，微软，搜狗等拥有搜索引擎服务的公司展开合作。</p>\r\n<p>\r\n	之后美国独立分析机构ABR InvestmentStrategy也爆料称奇虎与谷歌的合作即将展开。ABR表示：&ldquo;有鉴于预期中奇虎与谷歌的合作，我们将2013财年搜索营收预期从6200万美元调高至9000万美元。&rdquo;</p>\r\n<p>\r\n	而当ZDNet Asia联系到奇虎方面进行采访时，奇虎方面表示：&ldquo;奇虎只能确认与谷歌之间的合作确实存在，但目前无法透露任何细节信息。&rdquo;</p>\r\n<p>\r\n	花旗银行分析师李幕至(音译Lee Muzhi)与拉维&bull;萨拉蒂(RaviSarathy)表示，奇虎与谷歌的合作对于百度而言是个坏消息。他们重申了百度的卖出评级，表示这是因为奇虎搜索服务货币化以及与谷歌关键词服务进行合作的缘故。</p>\r\n<p>\r\n	如果一切进展顺利，奇虎将于谷歌首次展开合作。之前奇虎曾在其浏览器中使用谷歌搜索服务，现在则已经替换成了自己的搜索服务。</p>\r\n<p>\r\n	奇虎在安全软件领域已经确立了自己的地位，该公司也已经将业务延伸至其他互联网服务领域，如浏览器和搜索引擎服务。(西风)<br />\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:00:04',NULL,'11',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('9','22',NULL,'1','万网被指存在安全漏洞可导致注册域名被恶意劫持',NULL,'<p>\r\n	新浪科技讯 1月4日午间消息，安全问题反馈平台乌云(wooyun.org)今日通过微博发布消息称，万网存在安全漏洞可导致注册域名被恶意劫持。</p>\r\n<p>\r\n	乌云在微博中表示，&ldquo;近期万网被证明存在安全漏洞，恶意用户可以任意劫持在万网注册的域名，在万网彻底修复漏洞之前建议各位站长和企业添加对域名的监控&rdquo;。</p>\r\n<p>\r\n	实际上，乌云就是这一漏洞的受害者。据乌云微博透露，这一漏洞的存在导致乌云遭受攻击，&ldquo;并且一段时间内无法访问且造成了实际的权益损失&rdquo;。乌云官方进一步表示，作为万网用户将保留起诉的权利。</p>\r\n<p>\r\n	对此，律师赵占领指出：如果是自身存在漏洞而不是用户原因导致域名被劫持，万网应该向用户赔偿损失。否则，用户可以通过法律途径追究万网责任。</p>\r\n<p>\r\n	至截稿时，万网方面未对此作出回应。<br />\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:00:04',NULL,'9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('10','22',NULL,'1','360搜索引擎http://so.360.cn上线',NULL,'<p>\r\n	前几日盛传奇虎360欲推自己的搜索引擎，今天，360的搜索引擎悄然上线，一些业内人士已经得到小道消息并开始试用。360搜索启用二级域名so.360.cn。</p>\r\n<p>\r\n	目前360搜索的界面还非常简陋，下图中红色的下标采取了与&ldquo;有道搜索&rdquo;类似的设计。另外，除了网页搜索由360搜索提供搜索结果之外，新闻搜索，MP3搜索，图片搜索，地图搜索，问答搜索等均直接链接到百度的对应搜索分类，视频搜索链接到360原有的&ldquo;360影视搜索&rdquo;。</p>\r\n<p>\r\n	可能鉴于360搜索刚刚上线，搜索技术和体验还不够完善，因此360搜索目前仍保留了百度和Google搜索，将这两个搜索都集成到360搜索的页面，如果用户觉得360搜索的结果不满意，可直接点击切换到百度搜索或者Google搜索。</p>\r\n<p>\r\n	从微博上大家对360搜索引擎的测试结果来看，360搜索有可能走的是Blekko的路线（个人猜测），也就是只索引权威的站点以保证搜索结果的权威性和剔除垃圾站。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	8月10日程苓峰曾在微博上透露：</p>\r\n<p>\r\n	听说360即将推出独立域名的一般搜索。本来是要推出基于浏览器的资讯推荐，但还不成熟。也听说会对其他搜索引擎结果里的＂非法＂内容或者广告进行标注以提醒用户。</p>\r\n<p>\r\n	目前看来所言非虚，另据Fenng在微博上透露的消息：</p>\r\n<p>\r\n	关于 360 搜索的更多小道消息：地址大家都知道了，现在在做初期试水，自己的搜索效果还不够好，可能会和 Bing 先做合作。等实际成熟再用自己的。360 股价要涨。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	另外下午会有小热闹可看：搜狗CEO王小川在微博上表示：</p>\r\n<p>\r\n	借三级火箭模式，360终于发布通用搜索了。网民有更多的选择是好事情。但搜索技术需要长时间积累，我们也要担心品质不佳用不正当手段伤害用户。我之前就听说研发过程有一些超越底线的&ldquo;极端手段&rdquo;。搜狗搜索团队会对360搜索品质做一个常规性评测，下午给大家发报告。</p>\r\n<p>\r\n	目前360官方以及周鸿祎尚未披露更多消息。<br />\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:00:04',NULL,'9',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('11','22',NULL,'1','哪些原因会导致数据中心断网？',NULL,'<p>\r\n	人再囧途之泰囧在2012年岁末床下了华语电影的票房记录，而且还在刷新着记录。但是在IT界，频频爆发的数据中心安全故障事件，也在一次次冲击着企业用户的心理防线。只期待，数据中心的安全问题，不要成为人再囧途之&ldquo;泰囧&rdquo;。</p>\r\n<p>\r\n	云计算服务在这个时代被吹捧成为IT圣者，所有的服务都可以被&ldquo;云&rdquo;化。但是，当很多公司勇于第一个吃螃蟹之后，却发现往往最容易受伤的也是他们。近几年来，层出不穷的云服务断网事件，让业界听得心惊胆寒。</p>\r\n<p>\r\n	<img alt=\"\" src=\"/Upload/news/135I5001YE50-23296%5B1%5D.jpg\" style=\"width: 350px; height: 253px\" /></p>\r\n<p>\r\n	人们渐渐回归理想，更加清晰地看清楚云计算的真面目。可以说，无论多么高远的梦想还是要找到稳固的立足点，云服务最终还是要从一个数据中心被传输到另外一个数据中心，在这个过程仍然摆脱不了需要人、计算机、网络、电能、存储等之间协同工作。这样一来，整个过程出现错误和漏洞就在所难免，再加上天灾人祸。所以，启用云服务你必须有一定的思想准备，同时要有第二手的解决方案来应对。</p>\r\n<p>\r\n	编者在这里回顾一下近年来发生的一系列断网事件背后的原因。从2009年-2012年之间。也许能让你看到：即便是计算机出错似乎在所难免，再保险的措施似乎也只能把安全事件控制在一个小概率范围内。</p>\r\n<p>\r\n	<strong>断网类型一：系统故障</strong></p>\r\n<p>\r\n	典型事件1：亚马逊AWS平安夜断网</p>\r\n<p>\r\n	故障原因：弹性负载均衡服务故障</p>\r\n<p>\r\n	2012年12月24日，刚刚过去的圣诞节平安夜，亚马逊并没有让他们的客户过得太平安。亚马逊AWS位于美国东部1区的数据中心发生故障，其弹性负载均衡服务（Elastic Load Balancing Service）中断，导致Netflix和Heroku等网站受到影响。其中，Heroku在之前的AWS美国东部区域服务故障中也受到过影响。不过，有些巧合的事情是Netflix的竞争对手，亚马逊自己的业务Amazon Prime Instant Video并未因为这个故障而受到影响。</p>\r\n<p>\r\n	12月24日，亚马逊AWS中断服务事件不是第一次，当然也绝非最后一次。</p>\r\n<p>\r\n	2012年10月22日，亚马逊位于北维吉尼亚的网络服务AWS也中断过一次。其原因与上次相似。事故影响了包括Reddit、Pinterest等知名大网站。中断影响了弹性魔豆服务，其后是弹性魔豆服务的控制台，关系数据库服务，弹性缓存，弹性计算云EC2，以及云搜索。这次事故让很多人认为，亚马逊是应该升级其北维尼吉亚数据中心的基础设施了。</p>\r\n<p>\r\n	2011年4月22日，亚马逊云数据中心服务器大面积宕机，这一事件被认为是亚马逊史上最为严重的云计算安全事件。由于亚马逊在北弗吉尼亚州的云计算中心宕机，包括回答服务Quora、新闻服务Reddit、Hootsuite和位置跟踪服务FourSquare在内的一些网站受到了影响。亚马逊官方报告中声称，此次事件是由于其EC2系统设计存在漏洞和设计缺陷，并且在不断修复这些已知的漏洞和缺陷来提高EC2（亚马逊ElasticComputeCloud服务）的竞争力。</p>\r\n<p>\r\n	2010年1月，几乎6万8千名的Salesforce.com用户经历了至少1个小时的宕机。Salesforce.com由于自身数据中心的&ldquo;系统性错误&rdquo;，包括备份在内的全部服务发生了短暂瘫痪的情况。这也露出了Salesforce.com不愿公开的锁定策略：旗下的PaaS平台、Force.com不能在Salesforce.com之外使用。所以一旦Salesforce.com出现问题，Force.com同样会出现问题。所以服务发生较长时间中断，问题将变得很棘手。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>断网诱因二：自然灾害</strong></p>\r\n<p>\r\n	典型事件1：亚马逊北爱尔兰柏林数据中心宕机</p>\r\n<p>\r\n	故障原因：闪电击中柏林数据中心的变压器</p>\r\n<p>\r\n	2011年8月6日，在北爱尔兰都柏林出现的闪电引起亚马逊和微软在欧洲的云计算网络因为数据中心停电而出现大规模宕机。闪电击中都柏林数据中心附近的变压器，导致其爆炸。爆炸引发火灾，使所有公用服务机构的工作暂时陷入中断，导致整个数据中心出现宕机。</p>\r\n<p>\r\n	这个数据中心是亚马逊在欧洲唯一的数据存储地，也就是说，EC2云计算平台客户在事故期间没有其他数据中心可供临时使用。宕机事件使得采用亚马逊EC2云服务平台的多家网站长中断达两天时间之久。</p>\r\n<p>\r\n	典型事件2：卡尔加里数据中心火灾事故</p>\r\n<p>\r\n	故障原因：数据中心发生火灾</p>\r\n<p>\r\n	2012年7月11日卡尔加里数据中心火灾事故：加拿大通信服务供应商ShawCommunicationsInc位于卡尔加里阿尔伯塔的数据中心发生了一场火灾，造成当地医院的数百个手术延迟。由于该数据中心提供管理应急服务，此次火灾事件影响了支持关键公共服务主要的备份系统。此次事件为一系列政府机构敲响了警钟，必须确保及时的恢复和拥有故障转移系统，同时结合出台灾害管理计划。</p>\r\n<p>\r\n	典型事件3：超级飓风桑迪袭击数据中心</p>\r\n<p>\r\n	故障原因：风暴和洪水导致数据中心停止运行</p>\r\n<p>\r\n	2012年10月29日，超级飓风桑迪：纽约和新泽西州的数据中心都受到了此次飓风的影响，所带来的恶劣影响包括为曼哈顿下城地区的洪水和一些设施的停机，周围地区数据中心发电机运行失常。飓风桑迪所带来的影响超出了一般单一的中断事故，为受灾地区数据中心产业带来了规模空前的灾难。事实上，柴油已然成为了数据中心恢复工作的生命线，作为备用电源系统接管了整个地区的负荷，促使特别措施，保持发电机的燃料。随着眼前的工作重点逐步转移到灾后重建，我们有必要长期就数据中心的选址、工程和灾难恢复进行探讨，这一话题可能将持续几个月，甚至几年。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>断网诱因三：人为因素</strong></p>\r\n<p>\r\n	典型事件1：Hosting.com服务中断事故</p>\r\n<p>\r\n	故障原因：服务供应商执行断路器操作顺序不正确造成的UPS关闭</p>\r\n<p>\r\n	2012年7月28日Hosting.com停运事件：人为错误通常被认为是数据中心停机的主导因素之一。7月Hosting.com中断事件造成 1100名客户服务中断就是一个例子。停机事故的发生是由于该公司位于特拉华州纽瓦克的数据中心正进行UPS系统预防性维护，&ldquo;服务供应商执行断路器操作顺序不正确造成的UPS关闭是造成数据中心套房内的设施损失的关键因素之一。&rdquo;Hosting.com首席执行官ArtZeile说。&ldquo;没有任何重要的电力系统或备用电源系统出现故障，完全是一种人为的错误造成的。&rdquo;</p>\r\n<p>\r\n	典型事件2：微软爆发BPOS服务中断事件</p>\r\n<p>\r\n	故障原因：微软在美国、欧洲和亚洲的数据中心的一个没有确定的设置错误造成的</p>\r\n<p>\r\n	2010年9月，微软在美国西部几周时间内出现至少三次托管服务中断事件向用户致歉。这是微软首次爆出重大的云计算事件。</p>\r\n<p>\r\n	事故当时，用户访问BPOS（Business Productivity Online Suite）服务的时候，如果使用微软北美设施访问服务的客户可能遇到了问题，这个故障持续了两个小时。虽然，后来微软工程师声称解决了这一问题，但是没有解决根本问题，因而又产生了9月3日和9月7日服务再次中断。</p>\r\n<p>\r\n	微软的Clint Patterson说，这次数据突破事件是由于微软在美国、欧洲和亚洲的数据中心的一个没有确定的设置错误造成的。BPOS软件中的离线地址簿在&ldquo;非常特别的情况下&rdquo;提供给了非授权用户。这个地址簿包含企业的联络人信息。</p>\r\n<p>\r\n	微软称，这个错误在发现之后两个小时就修复了。微软称，它拥有跟踪设施，使它能够与那些错误地下载这些数据的人取得联系以便清除这些数据。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>断网诱因四：系统故障</strong></p>\r\n<p>\r\n	典型事件1：GoDaddy网站DNS服务器中断</p>\r\n<p>\r\n	故障原因：系统内一系列路由器的数据表造成的网络中断</p>\r\n<p>\r\n	2012年9月10日GoDaddy网站DNS服务器中断：域名巨头GoDaddy是一家最重要的DNS服务器供应商，其拥有500万个网站，管理超过5000万的域名。这就是为什么九月10日中断事故会是一个2012年最具破坏性的事件。</p>\r\n<p>\r\n	一些炒作甚至认为，此次长达6个小时的中断事件是由于拒绝服务攻击的结果，但GoDaddy后来表示，这是路由器表的损坏数据造成的。&ldquo;服务中断不是由外部影响造成的。&rdquo;GoDaddy的临时首席执行官史葛瓦格纳说。&ldquo;这不是黑客攻击也不是一个拒绝服务攻击（DDoS）。我们已经确定了服务中断是由于内部的一系列路由器的数据表造成的网络事件损坏。&rdquo;</p>\r\n<p>\r\n	典型事件2：盛大云存储断网</p>\r\n<p>\r\n	故障原因：数据中心一台物理服务器磁盘损坏</p>\r\n<p>\r\n	2012年8月6日晚上8：10，盛大云在其官方微博上发布一则因云主机故障致用户数据丢失事件的公开声明。声明说到：8月6日，盛大云在无锡的数据中心因为一台物理服务器磁盘发生损坏，导致&ldquo;个别用户&rdquo;数据的丢失。盛大云已经在尽全力协助用户恢复数据。</p>\r\n<p>\r\n	对于因为一台&ldquo;物理服务器磁盘发生损坏&rdquo;，导致&ldquo;个别用户&rdquo;数据的丢失的情况，盛大云技术人员给出自己的解释：虚拟机的磁盘有两种生产方式，一种是直接使用宿主机的物理磁盘。这种情况下，如果宿主机的物理磁盘发生故障，云主机不可避免会造成数据丢失，这也是本次事件产生的原因;另外一种是使用远程存储，也就是盛大硬盘产品，这种方式实际上是把用户的数据存到了远程的一个集群里，并同时做了多份备份，即使宿主机出故障也不会影响到云主机的数据。因为物理机的损坏很难避免，为了避免您遇到意外损失，我们建议您在云主机之外，也做好数据备份。</p>\r\n<p>\r\n	典型事件3：Google App Engine中断服务</p>\r\n<p>\r\n	故障原因：网络延迟</p>\r\n<p>\r\n	Google App Engine：GAE是用于开发和托管WEB应用程序的平台，数据中心由google管理，中断时间是10月26日，持续4小时，因为突然变得反应缓慢，而且出错。受此影响，50%的GAE请求均失败。</p>\r\n<p>\r\n	谷歌表示没有数据丢失，应用程序行为也有备份可以还原。为表歉意，google宣布11月份用户可以google表示他们正在加强其网络服务以应对网络延迟问题，&ldquo;我们已经增强了流量路由能力，并调整了配置，这些将会有效防止此类问题再次发生&rdquo;。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>断网诱因五：系统Bug</strong></p>\r\n<p>\r\n	典型事件1：Azure全球中断服务</p>\r\n<p>\r\n	事故原因：软件Bug导致闰年时间计算不正确</p>\r\n<p>\r\n	2012年2月28日，由于&ldquo;闰年bug&rdquo;导致微软Azure在全球范围内大面积服务中断，中断时间超过24小时。虽然微软表示该软件BUG是由于闰年时间计算不正确导致，但这一事件激起了许多用户的强烈反应，许多人要求微软为此做出更合理详细的解释。</p>\r\n<p>\r\n	典型事件2：Gmail电子邮箱爆发全球性故障</p>\r\n<p>\r\n	事故原因：数据中心例行性维护时，新程序代码的副作用</p>\r\n<p>\r\n	2009年2月24日，谷歌的Gmail电子邮箱爆发全球性故障，服务中断时间长达4小时。谷歌解释事故的原因：在位于欧洲的数据中心例行性维护之时，有些新的程序代码（会试图把地理相近的数据集中于所有人身上）有些副作用，导致欧洲另一个资料中心过载，于是连锁效应就扩及到其它数据中心接口，最终酿成全球性的断线，导致其他数据中心也无法正常工作。</p>\r\n<p>\r\n	典型事件3：&ldquo;5.19断网事件&rdquo;</p>\r\n<p>\r\n	事故原因：客户端软件Bug，上网终端频繁发起域名解析请求，引发DNS拥塞</p>\r\n<p>\r\n	2009年5月19日的21：50，江苏、安徽、广西、海南、甘肃、浙江等六省用户申告访问网站速度变慢或无法访问。经过工信部相关单位调查通报称，此次全国六省网络中断事故，原因是国内某公司推出的客户端软件存在缺陷，在该公司域名授权服务器工作异常的情况下，导致安装该软件的上网终端频繁发起域名解析请求，引发DNS拥塞，造成大量用户访问网站慢或网页打不开。</p>\r\n<p>\r\n	其中，DN SPod是国内知名的域名解析服务商之一的N SPod公司，服务数家知名网站的域名解析服务。此次攻击导致DN SPod公司所属的6台dns域名解析服务器瘫痪，直接造成包括暴风影音在内的多家网络服务商的域名解析系统瘫痪，由此引发网络拥塞，造成大量用户不能正常上网。 工信部指出，此次事件暴露出域名解析服务成为目前网络安全的薄弱环节，指示各单位要加强对域名解析服务的安全保护。</p>\r\n<p>\r\n	小结</p>\r\n<p>\r\n	启用云服务的公司，很大程度是考虑这种服务可以更加编辑，性价比高。但是，这样的考虑如果是以降低安全性作为代价，估计很多公司老大不会同意。层出不穷的云服务断网事件引起了云端安全性的担忧。</p>\r\n<p>\r\n	目前来看，解决的办法可以从几个角度出发，对于企业级客户来说，务必在采用云服务的同时定期备份云端的数据，拥有第二套解决方案按，以备不时之需。而对于云服务提供商来说，既然各种断网事件是在所难免的，那就必须思考一个对策，将自己用户的损失降到最低，对断网事件的响应效率要提高。</p>\r\n<p>\r\n	政府部门则具有监督和提醒的职责，云服务相关的法律法律要相继出台和不断完善，并且提醒用户百分之百可靠的云计算服务目前还不存在。</p>\r\n','0','/Upload/news/4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:01:41',NULL,'12',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('12','22',NULL,'1','业界传出称百度将加速并购UCweb',NULL,'<p>\r\n	搜狐IT称来自投资界消息人士称，百度正在加速与优视科技（UCweb）进行资本谈判，以期控股或者战略投资UCweb。&ldquo;投资金山、UCweb的一系列谈判都是由李彦宏亲自带人进行的。预计很快将达成。&rdquo;2012年6月曾传百度4亿美金收购UC49%股份。不过交易并未达成。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	来自百度内部的消息人士称，百度近期加紧了一切防御性及移动端的投资，并加速推进投资过程，而此次的投资和并购都是由李彦宏亲自过问的。</p>\r\n<p>\r\n	&ldquo;百度缺乏移动端的入口，控股UCweb是最好的选择。&rdquo;投资界分析人士称。此前互联网分析师Keso也曾表示，&ldquo;如果此消息（百度并购UCweb）被证实，这将是百度一次防御性的收购，主要目的是防止UC被其它互联网巨头所收购。&rdquo;</p>\r\n<p>\r\n	不过，百度并购UCweb的交易能否达成还有许多因素在左右。消息人士称，在去年6月的接触中，百度给UCweb估值8.16亿美金，UCweb方面的自行估值为10亿美金，最终双方价格没有谈拢。而此次UCweb的估值可能更高，百度需要付出更多的现金，百度能否接受是个问题。同时，UCweb的创始团队以及阿里巴巴、诺基亚等战略投资者能否接受百度收购也是变数。</p>\r\n<p>\r\n	截至发稿时止，百度和UCweb尚未对双方洽谈一事作出评论。</p>\r\n<p>\r\n	<img alt=\"\" src=\"/Upload/news/135ZM1951a0-61W2.jpg\" style=\"width: 550px; height: 1267px\" /></p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:02:16',NULL,'16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('13','22',NULL,'1','百度大规模算法升级，SEO请慎用点击器类软件',NULL,'<p>\r\n	最近，由于百度进行大规模的算法升级和改版，搞的人心惶惶。先是百度新闻搜索失灵，又是百度搜索引擎频繁出错，尤其是稍长文本时更是每次必错。其中的一条就是针对目前比较流行的点击器类软件做了一定的算法调整，从最近此类软件提供商出现跑路事件，就可以肯定地说点击器要没市场了。百度点击器软件从2009年开始在国内流行，也称模拟点击，其主要通过P2P技术和代理技术来真实模拟用户的点击行为来影响搜索引擎排名。主要针对百度联盟广告、互点联盟、互点群等等性质的对百度联盟广告进行相互点击的行为进行惩罚。</p>\r\n<p>\r\n	我也收到了百度联盟的邮件通知，所有百度联盟内的网站，悬赏举报，可见人为使用软件模拟点击的行为已经触动了百度的根本利益，百度当然无法容忍。</p>\r\n<p>\r\n	最近有网友反馈：花了598买了个点击器软件，原本排名15位的词，用点击器模拟点击了一下午，结果第二天，不仅这个词的排名没了，最气愤的是，其它的关键词排名也都消失了，辛辛苦苦优化了大半年的网站，就只有搜索标题能搜索到了，连长尾词也一个都搜索不到了。</p>\r\n<p>\r\n	&nbsp;</p>\r\n','0','/Upload/news/3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:02:44',NULL,'16',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('14','22',NULL,'1','百度确认：蜘蛛会抓取纯文本链接的URL',NULL,'<p>\r\n	百度官方确认纯文本的链接URL会被百度抓取，百度爬虫会对网络上的纯文本链接进行抓取，以下是来自百度站长俱乐部Lee的回复!</p>\r\n<p>\r\n	1，文本链接url地址,百度会发现他是一个url地址并通过这个地址到相应的url地址上去抓取。</p>\r\n<p>\r\n	2，我们对链接是否应该传递权重，唯一的判断标准是：这个链接是否用户or对方网站真心推荐你的网站、这个推荐，是否对用户有价值。</p>\r\n<p>\r\n	注：纯文本链接也就是去掉了超链接的URL，多数投稿文章会被去掉超链接，无疑这是个好消息，<strong>但不能确认是否传递权重</strong>。</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:03:11',NULL,'15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('15','22',NULL,'1','Godaddy被封，大量网站无法访问',NULL,'<p>\r\n	2012年5月，Godaddy的主站目前从中国地区解析很不稳定，解析被屏蔽，铁通线路正常，电信的基本都屏蔽掉了，越来越多的GoDaddy DNS服务器被区域性的干扰导致无法使用，这次主要是Godaddy自身的域名都无法解析了，使得大量网站无法访问，尤其是在Godaddy注册域名的站长。</p>\r\n<p>\r\n	从去年7月份开始，中国的一些电信运营商就开始屏蔽部分Godaddy的DNS服务，导致大量使用Godaddy的DNS的网站无法从中国访问，这种直接屏蔽NS（域名解析）服务的手法，影响非常恶劣，为了&ldquo;惩罚&rdquo;某一两个所谓的&ldquo;有害信息&rdquo;，直接导致成千上万的无辜网站无法访问，可谓&ldquo;宁可错杀一千，不可放过一个&rdquo;的极端手段。</p>\r\n<p>\r\n	Godaddy是世界第一大域名注册商，Godaddy的域名注册费用是同行业中非常低，平均价格只有国内域名服务的一半，是一个非常不错的域名服务商，例如万网注册 com域名要一年139元，Godaddy最低仅50元。众多网站主都在使用Godaddy的域名服务。中国网络服务商对知名域名注册商的这种非法屏蔽涉嫌不正当竞争。Godaddy全球市场占近32%，加上其他原因被国内屏蔽的，海外有三成以上网站在国内是无法正常访问的。</p>\r\n<p>\r\n	凡是使用GoDaddy提供的域名解析服务器的，都有可能被墙了。好在只是DNS被屏蔽，可以从Godaddy切换到DNSPod，期间host unknown 数分钟。使用国内DNS的方式。</p>\r\n<p>\r\n	另修改本机DNS可正常访问，试试Google dns:8.8.8.8。</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 12:03:38',NULL,'73',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('16','30',NULL,'1','NET Framework 2.0简体中文版',NULL,'<p>\r\n	Microsoft .NET Framework 2.0 版可再发行组件包将安装运行针对 .NET Framework 2.0 版开发的应用程序时所需的 .NET Framework 运行库及相关文件。</p>\r\n<p>\r\n	　　.NET Framework 2.0 版改进了缓存，从而提高了应用程序的可扩展性和性能；使用 ClickOnce 改进了应用程序部署和更新；通过 ASP.NET 2.0 控件和服务对各种浏览器和设备提供更强大的支持。有关 .NET Framework 2.0 的详细信息，请单击此处。重要事项：不能在同一台计算机上安装两种不同语言版本的 .NET Framework。试图安装第二种语言版本的 .NET Framework 时，将会导致出现以下错误：&ldquo;安装程序无法安装 Microsoft .NET Framework，因为已经安装了该产品的其他版本。&rdquo;如果您要使用非英语的平台或要以另一种语言查看 .NET Framework 资源，则必须下载相应语言版本的 .NET Framework 语言包。发布日期： 2008/3/24，语言： 简体中文</p>\r\n','0',NULL,NULL,'http://download.microsoft.com/download/c/6/e/c6e88215-0178-4c6c-b5f3-158ff77b1f38/NetFx20SP2_x86.exe','0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 16:14:31',NULL,'5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('19','24',NULL,'1','AZ86505 PH计 酸碱计',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/a2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:13:32',NULL,'8',NULL,NULL,'500','C001',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('20','24',NULL,'1','AZ8403手持式溶氧仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/a1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:15:25',NULL,'1',NULL,NULL,'298','C002',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('32','26',NULL,'1','AZ8809高精度LED温湿度记录仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/c4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'518','C013',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('33','26',NULL,'1','AZ9801记录印表机',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/c3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,NULL,'188','C014',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('34','26',NULL,'1','AZ87792高精度温湿度计监控仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/c2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'10',NULL,NULL,'268','C015',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('35','26',NULL,'1','AZ88378双通道热电偶温度自动记录',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/c1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'2',NULL,'15','288','C016',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('36','27',NULL,'1','AZ9651便携分体式高精度温湿度记录仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/d4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'228','C017',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('37','27',NULL,'1','记忆式PH酸碱度计AZ-9661',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/d3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'1080','C018',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('38','27',NULL,'1','AZ9861酸碱计记录仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/d2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,'15','98','C019',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('39','27',NULL,'1','AZ9881高精度双热电偶温度记录仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/d1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'5',NULL,NULL,'988','C020',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('40','28',NULL,'1','希玛AS8901手持便携式O2氧气检测仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/e4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'458','C021',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('41','28',NULL,'1','台湾衡欣 AZ7788 二氧化碳检测仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/e3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'788','C022',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('42','28',NULL,'1','希玛AS8902可燃气体数显检测仪报警器',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/e2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,'15','88','C023',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('43','28',NULL,'1','希玛 SMART AS8903 气体检测仪二合一',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/e1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'2',NULL,NULL,'589','C024',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('56','25',NULL,'1','AZ8910数字式多功能风速计风速仪',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/b4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'5',NULL,NULL,'2880','C037',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('57','25',NULL,'1','AZ8905多功能风速计测量湿度',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/b3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'11',NULL,'13','3980','C038',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('58','25',NULL,'1','AZ8912高精度多功能风速风量计',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/b2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'13',NULL,'13','4580','C039',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('59','25',NULL,'1','希玛 AS856手持式高精度数字风速仪风速计',NULL,'<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n<p>\r\n	产品描述信息</p>\r\n','0','/Upload/product/b1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'86',NULL,'13','2000','C040',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('63','32',NULL,'1','对于静电放电问题的解决方案',NULL,'<p>\r\n	对于静电放电问题的解决方案，可按以下十二条规则来进行（按优先顺序排列）<br />\r\n	1.PCB上的非绝缘机壳地线与其他走线相距至少2.2毫米。这适用于连接到机壳地上的所有物体，包括轨线。<br />\r\n	2.机壳地线的长度不应超过其宽度的五倍。<br />\r\n	3.使未绝缘的电路与操作人员可触摸到的PCB区域或未接地的金属物体相隔至少2厘米以上。<br />\r\n	4.电源线与地线要么并排行放在PCB的同一层上，要么放在相邻的两层。<br />\r\n	5.地平面和地线必须连接网络。在任意一个方向上，垂直地线与水平地线至少每隔6厘米连接一次。尤其是双面PCB板，也就是说，PCB板的第一层可以布局水平的地线，而第二层可以布垂直的地线，必须至少每隔6厘米放置一个孔已将两者相连（当然，小于6厘米的地方进行连接是更好的，地平面比地线网格要好一些）<br />\r\n	6.所有信号线必须在地线面边缘或地线以内13毫米以上。地线既可以布在信号线相同的层，也可布在与之紧挨着的层上。如果信号线的长度达到30厘米或其以上，则必须在其旁边放置一根地线，在信号线上方或其相邻面上放置地线也是可以的。<br />\r\n	7.电源线与地线之间跨接的旁路电容器，彼此之间的距离不能大于8厘米（这样每片集成块可能会有多个旁路电容相连）。<br />\r\n	8.相互之间连线较多的元件要靠在一起。<br />\r\n	9.所有元件必须尽可能靠近I/O连接器（注意：首先应满足第3条）。<br />\r\n	10.将PCB的空余部分全部填以地线（应注意每隔6厘米的地方进行连续以产生地线网络）。<br />\r\n	11.如可能的话，将馈送电源线或信号线从PCB板的边缘中心处引出，而不应从某一角上引出来。<br />\r\n	12.对于特别敏感且较长的信号线（30厘米或更长），应每隔一定间隔与其地线对调。<br />\r\n	注意：这些设计规则必须应用到系统内的所有PCB板上（例如主板及插件在上面的板卡）。例如，当应用第2条时，机壳地线长度包括母板与子板所有地线的长度之和。</p>\r\n','0','/Upload/case/4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('64','32',NULL,'1','医疗设备的电磁兼容性分析',NULL,'<p>\r\n	电磁抗扰度传播途径一般也分为两种：即传导耦合方式和辐射耦合方式。任何电磁抗扰度的发生都必然存在抗扰度能量的传输和传输途径（或传输通道）。通常认为电磁抗扰度传输有两种方式：一种是传导传输方式；另一种是辐射传输方式。因此从被抗扰度的敏感器来看，抗扰度耦合可分为传导耦合和辐射耦合两大类。传导传输必须在抗扰度源和敏感器之间有完整的电路连接，抗扰度信号沿着这个连接电路传递到敏感器，发生抗扰度现象。这个传输电路可包括导线，设备的导电构件、供电电源、公共阻抗、接地平板、电阻、电感、电容和互感元件等。　　<br />\r\n	辐射传输是通过介质以电磁波的形式传播，抗扰度能量按电磁场的规律向周围空间发射。常见的辐射耦合由三种：　　<br />\r\n	1. 甲天线发射的电磁波被乙天线意外接受，称为天线对天线耦合；　　<br />\r\n	2. 空间电磁场经导线感应而耦合，称为场对线的耦合；　<br />\r\n	3.两根平行导线之间的高频信号感应，称为线对线的感应耦合。在实际工程中，两个设备之间发生抗扰度通常包含着许多种途径的耦合。正因为多种途径的耦合同时存在，反复交叉耦合，共同产生干扰，才使电磁干扰变得难以控制。　　<br />\r\n	医疗设备在诊断和治疗方面所起的重要作用，使得电磁抗扰度对其的影响直接关系到患者的人身安全，目前医疗设备小型、高灵敏度和智能化的实现，使它们更易受电磁抗扰度的影响，特别是那些抗扰度能力差的（即电磁兼容性差的诊断仪器，为医生提供了失真的数据、波形及图像等信息，使得医生不能做出正确诊断，当然会影响有效的治疗，甚至危及人的生命，国际有许多这方面的报道。　　<br />\r\n	经美国FDA认定的疑为因医疗器械受电磁抗扰度引发的事故；一位心脏起搏器的患者在乘坐救护车急救过程中，因救护人员使用双向无线通讯设备而导致起博失效。病人监护仪受电磁抗扰度影响，致使病人因检测不出心律不齐而死亡。设备的CAT显示器上过度抗扰度，医务人员难以判断心率，致使病人无法复苏。　　<br />\r\n	移动电话对婴儿暖箱、输液泵、人工透析器、心脏起博器、心脏除颤装置产生的抗扰度，因此美国的医院明令禁止在有这类设备的病房使用手机新生儿呼吸监护仪（新生儿呼吸停止而专门设计的报警装置）受调频电台FM发射的抗扰度调制波的影响，扰乱了呼吸节律导致报警失灵。　　<br />\r\n	上面的例子仅谈了外界的电磁抗扰度对医用设备的影响，殊不知现代医疗中使用了各种高频、射频发射机高敏感性电气，电子元件和部件以及使用射频能量作为诊断或治疗的设备或系统（MAI），其工作时可能作为一EMI抗扰度源通过不同的耦合途径向周围传播出不同频率范围和电磁场强度的有用或无用的电磁波，无线电广播通讯业务和周围其它设备的工作，且它们在共同的电磁环境中，还可能受到周围电力、电子设备，以及医疗设备之间抗扰度。所以许多医用设备既是抗扰度源又是敏感设备也就是说它存在抗扰度和被抗扰度两重性，如此以来一个问题值得我们思考，在此复杂的电磁环境下，医疗设备如何达到一个既不受或尽量减少受到其它各种电磁抗扰度的影响，又能尽量减少对其它设备或人体的电磁抗扰度，从而达到一种平衡，电磁兼性就是这样的一个概念。　　<br />\r\n	电磁兼容性（EMC）是指设备或系统在其电磁环境中符合要求运行并不对其环境中的任何设备产生无法忍受的电磁抗扰度的能力。因此，EMC包括两个方面的要求：一方面是指设备在正常运行过程中对所在环境产生的电磁抗扰度不能超过一定的限值；另一方面是指器具对所在环境中存在的电磁抗扰度具有一定程度的抗扰度，即电磁敏感性。　　<br />\r\n	为实现在同一电磁环境中的医疗设备或系统在自身工作正常的情况下，又能达到不妨碍正常的无线电通讯工作，又不抗扰度周围设备的正常工作，就须建立一种规则，既要对设备或系统的抗扰度能力做出规定，即设备的抗扰度水平不能太低，将发射电平和抗扰度电平限制在规定的发射限值和规定的抗扰度限值内，设备就达到了电磁兼容的目的。任何有源的医疗电子设备都会向外辐射电磁场，只不过辐射磁场强大小、频率不同，场强愈强对外界抗扰度愈强。　　<br />\r\n	发射值与抗扰度限值的间隔愈大，则电磁兼容度就愈大，设备的电磁兼容性愈高。所以限制医疗设备的对外发射电平，提高其对电磁环境的抗扰度能力，两者兼顾，才能达到设备与环境的互相协调。　　<br />\r\n	随着医疗设备的电磁兼容问题日益突显，国际上许多国家从法规上采取了措施对医疗设备产品的电磁兼容性进行控制，我国政府也非常重视这个问题，已于2005年4月1日，由国家食品药品监督管理局批准发了：&quot;Y Y05 05-2005医用电气设备电磁兼容性要求和试验&quot;行业标准，经过两年执行过渡期，已于2007年4月1日起正式执行，这就需要我们在医疗实践中贯彻这个行业标准，努力提高医疗设备的电磁兼容性，提升设备的抗扰度能力，将潜在的电磁抗扰度风险降到最低。<br />\r\n	理论和实践的研究表明，不管复杂系统还是简单装置，任何一个电磁抗扰度的发生必须具备三个基本条件：首先应该具有抗扰度源；其次有传播干扰能量的途径和通道；第三还必须有被抗扰度对象的响应。在电磁兼容性理论中把被抗扰度对象统称为敏感设备（或敏感器）。因此抗扰度源、抗扰度传播途径（或传输通道）和敏感设备称为电磁抗扰度三要素。　　　<br />\r\n	总之，医院作为医疗设备的主要使用方，应重视对操作的医护人员、采购、维修人员进行必要的电磁兼容（EMC）知识的学习培训，按照使用现场的电磁环境选购符合EMC要求的产品并正确地按设备使用说明书或技术说明书安装、操作，为了广大公众的健康和安全，应让其能按照设计，不受抗扰度正常运行。</p>\r\n','0','/Upload/case/3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('65','32',NULL,'1','电力仪表的电磁兼容设计与解决手段',NULL,'<p>\r\n	电力行业常用的监控仪表与传统的电参量变送器相比，逐步向智能化、集成化、多功能化方向发展，并且在电磁兼容性能上也有很高的要求（ＥＭＳ和ＥＭＩ试验均有相关要求）。设计者如何选择适当的ＥＭＣ设计方案，对产品设计的成败起到决定性作用。本文就如何进行电力监控仪表的电磁兼容设计进行了综合阐述。　<br />\r\n	标准解读<br />\r\n	１ 判定标准<br />\r\n	结合重工业产品通用标准，电力监控用电力仪表需要满足的ＥＭＳ、ＥＭＩ项目及评判等级见图１.<br />\r\n	２ 标准解读<br />\r\n	干扰通常分为持续干扰和瞬态干扰两类。如广播电台、手机信号、步话机等属于持续干扰。由于开关切换，电机制动等造成电网的波动，此类干扰我们称为瞬态干扰。图１中瞬态干扰包含：浪涌ＳＵＲＧＥ，静电ＥＳＤ，电快速脉冲群ＥＦＴ/Ｂ，电压暂降、短时中断和电压变化ＤＩＰＳ；持续干扰包含：传导敏感度ＣＳ，辐射敏感度ＲＳ。<br />\r\n	评判等级Ａ所述的&ldquo;性能不降低&rdquo;，即干扰施加后，硬件无损害，干扰施加过程中无死机、复位、数据掉帧或误码率较高等问题，好像无干扰施加到产品一样。通常持续性的干扰的评判等级均采用此评判等级。瞬态干扰为偶然性发生，且引起的电网干扰时间不长，故暂时性能降低，也就是评判等级Ｂ.<br />\r\n	３　ＥＭＳ试验项目及干扰实质分析<br />\r\n	（１）浪涌ＳＵＲＧＥ：波形１．２/５０&mu;ｓ、８/２０&mu;ｓ，是一种脉冲宽度为几十个&mu;ｓ的脉冲，是一种传导性干扰，因其脉冲携带较强能量，故需要对所有功能端口做相应程度的防护，否则会引起内部电路元件的永久性硬损伤。<br />\r\n	（２）静电ＥＳＤ：波形上升沿为０．７－１ｎｓ，是一种脉冲宽度为几十个ｎｓ的脉冲，因其峰值电压范围在数千至上万伏，故脉冲也具有一定的能量，须在端口做防护。由于其上升沿很陡，故其携带的高频谐波很丰富，可达５００ＭＨｚ，所以静电在仪表所有裸露的金属部件（包含端子，螺钉等）进行接触放电或孔缝（包含ＬＥＤ指示灯的开孔，各种散热和观察孔）时，或分别对水平耦合板和垂直耦合板间接放电时，均会在放电点瞬时形成一个高频电场，通过空间对电路进行干扰，这种干扰是共模干扰。因此，静电设计时应注意端口保护和空间高频辐射场两方面内容。<br />\r\n	（３）电快速脉冲群ＥＦＴ/Ｂ：波形上升沿为５ｎｓ，波形为数个周期脉冲串的组合，能量很低。干扰的性质和静电一样是共模，干扰路径既包括传导也包含辐射。<br />\r\n	（４）传导敏感度ＣＳ：共模干扰，干扰频段从１５０ＫＨｚ到８０ＭＨｚ。在进行项目试验时，其干扰信号源至仪表的线缆长度与干扰频段（３０ＭＨｚ）对应的波长&lambda;的１/４比拟，故在施加干扰电压的调制频率超过３０ＭＨｚ时，因趋肤效应，干扰信号主要以空间辐射方式出现（低于３０ＭＨｚ时，主要还是以传导方式干扰）。<br />\r\n	（５）辐射敏感度ＲＳ：共模干扰，干扰频段从８０ＭＨｚ到１ＧＨｚ。需注意，外拖的线缆充当接收天线，干扰为电磁场的远场。</p>\r\n','0','/Upload/case/2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('66','32',NULL,'1','PCB板关于静电放电的设计与解决方案',NULL,'<p>\r\n	在PCB板的设计当中，可以通过分层、恰当的布局布线和安装实现PCB的抗ESD设计。通过调整PCB布局布线，能够很好地防范ESD。*尽可能使用多层PCB，相对于双面PCB而言，地平面和电源平面，以及排列紧密的信号线-地线间距能够减小共模阻抗和感性耦合，使之达到双面PCB的1/10到1/100。对于顶层和底层表面都有元器件、具有很短连接线。<br />\r\n	来自人体、环境甚至电子设备内部的静电对于精密的半导体芯片会造成各种损伤，例如穿透元器件内部薄的绝缘层；损毁MOSFET和CMOS元器件的栅极；CMOS器件中的触发器锁死；短路反偏的PN结；短路正向偏置的PN结；熔化有源器件内部的焊接线或铝线。为了消除静电释放(ESD)对电子设备的干扰和破坏，需要采取多种技术手段进行防范。<br />\r\n	在PCB板的设计当中，可以通过分层、恰当的布局布线和安装实现PCB的抗ESD设计。在设计过程中，通过预测可以将绝大多数设计修改仅限于增减元器件。通过调整PCB布局布线，能够很好地防范ESD。以下是一些常见的防范措施。<br />\r\n	*尽可能使用多层PCB，相对于双面PCB而言，地平面和电源平面，以及排列紧密的信号线-地线间距能够减小共模阻抗和感性耦合，使之达到双面PCB的1/10到1/100。尽量地将每一个信号层都紧靠一个电源层或地线层。对于顶层和底层表面都有元器件、具有很短连接线以及许多填充地的高密度PCB，可以考虑使用内层线。<br />\r\n	*对于双面PCB来说，要采用紧密交织的电源和地栅格。电源线紧靠地线，在垂直和水平线或填充区之间，要尽可能多地连接。一面的栅格尺寸小于等于60mm，如果可能，栅格尺寸应小于13mm。<br />\r\n	*确保每一个电路尽可能紧凑。<br />\r\n	*尽可能将所有连接器都放在一边。<br />\r\n	*如果可能，将电源线从卡的中央引入，并远离容易直接遭受ESD影响的区域。</p>\r\n','0','/Upload/case/1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'81',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('67','33',NULL,'1','网站发布的公告标题1111',NULL,'<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 21:05:22',NULL,'6',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('68','33',NULL,'1','网站发布的公告标题2222',NULL,'<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 21:05:22',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('69','33',NULL,'1','网站发布的公告标题3333',NULL,'<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 21:05:22',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('70','33',NULL,'1','网站发布的公告标题4444',NULL,'<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 21:05:22',NULL,'8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('71','33',NULL,'1','网站发布的公告标题5555',NULL,'<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 21:05:22',NULL,'28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('124','51',NULL,'1','NET Framework 2.0 simplified chinese version ',NULL,'<p>\r\n	.NET Framework runtime application needs Microsoft.NET Framework version 2 redistributable package will be installed to run on.NET Framework 2 version of the development and the related documents..NET Framework version 2 improves the cache, thereby improving the scalability of applications and performance; the use of ClickOnce improved the application deployment and update; 2 through ASP.NET controls and services provided for browsers and devices more powerful support. For more information about.NET Framework 2, please click here. Important: do not install two different language version of.NET Framework on the same computer. To install.NET Framework second language versions, will lead to the following error occurred: &quot;setup was unable to install the Microsoft.NET Framework, because the other version of the product is already installed.&quot; If you want to use a non - English platform or to view the.NET Framework resource in another language, you must download the appropriate language version of the.NET Framework language pack. Release date: 2008/3/24, languages: Simplified Chinese</p>\r\n','0',NULL,NULL,'http://download.microsoft.com/download/c/6/e/c6e88215-0178-4c6c-b5f3-158ff77b1f38/NetFx20SP2_x86.exe','0','0',NULL,NULL,NULL,NULL,'3','2013-03-27 20:12:52',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('128','41',NULL,'1','Warmest congratulations on enterprise website management system 3 release',NULL,'<p>\r\n	Warmest congratulations on enterprise website management system 3 release</p>\r\n<p>\r\n	The new added feature phone website, domain name, website optimization.<br />\r\n	The friends of the enterprise website management system using PHP+MySQL development, it has the advantages of simple operation, powerful function, good stability, easy expansion, high safety, convenient maintenance, can help you quickly, easy to build up a strong professional business website. System support for mobile phone website, language, custom model, SEO optimization, static page generation, comment, ordering, membership, advertising, recruitment, statistics, self-help form and other basic functions of common enterprise website, through can plug-in mechanism flexibility to expand more applications. By virtue of the company team accumulated rich experience in Web development and innovation in the pursuit of the perfect design concept, the product is supported by many enterprises, and has been used in more and more large and medium-sized commercial website.</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'3','2013-03-27 20:30:38',NULL,'5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('129','41',NULL,'1','Warmest congratulations on  blog system 6.3 release',NULL,'<p>\r\n	<span class=\"highlight\" leftzone=\"0|12\" rightzone=\"0|12\" space=\"\">Warmest congratulations on blog system 6.3 release</span></p>\r\n<p>\r\n<span leftzone=\"58|12\" rightzone=\"6|12\" space=\"0| \">&nbsp;blog&nbsp;system</span><span leftzone=\"103|12\" rightzone=\"51|12\" space=\"0| \"> of building</span><span leftzone=\"115|6\" rightzone=\"63|6\" space=\"0| \"> software</span><span leftzone=\"121|3\" rightzone=\"69|3\" space=\"\">,</span><span leftzone=\"124|6\" rightzone=\"72|6\" space=\"0| \"> search</span><span leftzone=\"130|12\" rightzone=\"78|12\" space=\"0| \"> engine optimization</span><span leftzone=\"142|1\" rightzone=\"90|1\" space=\"0| \"> (</span><span leftzone=\"143|3\" rightzone=\"91|3\" space=\"0| \">SEO</span><span leftzone=\"146|1\" rightzone=\"94|1\" space=\"0| \">)</span><span leftzone=\"147|12\" rightzone=\"95|12\" space=\"0| \"> tool of choice</span><span leftzone=\"159|3\" rightzone=\"107|3\" space=\"\">.</span><span leftzone=\"162|12\" rightzone=\"110|12\" space=\"0| \"> Support smart</span><span leftzone=\"174|12\" rightzone=\"122|12\" space=\"0| \"> account registration</span><span leftzone=\"186|3\" rightzone=\"134|3\" space=\"\">,</span><span leftzone=\"189|12\" rightzone=\"137|12\" space=\"0| \"> article management</span><span leftzone=\"201|3\" rightzone=\"149|3\" space=\"\">,</span><span leftzone=\"204|6\" rightzone=\"152|6\" space=\"0| \"> publishing</span><span leftzone=\"210|6\" rightzone=\"158|6\" space=\"0| \"> history</span><span leftzone=\"216|3\" rightzone=\"164|3\" space=\"\">,</span><span leftzone=\"219|9\" rightzone=\"167|9\" space=\"0| \"> pseudo original</span><span leftzone=\"228|3\" rightzone=\"176|3\" space=\"\">,</span><span leftzone=\"231|9\" rightzone=\"179|9\" space=\"0| \"> automatic</span><span leftzone=\"240|6\" rightzone=\"188|6\" space=\"0| \"> release</span><span leftzone=\"246|3\" rightzone=\"194|3\" space=\"\">,</span><span leftzone=\"249|15\" rightzone=\"197|15\" space=\"0| \"> custom web site</span><span leftzone=\"264|3\" rightzone=\"212|3\" space=\"\">,</span><span leftzone=\"267|6\" rightzone=\"215|6\" space=\"0| \"> a variety of</span><span leftzone=\"273|12\" rightzone=\"221|12\" space=\"0| \"> ways to release</span><span leftzone=\"285|3\" rightzone=\"233|3\" space=\"1|&#13;&#10;\">.</span></p>\r\n<p>\r\n	<span leftzone=\"292|9\" rightzone=\"0|9\" space=\"\">There are</span><span leftzone=\"301|12\" rightzone=\"9|12\" space=\"0| \"> some functions</span><span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\">:</span></p>\r\n<p>\r\n	&nbsp;</p>\r\n<table border=\"0\" cellpadding=\"0\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"width: 38px\">\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image001.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><span class=\"highlight\" leftzone=\"0|6\" rightzone=\"0|6\" space=\"\">Intelligent</span><span leftzone=\"6|12\" rightzone=\"6|12\" space=\"0| \"> account registration</span><span leftzone=\"18|3\" rightzone=\"18|3\" space=\"\">:</span><span leftzone=\"21|9\" rightzone=\"21|9\" space=\"0| \"> only need to</span><span leftzone=\"30|15\" rightzone=\"30|15\" space=\"0| \"> enter the code</span><span leftzone=\"45|12\" rightzone=\"45|12\" space=\"0| \"> can continue to</span><span leftzone=\"57|12\" rightzone=\"57|12\" space=\"0| \"> register an account</span><span leftzone=\"69|1\" rightzone=\"69|1\" space=\"0| \"> (</span><span leftzone=\"70|12\" rightzone=\"70|12\" space=\"0| \">similar products</span><span leftzone=\"82|12\" rightzone=\"82|12\" space=\"0| \"> almost all</span><span leftzone=\"94|9\" rightzone=\"94|9\" space=\"0| \"> to open the</span><span leftzone=\"103|6\" rightzone=\"103|6\" space=\"0| \"> webpage</span><span leftzone=\"109|1\" rightzone=\"109|1\" space=\"0| \">)</span></span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image003.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><span class=\"highlight\" leftzone=\"9|6\" rightzone=\"9|6\" space=\"\">Account</span><span leftzone=\"0|6\" rightzone=\"0|6\" space=\"0| \"> management</span><span leftzone=\"6|3\" rightzone=\"6|3\" space=\"\">:</span><span leftzone=\"22|6\" rightzone=\"22|6\" space=\"0| \"> account</span><span leftzone=\"28|9\" rightzone=\"28|9\" space=\"0| \"> grouping</span><span leftzone=\"37|12\" rightzone=\"37|12\" space=\"0| \"> web site management</span><span leftzone=\"49|9\" rightzone=\"49|9\" space=\"0| \"> and display</span><span leftzone=\"58|3\" rightzone=\"58|3\" space=\"\">,</span><span leftzone=\"61|6\" rightzone=\"61|6\" space=\"0| \"> universal</span><span leftzone=\"67|12\" rightzone=\"67|12\" space=\"0| \"> import and export</span><span leftzone=\"79|3\" rightzone=\"79|3\" space=\"\">,</span><span leftzone=\"82|11\" rightzone=\"82|11\" space=\"0| \"> automatic IE</span><span leftzone=\"93|6\" rightzone=\"93|6\" space=\"0| \"> login</span></span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image005.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><span class=\"highlight\" leftzone=\"0|12\" rightzone=\"0|12\" space=\"\">Simple article</span><span leftzone=\"12|6\" rightzone=\"12|6\" space=\"0| \"> management</span><span leftzone=\"18|3\" rightzone=\"18|3\" space=\"\">:</span><span leftzone=\"45|12\" rightzone=\"45|12\" space=\"0| \"> fool</span><span leftzone=\"21|6\" rightzone=\"21|6\" space=\"0| \"> acquisition method</span><span leftzone=\"27|6\" rightzone=\"27|6\" space=\"\">,</span><span leftzone=\"33|12\" rightzone=\"33|12\" space=\"0| \"> various forms of</span><span leftzone=\"60|6\" rightzone=\"60|6\" space=\"0| \"> other</span><span leftzone=\"66|6\" rightzone=\"66|6\" space=\"0| \"> mass</span><span leftzone=\"72|1\" rightzone=\"72|1\" space=\"0| \"> (</span><span leftzone=\"73|6\" rightzone=\"73|6\" space=\"0| \">acquisition</span><span leftzone=\"79|1\" rightzone=\"79|1\" space=\"0| \">)</span><span leftzone=\"80|6\" rightzone=\"80|6\" space=\"0| \"> software</span><span leftzone=\"86|6\" rightzone=\"86|6\" space=\"0| \"> the</span><span leftzone=\"92|12\" rightzone=\"92|12\" space=\"0| \"> data import</span></span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image007.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\">Convenient and flexible pseudo-original: pseudo original function rules of preservation, convenient access, advanced keyword management page</span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image009.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\">Automatic release: send the article completely unattended, need artificial auxiliary will give tips (automatic processing after the timeout)</span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image011.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><span class=\"highlight\" leftzone=\"0|6\" rightzone=\"0|6\" space=\"\">A variety of</span><span leftzone=\"6|12\" rightzone=\"6|12\" space=\"0| \"> ways to release</span><span leftzone=\"18|3\" rightzone=\"18|3\" space=\"\">:</span><span leftzone=\"21|21\" rightzone=\"21|21\" space=\"0| \"> the article</span><span leftzone=\"42|6\" rightzone=\"42|6\" space=\"0| \"> sent to</span><span leftzone=\"48|6\" rightzone=\"48|6\" space=\"0| \"> all</span><span leftzone=\"54|15\" rightzone=\"54|15\" space=\"0| \"> account can also be</span><span leftzone=\"69|6\" rightzone=\"69|6\" space=\"0| \"> sent to the</span><span leftzone=\"75|6\" rightzone=\"75|6\" space=\"0| \"> random</span><span leftzone=\"81|6\" rightzone=\"81|6\" space=\"0| \"> account</span><span leftzone=\"87|6\" rightzone=\"87|6\" space=\"0| \"> etc.</span><span leftzone=\"93|3\" rightzone=\"93|3\" space=\"\">.</span><span leftzone=\"96|3\" rightzone=\"96|3\" space=\"\">.</span><span leftzone=\"99|3\" rightzone=\"99|3\" space=\"\">.</span></span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image013.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><span class=\"highlight\" leftzone=\"0|15\" rightzone=\"0|15\" space=\"\">A custom web site</span><span leftzone=\"15|3\" rightzone=\"15|3\" space=\"\">:</span><span leftzone=\"18|18\" rightzone=\"18|18\" space=\"0| \"> to support a variety of mainstream</span><span leftzone=\"36|12\" rightzone=\"36|12\" space=\"0| \"> site program</span><span leftzone=\"48|15\" rightzone=\"48|15\" space=\"0| \"> backstage release</span><span leftzone=\"63|3\" rightzone=\"63|3\" space=\"\">,</span><span leftzone=\"66|6\" rightzone=\"66|6\" space=\"0| \"> convenient</span><span leftzone=\"72|3\" rightzone=\"72|3\" space=\"0| \"> to</span><span leftzone=\"75|12\" rightzone=\"75|12\" space=\"0| \"> your website</span><span leftzone=\"87|9\" rightzone=\"87|9\" space=\"0| \"> and blog</span><span leftzone=\"96|9\" rightzone=\"96|9\" space=\"0| \"> integration</span><span leftzone=\"105|3\" rightzone=\"105|3\" space=\"\">.</span></span></span></p>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\"><img src=\"/Upload/product/clip_image015.png\" /></span></span></p>\r\n			</td>\r\n			<td>\r\n				<p align=\"left\">\r\n					<span leftzone=\"313|3\" rightzone=\"21|3\" space=\"1|&#13;&#10;\"><span style=\"widows: 2; text-transform: none; text-indent: 25px; display: inline !important; font: 12px/21px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(102,102,102); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px\">History: History sent send grouped into account, the convenience of your group call, a set of software to manage multiple promotion plan.</span></span></p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'4','2013-03-27 20:33:56',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('130','41',NULL,'1','High Xingjiebi finished Website Package officially is launched',NULL,'<p>\r\n	The finished website is the subdivision of all walks of life on the website, by professional personnel of careful planning, design and production, a large number of ready-made site, site classification in supermarket display and packaged for sale, the user can be finished web site to install their own hosting space. Design style, each finished the section of the web site layout planning, test contents are referring to the industry&#39;s actual site requirements and case to make, so that final demand closer to industrial users. Each a product websites offer online demo and trial experience, let users fully understand the design and functions of the website. WYSIWYG web, fast, convenient maintenance, high ratio of performance to price...</p>\r\n','0','/Upload/news/5en.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'5','2013-03-27 20:39:02',NULL,'5',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('132','42',NULL,'1','Qihoo 360 and Google search cooperation agreement reached',NULL,'<p>\r\n	Netease science and technology news on January 4th message, according to foreign media reports, before the news Qihoo 360 and Google is expected to reach a search deal, may have on the Chinese search giant Baidu threat, but Qihoo has to ZDNet officially confirmed the news, said that the agreement with the Google does exist, but declined to give further details.<br />\r\n	Bloomberg news earlier this week quoted the analysis of investment firm WedgePartners said, Qihoo and Google will collaborate in early 2013. Qihoo chief executive Zhou Hongyi said before, Qihoo to Google, Microsoft, Sogou search engine service companies have cooperation.<br />\r\n	After the United States independent analyst ABR InvestmentStrategy also reported the upcoming Qihoo and Google cooperation. ABR said: &quot;given the Qihoo and Google expected cooperation, we will search revenue in fiscal year 2013 is expected to increase to $90000000 from $62000000.&quot;<br />\r\n	When ZDNet Asia linked to Qihoo aspects of the interview, Qihoo said: &quot;between Qihoo can only confirm and Google cooperation does exist, but can not disclose any details of the information.&quot;<br />\r\n	Citibank analyst Lee Act (Lee, Muzhi) to (RaviSarathy), and Ravi Saladi said, Qihoo and Google cooperation is bad news for Baidu is concerned. They reaffirmed Baidu sell rating, said this is because cooperation Qihoo search monetization and service and Google keyword.<br />\r\n	If everything goes smoothly, Qihoo on Google cooperation for the first time. Qihoo has in their browsers before using Google search service, now it has been replaced by its own search service.<br />\r\n	Qihoo has established itself in the field of software safety, the company has operations will be extended to other Internet services, such as browsers and search engine service. (West)</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:45:56',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('133','42',NULL,'1','wanwang alleged breach of security can lead to register a domain name malicious hijacking',NULL,'<p>\r\n	Dispatch of sina science and technology on January 4th afternoon message, security issues feedback platform clouds (wooyun.org) today through the micro-blog said in a news release, network security vulnerabilities can lead to register a domain name hijacking is malicious.<br />\r\n	Wu Yun said in the micro-blog, &quot;the network be proof of the existence of security vulnerabilities, can be hijacked in the network domain name registration malicious users, completely repair loopholes in the nets suggest you Adsense and enterprises to increase monitoring of domain name&quot;.<br />\r\n	In fact, the clouds are victims of this vulnerability. According to the micro-blog has revealed, this vulnerability to the attack, &quot;and a long time cannot access and creates the actual loss of interest&quot;. The official further said, as network users will retain the right to prosecute.<br />\r\n	In this regard, the lawyer Zhao Zhanling pointed out: if its loopholes instead of the user causes the domain name hijacking, 10 thousand nets should ask users to compensate for the losses. Otherwise, the user can through legal channels for all responsibility.<br />\r\n	To date, all did not respond.</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:45:56',NULL,'5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('134','42',NULL,'1','360 search engine http://so.360.cn is on line',NULL,'<p>\r\n	The previous day legend tiger 360 to push its own search engine, today, 360 of the search engine quietly on the line, some in the industry have been hearsay and start trial. 360 search enable domain so.360.cn two.<br />\r\n	At present, 360 search interface is also very simple, subscript red below to design similar to &quot;Youdao search&quot;. In addition, in addition to webpage search by 360 search provides search results, news search, MP3 search, image search, map search, ask search are directly linked to the corresponding classification of Baidu search, video search link to 360 of the original &quot;360 video search&quot;.<br />\r\n	In view of the line just 360 possible search, search technology and experience is still not perfect, so the 360 search is still retained the Baidu and Google search, the two search are integrated into the 360 search page, if the user feel dissatisfied with 360 search results, can be directly click switch to Baidu search or Google search.<br />\r\n	From the micro-blog everyone to the 360 search engine test results, the 360 search may go is route Blekko (personal speculation), is also the only index authority sites to ensure that the garbage station authority and removing search results.<br />\r\n	In August 10th, Cheng Lingfeng said in the micro-blog:<br />\r\n	I heard that the general search 360 is about to launch its own domain name. Was supposed to launch the browser information recommendation based on, but not mature. Also heard on other search engine results in the &quot;illegal&quot; content or ads to remind users tagging.<br />\r\n	At present, it said non-trivial, according to another Fenng in the micro-blog sources:<br />\r\n	More hearsay about 360 search: everyone knows the address, now in the first test of water, its search results is not good enough, may and Bing do first cooperation. Real maturity in his own. 360 the stock price to rise.<br />\r\n	In the afternoon there will be a small noisy can see: Sogou CEO Wang Xiaochuan said in the micro-blog:<br />\r\n	By three stage rocket model, the 360 finally released universal search. Internet users have more choice is a good thing. But the search technology need long time of accumulation, we have to worry about the poor quality of the use of improper means to hurt the user. I&#39;d heard the development process there are some extreme means to go beyond the bottom line &quot;&quot;. Sogou search team will make a general evaluation on the 360 search quality, afternoon for everyone to send report.<br />\r\n	At present the 360 official and Zhou Hongyi have not been disclosed more information.</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:45:56',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('135','42',NULL,'1','What reasons cause the broken network data center?',NULL,'<p>\r\n	One way of Thai embarrassed embarrassed at the end of 2012 under the bed to the Chinese film box office record, but also refresh the record. But in IT, data center security failure events erupt frequently, also the impact of enterprise user&#39;s psychological line of defense in a meeting. Only look, the security problems of the data center, don&#39;t be embarrassed again. &quot;Tai embarrassed&quot;.<br />\r\n	Cloud computing service is touted to be the IT saints in this era, all services can be &quot;cloud&quot;. However, when many companies to be the first to eat crab, but found that often the most vulnerable is their. In recent years, emerge in an endless stream of cloud services broken network events, so that the industry could appall.</p>\r\n<p>\r\n	&nbsp;<img alt=\"\" src=\"/Upload/news/135I5001YE50-23296%5B1%5D.jpg\" style=\"width: 350px; height: 253px\" /></p>\r\n<p>\r\n	People gradually return to the ideal, to more clearly see the true face of cloud computing. It can be said, no matter how lofty dream or to find a secure foothold, cloud services eventually from one data center to be transmitted to a data center, and in the process still could not escape the need, computer, network, power, storage, etc. between collaborative work. As a result, the entire process error and loopholes in the offing, coupled with natural disasters. So, enabled cloud services, you must have a certain amount of mental preparation, but also with a second-hand solutions to deal with.</p>\r\n<p>\r\n	Editor here, look at the reasons behind a series of broken network events that occurred in recent years. Between from 2009 to 2012. Perhaps make you see: even if the computer error seems inevitable, reinsurance measures seem only security event control in a small probability range.</p>\r\n<p>\r\n	The off network types: system failure</p>\r\n<p>\r\n	Typical event 1: Amazon AWS Christmas Eve off network</p>\r\n<p>\r\n	The cause of the malfunction: Elastic Load Balancing service failure</p>\r\n<p>\r\n	December 24, 2012, Christmas Eve just past, Amazon did not let their customers have had peace. Amazon the AWS located in the eastern United States data center fails, the Elastic Load Balancing service (Elastic Load Balancing Service) interrupt, sites such as Netflix and Heroku affected. Which, Heroku in the AWS eastern United States regional service before failure has also been influenced. However, some coincidence Netflix rival Amazon&#39;s own Amazon Prime Instant Video is not affected because of this failure.</p>\r\n<p>\r\n	December 24, Amazon AWS interrupt service event is not the first time, of course, will not be the last time.</p>\r\n<p>\r\n	October 22, 2012, Amazon AWS network services in Northern Virginia interruption. The reason is similar to the last. The effects of the accident including Reddit, Pinterest and other well-known websites. Interrupt affect the elasticity of magic beans, followed by flexible magic beans console, relational database services, flexible cache, Elastic Compute Cloud EC2, cloud search. This accident made a lot of people believe that Amazon should to upgrade North Pooh the Ghia data center infrastructure.</p>\r\n<p>\r\n	April 22, 2011, a large area of ​​the Amazon cloud data center server downtime, this event is considered to Amazon the most serious in the history of cloud computing security event. Amazon downtime cloud computing center in Northern Virginia, including answer service Quora, the news service Reddit, Hootsuite and location tracking service FourSquare, some sites have been affected. Amazon&#39;s official report claims that the incident is due to the presence of its EC2 system design vulnerabilities and design flaws, to improve the EC2 (the Amazon ElasticComputeCloud service), competitive and continue to fix known vulnerabilities and defects.</p>\r\n<p>\r\n	In January 2010, almost 60,008 thousand Salesforce.com users experienced at least one hour of downtime. Salesforce.com &quot;systematic errors&quot; due to their own data center, all services, including backup, including a brief paralysis. It also exposed the Salesforce.com do not want to open the lock strategy: its PaaS platform, Force.com Salesforce.com outside the. Once Salesforce.com problems, Force.com the same problems. Interrupt service occurred a long time, the problem will become very tricky.</p>\r\n<p>\r\n	The broken network inducement: natural disasters</p>\r\n<p>\r\n	Typical event: Amazon Northern Ireland Berlin data center downtime</p>\r\n<p>\r\n	The fault reasons: lightning struck a transformer of the data center in Berlin</p>\r\n<p>\r\n	August 6, 2011, caused by lightning in Northern Ireland, Dublin Amazon and Microsoft cloud computing network in Europe, large-scale data center power outage downtime. The lightning struck a transformer near Dublin data center, leading to its explosion. The explosion triggered a fire, so that the work of all public service agencies to temporarily halt the entire data center downtime.</p>\r\n<p>\r\n	This data center is the Amazon, only for data storage and in Europe, that is, EC2 cloud computing platform customers during the accident no other data center for temporary use. Downtime event makes the length of the Amazon EC2 cloud service platform many websites to interrupt a long time up to two days.</p>\r\n<p>\r\n	Typical event: Calgary data center fire accident</p>\r\n<p>\r\n	Failure reasons: data center fire</p>\r\n<p>\r\n	Calgary data center fire accident July 11, 2012: Canadian communications service providers ShawCommunicationsInc in Calgary the A Er Bota&#39;s data center, a fire occurred, resulting in hundreds of local hospital surgical delay. Manage the data center to provide emergency services, the fire affected the the main backup systems to support critical public services. The event as a series of government agencies sounded the alarm, you must ensure the timely recovery and have failover system, combined with the introduction of disaster management plans.</p>\r\n<p>\r\n	Typical event: Hurricane Sandy attacks data center</p>\r\n<p>\r\n	The cause of the malfunction: storms and floods led to the data center to stop running</p>\r\n<p>\r\n	October 29, 2012, super hurricane Sandy: data center in New York and New Jersey are subject to the impact of the hurricane, including the adverse impact for the Lower Manhattan area flooding and the shutdown of some facilities, the surrounding area data center generators run disorders. Impact in hurricane Sandy and beyond the general single disruptions brought disaster of unprecedented scale in the data center industry in the affected areas. In fact, the diesel has become the lifeblood of the data center recovery, to take over the entire load as a backup power system, prompting the special measures to keep the generator fuel. With the immediate focus gradually shifted to the post-disaster reconstruction, we need long-term engineering and disaster recovery data center location, explore this topic may last for months, or even years.</p>\r\n<p>\r\n	The off net incentive III: human factors</p>\r\n<p>\r\n	Typical event 1: Hosting.com service disruptions</p>\r\n<p>\r\n	The cause of the malfunction: the service provider implementation of the circuit breaker operating sequence is incorrect due to UPS Close</p>\r\n<p>\r\n	July 28, 2012 the Hosting.com outage event: human error is often considered one of the dominant factors in the data center downtime. July the Hosting.com interrupt events caused the 1100 Customer Service interruption is an example. Shutdown accident is being carried out due to the company&#39;s data center in Newark, Delaware, UPS systems preventive maintenance, service provider implementation of the circuit breaker operating sequence is not correct to cause the UPS shut down is caused by the data center suites facilities the loss of one of the key factors. &quot;CEO of ArtZeile Hosting.com. &quot;There is no failure of any important power system or standby power systems, is entirely caused by a human error.&quot;</p>\r\n<p>\r\n	Typical event: Microsoft outbreak of the BPOS service interruptions event</p>\r\n<p>\r\n	The cause of the malfunction: Microsoft data centers in the United States, Europe and Asia, a determined set error</p>\r\n<p>\r\n	In September 2010, Microsoft hosting services at least three times in the western United States within a few weeks time interrupt event to apologize to the user. This is Microsoft&#39;s first major cloud computing events broke.</p>\r\n<p>\r\n	The accident, the user access BPOS (Business Productivity Online Suite) service, if you use Microsoft&#39;s North American facilities access service customers may encounter a problem, this failure lasted two hours. Although Microsoft engineers later claimed to have solved the problem, but did not solve the fundamental problem, which is also produced September 3 and September 7 service interrupted again.</p>\r\n<p>\r\n	Microsoft&#39;s Clint Patterson said this data breaches are caused by errors due to Microsoft data centers in the United States, Europe and Asia, a determined set. BPOS software in the offline address book in the &quot;very special circumstances&quot; available to unauthorized users. The address book contains the contact information.</p>\r\n<p>\r\n	Microsoft said that this error fixed two hours after the discovery. Microsoft said it has tracking facilities, to enable it to get in touch with people who download these data errors in order to clear these data.</p>\r\n<p>\r\n	Off network incentives: system failure</p>\r\n<p>\r\n	Typical event 1: GoDaddy the website DNS server interrupt</p>\r\n<p>\r\n	The fault reasons: data table within a series of routers in the system caused by network outages</p>\r\n<p>\r\n	The GoDaddy website DNS server interrupts: September 10, 2012 the domain name giant GoDaddy DNS server is one of the most important suppliers, which has 5,000,000 websites and manages over 50 million domain names. This is why the disruptions will be the most devastating event in 2012 on September 10.</p>\r\n<p>\r\n	Some speculation even to the interrupt events for up to six hours is the result of denial of service attacks, but GoDaddy later said, this router table corrupted data. Service interruption is not caused by external influences. &quot;GoDaddy interim CEO 史葛瓦格纳 said. &quot;This is not a hacker attack is not a denial of service attack (DDoS) We have determined that the service interruption is due to damage to the network event caused by the series of routers internal data table.&quot;</p>\r\n<p>\r\n	Typical event: Shengda Yun stored off network</p>\r\n<p>\r\n	The fault reasons: data center physical server disk is damaged</p>\r\n<p>\r\n	August 6, 2012 8:10 pm Shengda Yun due to cloud host failure caused by the loss of user data events public statement published on its official microblogging. The statement said: August 6, Shengda Yun data center in Wuxi, because a single physical server disk is damaged, resulting in the loss of individual users&#39; data. Shengda Yun has to make every effort to assist the user to recover data.</p>\r\n<p>\r\n	Lead to individual users&#39; data lost because of a physical server disk is damaged, Shengda Yun technicians are given their own interpretation: the virtual machine&#39;s disk, there are two modes of production, a direct host the physical disk. This case, if the host&#39;s physical disk fails, the cloud host will inevitably result in the loss of data, which is generated by the incident reasons; another is to use remote storage is grand hard disk products, this way the actual is to save the user&#39;s data to a remote cluster, and at the same time do multiple backups, and even host a failure will not affect a the Cloud host of data. Difficult to avoid because the physical damage to the machine, in order to avoid accidental loss you are experiencing, we recommend that you also do data backup to cloud host.</p>\r\n<p>\r\n	Typical events 3: Google App Engine interrupt service</p>\r\n<p>\r\n	The cause of the malfunction: network delay</p>\r\n<p>\r\n	Google App Engine: GAE WEB application development and hosting platform, data center management by google interrupt time is October 26th, and lasted 4 hours, because suddenly become slow to respond, and an error. Affected, 50% of the GAE request fails.</p>\r\n<p>\r\n	Google said that there is no loss of data, application behavior also have backup can be restored. Apologize, google announced Nov. user can google said they are strengthening their network services to cope with the problems of network delay, &quot;We have enhanced the flow routing capabilities, and to adjust the configuration, these will effectively prevent such problems from happening again.</p>\r\n<p>\r\n	The off net incentive Five: System Bug</p>\r\n<p>\r\n	Typical Event 1: Azure global interrupt service</p>\r\n<p>\r\n	The cause of the accident: Software Bug calculated incorrectly result in a leap year time</p>\r\n<p>\r\n	February 28, 2012, due to the leap year bug &quot;causing Microsoft Azure service a large area on a global scale to interrupt, the interrupt time over 24 hours. Although Microsoft said the software bug is incorrect leap year calculation of time lead, but the incident provoked a strong reaction in many users, many people asked Microsoft to make more reasonable explanation for this purpose.</p>\r\n<p>\r\n	The typical event 2: Gmail e-mail the outbreak of a global failure</p>\r\n<p>\r\n	The cause of the accident: data center routine maintenance, the side effects of the new code</p>\r\n<p>\r\n	February 24, 2009, Google&#39;s Gmail e-mail to the outbreak of the global failure service interrupted time up to 4 hours. Google explained the cause of the accident: when routine maintenance of the data center in Europe, some of the new program code (trying to geographical proximity data focus on all of the body) some side effects, leading to another data center in Europe to overload, so The knock-on effect on the expansion and interface to other data centers, and ultimately lead to the disconnection of the global and other data center does not work.</p>\r\n<p>\r\n	Typical event: &quot;5.19 off network events</p>\r\n<p>\r\n	The cause of the accident: the client-side software Bug, internet terminals frequent DNS requests, triggering DNS congestion</p>\r\n<p>\r\n	May 19, 2009, 21:50, Jiangsu, Anhui, Guangxi, Hainan, Gansu, Zhejiang and other six provinces user declaration to access the site slow or inaccessible. Unit investigating after the Ministry of Communications, said the national six provinces network disruptions, because a company launched the client software defects, resulting in the installation of the software of the Internet, in the case of abnormal work of the company&#39;s domain name authorization server terminal frequently initiate DNS request triggered DNS congestion, resulting in a large number of users access the site slow or page can not open.</p>\r\n<p>\r\n	Which the, DN SPod is the leading DNS service provider one N SPod company service DNS service for a number of well-known websites. The attack resulted in paralysis the 6 units dns the DN SPod belongs DNS server, a direct result of the DNS system paralyzed STORM, including a number of network service providers, and thereby lead to network congestion, resulting in a large number of users can not be normal Internet. The Ministry of Industry and pointed out that this incident exposed the Domain Name Service to become the weak link in network security, instructed all units to strengthen the security of the Domain Name Service.</p>\r\n<p>\r\n	Summary</p>\r\n<p>\r\n	Enable cloud services company, a large extent, is considering such a service can be more editing, cost-effective. However, such considerations if it is based on reducing the cost of security as, it is estimated that the boss will not agree with a lot of companies. Cloud services off the endless stream of events caused by concerns about the safety of the cloud.</p>\r\n<p>\r\n	Now, the solution can proceed from several angles, sure cloud services for enterprise-class customers, regular backups of the data of the cloud, with the second set of solutions, in order to prepare for contingencies. For cloud service providers, since a variety of off-network event is inevitable, it must consider a countermeasure to minimize the loss of their users, improve response efficiency off network events.</p>\r\n<p>\r\n	Government departments have responsibilities of oversight and remind legal legal cloud services were introduced and constantly improve, and to remind the user to one hundred percent reliable cloud computing services do not currently exist.<br />\r\n	&nbsp;</p>\r\n','0','/Upload/news/4en.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:45:56',NULL,'3',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('136','42',NULL,'1','The trade rumors that Baidu will accelerate mergers and acquisitions UCweb',NULL,'<p>\r\n	<span closure_uid_503514901=\"213\" wd=\"null\">Sohu IT</span><span closure_uid_503514901=\"214\" wd=\"null\">, said</span> <span class=\"hps\" closure_uid_503514901=\"215\" wd=\"null\">sources</span> <span class=\"hps\" closure_uid_503514901=\"216\" wd=\"null\">from</span> <span class=\"hps\" closure_uid_503514901=\"217\" wd=\"null\">the investment community</span><span closure_uid_503514901=\"218\" wd=\"null\">, Baidu</span> <span class=\"hps\" closure_uid_503514901=\"219\" wd=\"null\">is accelerating</span> <span class=\"hps\" closure_uid_503514901=\"220\" wd=\"null\">capital</span> <span class=\"hps\" closure_uid_503514901=\"221\" wd=\"null\">negotiations</span> <span class=\"hps\" closure_uid_503514901=\"222\" wd=\"null\">with</span> <span class=\"hps\" closure_uid_503514901=\"223\" wd=\"null\">gifted as</span> <span class=\"hps\" closure_uid_503514901=\"224\" wd=\"null\">(UCweb)</span><span closure_uid_503514901=\"225\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"226\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"227\" wd=\"null\">controlling</span> <span class=\"hps\" closure_uid_503514901=\"228\" wd=\"null\">or</span> <span class=\"hps\" closure_uid_503514901=\"229\" wd=\"null\">strategic investment</span> <span class=\"hps\" closure_uid_503514901=\"230\" wd=\"null\">UCweb</span><span closure_uid_503514901=\"231\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"232\" wd=\"null\">&quot;Investment</span> <span class=\"hps\" closure_uid_503514901=\"233\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"234\" wd=\"null\">Jinshan</span><span closure_uid_503514901=\"235\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"236\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"237\" wd=\"null\">series of negotiations</span> <span class=\"hps\" closure_uid_503514901=\"238\" wd=\"null\">are</span> <span class=\"hps\" closure_uid_503514901=\"239\" wd=\"null\">conducted</span> <span class=\"hps\" closure_uid_503514901=\"240\" wd=\"null\">by</span> <span class=\"hps\" closure_uid_503514901=\"241\" wd=\"null\">Li</span> <span class=\"hps\" closure_uid_503514901=\"242\" wd=\"null\">himself</span> <span class=\"hps\" closure_uid_503514901=\"243\" wd=\"null\">with</span> <span class=\"hps\" closure_uid_503514901=\"244\" wd=\"null\">people</span> <span class=\"hps\" closure_uid_503514901=\"245\" wd=\"null\">is expected to</span> <span class=\"hps\" closure_uid_503514901=\"246\" wd=\"null\">be reached</span> <span class=\"hps\" closure_uid_503514901=\"247\" wd=\"null\">soon</span><span closure_uid_503514901=\"248\" wd=\"null\">.</span><span closure_uid_503514901=\"249\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"250\" wd=\"null\">In June 2012</span><span closure_uid_503514901=\"251\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"252\" wd=\"null\">there had been</span> <span class=\"hps\" closure_uid_503514901=\"253\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"254\" wd=\"null\">$</span> <span class=\"hps\" closure_uid_503514901=\"255\" wd=\"null\">400 million</span> <span class=\"hps\" closure_uid_503514901=\"256\" wd=\"null\">acquisition of</span> <span class=\"hps\" closure_uid_503514901=\"257\" wd=\"null\">UC49%</span> <span class=\"hps\" closure_uid_503514901=\"258\" wd=\"null\">stake</span><span closure_uid_503514901=\"259\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"260\" wd=\"null\">But</span> <span class=\"hps\" closure_uid_503514901=\"261\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"262\" wd=\"null\">transaction has not been</span> <span class=\"hps\" closure_uid_503514901=\"263\" wd=\"null\">reached</span><span closure_uid_503514901=\"264\" wd=\"null\">.</span><br closure_uid_503514901=\"438\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"439\" wd=\"null\" />\r\n	&nbsp;<br closure_uid_503514901=\"440\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"441\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"265\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"266\" wd=\"null\">internal</span> <span class=\"hps\" closure_uid_503514901=\"267\" wd=\"null\">sources said</span><span closure_uid_503514901=\"268\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"269\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"270\" wd=\"null\">recently</span> <span class=\"hps\" closure_uid_503514901=\"271\" wd=\"null\">stepped up</span> <span class=\"hps\" closure_uid_503514901=\"272\" wd=\"null\">investment</span> <span class=\"hps\" closure_uid_503514901=\"273\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"274\" wd=\"null\">all</span> <span class=\"hps\" closure_uid_503514901=\"275\" wd=\"null\">defense</span> <span class=\"hps\" closure_uid_503514901=\"276\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"277\" wd=\"null\">mobile</span> <span class=\"hps\" closure_uid_503514901=\"278\" wd=\"null\">end</span><span closure_uid_503514901=\"279\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"280\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"281\" wd=\"null\">to accelerate</span> <span class=\"hps\" closure_uid_503514901=\"282\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"283\" wd=\"null\">process of investment</span><span closure_uid_503514901=\"284\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"285\" wd=\"null\">but</span> <span class=\"hps\" closure_uid_503514901=\"286\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"287\" wd=\"null\">investment</span> <span class=\"hps\" closure_uid_503514901=\"288\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"289\" wd=\"null\">M &amp; A</span><span closure_uid_503514901=\"290\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"291\" wd=\"null\">by</span> <span class=\"hps\" closure_uid_503514901=\"292\" wd=\"null\">Robin Li</span> <span class=\"hps\" closure_uid_503514901=\"293\" wd=\"null\">personally intervene</span><span closure_uid_503514901=\"294\" wd=\"null\">.</span><br closure_uid_503514901=\"442\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"443\" wd=\"null\" />\r\n	<span class=\"atn\" closure_uid_503514901=\"295\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"296\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"297\" wd=\"null\">lack</span> <span class=\"hps\" closure_uid_503514901=\"298\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"299\" wd=\"null\">moving</span> <span class=\"hps\" closure_uid_503514901=\"300\" wd=\"null\">side</span> <span class=\"hps\" closure_uid_503514901=\"301\" wd=\"null\">entrance</span><span closure_uid_503514901=\"302\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"303\" wd=\"null\">holding</span> <span class=\"hps\" closure_uid_503514901=\"304\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"305\" wd=\"null\">is the best choice</span><span closure_uid_503514901=\"306\" wd=\"null\">.&quot;</span> <span class=\"hps\" closure_uid_503514901=\"307\" wd=\"null\">Analysts said</span> <span class=\"hps\" closure_uid_503514901=\"308\" wd=\"null\">the investment community</span><span closure_uid_503514901=\"309\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"310\" wd=\"null\">Internet analysts</span> <span class=\"hps\" closure_uid_503514901=\"311\" wd=\"null\">had</span> <span class=\"hps\" closure_uid_503514901=\"312\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"313\" wd=\"null\">Keso</span> <span class=\"hps\" closure_uid_503514901=\"314\" wd=\"null\">also said</span><span closure_uid_503514901=\"315\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"316\" wd=\"null\">&quot;If</span> <span class=\"hps\" closure_uid_503514901=\"317\" wd=\"null\">this message</span> <span class=\"hps atn\" closure_uid_503514901=\"318\" wd=\"null\">(</span><span closure_uid_503514901=\"319\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"320\" wd=\"null\">acquisitions</span> <span class=\"hps\" closure_uid_503514901=\"321\" wd=\"null\">UCweb)</span> <span class=\"hps\" closure_uid_503514901=\"322\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"323\" wd=\"null\">confirmed</span><span closure_uid_503514901=\"324\" wd=\"null\">, it will be</span> <span class=\"hps\" closure_uid_503514901=\"325\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"326\" wd=\"null\">defensive</span> <span class=\"hps\" closure_uid_503514901=\"327\" wd=\"null\">acquisition</span><span closure_uid_503514901=\"328\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"329\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"330\" wd=\"null\">main purpose</span> <span class=\"hps\" closure_uid_503514901=\"331\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"332\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"333\" wd=\"null\">prevent</span> <span class=\"hps\" closure_uid_503514901=\"334\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"335\" wd=\"null\">UC</span> <span class=\"hps\" closure_uid_503514901=\"336\" wd=\"null\">acquisition of</span> <span class=\"hps\" closure_uid_503514901=\"337\" wd=\"null\">other</span> <span class=\"hps\" closure_uid_503514901=\"338\" wd=\"null\">Internet giants</span><span closure_uid_503514901=\"339\" wd=\"null\">.</span><span closure_uid_503514901=\"340\" wd=\"null\">&quot;</span><br closure_uid_503514901=\"444\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"445\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"341\" wd=\"null\">However</span><span closure_uid_503514901=\"342\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"343\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"344\" wd=\"null\">transactions</span> <span class=\"hps\" closure_uid_503514901=\"345\" wd=\"null\">acquisitions</span> <span class=\"hps\" closure_uid_503514901=\"346\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"347\" wd=\"null\">ability to achieve</span> <span class=\"hps\" closure_uid_503514901=\"348\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"349\" wd=\"null\">there</span> <span class=\"hps\" closure_uid_503514901=\"350\" wd=\"null\">are</span> <span class=\"hps\" closure_uid_503514901=\"351\" wd=\"null\">many</span> <span class=\"hps\" closure_uid_503514901=\"352\" wd=\"null\">factors</span> <span class=\"hps\" closure_uid_503514901=\"353\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"354\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"355\" wd=\"null\">left and right</span><span closure_uid_503514901=\"356\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"357\" wd=\"null\">The</span> <span class=\"hps\" closure_uid_503514901=\"358\" wd=\"null\">source said that</span> <span class=\"hps\" closure_uid_503514901=\"359\" wd=\"null\">contact</span> <span class=\"hps\" closure_uid_503514901=\"360\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"361\" wd=\"null\">June</span> <span class=\"hps\" closure_uid_503514901=\"362\" wd=\"null\">last</span> <span class=\"hps\" closure_uid_503514901=\"363\" wd=\"null\">year</span><span closure_uid_503514901=\"364\" wd=\"null\">, Baidu</span> <span class=\"hps\" closure_uid_503514901=\"365\" wd=\"null\">valuation of</span> <span class=\"hps\" closure_uid_503514901=\"366\" wd=\"null\">$</span> <span class=\"hps\" closure_uid_503514901=\"367\" wd=\"null\">816 million</span> <span class=\"hps\" closure_uid_503514901=\"368\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"369\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"370\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"371\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"372\" wd=\"null\">aspects of</span> <span class=\"hps\" closure_uid_503514901=\"373\" wd=\"null\">their own</span> <span class=\"hps\" closure_uid_503514901=\"374\" wd=\"null\">valuation</span> <span class=\"hps\" closure_uid_503514901=\"375\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"376\" wd=\"null\">10</span> <span class=\"hps\" closure_uid_503514901=\"377\" wd=\"null\">billion dollars</span><span closure_uid_503514901=\"378\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"379\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"380\" wd=\"null\">final</span> <span class=\"hps\" closure_uid_503514901=\"381\" wd=\"null\">price</span> <span class=\"hps\" closure_uid_503514901=\"382\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"383\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"384\" wd=\"null\">two</span> <span class=\"hps\" closure_uid_503514901=\"385\" wd=\"null\">sides</span> <span class=\"hps\" closure_uid_503514901=\"386\" wd=\"null\">did not</span>&nbsp; agree<span closure_uid_503514901=\"388\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"389\" wd=\"null\">The</span> <span class=\"hps\" closure_uid_503514901=\"390\" wd=\"null\">valuation</span> <span class=\"hps\" closure_uid_503514901=\"391\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"392\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"393\" wd=\"null\">may</span> <span class=\"hps\" closure_uid_503514901=\"394\" wd=\"null\">be higher,</span> <span class=\"hps\" closure_uid_503514901=\"395\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"396\" wd=\"null\">need</span> <span class=\"hps\" closure_uid_503514901=\"397\" wd=\"null\">to pay</span> <span class=\"hps\" closure_uid_503514901=\"398\" wd=\"null\">more</span> <span class=\"hps\" closure_uid_503514901=\"399\" wd=\"null\">cash</span><span closure_uid_503514901=\"400\" wd=\"null\">, Baidu</span> <span class=\"hps\" closure_uid_503514901=\"401\" wd=\"null\">can accept</span> <span class=\"hps\" closure_uid_503514901=\"402\" wd=\"null\">is a</span> <span class=\"hps\" closure_uid_503514901=\"403\" wd=\"null\">problem</span><span closure_uid_503514901=\"404\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"405\" wd=\"null\">Meanwhile</span><span closure_uid_503514901=\"406\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"407\" wd=\"null\">UCweb</span> <span class=\"hps\" closure_uid_503514901=\"408\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"409\" wd=\"null\">founding team</span> <span class=\"hps\" closure_uid_503514901=\"410\" wd=\"null\">as well as</span> <span class=\"hps\" closure_uid_503514901=\"411\" wd=\"null\">Alibaba</span><span closure_uid_503514901=\"412\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"413\" wd=\"null\">Nokia</span> <span class=\"hps\" closure_uid_503514901=\"414\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"415\" wd=\"null\">other</span> <span class=\"hps\" closure_uid_503514901=\"416\" wd=\"null\">strategic investors</span> <span class=\"hps\" closure_uid_503514901=\"417\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"418\" wd=\"null\">whether they can accept</span> <span class=\"hps\" closure_uid_503514901=\"419\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"420\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"421\" wd=\"null\">acquisition</span> <span class=\"hps\" closure_uid_503514901=\"422\" wd=\"null\">is also</span> <span class=\"hps\" closure_uid_503514901=\"423\" wd=\"null\">variable</span><span closure_uid_503514901=\"424\" wd=\"null\">.</span><br closure_uid_503514901=\"446\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"447\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"425\" wd=\"null\">As of press time</span><span closure_uid_503514901=\"426\" wd=\"null\">, Baidu</span> <span class=\"hps\" closure_uid_503514901=\"427\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"428\" wd=\"null\">UCweb</span><span closure_uid_503514901=\"429\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"430\" wd=\"null\">not yet</span> <span class=\"hps\" closure_uid_503514901=\"431\" wd=\"null\">to comment</span> <span class=\"hps\" closure_uid_503514901=\"432\" wd=\"null\">on</span> <span class=\"hps\" closure_uid_503514901=\"433\" wd=\"null\">the two sides</span> <span class=\"hps\" closure_uid_503514901=\"434\" wd=\"null\">to discuss</span> <span class=\"hps\" closure_uid_503514901=\"435\" wd=\"null\">the issue</span><span closure_uid_503514901=\"436\" wd=\"null\">.</span></p>\r\n<p>\r\n	<span closure_uid_503514901=\"436\" wd=\"null\"><img alt=\"\" src=\"/Upload/news/135ZM1951a0-61W2.jpg\" style=\"width: 550px; height: 1267px\" /></span></p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:45:56',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('137','42',NULL,'1','Baidu large-scale algorithm upgrade SEOer carefully use clicking  software',NULL,'<p>\r\n	<span closure_uid_503514901=\"510\" wd=\"null\">Recently,</span> <span class=\"hps\" closure_uid_503514901=\"511\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"512\" wd=\"null\">large-scale</span> <span class=\"hps\" closure_uid_503514901=\"513\" wd=\"null\">upgrade</span> <span class=\"hps\" closure_uid_503514901=\"514\" wd=\"null\">of the</span> <span class=\"hps\" closure_uid_503514901=\"515\" wd=\"null\">algorithm</span> <span class=\"hps\" closure_uid_503514901=\"516\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"517\" wd=\"null\">revision</span><span closure_uid_503514901=\"518\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"519\" wd=\"null\">engage in</span> <span class=\"hps\" closure_uid_503514901=\"520\" wd=\"null\">panic</span><span closure_uid_503514901=\"521\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"522\" wd=\"null\">First,</span> <span class=\"hps\" closure_uid_503514901=\"523\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"524\" wd=\"null\">failure</span> <span class=\"hps\" closure_uid_503514901=\"525\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"526\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"527\" wd=\"null\">news search</span><span closure_uid_503514901=\"528\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"529\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"530\" wd=\"null\">search engine</span><span closure_uid_503514901=\"531\" wd=\"null\">, frequent errors,</span> <span class=\"hps\" closure_uid_503514901=\"532\" wd=\"null\">especially</span> <span class=\"hps\" closure_uid_503514901=\"533\" wd=\"null\">slightly longer</span> <span class=\"hps\" closure_uid_503514901=\"534\" wd=\"null\">text</span> <span class=\"hps\" closure_uid_503514901=\"535\" wd=\"null\">each will</span> <span class=\"hps\" closure_uid_503514901=\"536\" wd=\"null\">wrong</span><span closure_uid_503514901=\"537\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"538\" wd=\"null\">Which</span> <span class=\"hps\" closure_uid_503514901=\"539\" wd=\"null\">one is</span> <span class=\"hps\" closure_uid_503514901=\"540\" wd=\"null\">clicking</span> <span class=\"hps\" closure_uid_503514901=\"541\" wd=\"null\">on</span> <span class=\"hps\" closure_uid_503514901=\"542\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"543\" wd=\"null\">class</span> <span class=\"hps\" closure_uid_503514901=\"544\" wd=\"null\">of the more popular</span> <span class=\"hps\" closure_uid_503514901=\"545\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"546\" wd=\"null\">algorithm</span> <span class=\"hps\" closure_uid_503514901=\"547\" wd=\"null\">adjustments</span> <span class=\"hps\" closure_uid_503514901=\"548\" wd=\"null\">at running</span> <span class=\"hps\" closure_uid_503514901=\"549\" wd=\"null\">events</span> <span class=\"hps\" closure_uid_503514901=\"550\" wd=\"null\">from the most recent</span> <span class=\"hps\" closure_uid_503514901=\"551\" wd=\"null\">such software</span> <span class=\"hps\" closure_uid_503514901=\"552\" wd=\"null\">provider</span><span closure_uid_503514901=\"553\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"554\" wd=\"null\">can</span> <span class=\"hps\" closure_uid_503514901=\"555\" wd=\"null\">say with certainty that</span> <span class=\"hps\" closure_uid_503514901=\"556\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"557\" wd=\"null\">clicker</span> <span class=\"hps\" closure_uid_503514901=\"558\" wd=\"null\">market</span><span closure_uid_503514901=\"559\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"560\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"561\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"562\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"563\" wd=\"null\">popular</span> <span class=\"hps\" closure_uid_503514901=\"564\" wd=\"null\">in the country</span><span closure_uid_503514901=\"565\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"566\" wd=\"null\">starting</span> <span class=\"hps\" closure_uid_503514901=\"567\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"568\" wd=\"null\">2009</span><span closure_uid_503514901=\"569\" wd=\"null\">, also known as</span> <span class=\"hps\" closure_uid_503514901=\"570\" wd=\"null\">analog</span> <span class=\"hps\" closure_uid_503514901=\"571\" wd=\"null\">click</span><span closure_uid_503514901=\"572\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"573\" wd=\"null\">P2P technology</span> <span class=\"hps\" closure_uid_503514901=\"574\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"575\" wd=\"null\">agent technology</span> <span class=\"hps\" closure_uid_503514901=\"576\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"577\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"578\" wd=\"null\">realistic simulation of</span> <span class=\"hps\" closure_uid_503514901=\"579\" wd=\"null\">user</span> <span class=\"hps\" closure_uid_503514901=\"580\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"581\" wd=\"null\">behavior</span> <span class=\"hps\" closure_uid_503514901=\"582\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"583\" wd=\"null\">affect search engine rankings</span><span closure_uid_503514901=\"584\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"585\" wd=\"null\">Baidu Union</span> <span class=\"hps\" closure_uid_503514901=\"586\" wd=\"null\">ad</span> <span class=\"hps\" closure_uid_503514901=\"587\" wd=\"null\">interaction</span> <span class=\"hps\" closure_uid_503514901=\"588\" wd=\"null\">point</span> <span class=\"hps\" closure_uid_503514901=\"589\" wd=\"null\">Union</span><span closure_uid_503514901=\"590\" wd=\"null\">,</span> <span class=\"hps atn\" closure_uid_503514901=\"591\" wd=\"null\">cross-</span><span closure_uid_503514901=\"592\" wd=\"null\">point group</span> <span class=\"hps\" closure_uid_503514901=\"593\" wd=\"null\">and so</span> <span class=\"hps\" closure_uid_503514901=\"594\" wd=\"null\">the nature of</span> <span class=\"hps\" closure_uid_503514901=\"595\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"596\" wd=\"null\">mutual</span> <span class=\"hps\" closure_uid_503514901=\"597\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"598\" wd=\"null\">advertising</span> <span class=\"hps\" closure_uid_503514901=\"599\" wd=\"null\">on</span> <span class=\"hps\" closure_uid_503514901=\"600\" wd=\"null\">Baidu Union</span> <span class=\"hps\" closure_uid_503514901=\"601\" wd=\"null\">conduct</span> <span class=\"hps\" closure_uid_503514901=\"602\" wd=\"null\">penalty.</span><br closure_uid_503514901=\"690\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"691\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"603\" wd=\"null\">I also received</span> <span class=\"hps\" closure_uid_503514901=\"604\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"605\" wd=\"null\">e-mail notification</span> <span class=\"hps\" closure_uid_503514901=\"606\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"607\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"608\" wd=\"null\">Union</span><span closure_uid_503514901=\"609\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"610\" wd=\"null\">all</span> <span class=\"hps\" closure_uid_503514901=\"611\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"612\" wd=\"null\">Union</span> <span class=\"hps\" closure_uid_503514901=\"613\" wd=\"null\">websites</span><span closure_uid_503514901=\"614\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"615\" wd=\"null\">Reward</span> <span class=\"hps\" closure_uid_503514901=\"616\" wd=\"null\">Report</span><span closure_uid_503514901=\"617\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"618\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"619\" wd=\"null\">visible</span> <span class=\"hps\" closure_uid_503514901=\"620\" wd=\"null\">human</span> <span class=\"hps\" closure_uid_503514901=\"621\" wd=\"null\">use</span> <span class=\"hps\" closure_uid_503514901=\"622\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"623\" wd=\"null\">simulation</span> <span class=\"hps\" closure_uid_503514901=\"624\" wd=\"null\">behavior</span> <span class=\"hps\" closure_uid_503514901=\"625\" wd=\"null\">has</span> <span class=\"hps\" closure_uid_503514901=\"626\" wd=\"null\">touched</span> <span class=\"hps\" closure_uid_503514901=\"627\" wd=\"null\">the fundamental interests</span> <span class=\"hps\" closure_uid_503514901=\"628\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"629\" wd=\"null\">Baidu</span><span closure_uid_503514901=\"630\" wd=\"null\">, Baidu,</span> <span class=\"hps\" closure_uid_503514901=\"631\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"632\" wd=\"null\">course</span><span closure_uid_503514901=\"633\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"634\" wd=\"null\">can not be tolerated</span><span closure_uid_503514901=\"635\" wd=\"null\">.</span><br closure_uid_503514901=\"692\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"693\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"636\" wd=\"null\">User</span> <span class=\"hps\" closure_uid_503514901=\"637\" wd=\"null\">feedback</span><span closure_uid_503514901=\"638\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"639\" wd=\"null\">it took</span> <span class=\"hps\" closure_uid_503514901=\"640\" wd=\"null\">598</span> <span class=\"hps\" closure_uid_503514901=\"641\" wd=\"null\">to buy</span> <span class=\"hps\" closure_uid_503514901=\"642\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"643\" wd=\"null\">one</span><span class=\"atn\" closure_uid_503514901=\"644\" wd=\"null\">-</span><span closure_uid_503514901=\"645\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"646\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"647\" wd=\"null\">originally</span> <span class=\"hps\" closure_uid_503514901=\"648\" wd=\"null\">ranked</span> <span class=\"hps\" closure_uid_503514901=\"649\" wd=\"null\">15</span> <span class=\"hps\" closure_uid_503514901=\"650\" wd=\"null\">words</span><span closure_uid_503514901=\"651\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"652\" wd=\"null\">click</span> <span class=\"hps\" closure_uid_503514901=\"653\" wd=\"null\">afternoon</span> <span class=\"hps\" closure_uid_503514901=\"654\" wd=\"null\">clicker</span> <span class=\"hps\" closure_uid_503514901=\"655\" wd=\"null\">analog</span> <span class=\"hps\" closure_uid_503514901=\"656\" wd=\"null\">results</span> <span class=\"hps\" closure_uid_503514901=\"657\" wd=\"null\">gone</span> <span class=\"hps\" closure_uid_503514901=\"658\" wd=\"null\">the next day</span><span closure_uid_503514901=\"659\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"660\" wd=\"null\">not only</span> <span class=\"hps\" closure_uid_503514901=\"661\" wd=\"null\">the word</span> <span class=\"hps\" closure_uid_503514901=\"662\" wd=\"null\">ranking</span><span closure_uid_503514901=\"663\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"664\" wd=\"null\">the most</span> <span class=\"hps\" closure_uid_503514901=\"665\" wd=\"null\">angry</span><span closure_uid_503514901=\"666\" wd=\"null\">, the other</span> <span class=\"hps\" closure_uid_503514901=\"667\" wd=\"null\">keywords</span> <span class=\"hps\" closure_uid_503514901=\"668\" wd=\"null\">ranking</span> <span class=\"hps\" closure_uid_503514901=\"669\" wd=\"null\">disappeared</span><span closure_uid_503514901=\"670\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"671\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"672\" wd=\"null\">worked hard to</span> <span class=\"hps\" closure_uid_503514901=\"673\" wd=\"null\">optimize</span> <span class=\"hps\" closure_uid_503514901=\"674\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"675\" wd=\"null\">site</span> <span class=\"hps\" closure_uid_503514901=\"676\" wd=\"null\">for</span> <span class=\"hps\" closure_uid_503514901=\"677\" wd=\"null\">six months</span><span closure_uid_503514901=\"678\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"679\" wd=\"null\">just</span> <span class=\"hps\" closure_uid_503514901=\"680\" wd=\"null\">search</span> <span class=\"hps\" closure_uid_503514901=\"681\" wd=\"null\">the title</span> <span class=\"hps\" closure_uid_503514901=\"682\" wd=\"null\">search</span><span closure_uid_503514901=\"683\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"684\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"685\" wd=\"null\">company commander</span> <span class=\"hps\" closure_uid_503514901=\"686\" wd=\"null\">Suffix</span> <span class=\"hps\" closure_uid_503514901=\"687\" wd=\"null\">not search</span><span closure_uid_503514901=\"688\" wd=\"null\">.</span></p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 20:58:02',NULL,'3',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('138','42',NULL,'1','Baidu confirmed that spiders will crawl plain text link URL',NULL,'<p>\r\n	<span closure_uid_503514901=\"724\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"725\" wd=\"null\">officially recognized as</span> <span class=\"hps\" closure_uid_503514901=\"726\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"727\" wd=\"null\">plain text</span> <span class=\"hps\" closure_uid_503514901=\"728\" wd=\"null\">link URL</span> <span class=\"hps\" closure_uid_503514901=\"729\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"730\" wd=\"null\">crawl</span><span closure_uid_503514901=\"731\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"732\" wd=\"null\">network</span> <span class=\"hps\" closure_uid_503514901=\"733\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"734\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"735\" wd=\"null\">reptiles</span> <span class=\"hps\" closure_uid_503514901=\"736\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"737\" wd=\"null\">plain text</span> <span class=\"hps\" closure_uid_503514901=\"738\" wd=\"null\">on the</span> <span class=\"hps\" closure_uid_503514901=\"739\" wd=\"null\">link</span> <span class=\"hps\" closure_uid_503514901=\"740\" wd=\"null\">to crawl</span> <span class=\"hps\" closure_uid_503514901=\"741\" wd=\"null\">from</span> <span class=\"hps\" closure_uid_503514901=\"742\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"743\" wd=\"null\">owners club</span> <span class=\"hps\" closure_uid_503514901=\"744\" wd=\"null\">Lee</span> <span class=\"hps\" closure_uid_503514901=\"745\" wd=\"null\">Reply</span><span closure_uid_503514901=\"746\" wd=\"null\">!</span><br closure_uid_503514901=\"820\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"821\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"747\" wd=\"null\">1</span> <span class=\"hps\" closure_uid_503514901=\"748\" wd=\"null\">text</span> <span class=\"hps\" closure_uid_503514901=\"749\" wd=\"null\">link</span> <span class=\"hps\" closure_uid_503514901=\"750\" wd=\"null\">url</span> <span class=\"hps\" closure_uid_503514901=\"751\" wd=\"null\">address</span><span closure_uid_503514901=\"752\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"753\" wd=\"null\">Baidu</span> <span class=\"hps\" closure_uid_503514901=\"754\" wd=\"null\">will find</span> <span class=\"hps\" closure_uid_503514901=\"755\" wd=\"null\">he is</span> <span class=\"hps\" closure_uid_503514901=\"756\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"757\" wd=\"null\">url address</span> <span class=\"hps\" closure_uid_503514901=\"758\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"759\" wd=\"null\">crawl</span> <span class=\"hps\" closure_uid_503514901=\"760\" wd=\"null\">up</span> <span class=\"hps\" closure_uid_503514901=\"761\" wd=\"null\">this address</span> <span class=\"hps\" closure_uid_503514901=\"762\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"763\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"764\" wd=\"null\">url</span> <span class=\"hps\" closure_uid_503514901=\"765\" wd=\"null\">address</span><span closure_uid_503514901=\"766\" wd=\"null\">.</span><br closure_uid_503514901=\"822\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"823\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"767\" wd=\"null\">2,</span> <span class=\"hps\" closure_uid_503514901=\"768\" wd=\"null\">whether</span> <span class=\"hps\" closure_uid_503514901=\"769\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"770\" wd=\"null\">link</span> <span class=\"hps\" closure_uid_503514901=\"771\" wd=\"null\">should be passed</span> <span class=\"hps\" closure_uid_503514901=\"772\" wd=\"null\">weights</span> <span class=\"hps\" closure_uid_503514901=\"773\" wd=\"null\">only</span> <span class=\"hps\" closure_uid_503514901=\"774\" wd=\"null\">criteria</span><span closure_uid_503514901=\"775\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"776\" wd=\"null\">whether</span> <span class=\"hps\" closure_uid_503514901=\"777\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"778\" wd=\"null\">user</span> <span class=\"hps\" closure_uid_503514901=\"779\" wd=\"null\">or</span> <span class=\"hps\" closure_uid_503514901=\"780\" wd=\"null\">other sites</span> <span class=\"hps\" closure_uid_503514901=\"781\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"782\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"783\" wd=\"null\">link</span> <span class=\"hps\" closure_uid_503514901=\"784\" wd=\"null\">really</span> <span class=\"hps\" closure_uid_503514901=\"785\" wd=\"null\">recommend your site to</span> <span class=\"hps\" closure_uid_503514901=\"786\" wd=\"null\">this recommendation</span><span closure_uid_503514901=\"787\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"788\" wd=\"null\">whether</span> <span class=\"hps\" closure_uid_503514901=\"789\" wd=\"null\">Users</span> <span class=\"hps\" closure_uid_503514901=\"790\" wd=\"null\">valuable</span><span closure_uid_503514901=\"791\" wd=\"null\">.</span><br closure_uid_503514901=\"824\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"825\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"792\" wd=\"null\">Note</span><span closure_uid_503514901=\"793\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"794\" wd=\"null\">plain text</span> <span class=\"hps\" closure_uid_503514901=\"795\" wd=\"null\">link</span> <span class=\"hps\" closure_uid_503514901=\"796\" wd=\"null\">that is</span> <span class=\"hps\" closure_uid_503514901=\"797\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"798\" wd=\"null\">remove the</span> <span class=\"hps\" closure_uid_503514901=\"799\" wd=\"null\">hyperlink</span> <span class=\"hps\" closure_uid_503514901=\"800\" wd=\"null\">URL</span> <span class=\"hps\" closure_uid_503514901=\"801\" wd=\"null\">majority</span> <span class=\"hps\" closure_uid_503514901=\"802\" wd=\"null\">Contributions</span> <span class=\"hps\" closure_uid_503514901=\"803\" wd=\"null\">will be</span> <span class=\"hps\" closure_uid_503514901=\"804\" wd=\"null\">removed</span> <span class=\"hps\" closure_uid_503514901=\"805\" wd=\"null\">hyperlink</span><span closure_uid_503514901=\"806\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"807\" wd=\"null\">which is</span> <span class=\"hps\" closure_uid_503514901=\"808\" wd=\"null\">undoubtedly</span> <span class=\"hps\" closure_uid_503514901=\"809\" wd=\"null\">good</span> <span class=\"hps\" closure_uid_503514901=\"810\" wd=\"null\">news</span><span closure_uid_503514901=\"811\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"812\" wd=\"null\">but</span> <span class=\"hps\" closure_uid_503514901=\"813\" wd=\"null\">can not</span> <span class=\"hps\" closure_uid_503514901=\"814\" wd=\"null\">confirm</span> <span class=\"hps\" closure_uid_503514901=\"815\" wd=\"null\">whether</span> <span class=\"hps\" closure_uid_503514901=\"816\" wd=\"null\">passing</span> <span class=\"hps\" closure_uid_503514901=\"817\" wd=\"null\">weight</span><span closure_uid_503514901=\"818\" wd=\"null\">.</span></p>\r\n','0','/Upload/news/3en.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 21:00:08',NULL,'4',NULL,'3',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('139','42',NULL,'1','Godaddy is sealed, the large number of sites can not be accessed',NULL,'<p>\r\n	<span closure_uid_503514901=\"854\" wd=\"null\">In</span> <span class=\"hps\" closure_uid_503514901=\"855\" wd=\"null\">May 2012</span><span closure_uid_503514901=\"856\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"857\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"858\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"859\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"860\" wd=\"null\">main</span> <span class=\"hps\" closure_uid_503514901=\"861\" wd=\"null\">station</span> <span class=\"hps\" closure_uid_503514901=\"862\" wd=\"null\">from China</span> <span class=\"hps\" closure_uid_503514901=\"863\" wd=\"null\">resolution</span> <span class=\"hps\" closure_uid_503514901=\"864\" wd=\"null\">is very unstable</span><span closure_uid_503514901=\"865\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"866\" wd=\"null\">parsing</span> <span class=\"hps\" closure_uid_503514901=\"867\" wd=\"null\">is masked</span> <span class=\"hps\" closure_uid_503514901=\"868\" wd=\"null\">normal</span><span closure_uid_503514901=\"869\" wd=\"null\">, Railway line</span><span closure_uid_503514901=\"870\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"871\" wd=\"null\">basic</span> <span class=\"hps\" closure_uid_503514901=\"872\" wd=\"null\">telecommunications</span> <span class=\"hps\" closure_uid_503514901=\"873\" wd=\"null\">masked</span> <span class=\"hps\" closure_uid_503514901=\"874\" wd=\"null\">more and more</span> <span class=\"hps\" closure_uid_503514901=\"875\" wd=\"null\">GoDaddy DNS</span> <span class=\"hps\" closure_uid_503514901=\"876\" wd=\"null\">server</span> <span class=\"hps\" closure_uid_503514901=\"877\" wd=\"null\">regional</span> <span class=\"hps\" closure_uid_503514901=\"878\" wd=\"null\">interference</span> <span class=\"hps\" closure_uid_503514901=\"879\" wd=\"null\">can not</span><span closure_uid_503514901=\"880\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"881\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"882\" wd=\"null\">own</span> <span class=\"hps\" closure_uid_503514901=\"883\" wd=\"null\">domain</span> <span class=\"hps\" closure_uid_503514901=\"884\" wd=\"null\">name</span> <span class=\"hps\" closure_uid_503514901=\"885\" wd=\"null\">can not be resolved</span><span closure_uid_503514901=\"886\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"887\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"888\" wd=\"null\">large number of sites</span> <span class=\"hps\" closure_uid_503514901=\"889\" wd=\"null\">can not be accessed</span><span closure_uid_503514901=\"890\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"891\" wd=\"null\">especially in</span> <span class=\"hps\" closure_uid_503514901=\"892\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"893\" wd=\"null\">registered</span> <span class=\"hps\" closure_uid_503514901=\"894\" wd=\"null\">domain name</span> <span class=\"hps\" closure_uid_503514901=\"895\" wd=\"null\">owners</span><span closure_uid_503514901=\"896\" wd=\"null\">.</span><br closure_uid_503514901=\"1083\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1084\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"897\" wd=\"null\">Beginning</span> <span class=\"hps\" closure_uid_503514901=\"898\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"899\" wd=\"null\">July</span> <span class=\"hps\" closure_uid_503514901=\"900\" wd=\"null\">last</span> <span class=\"hps\" closure_uid_503514901=\"901\" wd=\"null\">year</span><span closure_uid_503514901=\"902\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"903\" wd=\"null\">some of the</span> <span class=\"hps\" closure_uid_503514901=\"904\" wd=\"null\">telecom operators</span> <span class=\"hps\" closure_uid_503514901=\"905\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"906\" wd=\"null\">China</span> <span class=\"hps\" closure_uid_503514901=\"907\" wd=\"null\">began to</span> <span class=\"hps\" closure_uid_503514901=\"908\" wd=\"null\">shield</span> <span class=\"hps\" closure_uid_503514901=\"909\" wd=\"null\">part</span> <span class=\"hps\" closure_uid_503514901=\"910\" wd=\"null\">Godaddy</span><span closure_uid_503514901=\"911\" wd=\"null\">&#39;s</span> <span class=\"hps\" closure_uid_503514901=\"912\" wd=\"null\">DNS</span> <span class=\"hps\" closure_uid_503514901=\"913\" wd=\"null\">service</span><span closure_uid_503514901=\"914\" wd=\"null\">, leading to</span> <span class=\"hps\" closure_uid_503514901=\"915\" wd=\"null\">large-scale use</span> <span class=\"hps\" closure_uid_503514901=\"916\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"917\" wd=\"null\">DNS</span> <span class=\"hps\" closure_uid_503514901=\"918\" wd=\"null\">website</span> <span class=\"hps\" closure_uid_503514901=\"919\" wd=\"null\">can</span> <span class=\"hps\" closure_uid_503514901=\"920\" wd=\"null\">not</span> <span class=\"hps\" closure_uid_503514901=\"921\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"922\" wd=\"null\">accessed</span> <span class=\"hps\" closure_uid_503514901=\"923\" wd=\"null\">from China</span><span closure_uid_503514901=\"924\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"925\" wd=\"null\">such a direct</span> <span class=\"hps\" closure_uid_503514901=\"926\" wd=\"null\">shielding</span> <span class=\"hps\" closure_uid_503514901=\"927\" wd=\"null\">NS</span> <span class=\"hps atn\" closure_uid_503514901=\"928\" wd=\"null\">(</span><span closure_uid_503514901=\"929\" wd=\"null\">DNS</span><span closure_uid_503514901=\"930\" wd=\"null\">)</span> <span class=\"hps\" closure_uid_503514901=\"931\" wd=\"null\">service</span> <span class=\"hps\" closure_uid_503514901=\"932\" wd=\"null\">approach</span><span closure_uid_503514901=\"933\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"934\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"935\" wd=\"null\">very bad</span> <span class=\"hps\" closure_uid_503514901=\"936\" wd=\"null\">influence</span> <span class=\"hps\" closure_uid_503514901=\"937\" wd=\"null\">one or two</span> <span class=\"hps\" closure_uid_503514901=\"938\" wd=\"null\">so-called</span> <span class=\"hps\" closure_uid_503514901=\"939\" wd=\"null\">&quot;harmful information&quot;</span> <span class=\"hps\" closure_uid_503514901=\"940\" wd=\"null\">in order to</span> <span class=\"hps atn\" closure_uid_503514901=\"941\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"942\" wd=\"null\">punish</span><span closure_uid_503514901=\"943\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"944\" wd=\"null\">a direct result of</span> <span class=\"hps\" closure_uid_503514901=\"945\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"946\" wd=\"null\">thousands of</span> <span class=\"hps\" closure_uid_503514901=\"947\" wd=\"null\">innocent</span> <span class=\"hps\" closure_uid_503514901=\"948\" wd=\"null\">sites</span> <span class=\"hps\" closure_uid_503514901=\"949\" wd=\"null\">can not be accessed</span><span closure_uid_503514901=\"950\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"951\" wd=\"null\">can be described as</span> <span class=\"hps atn\" closure_uid_503514901=\"952\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"953\" wd=\"null\">rather kill</span> <span class=\"hps\" closure_uid_503514901=\"954\" wd=\"null\">a thousand,</span> <span class=\"hps\" closure_uid_503514901=\"955\" wd=\"null\">can not</span> <span class=\"hps\" closure_uid_503514901=\"956\" wd=\"null\">let go of</span> <span class=\"hps\" closure_uid_503514901=\"957\" wd=\"null\">a</span><span closure_uid_503514901=\"958\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"959\" wd=\"null\">less extreme means</span><span closure_uid_503514901=\"960\" wd=\"null\">.</span><br closure_uid_503514901=\"1085\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1086\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"961\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"962\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"963\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"964\" wd=\"null\">world&#39;s largest</span> <span class=\"hps\" closure_uid_503514901=\"965\" wd=\"null\">domain name registrar</span><span closure_uid_503514901=\"966\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"967\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"968\" wd=\"null\">domain name</span> <span class=\"hps\" closure_uid_503514901=\"969\" wd=\"null\">registration fee</span> <span class=\"hps\" closure_uid_503514901=\"970\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"971\" wd=\"null\">very low</span> <span class=\"hps\" closure_uid_503514901=\"972\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"973\" wd=\"null\">the same industry</span><span closure_uid_503514901=\"974\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"975\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"976\" wd=\"null\">average</span> <span class=\"hps\" closure_uid_503514901=\"977\" wd=\"null\">price</span> <span class=\"hps\" closure_uid_503514901=\"978\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"979\" wd=\"null\">only</span> <span class=\"hps\" closure_uid_503514901=\"980\" wd=\"null\">half</span> <span class=\"hps\" closure_uid_503514901=\"981\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"982\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"983\" wd=\"null\">domestic</span> <span class=\"hps\" closure_uid_503514901=\"984\" wd=\"null\">domain name</span> <span class=\"hps\" closure_uid_503514901=\"985\" wd=\"null\">service</span><span closure_uid_503514901=\"986\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"987\" wd=\"null\">is</span> <span class=\"hps\" closure_uid_503514901=\"988\" wd=\"null\">a very</span> <span class=\"hps\" closure_uid_503514901=\"989\" wd=\"null\">good</span> <span class=\"hps\" closure_uid_503514901=\"990\" wd=\"null\">domain name service provider</span><span closure_uid_503514901=\"991\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"992\" wd=\"null\">for example,</span> <span class=\"hps\" closure_uid_503514901=\"993\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"994\" wd=\"null\">year of</span> <span class=\"hps\" closure_uid_503514901=\"995\" wd=\"null\">139</span> <span class=\"hps\" closure_uid_503514901=\"996\" wd=\"null\">million net</span> <span class=\"hps\" closure_uid_503514901=\"997\" wd=\"null\">registered</span> <span class=\"hps\" closure_uid_503514901=\"998\" wd=\"null\">com</span> <span class=\"hps\" closure_uid_503514901=\"999\" wd=\"null\">domain name</span> <span class=\"hps\" closure_uid_503514901=\"1000\" wd=\"null\">yuan</span><span closure_uid_503514901=\"1001\" wd=\"null\">, Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"1002\" wd=\"null\">minimum is only</span> <span class=\"hps\" closure_uid_503514901=\"1003\" wd=\"null\">$ 50.</span> <span class=\"hps\" closure_uid_503514901=\"1004\" wd=\"null\">Many</span> <span class=\"hps\" closure_uid_503514901=\"1005\" wd=\"null\">site owners</span> <span class=\"hps\" closure_uid_503514901=\"1006\" wd=\"null\">are using</span> <span class=\"hps\" closure_uid_503514901=\"1007\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"1008\" wd=\"null\">Domain Name Service</span><span closure_uid_503514901=\"1009\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1010\" wd=\"null\">Network</span> <span class=\"hps\" closure_uid_503514901=\"1011\" wd=\"null\">service providers</span> <span class=\"hps\" closure_uid_503514901=\"1012\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1013\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"1014\" wd=\"null\">well</span><span class=\"atn\" closure_uid_503514901=\"1015\" wd=\"null\">-</span><span closure_uid_503514901=\"1016\" wd=\"null\">known</span> <span class=\"hps\" closure_uid_503514901=\"1017\" wd=\"null\">domain registrar</span> <span class=\"hps\" closure_uid_503514901=\"1018\" wd=\"null\">illegal</span> <span class=\"hps\" closure_uid_503514901=\"1019\" wd=\"null\">shielding</span> <span class=\"hps\" closure_uid_503514901=\"1020\" wd=\"null\">alleged</span> <span class=\"hps\" closure_uid_503514901=\"1021\" wd=\"null\">unfair competition</span><span closure_uid_503514901=\"1022\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1023\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"1024\" wd=\"null\">accounted</span> <span class=\"hps\" closure_uid_503514901=\"1025\" wd=\"null\">for</span> <span class=\"hps\" closure_uid_503514901=\"1026\" wd=\"null\">nearly</span> <span class=\"hps\" closure_uid_503514901=\"1027\" wd=\"null\">32%</span> <span class=\"hps\" closure_uid_503514901=\"1028\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1029\" wd=\"null\">global market</span><span closure_uid_503514901=\"1030\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1031\" wd=\"null\">with other causes of</span> <span class=\"hps\" closure_uid_503514901=\"1032\" wd=\"null\">shielding</span> <span class=\"hps\" closure_uid_503514901=\"1033\" wd=\"null\">domestic</span><span closure_uid_503514901=\"1034\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1035\" wd=\"null\">overseas</span> <span class=\"hps\" closure_uid_503514901=\"1036\" wd=\"null\">Sancheng</span> <span class=\"hps\" closure_uid_503514901=\"1037\" wd=\"null\">website</span> <span class=\"hps\" closure_uid_503514901=\"1038\" wd=\"null\">in the country</span> <span class=\"hps\" closure_uid_503514901=\"1039\" wd=\"null\">can not be</span> <span class=\"hps\" closure_uid_503514901=\"1040\" wd=\"null\">normal</span> <span class=\"hps\" closure_uid_503514901=\"1041\" wd=\"null\">visit</span><span closure_uid_503514901=\"1042\" wd=\"null\">.</span><br closure_uid_503514901=\"1087\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1088\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1043\" wd=\"null\">Any use of</span> <span class=\"hps\" closure_uid_503514901=\"1044\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1045\" wd=\"null\">GoDaddy</span> <span class=\"hps\" closure_uid_503514901=\"1046\" wd=\"null\">DNS</span> <span class=\"hps\" closure_uid_503514901=\"1047\" wd=\"null\">server</span><span closure_uid_503514901=\"1048\" wd=\"null\">, there</span> <span class=\"hps\" closure_uid_503514901=\"1049\" wd=\"null\">may</span> <span class=\"hps\" closure_uid_503514901=\"1050\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"1051\" wd=\"null\">the wall</span><span closure_uid_503514901=\"1052\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1053\" wd=\"null\">Fortunately, only</span> <span class=\"hps\" closure_uid_503514901=\"1054\" wd=\"null\">DNS</span> <span class=\"hps\" closure_uid_503514901=\"1055\" wd=\"null\">shield,</span> <span class=\"hps\" closure_uid_503514901=\"1056\" wd=\"null\">can</span> <span class=\"hps\" closure_uid_503514901=\"1057\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"1058\" wd=\"null\">switched</span> <span class=\"hps\" closure_uid_503514901=\"1059\" wd=\"null\">from</span> <span class=\"hps\" closure_uid_503514901=\"1060\" wd=\"null\">Godaddy</span> <span class=\"hps\" closure_uid_503514901=\"1061\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1062\" wd=\"null\">DNSPod</span> <span class=\"hps\" closure_uid_503514901=\"1063\" wd=\"null\">host unknown</span> <span class=\"hps\" closure_uid_503514901=\"1064\" wd=\"null\">during</span> <span class=\"hps\" closure_uid_503514901=\"1065\" wd=\"null\">a few minutes</span><span closure_uid_503514901=\"1066\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1067\" wd=\"null\">Domestic</span> <span class=\"hps\" closure_uid_503514901=\"1068\" wd=\"null\">DNS</span> <span class=\"hps\" closure_uid_503514901=\"1069\" wd=\"null\">manner</span><span closure_uid_503514901=\"1070\" wd=\"null\">.</span><br closure_uid_503514901=\"1089\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1090\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1071\" wd=\"null\">Other</span> <span class=\"hps\" closure_uid_503514901=\"1072\" wd=\"null\">normal access</span> <span class=\"hps\" closure_uid_503514901=\"1073\" wd=\"null\">to modify</span> <span class=\"hps\" closure_uid_503514901=\"1074\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1075\" wd=\"null\">local DNS</span><span closure_uid_503514901=\"1076\" wd=\"null\">, try</span> <span class=\"hps\" closure_uid_503514901=\"1077\" wd=\"null\">Google</span> <span class=\"hps\" closure_uid_503514901=\"1078\" wd=\"null\">dns</span><span closure_uid_503514901=\"1079\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1080\" wd=\"null\">8.8.8.8</span><span closure_uid_503514901=\"1081\" wd=\"null\">.</span></p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 21:00:08',NULL,'9',NULL,'1',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('140','34',NULL,'1','website announcement 1',NULL,'<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 23:04:47',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('141','34',NULL,'1','website announcement 2',NULL,'<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 23:04:47',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('142','34',NULL,'1','website announcement 3',NULL,'<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 23:04:47',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('143','34',NULL,'1','website announcement 4',NULL,'<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 23:04:47',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('144','34',NULL,'1','website announcement 5',NULL,'<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-27 23:04:47',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('146','55',NULL,'1','阿迪达斯创意广告',NULL,NULL,'0',NULL,NULL,'http://www.tudou.com/programs/view/html5embed.action?type=0&code=dsSmyDrPf_U&lcode=&resourceId=0_06_05_99','0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 17:34:10',NULL,'21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('147','55',NULL,'1','和鞋社会',NULL,NULL,'0',NULL,NULL,'http://player.youku.com/embed/XNTAzODQ2MDA0','0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 18:06:04',NULL,'4',NULL,'9',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('148','56',NULL,'1','Adidas creative advertising','<iframe src=\"http://www.tudou.com/programs/view/html5embed.action?type=0&code=dsSmyDrPf_U&lcode=&resourceId=0_06_05_99\" allowtransparency=\"true\" scrolling=\"no\" border=\"0\" frameborder=\"0\" style=\"width:100%;height:300px;\"></iframe>',NULL,'0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 18:09:06',NULL,'2',NULL,'9',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('149','56',NULL,'1','Social and shoes','<iframe height=\"300\" width=\"100%\" src=\"http://player.youku.com/embed/XNTAzODQ2MDA0\" frameborder=0 allowfullscreen></iframe>',NULL,'0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 18:10:08',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('150','55',NULL,'1','聚美优品创意广告',NULL,'<p>\r\n	你只闻到我的香水，却没看的我的汗水，你有你的规则，我有我的选择，你否定我的现在，我决定我的未来，你嘲笑我一无所有，不配去爱，我可怜你总是等待，你可以轻视我们的年轻，我们会证明这是谁的时代，梦想是注定孤独的旅行，路上少不了质疑和嘲笑，但那又怎样，哪怕遍体鳞伤也要活的漂亮！</p>\r\n','0',NULL,NULL,'http://player.youku.com/embed/XNTE1Mzk4MDAw','0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 20:05:14',NULL,'31',NULL,'7',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('151','56',NULL,'1','Jumei Youpin creative advertising','<iframe height=\"300\" width=\"100%\" src=\"http://player.youku.com/embed/XNTE1Mzk4MDAw\" frameborder=0 allowfullscreen></iframe>','<p>\r\n	<span a=\"undefined\" c=\"4\" closure_uid_888351617=\"43\" id=\"result_box\" lang=\"en\" ud=\"null\"><span closure_uid_888351617=\"79\" ud=\"null\">Smell</span> <span class=\"hps\" closure_uid_888351617=\"80\" ud=\"null\">my</span> <span class=\"hps\" closure_uid_888351617=\"81\" ud=\"null\">perfume</span><span closure_uid_888351617=\"82\" ud=\"null\">, but can not</span> <span class=\"hps\" closure_uid_888351617=\"83\" ud=\"null\">see</span> <span class=\"hps\" closure_uid_888351617=\"84\" ud=\"null\">me</span> <span class=\"hps\" closure_uid_888351617=\"85\" ud=\"null\">sweat</span><span closure_uid_888351617=\"86\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"87\" ud=\"null\">you have your</span> <span class=\"hps\" closure_uid_888351617=\"88\" ud=\"null\">rules</span><span closure_uid_888351617=\"89\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"90\" ud=\"null\">I have</span> <span class=\"hps\" closure_uid_888351617=\"91\" ud=\"null\">my choice</span><span closure_uid_888351617=\"92\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"93\" ud=\"null\">you</span> <span class=\"hps\" closure_uid_888351617=\"94\" ud=\"null\">deny</span> <span class=\"hps\" closure_uid_888351617=\"95\" ud=\"null\">I</span> <span class=\"hps\" closure_uid_888351617=\"96\" ud=\"null\">now</span><span closure_uid_888351617=\"97\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"98\" ud=\"null\">I decided</span> <span class=\"hps\" closure_uid_888351617=\"99\" ud=\"null\">my future</span><span closure_uid_888351617=\"100\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"101\" ud=\"null\">you</span> <span class=\"hps\" closure_uid_888351617=\"102\" ud=\"null\">laugh at me</span> <span class=\"hps\" closure_uid_888351617=\"103\" ud=\"null\">nothing</span><span closure_uid_888351617=\"104\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"105\" ud=\"null\">unworthy of</span> <span class=\"hps\" closure_uid_888351617=\"106\" ud=\"null\">love</span><span closure_uid_888351617=\"107\" ud=\"null\">, I</span><span closure_uid_888351617=\"108\" ud=\"null\">poor</span> <span class=\"hps\" closure_uid_888351617=\"109\" ud=\"null\">you always</span> <span class=\"hps\" closure_uid_888351617=\"110\" ud=\"null\">wait</span><span closure_uid_888351617=\"111\" ud=\"null\">, you can</span> <span class=\"hps\" closure_uid_888351617=\"112\" ud=\"null\">despise</span> <span class=\"hps\" closure_uid_888351617=\"113\" ud=\"null\">our</span> <span class=\"hps\" closure_uid_888351617=\"114\" ud=\"null\">young</span><span closure_uid_888351617=\"115\" ud=\"null\">, we will</span> <span class=\"hps\" closure_uid_888351617=\"116\" ud=\"null\">prove that this is</span> <span class=\"hps\" closure_uid_888351617=\"117\" ud=\"null\">the</span> <span class=\"hps\" closure_uid_888351617=\"118\" ud=\"null\">era</span> <span class=\"hps\" closure_uid_888351617=\"119\" ud=\"null\">who</span><span closure_uid_888351617=\"120\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"121\" ud=\"null\">dream is</span> <span class=\"hps\" closure_uid_888351617=\"122\" ud=\"null\">destined</span> <span class=\"hps\" closure_uid_888351617=\"123\" ud=\"null\">lonely</span> <span class=\"hps\" closure_uid_888351617=\"124\" ud=\"null\">trip</span><span closure_uid_888351617=\"125\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"126\" ud=\"null\">road</span> <span class=\"hps\" closure_uid_888351617=\"127\" ud=\"null\">and</span> <span class=\"hps\" closure_uid_888351617=\"128\" ud=\"null\">ultimately</span> <span class=\"hps\" closure_uid_888351617=\"129\" ud=\"null\">questioned</span> <span class=\"hps\" closure_uid_888351617=\"130\" ud=\"null\">and ridiculed</span><span closure_uid_888351617=\"131\" ud=\"null\">,</span> <span class=\"hps\" closure_uid_888351617=\"132\" ud=\"null\">but so what</span><span closure_uid_888351617=\"133\" ud=\"null\">, even if</span> <span class=\"hps\" closure_uid_888351617=\"134\" ud=\"null\">have to live</span> <span class=\"hps\" closure_uid_888351617=\"135\" ud=\"null\">beautiful</span> <span class=\"hps\" closure_uid_888351617=\"136\" ud=\"null\">black and blue</span><span closure_uid_888351617=\"137\" ud=\"null\">!</span></span></p>\r\n','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-04-27 20:12:27',NULL,'1',NULL,'7',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('152','21',NULL,'1','联想、华为、小米新品拉货升温　面板厂、触控厂出货强劲',NULL,'近期联想、华为、小米等品牌厂接棒拉货，伴随终端品牌厂智能型手机及平板计算机全面启动拉货，带动上游相关面板、触控面板供应链业者近期订单量出现明显增幅，供应链出货开始增温。<br />\r\n<br />\r\n供应链业者透露，终端品牌厂积极开拓市占率，纷纷重装上阵，推动2014年下半终端品牌厂智能型手机及平板计算机新机可说是万箭齐发。终端品牌厂为了抢得市场先机，发挥兵贵神速的效果，也带动中小尺寸面板、触控面板等零组件需求上扬。<br />\r\n<br />\r\n事实上，除了智能型手机战场外，目前平板计算机已成为终端品牌厂另一个主战场，包括：苹果(Apple)、三星电子(Samsung Electronics)、索尼移动通信(Sony Mobile Communications)、宏达电、乐金电子(LG Electronics)、联想、华为、小米、华硕、宏碁等终端品牌厂均不落人后。<br />\r\n<br />\r\n放大 放大图片<br />\r\n终端品牌厂为抢得市场先机，也带动面板、触控面板等需求上扬。李建梁摄<br />\r\n供应链业者从近期订单来观察，自2014年第3季起，包括：联想、华为、小米等品牌厂拉货升温，在智能型手机、平板计算机新品备货需求下，品牌客户需求持续加温，带动相关供应链业者包括：友达、胜华、欧菲光、莱宝高科、超声电子等出货强劲，相关供应链业者忙著出货，以因应终端品牌厂客户需求。<br />\r\n<br />\r\n供应链业者认为，平板计算机已经不是一个高利润市场，平板计算机机种市场行情已经被打坏，价格偏高机种往往买气不振。以目前市场销售状况来看，高价机种未打中消费者的需求，销售不理想，牵动多数终端品牌厂只会将高价机种视为堆叠品牌形象、展现技术的「英雄机种」，仅有中低价机种才有潜力冲量，也导致中低价机种越来越多，这是消费市场需求所决定。<br />\r\n<br />\r\n另一方面，终端品牌厂竞推智能型手机、平板计算机、智能型手表、穿戴式装置等行动装置产品，推动薄膜式触控面板阵营势力持续崛起窜出，由于薄膜式触控面板的成本较低，相对具备价格竞争力，有助于终端品牌业者撙节成本，加上薄膜式触控面板适于大量生产，2014年在智能型手机及平板计算机市场版图仍占优势，可望主导中低阶智能型手机、中低阶平板计算机、智能型手表、穿戴式装置等市场。<br />\r\n<br />\r\nDIGITIMES Research表示，大陆智能型手机业者新霸主小米，2014年第2季因入门机种红米机销售长红，在大陆本土市场出货开红盘，维持出货千万支以上水平；酷派则保持4G产品领先地位，本季出货量达980万支排名第二。其它大陆手机品牌厂则受制于零组件问题，芯片厂商4G应用处理器推迟至2014年第3季推出影响，使得大陆手机品牌厂4G新机款推出不多，且售价多半在人民币千元以上，第2季市场热络荣景未如产业链预期出现。<br />\r\n<br />\r\n国际手机品牌厂则受到大陆手机品牌厂压制，由于大陆手机品牌厂采取低价策略，旗下高性价比机种如雨后春笋般大量推出，一般消费者多半希望能用更低价格购入规格与使用体验近似的智能型手机，尤其冲击、影响三星为甚，三星在大陆手机市场出货大减。<br />\r\n<br />\r\n根据DIGITIMES Research估计，2014年第2季大陆手机市场受平价4G机种未能普及影响，因此，大陆手机市场不如预期活络，大陆手机品牌厂部分因产品转换，不得不牺牲3G机种出货，虽然大陆一线手机品牌厂采取次品牌策略，其高性价比机种销售表现不俗，二线手机品牌厂销量未减，但仅能稍微挽回颓势，与2014年第1季相比，大陆智能型手机市场出货量仅成长约4.8%，年增率亦只有约4.4%。<br />\r\n<br />\r\n展望2014年下半，上游芯片厂商4G应用处理器供应无虞，各业者新机终于得以顺利上市，加上电信商为达成原先预期4G终端销售目标，放宽3模机种限制、加强补贴力道，并提供更优惠的4G费率吸引消费者升级，DIGITIMES Research预估，第3季与第4季出货分别达1亿支与1.12亿支。','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('153','21',NULL,'1','大陆手机厂扩大蚕食市占　国际大厂下半年陷苦战',NULL,'大陆智能型手机厂凭借在中低价机种强力攻势，在全球市场快速崛起，近期包括三星电子(Samsung Electronics)、索尼行动(Sony Mobile)及宏达电等国际手机大厂，对于2014年下半展望都不甚乐观，由于大陆手机厂持续增强在中低阶市场火力，扩大蚕食市占版图，加上苹果(Apple)新款大尺寸iPhone呼之欲出，Android阵营国际手机大厂下半年都将陷入苦战，市占率恐持续下滑。<br />\r\n<br />\r\n供应链业者表示，大陆手机厂快速崛起，包括华为、联想、小米均已挤入全球智能型手机前5强，且市占率都持续提升，反观乐金、索尼行动已退出榜外，市占率亦出现萎缩，由于大陆手机市场竞争格局不易扭转，加上大陆手机厂在海外市场仍有很大成长空间，业界预期大陆手机厂将持续强势蚕食市占版图。<br />\r\n<br />\r\n放大 放大图片<br />\r\n近期包括三星、索尼行动及宏达电等国际手机大厂对于2014年下半展望都不甚乐观。李建梁摄<br />\r\n放大 放大图片<br />\r\n&nbsp;&nbsp;<br />\r\nAndroid阵营国际手机大厂出货表现<br />\r\n近期国际手机大厂包括三星、索尼行动、宏达电财报表现都不理想，对于第3季、甚至下半年营运展望都不甚乐观，其中，三星受到Galaxy S5销售不如预期，中低阶机种库存偏高影响，营收与获利均明显缩水，全球市占率从原本逾3成持续下滑至约25%，全球手机龙头光环明显失色。<br />\r\n<br />\r\n索尼行动虽然Xperia Z2受到不少好评，中低阶机种亦有佳作，然因供应链供货松动，导致高阶机种供货不足，加上在大陆等新兴市场节节败退，出货量不增反减，不仅移动通信部门连续两季亏损，还调降年度出货目标，从5,000万支下修到4,300万支。<br />\r\n<br />\r\n宏达电第2季营收目标勉强达成，并顺利转亏为盈，然对于第3季展望相当保守，一改原本预期全年营运逐季走高说法，显示宏达电在欧美市场业绩未见明显起色，加上在大陆与印度等新兴市场遭遇强势挑战，单季出货量已缩水至约500万支，距离前10大手机品牌愈来愈遥远。<br />\r\n<br />\r\n至于乐金第2季财报表现虽不差，在新一代旗舰手机G3与中低阶L III系列机种带动下，单季手机出货创1,450万支历史新高，与联想、小米在伯仲之间，但乐金同样对于下半年手机市场竞争感到很大压力，单季获利恐将昙花一现。<br />\r\n<br />\r\n对于三星、索尼、乐金与宏达电等国际手机大厂而言，不仅要面临市占保卫战，还要注意获利下滑、甚至亏损问题，尽管下半年各家Android手机厂仍有新款高阶机种推出，亦会在中低阶市场全力反击，但面对大陆厂商以高性价比机种蚕食市占，加上苹果大尺寸iPhone将持续鲸吞地盘，下半年恐将陷入苦战。','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('154','21',NULL,'1','大陆手机供应链扩大重整　中小型厂恐现淘汰潮',NULL,'近期大陆智能型手机上游供应链频传出厂商倒闭消息，供应链业者指出，由于大陆市场资金持续紧缩，手机上游零组件厂面临资金短缺冲击，加上零组件市场供过于求，供应链业者生存压力大增，业界纷预期2014年下半手机上游供应链恐持续进行大洗牌，整并风潮呈现山雨欲来之势，中小型厂商恐难逃新一波的淘汰赛。<br />\r\n<br />\r\n手机竞争趋烈　冲击上游供应链<br />\r\n<br />\r\n近期大陆手机上游厂商如维展光电等液晶模块厂，以及包括光学材料厂、终端手机及平板计算机方案商，均传出歇业消息，供应链业者表示，大陆手机供应链面临资金短缺及零组件市场供过于求影响，营运压力持续扩大，尤其大陆手机市场竞争愈益激烈，不少手机厂在市场上遭遇乱流，牵动上游供应商亦陷入困境。<br />\r\n<br />\r\n放大 放大图片<br />\r\n大陆手机市场争夺战激烈开打，整个手机供应链重整风潮山雨欲来。图为大陆手机销售通路景况。李建梁摄<br />\r\n放大 放大图片<br />\r\n&nbsp;&nbsp;<br />\r\n大陆触控面板供应链集成动向<br />\r\n大陆手机触控面板厂透露，全球手机市场竞争趋烈，市场拥挤程度远超过业界想象，不仅手机终端市场战火延烧，使得手机零组件价格压力加剧，加上零组件大厂频发动价格攻势抢市占，整个市场秩序大乱，手机零组件厂在制造、研发及库存压力大增，处于辛苦经营状态，中小型厂商处境更加困难，业者预期手机供应链恐再度大洗牌，市场版图将持续重整。<br />\r\n<br />\r\n手机业者指出，中小型供应链业者在中大型厂商强力排挤下，不仅产品很难差异化，中小型厂商势力亦将每况愈下，由于技术基础及经济规模明显不足，手机上游中小型厂商面对淘汰赛压力将愈来愈大。<br />\r\n<br />\r\n触控面板掀整并风　中小型厂难生存<br />\r\n<br />\r\n值得注意的是，大陆手机供应链动荡不安，不仅造成手机零组件厂市场版图大风吹，触控面板供应链更弥漫一股整并风潮，中大型触控厂商持续招兵买马，积极拉升战力，象是大陆前三大玻璃式投射电容触控传感器厂长信科技合并触控模块厂德普特，收购既有模块厂产能，至于大陆前三大保护玻璃厂星星科技则收购触控模块厂深越光电，进行上、下游一条鞭垂直集成。<br />\r\n<br />\r\n触控面板厂江西合力泰则是透过与联合化工合并，顺利取得股票上市入场券。另外，原为台资的触控面板厂牧东光电，由于触控产品价格竞争激烈，逐渐失去市场著力点，决议处分子公司Mutto Optronics Group Limited 100%股权，拱手让出触控面板事业，牧东光电台湾股东认赔出场，透过股权转移，由香港东山精密联合光电入主牧东光电苏州生产基地。<br />\r\n<br />\r\n事实上，触控面板产业大格局态势已逐渐形成，江西合力泰董事长文开福坦言，近年来触控产业资本集成活跃，从资金、资源配套等，构成全新的组合，包括上市与非上市公司之间的集成，中小型厂商资源集成，是个很好的趋势，长期对于触控产业竞局是良性发展，但对于中小型厂商未来生存空间恐会比较受限。','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('155','21',NULL,'1','中国手机市场发展趋势：本地厂商扮演主角',NULL,'相对于台湾，中国大陆手机产业链虽然发展得较晚，不过目前产业链上中下游已堪称相当齐备。在上游之关键芯片、周边零组件、下游之设计制造，和品牌等产业链环节，均有众多厂商投入。在关键芯片方面，又以基频芯片和应用处理器发展较快，前者包含展讯、联芯，后者包含展讯、海思等厂商。其中，展讯在2013年在中国大陆TD-SCDMA市场获得了70%的占有率，并开始着重研发WCDMA产品，在基频芯片方面实力也较强。在Samsung在中国和中国移动合作推出的产品中，大多数都将展讯的芯片作为标配。联芯则有大唐电信(600198,股吧)子公司的背景，目前的产品开发著重在整合NFC和3G功能的平板计算机上，和其它竞争者形成差异化。整体而言，由于目前中国大陆主流手机产品均采用turn-key解决方案，所以多采用基频和应用处理器整合的解决方案。<br />\r\n<br />\r\n图一 中国大陆手机产业链<br />\r\n在制造业者方面，受惠于近年来中国大陆手机品牌厂商于全球市占明显成长，并将代工订单委由本地供应链，亦催化出众多制造业者，其中又可分为三种不同的商业模式，包含自行设计、委托设计和生产(IDH/ODM)，以及委托其它公司生产(EMS)。其中较为代表性的业者，在委托设计和生产有闻泰、上海华勤通讯、龙旗、晨讯科技等。在EMS凿有BYD(比亚迪(002594,股吧))。目前，中国大陆主要品牌厂商，如华为、中兴、联想和酷派，和上述大型委托设计公司合作行之有年，不过大型品牌委托设计公司的订单多为中低阶产品，产品利润较高阶来得小，随之中国大陆委托设计公司亦将触角延伸到海外客户，借由提供海外客户PCBA及整机ODM来提高营收。<br />\r\n在品牌业务发展方面，中国大陆品牌业者增加快速，其中华为、中兴等大型厂商海外市占逐渐成长，天语、酷派、小米等二梯队业者，于本地市场亦取得佳绩，带动了中国大陆品牌业务的产业活跃度。2013年全球智能型手机品牌市占中，中国厂商就占了四家(联想、华为、中兴、酷派，第十一名为TCL)。其中，也由于中国大陆本地市场品牌厂商在低价高规市场厮杀激烈，并看准新兴市场手机需求强劲，中国大陆品牌厂商纷纷加强新兴市场之布局。<br />\r\n二、中国大陆手机销售市场分析<br />\r\n2013年中国大陆手机销售市场，在智能手机销售快速发展下，智能手机比重由快速攀升，带动中国大陆手机产值成长。其中，智能手机朝向高性能(大屏幕、高速CPU)等方向发展，因此换购手机的需求也促使中国大陆手机产销售值进一步成长，2013年销售金额达到约621亿美元，相较前一年成长约35.8%。<br />\r\n展望2014年中国大陆手机销售市场展望，预估智能手机将提升至88%，预估将带动产值734亿美元，较2013年成长约18.4%。不过值得注意的是，2014年整体市场主流产品将进一步往低价化发展，与2013之前的目标市场恰好相反，其中，中小城市以及农村用户，由低收入人群(农民工、儿童、主妇、老人等)的普及将成为市场推动主要力量。<br />\r\n三、中国大陆重要手机厂商近期发展动态<br />\r\n(一)华为：2013年华为在中国手机市场排名第三。华为的手机业务销售开始于2003年，初始手机是作为和核心基地台产品搭配销售的廉价产品，经过数年发展，在2009年华为凭借在海外市场推出IDEOS智能手机，以及之后Vision和Honor等品牌的推出，开始打响产品知名度，市占逐渐成长。在市场策略上，华为采取和海外运营商合作的方式推动业务，目前已和150个以上国家和地区的500多家运营商展开合作，借由电信客制化低价手机在国际市场做销售。目前，华为已经在日本开展LTE智能手机的销售。也由于近来华为在北美市场业务推动不如预期，近一年华为海外业务重心已转为欧洲市场，借由赞助德国、意大利、西班牙等足球比赛广告来打响知名度。此外，随着中国手机在电子商务销售平台销售量，因为电子商务管道销售成本较低而逐步增加，华为亦积极开拓电商销售管道，如2014年5月发布之P7，就同步在华为商城、苏宁易购、国美在线等七大店商平台同步销售。<br />\r\n(二) 中兴：中兴通讯(000063,股吧)在2002年开始发展行动终端产品，从2005年开始，为了配合海外市场系统基地台的销售，中兴开始涉入行动产品业务。随着行动终端市场需求扩大，2005年开始在印度、巴基斯坦、委内瑞拉和巴西等建造成立工厂。整体而言，在2011年以前，中兴的手机业务是以低阶产品为主，中兴透过与国际电信营运商合作销售客制化低价机种，已逐渐在北美、欧洲与拉丁美洲等地市场站稳脚步。而2011年开始随着中兴在海外市场提供LTE系统解决方案，并于2012年发布Nubia品牌，中兴手机业务开始走向高阶路线。<br />\r\n在智能手机的发展方面，中兴在2011到2012年是以美国和中国市场为主，凭借CDMA手机取得市占第四的排名。2013年以后，中兴亦加大品牌的经营，包含赞助NBA火箭队，以及加强在BestBuy、Walmart等流售通路的经营。2013全球智能手机排名第七(4.0%)，2013年生产约4,000万支智能手机，2014年出货目标为6,000万支。<br />\r\n(三) 联想：2013 年中国大陆手机品牌，排名第一为Samsung(21.7%)，其后本地品牌联想、华为、酷派等分列第二、三名(华为和酷派市占相同，均为7.1%)。其中，联想在2012~2013年的品牌市占成长约2.7%，来到2013年的9.1%，一跃成为中国大陆手机的第一大本土品牌，为本土品牌当中成长幅度较大者。2012年开始联想的市占就出现快速成长，其A系列低阶手机扮演不可或缺的角色，例如当时低阶入门手机A278t，配备展讯SC8810T、3.5寸显示器，以当时最低价600元人民币在市场上销售，达到500万台的出货量。对照中国移动2012年订制机种采购量约为6,000万台，联想单一款机型就占了十分之一。2013年联想更并购Google旗下的Motorola手机部门，让全球智能手机市占成长至第三名，希望借此进军欧美市场、中东非洲等新兴市场。<br />\r\n(四) 小米：小米自2010年成立以来，3年多来成长快速，2013年全球智能手机排名第十二(和天语同列)。小米在智能手机产品推出前，先投入MIUI开发，借此培育出基于Android系统开发出之操作系统，系统并支持其它手机产品，培育有一票死忠粉丝。为了将MIUI的软件功能体现在硬件上，随后小米才在2011年8月推出首款智能手机，售价人民币1,999元，在年轻族群大受欢迎，进而打开市场知名度。<br />\r\n分析小米产品线十分简单，以当初第一代手机M1来说，基本上是在人民币2,000之下提供低价高配的产品，虽然机型不多，以基本机型为主，产品推出之后时常通过对现有产品改款，以及推出支持不同通信标准的手机来进行改版，并凭借用户论坛的经营，收集用户回馈，不断优化使用者体验，进而维持手机的性能优化，型塑良好的使用者口碑，从而制造之高回购率(42%，2013年自行统计资料)。在平台的采用上，小米的产品过往有优先采用Qualcomm平台的情形，包含2011年采用MSM8260、2012年采用APQ8064。不过在2013年推出的人民币799元售价红米机，则是采用联发科MT6589T产品。随着小米在2013年下半年礼聘Google Android高层 Hugo Barra入职，预计小米会加强对于欧美市场的经营。','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('156','21',NULL,'1','公司参加2014年美国国际电子产品订货会EDS',NULL,'由美国电子元器件、组件及材料协会、电子产品代理商协会及电子产品分销商协会举办的&ldquo;2014年美国国际电子产品订货会EDS&rdquo; 已于2014年5月8日在美国拉斯维加斯成功落幕。此展会仅限专业人士参观，主要观众都来自北美电子产品制造商、供应商、代理商、分销商、采购商。EDS展会是国内电子产品企业开拓美国市场，联系北美各地分销商，寻找代理商、宣传企业、扩大影响的最佳平台。宇顺电子工业品事业部在总经理蒋尔琪带领下如期参加了2014年EDS,首次将业务聚焦北美市场，在本次展会上，我们总计共接洽了专业代理商20多家，并与其中5家现场确立了业务合作意向，相信2014EDS是宇顺工业品事业部走向北美市场的起点，美国市场也有望成为宇顺工业品事业部未来主要的业务增长区域。','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('157','24',NULL,'1','AZ8690便携式PH计',NULL,NULL,'0','/Upload/product/a3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:26:02',NULL,'1',NULL,NULL,'200','C333',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('158','24',NULL,'1','高精度PH计',NULL,NULL,'0','/Upload/product/a4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:26:02',NULL,'12',NULL,NULL,'300','C332332',NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('159','41',NULL,'1','The company in 2014 American international electronic product orders will be EDS',NULL,'By American electronic components, assemblies and materials, electronic products and electronic products distributors, agents association association &ldquo; 2014 American international electronic product orders will be EDS&rdquo; in May 8, 2014 in Las Vegas American successfully. This exhibition only professional visitors from North America, the main audience of electronic products manufacturers, suppliers, distributors, agents, purchasers. EDS exhibition is the electronic products enterprises to open up the market USA links across North America, distributors, agents, promotion of enterprise, expand the influence of the best platform. Yu Shun Electronics Industry Ministry of industry in the general manager under the leadership of Jiang Erqi scheduled to participate in the 2014 EDS, will be the first to focus on the North American market, in this exhibition, we have a total of more than 20 approached professional agents, and 5 of them live to establish business cooperation, I believe 2014EDS is the quality of industrial products division to the starting point the North American market, the market is expected to become America Shun Industrial Division, the next major growth area.','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('160','41',NULL,'1','The development trend of mobile phone market China: local manufacturers play a leading role',NULL,'Compared with Taiwan, mainland mobile phone industry chain development China although late, but now the midstream and downstream industry chain is very complete. In the design of the key chip manufacturing, upstream, downstream of the peripheral components, and brand and other aspects of the industry chain, many manufacturers have invested. In the key chip, the baseband chip and application processor development faster, the former includes Spreadtrum, with the core, which contains other vendors Hass, spreadtrum. Among them, Spreadtrum in 2013 received a 70% share in the Chinese, TD-SCDMA market, and began to focus on research and development of WCDMA products, in the baseband chip power is strong. In the Samsung in the Chinese and China Mobile to launch products, most of them will Spreadtrum chip as standard. The core is the Datang Telecom (600198, stock it), the background, current development of tablet computer products with an emphasis on the integration of NFC and 3G function, and the other competitors differentiation. Overall, due to the current mainstream mobile phone products, Chinese were treated by turn-key solution, so the solution of fundamental and application processor integration.<br />A Chinese mainland mobile phone industry chain<br />In the manufacturing industry, in recent years, thanks to the China mobile phone brands in global market share to grow significantly, and OEM orders are appointed by the local supply chain, but also by many manufacturers, which can be divided into three kinds of different business models, including design, client design and production (IDH/ODM) and other companies, commissioned the production (EMS). One of the most representative of the industry, have heard, Shanghai Huaqin communication, dragon flag, SIM technology in commissioned the design and production. BYD EMS (BYD chisel in (002594, stock it)). At present, Chinese mainland brand manufacturers, such as Lenovo, ZTE, Coolpad and Huawei, for the cooperation and the large commissioned the design firms, but the large brand design company commissioned the orders are mostly low-end products, product margins higher order is small, it Chinese, commissioned to design the company will expand to overseas customers, by providing overseas customer PCBA and the ODM to increase revenue.<br />In the aspect of the brand business development, the rapid increase in Chinese mainland brand industry, which Huawei, ZTE and other large manufacturers overseas market share has grown, Tianyu, cool, millet and other two echelon industry, in the local market also achieved success, led to the Chinese brand business, industrial activity. In 2013 the global smart mobile phone brand market share, China manufacturers accounted for four (Huawei, ZTE, Lenovo, cool, eleventh were TCL). Among them, but also because of Chinese local market brands in the low market fierce fighting, and saw strong demand in emerging markets, mobile phone, China brand manufacturers have to strengthen the layout of the emerging market.<br />Analysis of two, mobile phone sales market, China<br />In 2013, China mobile phone sales market, the rapid development of intelligent mobile phone sales, the proportion of smart mobile phone by the rapid rise of mobile phone Chinese, drive, output growth. The intelligent mobile phone, toward the high performance (large screen, high speed CPU) direction, so the purchase of mobile phone demand also contributed to Chinese, mobile phone sales value for further growth, 2013 sales of about $62100000000, compared to the previous year growth of approximately 35.8%.<br />Prospect in 2014, mobile phone sales market forecast China, intelligent mobile phone will increase to 88%, is expected to drive the value of $73400000000, compared with 2013 growth of about 18.4%. But it is worth noting that, in 2014 the overall market mainstream products will be further to the development of low-cost, on the contrary, and before the 2013 target market, small and medium-sized city and rural users, by lower income groups (children, migrant workers, housewives, the elderly and the popularity of the market) will become the main driving force.<br />The recent development of dynamic, Chinese important mobile phone manufacturers, three<br />(a) Huawei: 2013 mobile phone market ranked third in the Chinese Huawei. Huawei mobile phone sales began in 2003, the original mobile phone as the core and base station products sell cheap products, after several years of development, in 2009 with the launch of IDEOS smart mobile phone Huawei in overseas markets, as well as Vision and Honor brand launch, start started product visibility, market share gradually grow. In market strategy, Huawei take cooperation and overseas operators to promote business, currently more than 500 operators and more than 150 countries and regions to cooperate, by telecom customized mobile phone sales in the international market price. At present, Huawei has been carried out in Japan LTE intelligent mobile phone sales. Also due to the recent Huawei in the North American market business promotion as expected, nearly a year to focus Huawei overseas business has turned into the European market, Germany, Italy, sponsored by the Spanish football game started advertising awareness. In addition, with the mobile phone China in e-commerce sales platform sales, because the cost of e-commerce sales pipeline is low and gradually increased, Huawei also actively open up the electricity supplier sales channels, such as the 2014 May release of P7, the synchronization in the Huawei mall, Tesco Suning, Gome online store sales platform synchronization etc..<br />(two): ZTE ZTE (000063, stock it) in 2002 began the development of mobile terminal products, from the beginning of 2005, in order to cooperate with the overseas market system base station sales, ZTE began involvement of mobile products business. With the mobile terminal market demand, in 2005 began to set up factories in India, Pakistan, Venezuela and Brazil construction. Overall, in 2011, ZTE mobile phone business is based on low order products, ZTE telecom operators to cooperate with international sales of customized price models, has been in North America, Europe and Latin America market a firm pace. Beginning in 2011 with the resurgence in the overseas market to provide LTE system solutions, and released the Nubia brand in 2012, ZTE mobile phone business to high order path.<br />In the development of smart mobile phone, ZTE in 2011 to 2012 in America and China market, by virtue of CDMA mobile phone, accounting for fourth of the ranking. Since 2013, ZTE also increase the brand management, including sponsorship NBA rockets, and the strengthening of the BestBuy, Walmart current sales channel management. 2013 the global intelligent mobile phone ranked seventh (4%), the 2013 production of about 40000000 intelligent mobile phone shipments in 2014, the target is 60000000.<br />(three): in 2013, lenovo mobile phone brand China, ranking first for Samsung (21.7%), followed by local brands, Lenovo, cool second, Huawei equal three (Huawei and cool, for the same, both 7.1%). Among them, Lenovo accounted for about 2.7% years in the growth of 2012~2013 brand, to 9.1% in 2013, became the first domestic mobile phone brand, China, growth rate is larger local brands. Starting in 2012, Lenovo accounted for there is rapid growth, the low order A series mobile phone play an indispensable role, such as the low order entry of A278t mobile phone, equipped with Spreadtrum SC8810T, 3.5 inch display, at the lowest price 600 yuan of sales in the market, reached 5000000 units shipped. In 2012 China Mobile custom machine control purchase quantity is about 60000000 units, the association of single models accounted for 1/10. In 2013 Lenovo acquisition of Google\'s Motorola mobile phone sector, so that the global intelligent mobile phone market share up to third, hoping to enter the European market in emerging markets, such as the Middle East Africa.<br />Millet: millet (four) since its inception in 2010, more than 3 years of rapid growth, in 2013 the global smart mobile phone number twelfth (and the same column). Millet smart mobile phone products before the launch, the first investment of MIUI development, to cultivate the operating system developed based on Android system, and support for other mobile phone products, cultivate a loyal fans. In order to apply the MIUI software function is reflected in the hardware, then millet in 2011 August launched the first intelligent mobile phone, priced at 1999 yuan, welcome in the young greatly, and open the market popularity.<br />Analysis of millet product line is very simple, the first generation of mobile phone M1, basically is to provide high with cheap products in 2000 yuan, although not to the basic models, models, product launch is often based on the existing products modification, and launched to support different communication standards for mobile phone version, and by virtue of the management of user forum, collect user feedback, constantly optimize the user experience, in order to maintain the performance optimization of the mobile phone, forming good user reputation, high repurchase rate to manufacturing (42%, 2013 to statistics). In the platform, millet products in the past to give priority to the use of Qualcomm platform, including the MSM8260, the APQ8064 in 2012 2011. But in the 2013 launch of the 799 yuan price of red rice machine, is the use of MediaTek MT6589T products. With the Google Android Hugo Barra millet with top entry in the second half of 2013, is expected to European and American markets for millet will strengthen management.','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('161','41',NULL,'1','China mobile phone supply chain expansion of reforming small factory fear is now out of the tide',NULL,'Recently, the intelligent mobile phone supply chain upstream manufacturers news coming down the supply chain, the industry pointed out that, due to the mainland market funds continued to tighten, mobile phone upstream component factory is facing a shortage of funds, coupled with the components market pile up in excess of requirement, supply chain industry survival pressure increase, the industry is expected to continue to have a major reshuffle fear of semi mobile phone upstream in 2014 the whole supply chain, and fashion show atmosphere of the situation, small and medium-sized manufacturers will not escape a new wave of knockout. <br / >\n<br / >\nMobile phone competition increasingly fierce shock upstream supply chain <br / >\n<br / >\nRecently, mobile phone manufacturers such as dimensional upstream exhibition photoelectric LCD module plant, including optical material factory, mobile phone and tablet computer solution providers, are spread out a message, the supply chain industry, supply chain, mobile phone market is facing a shortage of funds and the components of pile up in excess of requirement, operating pressure continues to expand, more and more mobile phone market, especially the competition intense, many mobile phone factory encountered turbulence in the market, affecting the upstream suppliers also in trouble. <br / >\n<br / >\nAmplification of <br / >\nMobile phone market, fierce battle broke out, the mobile phone supply chain restructuring wave atmosphere. For mobile phone sales channels, \". Photo by Li Jianliang / <br\nAmplification of <br / >\n&nbsp; &nbsp; <br / >\nTouch panel integrated supply chain trends, <br / >\nChina mobile phone touch panel plant sources, the global mobile phone market, fierce competition in the market, the degree of congestion is far more than the industry expected, not only mobile phone terminal market from a war, the mobile phone components price pressures, coupled with the frequency components manufacturers price offensive grab market share, the market out of order, mobile phone components factory in manufacturing, research and development and the inventory pressure, in a hard business, small and medium companies the situation is more difficult, the industry expects mobile phone supply chain will once again reshuffle, the market will continue to re layout. <br / >\n<br / >\nMobile phone industry pointed out that, in the supply chain industry in large scale manufacturers strong crowding out, not only the product is difficult to differentiate, small and medium-sized manufacturers will also go from bad to worse because of power, technology and economy of scale is obviously insufficient, small mobile phone manufacturers upstream face elimination pressure will be more and more big. <br / >\n<br / >\nTouch panel and lift the whole wind small factory to survive <br / >\n<br / >\nIt is worth noting that, mobile phone chain, not only caused by the turbulent, mobile phone accessories plant layout wind touch panel market, supply chain integration and the trend of a more diffuse, large touch manufacturers continued to raise or enlarge an army, positive for power, like the mainland\'s top three glass projected capacitive touch sensor technology combined with touch module plant factory manager Depp, acquired both module factory capacity, as China top three protection glass factory star technology acquisition of Toptouch touch module plant, on the downstream of a whip, vertical integration. <br / >\n<br / >\nTouch panel factory Jiangxi helitai is through mergers and joint chemical, successfully get tickets listed stock. In addition, originally funded the touch panel factory Mutto optical touch, due to intense price competition, gradually losing market focus, resolution at Mutto Optronics Group Limited company 100% stake, to hand over the touch panel industry, Taiwan agreed to compensate shareholders Mutto optical field, through the equity transfer, Hongkong Dongshan precision optoelectronic in animal husbandry East photoelectric production base in Suzhou. <br / >\n<br / >\nIn fact, the situation of touch panel industry pattern has been gradually formed, Jiangxi helitai chairman Wen Kaifu frankly, in recent years the touch industry capital integrated active from the capital, resources, facilities, a new combination, including the integration between listed and non-listed company, small and medium-sized manufacturers resources integration, is a good trend, the long-term to touch industry competition is benign development, but for small and medium-sized manufacturers future living space may be limited.','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('162','41',NULL,'1','Mobile phone factory expansion, encroachment of large international companies in the second half of ',NULL,'The intelligent mobile phone, in the low-cost model plant with strong offensive, the rapid rise in the global market, including Samsung Electronics recently (Samsung Electronics), Sony action (Sony Mobile) and HTC electric and other international mobile phone manufacturers, for the second half of 2014 prospects are not very optimistic, because the mainland mobile phone factory continued to improve in the low-end market fire, to expand on, layout, coupled with Apple\'s (Apple) new large size iPhone to Android international mobile phone manufacturers camp, the second half of the year will struggle, fear of market share continued to decline. <br / >\n<br / >\nSupply chain industry, the rapid rise of mobile phone factory in mainland China, including Huawei, Lenovo, millet have to squeeze into the top 5 global smart mobile phone, and the market share has continued to improve, in contrast, LG, Sony action have withdrawn from the list, market share is shrinking, due to competition, mobile phone market is difficult to reverse, mobile phone factory, and there is still much room for growth in overseas markets, the industry is expected, mobile phone factory will continue to erode market share strong layout. <br / >\n<br / >\nAmplification of <br / >\nRecently, including Samsung, SONY and HTC and other international mobile phone manufacturers for the second half of 2014 are not very optimistic about the prospects. Photo by Li Jianliang / <br\nAmplification of <br / >\n&nbsp; &nbsp; <br / >\nAndroid international mobile phone manufacturers shipped camp <br / >\nThe recent international mobile phone manufacturers including Samsung, SONY, HTC earnings performance is not ideal, for the third quarter, and even the second half of the operation are not very optimistic about the prospects, the Samsung Galaxy S5 sales than expected, the low order models of high inventory, sales and profits have shrunk significantly, the global market share of more than 3 from the original to continue to decline to about 25%, the leading global mobile phone rings was pale. <br / >\n<br / >\nAlthough SONY Xperia Z2 received a lot of praise action, low order models are excellent, but because of supply chain and supply loose, resulting in higher order models lack of supply, coupled with emerging markets in mainland China retreat, volume reduced, not only for the two mobile communication department Ji Kuisun, also lowered the annual shipment goal, from 50000000 under the revised to 43000000. <br / >\n<br / >\nHTC electric revenue in the second quarter just to reach the target, and the successful turnaround, however, for the third quarter outlook is quite conservative, change the expected full year operating higher quarterly basis, HTC power in Europe and the United States market performance shows no significant improvement, and in emerging markets, and India suffered a strong challenge, single season shipments volume has shrunk to about 5000000, from the top 10 mobile phone brand is more and more far. <br / >\n<br / >\nAs for Le Jin\'s second quarter earnings performance is not bad, in the new generation of its flagship mobile phone G3 and the low order L III series models driven by single season shipments hit a record high of 14500000, Lenovo, millet in about the same, but Le Jin also for the second half of the competition of the mobile market feel great pressure, single quarter profit may be a flash in the pan. <br / >\n<br / >\nFor Samsung, SONY, LG, HTC and other international mobile phone manufacturers, not only have to face the market share battle, but also pay attention to the profit decline, and even losses, although the second half of the Android mobile phone factory is still a new high-end models launched, will in the low-end market to fight back, but the face of the mainland manufacturers in high cost model on market share, coupled with Apple\'s large size iPhone will continue in the second half of the year by site, may be struggling.','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('163','41',NULL,'1','Lenovo, millet new pull goods, Huawei heating panel factory, factory shipments strong touch',NULL,'Recently, Lenovo, millet and other brands, Huawei factory over to pull goods, with the terminal brand factory intelligent mobile phone and tablet computer started to pull goods, driven by the upstream panel, touch panel supply chain industry the recent significant increase in orders, shipments began warming in supply chain. <br / >\n<br / >\nSupply chain industry sources, terminal brand factory, and actively explore the market share, have reloaded the second half of 2014, to promote the terminal brand factory intelligent mobile phone and tablet computer new machine is the thousand arrows shot. Terminal brand factory in order to seize market opportunities, play Speed is the soldier\'s asset. effect, has also led to the development of small and medium size panel, touch panel and other components of demand to rise. <br / >\n<br / >\nIn fact, in addition to intelligent mobile phone outside of the battlefield, the tablet computer terminal brand factory has become the main battlefield of another, including: Apple (Apple), Samsung Electronics (Samsung Electronics), Sony mobile communication (Sony Mobile Communications), HTC electric, Le Jindian (Electronics LG), Lenovo, millet, Asus, Huawei so, Acer terminal brand factory shall not fall behind. <br / >\n<br / >\nAmplification of <br / >\nTerminal brand factory to seize market opportunities, but also drives the panel, touch panel and so on demand to rise. Photo by Li Jianliang / <br\nSupply chain industry to observe from the recent orders, including: since the third quarter of 2014, Lenovo, millet, Huawei brand factory pull goods rise, in the intelligent mobile phone, tablet computer products demand, brand customer demand continued warming, driven supply chain industry include: AU Optronics, Shenghua, Ou Feiguang, Gaoke LEYBOLD ultrasonic Electronics shipments, the strong, the supply chain industry busy shipping terminal brand factory, due to customer demand. <br / >\n<br / >\nSupply chain industry think, tablet computers have not a high profit market, tablet machine market has been broken, the high price models often - vibration. In the current market conditions, high priced models did not hit the consumer demand, sales are not ideal, affecting most terminal brand factory will only expensive aircraft as stacked brand image, display technology \"hero model\", only low-cost models that have the potential to impulse, also induced the low-cost model more and more, this is decided the consumer market demand. <br / >\n<br / >\nOn the other hand, terminal brand factory competing on the intelligent mobile phone, tablet PC, smart watches wearable device, such as mobile device products, to promote the film type touch panel camp out forces continued to rise, due to the film type touch panel, low cost, relatively have the price competitiveness, contribute to the terminal brand industry cut costs, coupled with film type touch panel is suitable for mass production, in 2014 is still dominant in the intelligent mobile phone and tablet PC market layout, is expected to dominate the low order of intelligent mobile phone, tablet computer, low-end smart watch, wearable device market. <br / >\n<br / >\nDIGITIMES said, Research, intelligent mobile phone industry new overlord of millet, the second quarter of 2014 due to red rice red entry-level machine sales, in the mainland market shipments on red, to maintain the ship above ten million level; cool 4G product leadership, this quarter shipments amounted to 9800000 ranked second. Other mobile phone brand factory, by component, application processor chip manufacturers 4G postponed to the third quarter of 2014, mobile phone brand launch, the new machine factory 4G launch is not much, and the price is mostly in RMB 1000 yuan of above, the second quarter market boom is not as hot industry chain is expected to occur. <br / >\n<br / >\nInternational mobile phone brand mobile phone brand factory, factory has been suppressed, due to the mainland mobile phone brand factory to adopt low-cost strategy, its high performance aircraft launched a large number of general like bamboo shoots after a spring rain, most consumers want to lower prices to purchase specifications and experience similar intelligent mobile phone, especially the impact effect of Samsung, Samsung, why, in the mobile phone market shipment is greatly reduced. <br / >\n<br / >\nAccording to the DIGITIMES Research estimates, the second quarter of 2014, mobile phone market by parity 4G model failed to spread influence, therefore, China mobile phone market than expected, active, mobile phone brand factory part due to product conversion, had to sacrifice 3G aircraft shipments, although the first mobile phone brand factory, the brand strategy, the high cost of aircraft sales performance is good, the second mobile phone brand factory sales is not reduced, but only slightly decline, compared with the first quarter of 2014, China mobile phone market shipments of smart growth of only about 4.8%, the annual growth rate is only about 4.4%. <br / >\n<br / >\nOutlook 2014 second half, the upstream chip manufacturers 4G application processor supply without fear, each new machine has been successfully listed, and telecom operators to achieve the expected 4G sales target, to relax the 3 mode model, strengthen the strength limit subsidies, and provide more preferential rates to attract consumers to upgrade 4G, DIGITIMES Research estimates, the third quarter and shipped in the fourth quarter were up to 100000000 and 112000000.','0',NULL,NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:10:27',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('164','50',NULL,'1','Design of electrostatic discharge of PCB plate and the solutions',NULL,'In the design of PCB board, can be layered, proper layout and installation of anti ESD design and implementation of PCB. By adjusting the PCB layout, can be very good to prevent ESD. * multilayer PCB is used as far as possible, the double PCB, the ground plane and power plane, and closely spaced signal earth line spacing can reduce common mode impedance and inductance coupling, so as to achieve the double PCB 1/10 to 1/100. For the top and bottom surfaces are components, with a short connecting line. <br / >\nFrom the human body, the environment and internal electronic equipment for semiconductor chip precision electrostatic will cause damage, such as through the components inside the thin insulating layer; a gate MOSFET lesion and CMOS components; CMOS device triggers lock; short PN junction reverse biased; short road to biased PN junction; active devices within the melting welding wire or wire. In order to eliminate the electrostatic discharge (ESD) interference and damage to the electronic equipment, need to take a variety of technical means of prevention. <br / >\nIn the design of PCB board, can be layered, proper layout and installation of anti ESD design and implementation of PCB. In the design process, through the forecast can be modified only to increase or decrease the vast majority of design components. By adjusting the PCB layout, can be very good to prevent ESD. The following are some of the common measure. <br / >\n* multilayer PCB is used as far as possible, the double PCB, the ground plane and power plane, and closely spaced signal earth line spacing can reduce common mode impedance and inductance coupling, so as to achieve the double PCB 1/10 to 1/100. As each signal layer are close to a power supply layer or ground layer. For the top and bottom surfaces are components, with a short connecting wire and a lot of filling high density PCB, can consider to use the inner line. <br / >\n* for a double PCB, by closely interwoven power and ground grid. Power line is close to the ground, between vertical and horizontal line or fill area, as much as possible to connect. The size of the grid side is less than or equal to 60mm, if possible, the grid size should be less than 13mm. <br / >\n* make sure that every circuit as compact as possible. <br / >\nAs far as possible to all connectors are put aside. <br / >\nIf possible, the introduction of the power line from the card and away from the central, to be directly influenced by ESD region.','0','/Upload/case/1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'79',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('165','50',NULL,'1','Electromagnetic compatibility design of power meter and the solving methods',NULL,'Compared with the electric parameters of transmitter power industry monitoring instruments commonly used with the traditional, gradually to the intelligent, integrated, multi-functional direction, and in the electromagnetic compatibility requirements are also high performance (EMS and EMI test were related requirements). The designer how to choose appropriate EMC design, a decisive role on the success or failure of the product design. This paper discussed the design of electromagnetic compatibility of the power monitoring instrument. <br / >\nThe standard interpretation of <br / >\n1 standard <br / >\nCombined with the general standard of heavy industrial products, electric power monitoring instrument for power to meet the needs of EMS, EMI and grade is shown in figure 1.<br / >\n<br / > 2 standard interpretation\nInterference is usually divided into two kinds of interference and transient interference. Such as mobile phone, walkie talkie, radio signal to interference. Because the switch, motor braking power fluctuation caused by such interference, we called the transient interference. Contains the transient interference figure 1: surge SURGE, static ESD, electrical fast transient EFT/B, voltage dips, short interruptions and voltage variations include: DIPS; interference conduction sensitivity CS, RS sensitivity to radiation. <br / >\nEvaluation of the class A of the &ldquo &rdquo does not decrease; performance; namely, applying interference, no hardware damage, data reduction, no crashes, dropped frames or bit error rate is higher in the process of applying interference, as applied to the products without interference. Usually persistent disturbance evaluation grade are the evaluation grade. The transient interference for incidental, grid disturbance caused by time and reduce the time is not long, the performance, also is the evaluation grade B.<br / >\n3 EMS test items and interference analysis of <br / Essence\n(1) SURGE 1.2/50&mu s: surge waveform;, 8/20&mu; s, a pulse width of dozens of &mu; s is a conductive interference pulse, pulse energy, because of its strong, so it needs to do some degree of protection to all ports, otherwise it will cause the internal circuit of permanent hard damage. <br / >\n(2) the static ESD: waveform rise time is 0.7 1ns, the pulse is a pulse width of dozens of NS, because of its peak voltage is in the range of thousands of volts, so the pulse also has a certain energy, to do protection in port. Due to the rising edge is very steep, so the high frequency harmonics carrying is very rich, up to 500MHz, so the static electricity in all exposed metal parts instrument (including the terminal screws, etc.) contact discharge or aperture (including opening, LED indicator of the various thermal and observation hole), or on the level of coupled plates respectively. And the vertical coupled plate indirect discharge, will form a high-frequency electric field in the discharge point of instantaneous, through the space interference on the circuit, the interference is the common mode interference. Therefore, the static design should pay attention to the protection and space port high frequency radiation of two aspects. <br / >\n(3) EFT/B: Electrical fast transient wave rising edge to 5ns, waveform into a number of periodic pulse string combination, very low energy. Properties and electrostatic interference is the same as the common mode interference path, including transmission also includes radiation. <br / >\nConducted susceptibility of CS (4): the common mode interference, interference frequency band from 150KHz to 80MHz. In the project during the experiment, the interference signal source to instrument cable length and interference frequency band (30MHz) corresponding to the wavelength of the &lambda; 1/4 is applied, the frequency modulation interference voltage exceeds 30MHz, due to the skin effect, the interference signal in space radiation mode (less than 30MHz, or in the main transmission interference). <br / >\nThe radiation sensitivity of RS (5): the common mode interference, interference frequency band from 80MHz to 1GHz. Need to pay attention to, drag cable as a receiving antenna, electromagnetic interference for the far field.','0','/Upload/case/2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('166','50',NULL,'1','For the solution of electrostatic discharge problems',NULL,'For the solution of electrostatic discharge problems, according to the following twelve rules to (prioritize) <br / >\n1.PCB non insulated casing wire and other wire distance of at least 2.2 mm. This applies to all objects connected to the chassis ground, including trajectory. <br / >\n2 chassis wire length should not be more than five times its width. <br / >\nMetal objects 3 the circuit without insulation and the operator can touch to the PCB area or ungrounded separated by at least 2 cm. <br / >\n4 power line and ground wire or ranking on PCB and in the same layer, or placed adjacent to the two layer. <br / >\n5 the ground plane and ground wire must be connected to the network. In an arbitrary direction, at least 6 cm every connection a vertical line and horizontal line. Especially the double PCB plate, that is to say, the first layer PCB board layout can be ground level, and the second layer can be vertical ground, must be at least every 6 centimeters place a hole has been connected to both (of course, less than 6 cm in the local connection is better than the ground grid, ground plane. <br / >)\n6 of all signal lines must be in the ground plane edges or less than 13 mm above the ground. Wire can be distributed in the same layer signal line, also can be in the next layer. If the signal line length of 30 cm or more, it must be placed on a ground beside it, placed above the signal line or the adjacent surface of the ground can be. <br / >\nAcross the bypass capacitor between the 7 power line and the ground wire, the distance between each other is not greater than 8 cm (so that each piece of integrated block may have multiple bypass capacitor is connected). <br / >\n8 mutual connection more components rely on together. <br / >\nAll 9 components must be as close as possible to the I/O connector (Note: should meet third). <br / >\nThe 10 part will spare all of PCB filled with ground (attention should be paid to every 6 centimeters place continuously to produce ground network). <br / >\n11 if possible, which will feed power line or signal line from the edge at the center of PCB board, and not from a corner out. <br / >\n12 for the signal line is particularly sensitive and long (30 cm or longer), should be at regular intervals and ground. <br / >\nNote: these design rules must be applied to all PCB in the system (such as main board and plug in the above board). For example, when the application of article second, a ground length including the motherboard and the daughter board and the length of all the earth.','0','/Upload/case/4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 20:46:31',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('167','44',NULL,'1','High precision pH meter',NULL,NULL,'0','/Upload/product/a4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:26:02',NULL,'0',NULL,NULL,'300','C332332',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('168','44',NULL,'1','AZ8690 portable pH meter',NULL,NULL,'0','/Upload/product/a3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2015-04-22 17:26:02',NULL,'0',NULL,NULL,'200','C333',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('169','44',NULL,'1','AZ8403 portable dissolved oxygen meter',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/a1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:15:25',NULL,'0',NULL,NULL,'298','C002',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('170','44',NULL,'1','AZ86505 pH meter pH meter',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/a2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:13:32',NULL,'8',NULL,NULL,'500','C001',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('171','45',NULL,'1','CIMA AS856 handheld high-precision digital anemometer anemometer',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/b1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'84',NULL,'13','2000','C040',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('172','45',NULL,'1','AZ8912 high precision multifunctional wind volume meter',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/b2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'13',NULL,'13','4580','C039',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('173','45',NULL,'1','AZ8905 multifunctional anemometer measurement of humidity',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/b3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'11',NULL,'13','3980','C038',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('174','45',NULL,'1','AZ8910 digital multifunctional anemometer anemometer',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/b4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'5',NULL,NULL,'2880','C037',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('175','46',NULL,'1','Automatic AZ88378 dual channel thermocouple temperature record',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/c1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'2',NULL,'15','288','C016',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('176','46',NULL,'1','Monitor AZ87792 high precision temperature and humidity meter',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/c2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'10',NULL,NULL,'268','C015',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('177','46',NULL,'1','AZ9801 record printer',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/c3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'1',NULL,NULL,'188','C014',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('178','46',NULL,'1','AZ9881 high accuracy thermocouple temperature recorder',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/d1.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'5',NULL,NULL,'988','C020',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('179','47',NULL,'1','AZ9861 pH meter recorder',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/d2.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,'15','98','C019',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('180','47',NULL,'1','Memory type PH pH meter AZ-9661',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/d3.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'1080','C018',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('181','47',NULL,'1','AZ9651 portable split of high precision temperature and humidity recorder',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/d4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'228','C017',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0'),
('182','47',NULL,'1','AZ8809 high precision LED temperature and humidity recorder',NULL,'Product description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information\nProduct description information','0','/Upload/product/c4.jpg',NULL,NULL,'0','0',NULL,NULL,NULL,NULL,'0','2013-03-26 18:54:16',NULL,'0',NULL,NULL,'518','C013',NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,NULL,'0',NULL,'0');

INSERT INTO `youdian_job` VALUES
('1','销售经理','大专以上','男女不限','20-25岁','面议','不限','10','北京','长期有效','<div class=\"cc_l\">\r\n	<strong>职位说明：</strong></div>\r\n<div class=\"cc_m\">\r\n	开拓市场，完成公司分配的销售任务；市场调研，挖掘客户潜在需求。</div>\r\n<div class=\"cc_m\">\r\n	&nbsp;</div>\r\n<div class=\"cc_l\">\r\n	<strong>职位要求：</strong></div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、普通话标准，性格开朗，善于与人沟通，具有一定的亲和力；<br />\r\n	2、有一定的客户资源优先；<br />\r\n	3、具有一定的市场开拓能力，挖掘客户潜在需求能力；<br />\r\n	4、具有良好的客户服务意识，高度的责任感。</div>\r\n','1','2012-08-23 17:18:10','1','1'),
('2','平面设计师','大专以上','女','20-30','3000-5000/月','不限','5','北京','长期有效','<div class=\"cc_l\">\r\n	<strong>职位说明：</strong></div>\r\n<div class=\"cc_m\">\r\n	从事我司软件产品相关美术设计，包括企业Logo、Flash动画设计、图标设计、网页美工等</div>\r\n<div class=\"cc_m\">\r\n	&nbsp;</div>\r\n<div class=\"cc_l\">\r\n	<strong>职位要求：</strong></div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、美术、平面设计相关专业，大专以上学历；<br />\r\n	2、有扎实的美术功底、良好的创意思维和理解能力，能及时把握客户需求；<br />\r\n	3、熟练使用设计相关工具，如Photoshop、Illustrator、Dreamweaver、Flash等；<br />\r\n	4、了解div+css+js网页布局设计；<br />\r\n	5、善于与人沟通，良好的团队合作精神和高度的责任感，能够承受压力，有创新精神，保证工作质量；</div>\r\n<p>\r\n	&nbsp;</p>\r\n','0','2012-11-14 14:24:54','1','1'),
('3','前台接待','大专','女','20-25','面议','不限','2','北京','长期有效','<div class=\"cc_l\">\r\n	职位要求：</div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、性格开朗，待人热情，身高1.60米以上，形象好，气质佳；<br />\r\n	2、普通话流利，具有良好的语言表达能力和沟通应变能力；<br />\r\n	3、熟练使用电脑、传真机及各种办公软件word，excel；<br />\r\n	4、工作积极主动，认真严谨，具备良好的团队合作精神；<br />\r\n	5、具有良好的思想道德素质，责任心强，较强的服务意识。</div>\r\n','0','2012-11-15 15:11:32','1','1'),
('4','Sales Manager','University Degree','Unlimited','20-25','Negotiable','Unlimited','10','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, good putonghua, cheerful, affinity, good at communicating;<br />\r\n	2, having a customer resources is preferred;<br />\r\n	3, having a ability of market development and mining customer potential demand;<br />\r\n	4, good customer service consciousness, high sense of responsibility.</p>\r\n','0','2012-11-15 15:11:54','1','2'),
('5','Receptionist','University Degree','Female','20-25','Negotiable','Unlimited','2','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, cheerful, warm, height 1.60 meters of above, good face, good temperament;<br />\r\n	2, good putonghua, good language expression ability and communication ability;<br />\r\n	3, skilled use of computer, fax and all kinds of office software,eg. word, excel;<br />\r\n	4, work actively, serious, and good team cooperation spirit;<br />\r\n	5, good ideological and moral quality, strong sense of responsibility, strong sense of service.</p>\r\n','0','2013-03-27 16:26:42','1','2'),
('6','Graphic Designers','University Degree','Female','20-30','3000-5000','Unlimited','5','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, related to arts, graphic design specialty, college degree or above;<br />\r\n	2, good art foundation, good understanding of the creative thinking and ability, understanding customer requirement;<br />\r\n	3, skilled use of design tools, such as Photoshop, Illustrator, Dreamweaver, Flash etc.;<br />\r\n	4, understanding of div+css+js webpage layout design;<br />\r\n	5, good communication skills, team cooperation spirit and high sense of responsibility, bearing pressure,innovation spirit, guarantee the quality of work;</p>\r\n','0','2013-03-27 16:26:42','1','2');

INSERT INTO `youdian_label` VALUES
('1','热门','30','0','1','1'),
('2','头条','30','0','1','1'),
('3','推荐','30','0','1','1'),
('4','热门','31','0','1','1'),
('5','头条','31','0','1','1'),
('6','推荐','31','0','1','1'),
('7','热门','34','0','1','1'),
('8','头条','34','0','1','1'),
('9','推荐','34','0','1','1'),
('10','热门','35','0','1','1'),
('11','头条','35','0','1','1'),
('12','推荐','35','0','1','1'),
('13','热门','36','0','1','1'),
('14','头条','36','0','1','1'),
('15','推荐','36','0','1','1'),
('16','保留使用','37','0','1','1'),
('17','保留使用','37','0','1','1'),
('18','保留使用','37','0','1','1'),
('19','保留使用','38','0','1','1'),
('20','保留使用','38','0','1','1'),
('21','保留使用','38','0','1','1'),
('22','保留使用','39','0','1','1'),
('23','保留使用','39','0','1','1'),
('24','保留使用','39','0','1','1');

INSERT INTO `youdian_language` VALUES
('1','中文','cn',NULL,'0','1'),
('2','英语','en',NULL,'1','1');

INSERT INTO `youdian_link` VALUES
('1','1','好搜','1','http://www.haosou.com',NULL,'0',NULL,'1','1'),
('4','1','搜狗搜索','2','http://www.sogou.com','/Upload/link/sogou.png','2',NULL,'1','1'),
('9','1','搜狐','1','http://www.sohu.com',NULL,'20',NULL,'1','1'),
('10','1','百度','1','http://www.baidu.com',NULL,'0',NULL,'1','1'),
('11','1','百度搜索','2','http://www.baidu.com','/Upload/link/baidu.gif','1',NULL,'1','1'),
('12','2','baidu','1','http://www.baidu.com',NULL,'0',NULL,'1','2'),
('13','2','google','1','http://www.google.com',NULL,'0',NULL,'1','2'),
('14','2','yahoo','1','http://www.yahoo.com',NULL,'0',NULL,'1','2'),
('15','2','sohu','1','http://www.sohu.com',NULL,'0',NULL,'1','2'),
('16','2','sina','1','http://www.sina.com.cn',NULL,'0',NULL,'1','2'),
('17','2','sogou','1','http://www.sogou.com',NULL,'0',NULL,'1','2'),
('18','2','tencent','1','http://www.qq.com',NULL,'0',NULL,'1','2'),
('19','1','新浪','1','http://www.sina.com.cn',NULL,'0',NULL,'1','1'),
('20','1','搜狗','1','http://www.sogou.com/',NULL,'0',NULL,'1','1'),
('21','1','中国新闻网','1','http://www.chinanews.com/',NULL,'0',NULL,'1','1'),
('22','1','腾讯新闻','1','http://news.qq.com/',NULL,'0',NULL,'1','1'),
('23','1','中国政府网','1','http://www.gov.cn/',NULL,'0',NULL,'1','1'),
('24','1','中国日报','1','http://cn.chinadaily.com.cn/',NULL,'0',NULL,'1','1'),
('25','1','中国网','1','http://www.china.com.cn/',NULL,'0',NULL,'1','1'),
('26','1','新浪网','2','http://www.sina.com.cn','/Upload/link/sina.png','3',NULL,'1','1'),
('27','1','雅虎','2','https://www.yahoo.com/','/Upload/link/yahoo.png','5',NULL,'1','1'),
('28','1','QQ','2','http://www.qq.com','/Upload/link/qq.png','4',NULL,'1','1'),
('29','1','TOM','2','http://www.tom.com','/Upload/link/tom.png','6',NULL,'1','1'),
('30','1','网易','2','http://www.netease.com','/Upload/link/163.png','7',NULL,'1','1'),
('31','1','sohu','2','http://www.sohu.com','/Upload/link/sohu.png','8',NULL,'1','1'),
('32','2','baidu.com','2','http://www.baidu.com','/Upload/link/baidu.gif','0',NULL,'1','2'),
('33','2','sina.com.cn','2','http://www.sina.com.cn','/Upload/link/sina.png','0',NULL,'1','2'),
('34','2','sogou.com','2','http://www.sogou.com','/Upload/link/sogou.png','0',NULL,'1','2'),
('35','2','QQ','2','http://www.qq.com','/Upload/link/qq.png','0',NULL,'1','2'),
('36','2','163.com','2','http://www.163.com','/Upload/link/tom.png','0',NULL,'1','2'),
('37','2','netease.com','2','http://www.netease.com','/Upload/link/163.png','0',NULL,'1','2'),
('38','2','yahoo.com','2','http://www.yahoo.com','/Upload/link/yahoo.png','0',NULL,'1','2'),
('39','2','sohu.com','2','http://www.sohu.com','/Upload/link/sohu.png','0',NULL,'1','2'),
('40','2','china news','1','http://www.china.com.cn/',NULL,'0',NULL,'1','2');

INSERT INTO `youdian_link_class` VALUES
('1','默认分类','0','1'),
('2','default','0','2');

INSERT INTO `youdian_log` VALUES
('1','8','管理员登录',' [ID:]','0.0.0.0',NULL,'2016-06-04 18:02:18','管理员登录失败，用户名：admin 或密码： youdian888 错误','1'),
('2','8','管理员登录',' [ID:]','0.0.0.0',NULL,'2016-06-04 18:02:23','管理员登录成功 admin','1');

INSERT INTO `youdian_mail_class` VALUES
('1','默认分类','0',NULL,'1','1'),
('2','Default','0',NULL,'1','2');

INSERT INTO `youdian_member` VALUES
('1','1','admin','0',NULL,'ed9f2df6c3b16155f6981c23a99afc9e','1989-09-22',NULL,'410000','xx@qq.com','400-699-1720',NULL,NULL,'网站在哪个公司做的',NULL,'2013-06-27 18:37:04',NULL,'2012-08-23 20:41:34','1','0','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,'0','0','');

INSERT INTO `youdian_member_group` VALUES
('1','注册会员','1','9,10,11','15,16,17','63,65,67,79,89,130,132','15,17,18,19,55,20,21,22',NULL,'1','1'),
('2','微信游客','1','9,10,12,11','15,16,17','63,65,67,79,89','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29',NULL,'1','1');

INSERT INTO `youdian_menu` VALUES
('5','1','数据库设置','Config/db','0','30',NULL,'1'),
('7','5','添加频道','Channel/add','0','1',NULL,'0'),
('8','5','频道管理','Channel/index','0','2',NULL,'1'),
('9','1','基本设置','Config/basic','0','1',NULL,'1'),
('10','9','留言设置','Config/guestbook','0','2',NULL,'0'),
('14','9','评论设置','Config/comment','0','6',NULL,'0'),
('16','7','在线客服设置','Config/online','0','3',NULL,'0'),
('17','19','搜索引擎优化设置','Config/seo','0','3',NULL,'1'),
('18','1','联系方式','Config/contact','0','2',NULL,'1'),
('19','1','文件上传设置','Config/upload','0','7',NULL,'1'),
('20','12','会员功能设置','Config/reg','0','5',NULL,'1'),
('24','2','邮件订阅分类管理','Mail/classindex','0','6',NULL,'1'),
('25','2','邮件群发管理','Mail/sendindex','0','0',NULL,'1'),
('26','2','订阅邮箱管理','Mail/index','0','5',NULL,'1'),
('27','2','网站安全提示','Public/welcome#c2','0','2',NULL,'0'),
('28','2','组件支持情况','Public/welcome#c4','0','4',NULL,'0'),
('32','4','添加专题','Special/add','0','1',NULL,'0'),
('33','5','专题管理','Special/index','0','2',NULL,'1'),
('34','7','添加在线客服','Support/add','0','1',NULL,'0'),
('35','7','在线客服管理','Support/index','0','2',NULL,'1'),
('37','6','添加幻灯片','Banner/add','0','1',NULL,'0'),
('38','11','幻灯片管理','Banner/index','0','2',NULL,'1'),
('39','7','第三方在线客服','Support/third','0','4',NULL,'1'),
('40','8','添加友情链接','Link/add','0','1',NULL,'0'),
('41','8','友情链接管理','Link/index','0','2',NULL,'1'),
('42','8','添加友情链接分类','Link/addclass','0','3',NULL,'0'),
('43','8','友情链接分类管理','Link/classindex','0','4',NULL,'1'),
('44','9','留言管理','Guestbook/index','0','1',NULL,'1'),
('45','9','人才招聘','Job/index','0','2',NULL,'1'),
('46','9','评论管理','Comment/index','0','6',NULL,'1'),
('47','9','发布招聘信息','Job/add','0','0',NULL,'0'),
('48','11','添加广告','Ad/add','0','1',NULL,'0'),
('49','11','广告内容管理','Ad/index','0','10',NULL,'1'),
('50','12','添加会员分组','MemberGroup/add','0','3',NULL,'0'),
('51','12','会员分组管理','MemberGroup/index','0','4',NULL,'1'),
('52','12','会员管理','Member/index','0','1',NULL,'1'),
('53','12','添加会员','Member/add','0','0',NULL,'0'),
('55','13','管理员管理','Admin/index','0','2',NULL,'1'),
('56','13','添加管理员分组','AdminGroup/add','0','3',NULL,'0'),
('57','13','管理员分组管理','AdminGroup/index','0','4',NULL,'1'),
('58','14','模板选择','Template/pick','0','1',NULL,'1'),
('59','14','模板管理','Template/index','0','2',NULL,'1'),
('60','14','样式管理','Template/style','0','3',NULL,'1'),
('61','1','水印设置','Config/water','0','6',NULL,'1'),
('62','3','内容频道',NULL,'3','0',NULL,'1'),
('63','15','我的个人资料','Member/modify','0','1',NULL,'1'),
('65','15','修改我的密码','Public/pwd','0','3',NULL,'1'),
('66','15','用户后台首页','Public/welcome','0','0',NULL,'0'),
('67','16','我的留言','Guestbook/index','0','1',NULL,'1'),
('68','16','我的评论','Comment/index','0','2',NULL,'1'),
('69','17','我发布的文章','Info/index','3','0',NULL,'1'),
('71','18','添加自定义标签','Tag/add','0','1',NULL,'0'),
('72','18','自定义标签管理','Tag/index','0','2',NULL,'1'),
('73','5','添加属性标记','Label/add','0','3',NULL,'0'),
('74','5','属性标记管理','Label/index','0','4',NULL,'0'),
('75','19','常用搜索引擎登录入口','SEO/searchenginelogin','0','10',NULL,'1'),
('76','19','伪静态设置','Config/core','0','0',NULL,'1'),
('77','9','订单设置','Config/order','0','4',NULL,'0'),
('78','26','订单管理','Order/index','0','3',NULL,'1'),
('79','16','我的订单','Order/index','0','3',NULL,'1'),
('80','18','数据库管理','Db/index','0','3',NULL,'1'),
('81','18','数据库还原','Db/restore','0','4',NULL,'1'),
('82','18','添加频道模型','ChannelModel/add','0','5',NULL,'0'),
('83','18','频道模型管理','ChannelModel/index','0','6',NULL,'1'),
('84','1','站长统计设置','Config/stat','0','15',NULL,'1'),
('85','1','百度分享设置','Config/baidushare','0','16',NULL,'1'),
('86','19','生成网站地图','SEO/sitemap','0','11',NULL,'1'),
('87','19','生成关键词内链','Config/autolink','0','12',NULL,'1'),
('88','10','应聘简历管理','Job/resume','0','3',NULL,'1'),
('89','16','我的应聘','Resume/index','0','3',NULL,'1'),
('90','6','添加幻灯分组','BannerGroup/add','0','3',NULL,'0'),
('91','11','幻灯分组管理','BannerGroup/index','0','4',NULL,'1'),
('92','12','会员模型管理','MemberModel/index','0','2',NULL,'0'),
('93','21','模板选择','WapTemplate/pick','0','1',NULL,'1'),
('94','21','模板管理','WapTemplate/index','0','2',NULL,'1'),
('95','21','样式管理','WapTemplate/style','0','3',NULL,'1'),
('96','18','一键备份全站','Db/backupall','0','7',NULL,'1'),
('97','1','其它设置','Config/other','0','50',NULL,'1'),
('98','1','缩略图设置','Config/thumb','0','17',NULL,'1'),
('99','1','手机网站设置','Config/wap','0','45',NULL,'1'),
('100','1','邮箱设置','Config/email','0','40',NULL,'1'),
('101','1','语言设置','Config/language','0','41',NULL,'1'),
('102','22','微信绑定设置','Wx/messageapi','0','1',NULL,'1'),
('103','22','自定义菜单设置','Wx/menu','0','5',NULL,'1'),
('104','23','关注自动回复','Wx/subscribereply','0','0',NULL,'1'),
('105','23','关键词自动回复','Wx/keywordreply','0','0',NULL,'1'),
('106','23','默认自动回复','Wx/defaultreply','0','10',NULL,'1'),
('107','22','凭证接口设置','Wx/credentialapi','0','3',NULL,'0'),
('108','22','微信公众平台登录','Wx/index','0','0',NULL,'0'),
('109','25','微消息','Wx/message','0','0',NULL,'1'),
('110','22','第三方接口','Wx/api','0','2',NULL,'0'),
('111','25','微活动','Wx/lottery','0','2',NULL,'1'),
('112','22','基本信息设置','Wx/basic','0','2',NULL,'1'),
('113','23','地理位置自动回复','Wx/lbsreply','0','8',NULL,'1'),
('114','25','微查询','Wx/query','0','1',NULL,'1'),
('115','25','微投票','Wx/vote','0','3',NULL,'1'),
('116','25','微会员卡','wx/card','0','4',NULL,'1'),
('117','25','微调查','wx/research','0','5',NULL,'1'),
('118','22','微信功能设置','Wx/config','0','6',NULL,'1'),
('119','14','模板设置','Template/config','0','4',NULL,'1'),
('120','21','模板设置','WapTemplate/config','0','4',NULL,'1'),
('121','18','操作日志管理','Log/index','0','10',NULL,'1'),
('122','18','数据采集','Collect/index','0','15',NULL,'1'),
('123','11','广告位管理','AdGroup/index','0','15',NULL,'1'),
('124','26','配送方式管理','Shipping/Index','0','5',NULL,'1'),
('125','26','支付方式管理','Pay/Index','0','6',NULL,'1'),
('126','1','第三方登录设置','Config/oauth','0','43',NULL,'1'),
('127','5','类型管理','Type/index','0','2',NULL,'1'),
('128','26','销售统计','Order/stat','0','8',NULL,'1'),
('129','18','网站目录权限检测','Public/dirDetection','0','12',NULL,'1'),
('130','16','我的收藏','Favorite/index','0','5',NULL,'1'),
('131','26','资金管理','Cash/index','0','10',NULL,'1'),
('132','16','我的资金','Cash/index','0','8',NULL,'1'),
('133','27','基本设置','App/config','0','5',NULL,'1'),
('134','28','用户反馈','App/feedback','0','10',NULL,'1'),
('135','29','安装统计','App/stat','0','15',NULL,'1'),
('136','27','关于我们设置','App/about','0','20',NULL,'1'),
('137','28','消息推送','App/addMessage','0','7',NULL,'1'),
('138','29','活跃度分析','App/active','0','25',NULL,'1'),
('139','27','通信秘钥管理','App/secret','0','25',NULL,'1');

INSERT INTO `youdian_menu_group` VALUES
('1','1','系统设置','2','1'),
('2','5','邮件群发','2','1'),
('3','3','信息管理','10','1'),
('4','2','专题管理','2','0'),
('5','3','频道管理','1','1'),
('6','5','幻 灯 片','0','0'),
('7','4','在线客服','1','1'),
('8','5','友情链接','2','1'),
('9','4','其它','4','1'),
('10','4','人才招聘','3','0'),
('11','5','网站广告','1','1'),
('12','6','会员信息','1','1'),
('13','6','管理员信息','1','1'),
('14','7','电脑模板管理','1','1'),
('15','9','基本信息','1','1'),
('16','9','互动管理','1','1'),
('17','10','内容管理','1','1'),
('18','2','系统管理','0','1'),
('19','14','网站优化','0','1'),
('20','5','第三方脚本','1','0'),
('21','7','手机模板管理','2','1'),
('22','15','微信设置','0','1'),
('23','15','自动回复','0','1'),
('24','15','消息管理','0','0'),
('25','15','微信应用','0','1'),
('26','4','订单管理','2','1'),
('27','16','应用设置','1','1'),
('28','16','功能模块','5','1'),
('29','16','统计分析','10','1');

INSERT INTO `youdian_menu_operation` VALUES
('1','41','添加','add','Link','Admin','0','10','1'),
('2','41','删除','del','Link','Admin','0','3','1'),
('3','41','修改','modify','Link','Admin','0','11','1'),
('4','41','排序','batchsort','Link','Admin','0','5','1'),
('5','41','查看','index','Link','Admin','0','9','1'),
('6','41','保存添加','saveadd','Link','Admin','0','2','1'),
('7','41','批量删除','batchdel','Link','Admin','0','3','1'),
('8','41','保存修改','savemodify','Link','Admin','0','4','1'),
('9','43','查看分类','classindex','Link','Admin','0','9','1'),
('10','43','添加分类','addclass','Link','Admin','0','10','1'),
('11','43','保存添加分类','saveaddclass','Link','Admin','0','2','1'),
('12','43','删除分类','delclass','Link','Admin','0','3','1'),
('13','43','批量删除分类','batchdelclass','Link','Admin','0','3','1'),
('14','43','分类排序','batchsortclass','Link','Admin','0','5','1'),
('15','43','修改分类','modifyclass','Link','Admin','0','11','1'),
('16','43','保存修改分类','savemodifyclass','Link','Admin','0','4','1'),
('17','49','查看','index','Ad','Admin','0','9','1'),
('18','49','添加','add','Ad','Admin','0','10','1'),
('19','49','保存添加','saveadd','Ad','Admin','0','2','1'),
('20','49','删除','del','Ad','Admin','0','3','1'),
('21','49','批量删除','batchdel','Ad','Admin','0','3','1'),
('22','49','修改','modify','Ad','Admin','0','11','1'),
('23','49','保存修改','savemodify','Ad','Admin','0','4','1'),
('24','55','查看','index','Admin','Admin','0','9','1'),
('25','55','添加','add','Admin','Admin','0','10','1'),
('26','55','保存添加','saveadd','Admin','Admin','0','2','1'),
('27','55','删除','del','Admin','Admin','0','3','1'),
('28','55','批量删除','batchdel','Admin','Admin','0','3','1'),
('29','55','锁定','batchlock','Admin','Admin','0','1','1'),
('30','55','修改密码','batchmodifypwd','Admin','Admin','0','1','1'),
('31','55','修改','modify','Admin','Admin','0','11','1'),
('32','55','保存修改','savemodify','Admin','Admin','0','4','1'),
('33','57','查看','index','AdminGroup','Admin','0','9','1'),
('34','57','添加','add','AdminGroup','Admin','0','10','1'),
('35','57','保存添加','saveadd','AdminGroup','Admin','0','2','1'),
('36','57','删除','del','AdminGroup','Admin','0','3','1'),
('37','57','批量删除','batchdel','AdminGroup','Admin','0','3','1'),
('38','57','修改','modify','AdminGroup','Admin','0','11','1'),
('39','57','保存修改','savemodify','AdminGroup','Admin','0','4','1'),
('40','38','查看','index','Banner','Admin','0','9','1'),
('41','38','添加','add','Banner','Admin','0','10','1'),
('42','38','保存添加','saveadd','Banner','Admin','0','2','1'),
('43','38','排序','batchsort','Banner','Admin','0','5','1'),
('44','38','删除','del','Banner','Admin','0','3','1'),
('45','38','批量删除','batchdel','Banner','Admin','0','3','1'),
('46','38','修改','modify','Banner','Admin','0','11','1'),
('47','38','保存修改','savemodify','Banner','Admin','0','4','1'),
('48','91','查看','index','BannerGroup','Admin','0','9','1'),
('49','91','添加','add','BannerGroup','Admin','0','10','1'),
('50','91','保存添加','saveadd','BannerGroup','Admin','0','2','1'),
('51','91','排序','batchsort','BannerGroup','Admin','0','5','1'),
('52','91','删除','del','BannerGroup','Admin','0','3','1'),
('53','91','批量删除','batchdel','BannerGroup','Admin','0','3','1'),
('54','91','修改','modify','BannerGroup','Admin','0','11','1'),
('55','91','保存修改','savemodify','BannerGroup','Admin','0','4','1'),
('56','8','查看','index','Channel','Admin','0','9','1'),
('57','8','链接频道查看','link','Channel','Admin','0','9','1'),
('58','8','单页频道查看','single','Channel','Admin','0','9','1'),
('59','8','添加','add','Channel','Admin','0','10','1'),
('60','8','保存添加','saveadd','Channel','Admin','0','2','1'),
('61','8','批量添加','batchadd','Channel','Admin','0','10','1'),
('62','8','保存批量添加','savebatchadd','Channel','Admin','0','2','1'),
('63','8','保存所有','saveall','Channel','Admin','0','4','1'),
('64','8','删除','del','Channel','Admin','0','3','1'),
('65','8','删除频道缓存','clearCache','Channel','Admin','0','7','1'),
('66','8','修改','modify','Channel','Admin','0','11','1'),
('67','8','保存修改','savemodify','Channel','Admin','0','4','1'),
('68','8','查看属性标记','index','Label','Admin','0','9','1'),
('69','8','添加属性标记','add','Label','Admin','0','10','1'),
('70','8','保存添加属性标记','saveadd','Label','Admin','0','2','1'),
('71','8','删除属性标记','del','Label','Admin','0','3','1'),
('72','8','批量删除属性标记','batchdel','Label','Admin','0','3','1'),
('73','8','属性标记排序','batchsort','Label','Admin','0','5','1'),
('74','8','修改属性标记','modify','Label','Admin','0','11','1'),
('75','8','保存修改属性标记','savemodify','Label','Admin','0','4','1'),
('76','83','添加','add','ChannelModel','Admin','0','10','1'),
('77','83','排序','batchsort','ChannelModel','Admin','0','5','1'),
('78','83','字段排序','batchsortfield','ChannelModel','Admin','0','5','1'),
('79','83','清除缓存','clearcache','ChannelModel','Admin','0','7','1'),
('80','83','删除','del','ChannelModel','Admin','0','3','1'),
('81','83','查看','index','ChannelModel','Admin','0','9','1'),
('82','83','修改','modify','ChannelModel','Admin','0','11','1'),
('83','83','修改字段','modifyfield','ChannelModel','Admin','0','11','1'),
('84','83','保存添加','saveadd','ChannelModel','Admin','0','2','1'),
('85','83','保存修改字段','savemodifyfield','ChannelModel','Admin','0','4','1'),
('86','83','查看字段','viewfield','ChannelModel','Admin','0','9','1'),
('87','83','保存修改','savemodify','ChannelModel','Admin','0','4','1'),
('88','122','添加','add','Collect','Admin','0','10','1'),
('89','122','采集内容','collectcontent','Collect','Admin','0','1','1'),
('90','122','采集列表地址','collectlist','Collect','Admin','0','1','1'),
('91','122','删除','del','Collect','Admin','0','3','1'),
('92','122','查看','index','Collect','Admin','0','9','1'),
('93','122','修改','modify','Collect','Admin','0','11','1'),
('94','122','保存添加','saveadd','Collect','Admin','0','2','1'),
('95','122','保存修改','savemodify','Collect','Admin','0','4','1'),
('96','122','开始采集数据','start','Collect','Admin','0','1','1'),
('97','122','测试采集字段数据','testfield','Collect','Admin','0','1','1'),
('98','46','审核','batchcheck','Comment','Admin','0','1','1'),
('99','46','批量删除','batchdel','Comment','Admin','0','3','1'),
('100','46','删除','del','Comment','Admin','0','3','1'),
('101','46','查看','index','Comment','Admin','0','9','1'),
('102','46','保存修改','savecomment','Config','Admin','0','4','1'),
('103','46','查看','comment','Config','Admin','0','9','1'),
('104','80','查看','index','Db','Admin','0','9','1'),
('105','80','备份','backup','Db','Admin','0','1','1'),
('106','80','分析','analyze','Db','Admin','0','1','1'),
('107','80','检查','check','Db','Admin','0','1','1'),
('108','80','优化','optimize','Db','Admin','0','1','1'),
('109','80','修复','repair','Db','Admin','0','1','1'),
('110','80','查看字段','columns','Db','Admin','0','9','1'),
('111','81','查看','restore','Db','Admin','0','9','1'),
('112','81','备份','backup','Db','Admin','0','1','1'),
('113','81','删除','delsqlfile','Db','Admin','0','3','1'),
('114','81','批量删除','batchdelsqlfile','Db','Admin','0','3','1'),
('115','81','还原','recover','Db','Admin','0','1','1'),
('116','81','查看SQL内容','viewsqlfile','Db','Admin','0','9','1'),
('117','96','查看','backupall','Db','Admin','0','9','1'),
('118','96','删除备份文件','delzip','Db','Admin','0','3','1'),
('119','96','一键备份全站','dobackupall','Db','Admin','0','1','1'),
('120','96','备份数据库','backupdata','Db','Admin','0','1','1'),
('121','9','查看','basic','Config','Admin','0','9','1'),
('122','9','保存修改','savebasic','Config','Admin','0','4','1'),
('123','18','查看','contact','Config','Admin','0','9','1'),
('124','18','保存修改','savecontact','Config','Admin','0','4','1'),
('125','61','查看','water','Config','Admin','0','9','1'),
('126','61','保存修改','savewater','Config','Admin','0','4','1'),
('127','19','查看','upload','Config','Admin','0','9','1'),
('128','19','保存修改','saveupload','Config','Admin','0','4','1'),
('129','84','查看','stat','Config','Admin','0','9','1'),
('130','84','保存修改','savestat','Config','Admin','0','4','1'),
('131','85','查看','baidushare','Config','Admin','0','9','1'),
('132','85','保存修改','savebaidushare','Config','Admin','0','4','1'),
('133','98','查看','thumb','Config','Admin','0','9','1'),
('134','98','保存修改','savethumb','Config','Admin','0','4','1'),
('135','5','查看','db','Config','Admin','0','9','1'),
('136','5','保存修改','savedb','Config','Admin','0','4','1'),
('137','100','查看','email','Config','Admin','0','9','1'),
('138','100','保存修改','saveemail','Config','Admin','0','4','1'),
('139','101','查看','language','Config','Admin','0','9','1'),
('140','101','保存修改','savelanguage','Config','Admin','0','4','1'),
('141','97','查看','other','Config','Admin','0','9','1'),
('142','97','保存修改','saveother','Config','Admin','0','4','1'),
('143','99','查看','wap','Config','Admin','0','9','1'),
('144','99','保存修改','savewap','Config','Admin','0','4','1'),
('145','44','回复留言','answermessage','Guestbook','Admin','0','2','1'),
('146','44','批量删除','batchdelmessage','Guestbook','Admin','0','3','1'),
('147','44','删除','delmessage','Guestbook','Admin','0','3','1'),
('148','44','审核/取消审核','batchcheckmessage','Guestbook','Admin','0','1','1'),
('149','44','查看','index','Guestbook','Admin','0','9','1'),
('150','44','导出','exportmessage','Guestbook','Admin','0','6','1'),
('151','44','设置','guestbook','Config','Admin','0','11','1'),
('152','44','保存修改','saveguestbook','Config','Admin','0','4','1'),
('153','45','发布招聘信息','add','Job','Admin','0','10','1'),
('154','45','批量删除','batchdel','Job','Admin','0','3','1'),
('155','45','批量删除简历','batchdelresume','Job','Admin','0','3','1'),
('156','45','排序','batchsort','Job','Admin','0','5','1'),
('157','45','删除','del','Job','Admin','0','3','1'),
('158','45','删除简历','delresume','Job','Admin','0','3','1'),
('159','45','查看','index','Job','Admin','0','9','1'),
('160','45','修改','modify','Job','Admin','0','11','1'),
('161','45','应聘简历','resume','Job','Admin','0','1','1'),
('162','45','应聘简历详情','viewresume','Job','Admin','0','1','1'),
('163','45','保存添加','saveadd','Job','Admin','0','2','1'),
('164','45','保存修改','savemodify','Job','Admin','0','4','1'),
('165','121','设置','config','Log','Admin','0','1','1'),
('166','121','删除','del','Log','Admin','0','3','1'),
('167','121','清除所有日志','delall','Log','Admin','0','3','1'),
('168','121','获取地理位置','getlocation','Log','Admin','0','3','1'),
('169','121','查看','index','Log','Admin','0','9','1'),
('170','121','保存设置','saveconfig','Log','Admin','0','4','1'),
('171','25','查看','sendindex','Mail','Admin','0','9','1'),
('172','25','添加','addsend','Mail','Admin','0','10','1'),
('173','25','保存添加','saveaddsend','Mail','Admin','0','2','1'),
('174','25','删除','delsend','Mail','Admin','0','3','1'),
('175','25','批量删除','batchdelsend','Mail','Admin','0','3','1'),
('176','25','修改','modifysend','Mail','Admin','0','11','1'),
('177','25','保存修改','savemodifysend','Mail','Admin','0','4','1'),
('178','26','添加','add','Mail','Admin','0','10','1'),
('179','26','批量删除','batchdel','Mail','Admin','0','3','1'),
('180','26','删除','del','Mail','Admin','0','3','1'),
('181','26','查看','index','Mail','Admin','0','9','1'),
('182','26','修改','modify','Mail','Admin','0','11','1'),
('183','26','保存添加','saveadd','Mail','Admin','0','2','1'),
('184','26','保存修改','savemodify','Mail','Admin','0','4','1'),
('185','24','添加','addclass','Mail','Admin','0','10','1'),
('186','24','批量删除','batchdelclass','Mail','Admin','0','3','1'),
('187','24','排序','batchsortclass','Mail','Admin','0','5','1'),
('188','24','删除','delclass','Mail','Admin','0','3','1'),
('189','24','查看','classindex','Mail','Admin','0','9','1'),
('190','24','修改','modifyclass','Mail','Admin','0','11','1'),
('191','24','导入查看','import','Mail','Admin','0','9','1'),
('192','24','导入','startimport','Mail','Admin','0','6','1'),
('193','24','导出','exportmail','Mail','Admin','0','6','1'),
('194','24','保存添加','saveaddclass','Mail','Admin','0','2','1'),
('195','24','保存修改','savemodifyclass','Mail','Admin','0','4','1'),
('196','52','添加','add','Member','Admin','0','10','1'),
('197','52','审核/取消审核','batchcheck','Member','Admin','0','1','1'),
('198','52','批量删除','batchdel','Member','Admin','0','3','1'),
('199','52','锁定/取消锁定','batchlock','Member','Admin','0','1','1'),
('200','52','修改密码','batchmodifypwd','Member','Admin','0','1','1'),
('201','52','删除','del','Member','Admin','0','3','1'),
('202','52','导出','export','Member','Admin','0','6','1'),
('203','52','查看','index','Member','Admin','0','9','1'),
('204','52','修改','modify','Member','Admin','0','11','1'),
('205','52','保存添加','saveadd','Member','Admin','0','2','1'),
('206','52','保存修改','savemodify','Member','Admin','0','4','1'),
('207','52','设置管理员','setadmin','Member','Admin','0','1','1'),
('208','52','代管','take','Member','Admin','0','1','1'),
('209','51','添加','add','MemberGroup','Admin','0','10','1'),
('210','51','批量删除','batchdel','MemberGroup','Admin','0','3','1'),
('211','51','删除','del','MemberGroup','Admin','0','3','1'),
('212','51','查看','index','MemberGroup','Admin','0','9','1'),
('213','51','修改','modify','MemberGroup','Admin','0','11','1'),
('214','51','保存添加','saveadd','MemberGroup','Admin','0','2','1'),
('215','51','保存修改','savemodify','MemberGroup','Admin','0','4','1'),
('216','20','添加','reg','Config','Admin','0','9','1'),
('217','20','保存修改','savereg','Config','Admin','0','4','1'),
('218','78','修改','modify','Order','Admin','0','10','1'),
('219','78','保存修改','savemodify','Order','Admin','0','4','1'),
('220','78','删除','delorder','Order','Admin','0','3','1'),
('221','78','查看','index','Order','Admin','0','9','1'),
('222','78','导出','export','Order','Admin','0','6','1'),
('223','78','设置','order','Config','Admin','0','11','1'),
('224','78','保存设置','saveorder','Config','Admin','0','4','1'),
('225','17','查看','seo','Config','Admin','0','9','1'),
('226','17','保存设置','saveseo','Config','Admin','0','4','1'),
('227','33','添加','add','Special','Admin','0','10','1'),
('228','33','删除','del','Special','Admin','0','3','1'),
('229','33','查看','index','Special','Admin','0','9','1'),
('230','33','修改','modify','Special','Admin','0','11','1'),
('231','33','保存所有','saveall','Special','Admin','0','2','1'),
('232','33','保存添加','saveadd','Special','Admin','0','2','1'),
('233','33','保存修改','savemodify','Special','Admin','0','4','1'),
('234','35','添加','add','Support','Admin','0','10','1'),
('235','35','批量删除','batchdel','Support','Admin','0','3','1'),
('236','35','排序','batchsort','Support','Admin','0','5','1'),
('237','35','删除','del','Support','Admin','0','3','1'),
('238','35','查看','index','Support','Admin','0','9','1'),
('239','35','修改','modify','Support','Admin','0','11','1'),
('240','35','保存添加','saveadd','Support','Admin','0','2','1'),
('241','35','保存修改','savemodify','Support','Admin','0','4','1'),
('242','35','设置','online','Config','Admin','0','11','1'),
('243','35','保存修改','saveonline','Config','Admin','0','4','1'),
('244','39','查看','third','Support','Admin','0','9','1'),
('245','39','保存添加','addthird','Support','Admin','0','2','1'),
('246','39','保存修改','savethird','Support','Admin','0','4','1'),
('247','72','添加','add','Tag','Admin','0','10','1'),
('248','72','批量删除','batchdel','Tag','Admin','0','3','1'),
('249','72','删除','del','Tag','Admin','0','3','1'),
('250','72','查看','index','Tag','Admin','0','9','1'),
('251','72','修改','modify','Tag','Admin','0','11','1'),
('252','72','保存添加','saveadd','Tag','Admin','0','2','1'),
('253','72','保存修改','savemodify','Tag','Admin','0','4','1'),
('268','58','查看模板切换','pick','Template','Admin','0','9','1'),
('269','58','保存模板切换','savepick','Template','Admin','0','4','1'),
('270','58','备份模板','backup','Template','Admin','0','1','1'),
('271','58','删除模板','del','Template','Admin','0','3','1'),
('272','58','语言包','lang','Template','Admin','0','1','1'),
('273','58','保存语言包','savelang','Template','Admin','0','4','1'),
('274','59','查看模板管理','index','Template','Admin','0','9','1'),
('275','59','修改模板文件','modify','Template','Admin','0','11','1'),
('276','59','保存模板文件修改','savemodify','Template','Admin','0','4','1'),
('278','59','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('279','60','查看样式管理','style','Template','Admin','0','9','1'),
('292','60','修改样式','modifystyle','Template','Admin','0','11','1'),
('293','60','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('294','119','模板设置','config','Template','Admin','0','9','1'),
('295','119','保存模板设置','saveconfig','Template','Admin','0','4','1'),
('296','93','查看模板切换','pick','WapTemplate','Admin','0','9','1'),
('297','93','保存模板切换','savepick','WapTemplate','Admin','0','4','1'),
('298','93','备份模板','backup','WapTemplate','Admin','0','1','1'),
('299','93','删除模板','del','WapTemplate','Admin','0','3','1'),
('300','93','语言包','lang','WapTemplate','Admin','0','1','1'),
('301','93','保存语言包','savelang','WapTemplate','Admin','0','4','1'),
('302','94','查看模板管理','index','WapTemplate','Admin','0','9','1'),
('303','94','修改模板文件','modify','WapTemplate','Admin','0','11','1'),
('304','94','保存模板文件修改','savemodify','WapTemplate','Admin','0','4','1'),
('306','94','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('307','95','查看样式管理','style','WapTemplate','Admin','0','9','1'),
('308','95','修改样式','modifystyle','WapTemplate','Admin','0','11','1'),
('309','95','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('310','120','模板设置','config','WapTemplate','Admin','0','9','1'),
('311','120','保存模板设置','saveconfig','WapTemplate','Admin','0','4','1'),
('312','102','微信绑定设置','messageapi','Wx','Admin','0','9','1'),
('313','102','保存微信绑定设置','savemessageapi','Wx','Admin','0','4','1'),
('314','112','基本信息设置','basic','Wx','Admin','0','9','1'),
('315','112','保存基本信息设置','savebasic','Wx','Admin','0','4','1'),
('316','103','同步菜单到微信','updatemenu','Wx','Admin','0','1','1'),
('317','103','清除微信菜单','clearmenu','Wx','Admin','0','1','1'),
('318','103','查看','menu','Wx','Admin','0','9','1'),
('319','103','添加','addmenu','Wx','Admin','0','10','1'),
('320','103','保存添加','saveaddmenu','Wx','Admin','0','2','1'),
('321','103','修改','modifymenu','Wx','Admin','0','11','1'),
('322','103','保存修改','savemodifymenu','Wx','Admin','0','4','1'),
('323','103','删除','menu','Wx','Admin','0','3','1'),
('324','103','保存所有','savemodifymenu','Wx','Admin','0','4','1'),
('325','118','排序','batchsortmenu','Wx','Admin','0','5','1'),
('326','118','查看','config','Wx','Admin','0','9','1'),
('327','118','显示/隐藏','savemodifymenu','Wx','Admin','0','1','1'),
('328','104','查看','subscribereply','Wx','Admin','0','9','1'),
('329','104','保存修改','savesubscribereply','Wx','Admin','0','4','1'),
('336','105','查看','keywordreply','Wx','Admin','0','9','1'),
('337','105','删除','delkeywordreply','Wx','Admin','0','3','1'),
('338','105','批量删除','batchdelkeywordreply','Wx','Admin','0','3','1'),
('339','105','排序','batchsortkeywordreply','Wx','Admin','0','5','1'),
('340','105','修改','modifykeywordreply','Wx','Admin','0','11','1'),
('341','105','保存修改','savemodifykeywordreply','Wx','Admin','0','4','1'),
('342','105','使用次数清零','zerokeywordcount','Wx','Admin','0','1','1'),
('343','105','添加','addkeywordreply','Wx','Admin','0','10','1'),
('344','105','保存添加','saveaddkeywordreply','Wx','Admin','0','2','1'),
('345','113','查看','lbsreply','Wx','Admin','0','9','1'),
('346','113','保存修改','savelbsreply','Wx','Admin','0','4','1'),
('347','106','查看','defaultreply','Wx','Admin','0','9','1'),
('348','106','保存修改','savedefaultreply','Wx','Admin','0','4','1'),
('349','109','查看','message','Wx','Admin','0','9','1'),
('350','109','删除','delallmessage','Wx','Admin','0','3','1'),
('351','109','批量删除','batchdelmessage','Wx','Admin','0','3','1'),
('352','109','导出','exportmessage','Wx','Admin','0','6','1'),
('353','114','查看','query','Wx','Admin','0','9','1'),
('354','111','查看','lottery','Wx','Admin','0','9','1'),
('355','111','查看中奖用户','award','Wx','Admin','0','1','1'),
('356','111','确认/取消领奖','checkaward','Wx','Admin','0','1','1'),
('357','111','删除','dellottery','Wx','Admin','0','3','1'),
('358','111','清除抽奖数据','clearlottery','Wx','Admin','0','3','1'),
('359','111','批量删除','batchdellottery','Wx','Admin','0','3','1'),
('360','111','添加','addlottery','Wx','Admin','0','10','1'),
('361','111','保存添加','saveaddlottery','Wx','Admin','0','2','1'),
('362','111','修改','modifylottery','Wx','Admin','0','11','1'),
('363','111','保存修改','savemodifylottery','Wx','Admin','0','4','1'),
('364','111','排序','batchsortlottery','Wx','Admin','0','5','1'),
('365','115','添加','addvote','Wx','Admin','0','10','1'),
('366','115','批量删除','batchdelvote','Wx','Admin','0','3','1'),
('367','115','排序','batchsortvote','Wx','Admin','0','5','1'),
('368','115','清空投票记录','clearvote','Wx','Admin','0','3','1'),
('369','115','删除','delvote','Wx','Admin','0','3','1'),
('370','115','查看','vote','Wx','Admin','0','9','1'),
('371','115','修改','modifyvote','Wx','Admin','0','11','1'),
('372','115','保存添加','saveaddvote','Wx','Admin','0','2','1'),
('373','115','保存修改','savemodifyvote','Wx','Admin','0','4','1'),
('374','117','查看','research','Wx','Admin','0','9','1'),
('375','117','添加','addresearch','Wx','Admin','0','10','1'),
('376','117','保存添加','saveresearchadd','Wx','Admin','0','2','1'),
('377','117','修改','modifyresearch','Wx','Admin','0','11','1'),
('378','117','保存修改','savemodifyresearch','Wx','Admin','0','4','1'),
('379','117','批量删除','batchdelresearch','Wx','Admin','0','3','1'),
('380','117','删除','delresearch','Wx','Admin','0','3','1'),
('381','117','清除调查数据','clearresearchdata','Wx','Admin','0','3','1'),
('382','117','无刷新清除调查数据','clearresearch','Wx','Admin','0','3','1'),
('383','117','查看设置调查问题','question','Wx','Admin','0','11','1'),
('384','117','导出调查结果','exportquestion','Wx','Admin','0','6','1'),
('385','117','添加调查问题','addquestion','Wx','Admin','0','10','1'),
('386','117','保存添加调查问题','savequestionadd','Wx','Admin','0','2','1'),
('387','117','修改调查问题','modifyquestion','Wx','Admin','0','11','1'),
('388','117','保存修改调查问题','savemodifyquestion','Wx','Admin','0','4','1'),
('389','117','批量删除调查问题','batchdelquestion','Wx','Admin','0','3','1'),
('390','117','删除调查问题','delquestion','Wx','Admin','0','3','1'),
('391','117','调查问题排序','sortquestion','Wx','Admin','0','5','1'),
('392','117','查看用户建议','suggest','Wx','Admin','0','11','1'),
('393','117','导出用户建议','exportsuggest','Wx','Admin','0','6','1'),
('394','116','查看会员卡','card','Wx','Admin','0','9','1'),
('395','116','会员卡设置','cardconfig','Wx','Admin','0','11','1'),
('396','116','保存会员卡设置','updatecardconfig','Wx','Admin','0','4','1'),
('397','116','会员卡充值','pay','Wx','Admin','0','1','1'),
('398','116','赠送积分','givescore','Wx','Admin','0','1','1'),
('399','116','批量冻结','batchlock','Wx','Admin','0','1','1'),
('400','116','导出所有会员','export','Wx','Admin','0','6','1'),
('401','116','查看消费记录','consume','Wx','Admin','0','11','1'),
('402','116','消费金额','expense','Wx','Admin','0','1','1'),
('403','116','查看积分记录','score','Wx','Admin','0','11','1'),
('404','116','查看礼品券','gift','Wx','Admin','0','11','1'),
('405','116','兑换礼品券会员','giftmember','Wx','Admin','0','11','1'),
('406','116','添加礼品券','addgift','Wx','Admin','0','10','1'),
('407','116','保存添加礼品券','savegiftadd','Wx','Admin','0','2','1'),
('408','116','修改礼品券','modifygift','Wx','Admin','0','11','1'),
('409','116','保存修改礼品券','savemodifygift','Wx','Admin','0','4','1'),
('410','116','删除礼品券','delgift','Wx','Admin','0','3','1'),
('411','116','礼品券排序','batchsortgift','Wx','Admin','0','5','1'),
('412','116','查看会员通知','notify','Wx','Admin','0','11','1'),
('413','116','发布会员通知','addnotify','Wx','Admin','0','10','1'),
('414','116','保存发布会员通知','savenotifyadd','Wx','Admin','0','2','1'),
('415','116','修改会员通知','modifynotify','Wx','Admin','0','11','1'),
('416','116','保存修改会员通知','savemodifynotify','Wx','Admin','0','4','1'),
('417','116','删除会员通知','delnotify','Wx','Admin','0','3','1'),
('418','116','查看优惠卷','coupon','Wx','Admin','0','11','1'),
('419','116','兑换优惠卷会员','couponmember','Wx','Admin','0','11','1'),
('420','116','添加优惠卷','addcoupon','Wx','Admin','0','10','1'),
('421','116','保存添加优惠卷','savecouponadd','Wx','Admin','0','2','1'),
('422','116','修改优惠卷','modifycoupon','Wx','Admin','0','11','1'),
('423','116','保存修改优惠卷','savemodifycoupon','Wx','Admin','0','4','1'),
('424','116','删除优惠卷','delcoupon','Wx','Admin','0','3','1'),
('425','116','优惠卷排序','batchsortcoupon','Wx','Admin','0','5','1'),
('426','63','查看','modify','Member','Member','0','9','1'),
('427','63','保存修改','savemodify','Member','Member','0','4','1'),
('428','67','批量删除','batchdelmessage','Guestbook','Member','0','3','1'),
('429','67','删除','delmessage','Guestbook','Member','0','3','1'),
('430','67','查看','index','Guestbook','Member','0','9','1'),
('431','79','批量删除','batchdelorder','Order','Member','0','3','1'),
('432','79','详情','view','Order','Member','0','9','1'),
('433','79','查看','index','Order','Member','0','9','1'),
('434','89','修改','modify','Resume','Member','0','11','1'),
('435','89','保存修改','savemodify','Resume','Member','0','4','1'),
('436','89','批量删除','batchdelresume','Resume','Member','0','3','1'),
('437','89','删除','delresume','Resume','Member','0','3','1'),
('438','89','查看','index','Resume','Member','0','9','1'),
('439','68','批量删除','batchdel','Comment','Member','0','3','1'),
('440','68','删除','del','Comment','Member','0','3','1'),
('441','68','查看','index','Comment','Member','0','9','1'),
('442','76','查看','core','Config','Admin','0','9','1'),
('443','76','保存修改','savecore','Config','Admin','0','4','1'),
('444','75','查看','searchenginelogin','Seo','Admin','0','9','1'),
('445','86','查看','sitemap','Seo','Admin','0','9','1'),
('446','86','生成网站地图','makesitemap','Seo','Admin','0','1','1'),
('447','86','删除网站地图','delsitemap','Seo','Admin','0','3','1'),
('448','87','查看','autolink','Config','Admin','0','9','1'),
('449','87','保存修改','saveautolink','Config','Admin','0','4','1'),
('451','123','添加','add','AdGroup','Admin','0','10','1'),
('452','123','删除','del','AdGroup','Admin','0','3','1'),
('453','123','查看','index','AdGroup','Admin','0','9','1'),
('454','123','修改','modify','AdGroup','Admin','0','11','1'),
('455','123','保存添加','saveadd','AdGroup','Admin','0','2','1'),
('456','123','保存修改','savemodify','AdGroup','Admin','0','4','1'),
('457','49','排序','sort','Ad','Admin','0','5','1'),
('458','25','群发当前邮件','send','Mail','Admin','0','1','1'),
('459','25','开始邮件群发','startsend','Mail','Admin','0','1','1'),
('460','25','查看邮件群发日志','viewlog','Mail','Admin','0','1','1'),
('461','86','保存网站地图设置','savesitemap','Seo','Admin','0','4','1'),
('462','78','查看日志','orderlog','Order','Admin','0','9','1'),
('463','78','修改日志','modifyorderlog','Order','Admin','0','11','1'),
('464','78','保存修改日志','savemodifyorderlog','Order','Admin','0','4','1'),
('465','78','删除日志','delorderlog','Order','Admin','0','3','1'),
('466','78','设置状态','setstatus','Order','Admin','0','1','1'),
('467','124','查看','index','Shipping','Admin','0','9','1'),
('468','124','添加','add','Shipping','Admin','0','10','1'),
('469','124','修改','modify','Shipping','Admin','0','11','1'),
('470','124','保存修改','savemodify','Shipping','Admin','0','4','1'),
('471','124','保存添加','saveadd','Shipping','Admin','0','2','1'),
('472','124','删除','del','Shipping','Admin','0','3','1'),
('473','124','排序','sort','Shipping','Admin','0','5','1'),
('474','125','查看','index','Pay','Admin','0','9','1'),
('475','125','添加','add','Pay','Admin','0','10','1'),
('476','125','修改','modify','Pay','Admin','0','11','1'),
('477','125','保存修改','savemodify','Pay','Admin','0','4','1'),
('478','125','保存添加','saveadd','Pay','Admin','0','2','1'),
('479','125','删除','del','Pay','Admin','0','3','1'),
('480','125','排序','sort','Pay','Admin','0','5','1'),
('481','126','查看','oauth','Config','Admin','0','9','1'),
('482','126','保存修改','saveoauth','Config','Admin','0','4','1'),
('483','80','批量执行SQL语句','sql','Db','Admin','0','11','1'),
('484','80','批量执行SQL语句','executesql','Db','Admin','0','1','1'),
('485','127','查看','index','Type','Admin','0','9','1'),
('486','127','添加','add','Type','Admin','0','10','1'),
('487','127','修改','modify','Type','Admin','0','11','1'),
('488','127','保存修改','savemodify','Type','Admin','0','4','1'),
('489','127','保存添加','saveadd','Type','Admin','0','2','1'),
('490','127','排序','sort','Type','Admin','0','5','1'),
('491','127','删除','del','Type','Admin','0','3','1'),
('492','127','属性分组管理','group','Type','Admin','0','1','1'),
('493','127','添加属性分组','addgroup','Type','Admin','0','10','1'),
('494','127','修改属性分组','modifygroup','Type','Admin','0','11','1'),
('495','127','保存属性分组修改','savemodifygroup','Type','Admin','0','4','1'),
('496','127','保存属性分组添加','saveaddgroup','Type','Admin','0','2','1'),
('497','127','属性分组排序','sortgroup','Type','Admin','0','5','1'),
('498','127','删除属性分组','delgroup','Type','Admin','0','3','1'),
('499','127','属性列表管理','attribute','Type','Admin','0','1','1'),
('500','127','添加属性','addattribute','Type','Admin','0','10','1'),
('501','127','修改属性','modifyattribute','Type','Admin','0','11','1'),
('502','127','保存属性修改','savemodifyattribute','Type','Admin','0','4','1'),
('503','127','保存属性添加','saveaddattribute','Type','Admin','0','2','1'),
('504','127','属性排序','sortattribute','Type','Admin','0','5','1'),
('505','127','删除属性','delattribute','Type','Admin','0','3','1'),
('506','128','销售统计','stat','Order','Admin','0','9','1'),
('507','129','网站目录权限检测','dirDetection','Public','Admin','0','9','1'),
('508','46','评论回复','reply','Comment','Admin','0','2','1'),
('509','131','资金管理','index','Cash','Admin','0','9','1'),
('510','131','修改','modify','Cash','Admin','0','11','1'),
('511','131','保存修改','savemodify','Cash','Admin','0','4','1'),
('512','131','删除','del','Cash','Admin','0','3','1'),
('513','131','给会员转电子币','transfer','Cash','Admin','0','2','1'),
('514','133','查看','config','App','Admin','0','9','1'),
('515','133','保存App基本设置','saveConfig','App','Admin','0','4','1'),
('516','136','查看','about','App','Admin','0','9','1'),
('517','136','保存修改','saveAbout','App','Admin','0','4','1'),
('518','139','查看','secret','App','Admin','0','9','1'),
('519','139','创建','addSecret','App','Admin','0','10','1'),
('520','139','修改','modifySecret','App','Admin','0','11','1'),
('521','139','保存修改','saveModifySecret','App','Admin','0','4','1'),
('522','139','保存创建','saveAddSecret','App','Admin','0','2','1'),
('523','139','删除','delSecret','App','Admin','0','3','1'),
('524','137','推送消息历史','message','App','Admin','0','1','1'),
('525','137','我要推送消息','addMessage','App','Admin','0','10','1'),
('526','137','推送消息','pushMessage','App','Admin','0','2','1'),
('527','137','删除','delMessage','App','Admin','0','3','1'),
('528','134','查看','feedback','App','Admin','0','9','1'),
('529','134','删除','delFeedback','App','Admin','0','3','1'),
('530','135','查看','stat','App','Admin','0','9','1'),
('531','138','查看','active','App','Admin','0','9','1');

INSERT INTO `youdian_menu_top` VALUES
('1','系统设置','Public/AdminLeft','menu','1','0001','1','1'),
('2','系统管理','Public/AdminLeft','menu','2','0001','0','1'),
('3','内容管理','Public/AdminLeft','menu','3','0001','0','1'),
('4','互动管理','Public/AdminLeft','menu','4','0001','0','1'),
('5','广告管理','Public/AdminLeft','menu','5','0001','0','1'),
('6','会员管理','Public/AdminLeft','menu','6','0001','0','1'),
('7','模板管理','Public/AdminLeft','menu','8','0001','0','1'),
('8','退出系统','Public/Logout','_top','15','0001','0','1'),
('9','基本信息','Public/MemberLeft','menu','1','0000','0','1'),
('10','内容管理','Public/MemberLeft','menu','2','0000','0','1'),
('11','安全退出','Public/Logout','_top','4','0000','0','1'),
('12','修改密码','Public/Pwd','main','3','0000','0','0'),
('13','缓存管理','Public/ClearCache','main','9','0001','0','1'),
('14','网站优化','Public/AdminLeft','menu','7','0001','0','1'),
('15','微信平台','Public/AdminLeft','menu','8','0001','0','1'),
('16','APP管理','Public/AdminLeft','menu','7','0001','0','1');

INSERT INTO `youdian_oauth` VALUES
('1','QQ号码登录','1',NULL,NULL,'http://connect.qq.com/','qq',NULL,'1');

INSERT INTO `youdian_pay_type` VALUES
('1','支付宝','1','1','1'),
('2','财付通即时到账','2','1','0'),
('3','财付通担保支付','3','1','0'),
('4','paypal支付','4','1','0'),
('5','银行汇款/转账、邮局汇款','5','0','1'),
('6','货到付款','6','0','1'),
('7','余额支付','7','0','1'),
('8','银联支付','8','1','0'),
('9','网银在线','9','1','0'),
('10','微信支付','2','1','1');

INSERT INTO `youdian_resume` VALUES
('1','3','0','肖芳','女','1990-05-16','汉族','2000-3000','群众','大专','13587898345','xiaofang@qq.com','北京市海淀区三一路','2013-05-16 11:13:27','北京','文秘','北京大学',NULL,'1');

INSERT INTO `youdian_support` VALUES
('1','业务咨询','1','123456','1','1','1'),
('6','consult','1','888888','1','1','2');

INSERT INTO `youdian_support3` VALUES
('1',NULL,'1','1'),
('2',NULL,'1','2');

INSERT INTO `youdian_support_type` VALUES
('1','腾讯QQ','1'),
('2','淘宝旺旺','2'),
('3','阿里旺旺','3'),
('4','微软MSN','4'),
('5','Skype','5'),
('6','阿里旺旺国际版','3'),
('7','自定义类型','20');

INSERT INTO `youdian_wx_app` VALUES
('1','迎中秋庆国庆刮刮卡大抽奖','1','刮刮卡','99','1@@@迎中秋庆国庆刮刮卡大抽奖，好运多多，机会多多，小伙伴们，赶快参与吧！@@@@@@2014-10-30 16:51:41@@@2018-10-31 16:51:41@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/scratch.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@联想x60笔记本@@@1@@@1@@@小米3S手机@@@2@@@5@@@64G U盘@@@5@@@10@@@3@@@123@@@1@@@',NULL,'1'),
('2','10周年店庆幸运大转抽奖活动','1','大转盘','99','0@@@10周年店庆大抽奖活动，好运多多，奖品多多，小伙伴们，赶快来参与吧！@@@@@@2014-10-30 16:52:46@@@2018-10-31 16:52:46@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/wheel.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@ipad平板电脑@@@1@@@1@@@iphone5手机@@@2@@@5@@@手机充电宝@@@5@@@10@@@3@@@123@@@1@@@',NULL,'1'),
('3','你是通过什么途径知道我们的','2','投票','99','0@@@2014-10-30 16:55:00@@@2019-10-30 16:55:00@@@1###搜索引擎$$$2###网络广告$$$3###朋友介绍$$$4###电视报纸$$$5###其它@@@/Upload/1414659467.png@@@1',NULL,'1'),
('4','高级会员卡','6','会员卡','99','高级会员卡@@@/Upload/1414659502.png@@@/Public/Images/card/bg17.png@@@/Public/Images/card/cover.jpg@@@微时代会员卡，方便携带收藏，永不挂失@@@#FFFF00@@@#FFFF00@@@@@@@@@1@@@1@@@某某商家@@@长沙友点软件科技有限公司（http://www.youdiansoft.cn）位于长沙市星沙经济开发区，是国内首家研发中英文网站、手机网站、微信网站三站合一的高科技软件企业，拥有独立自主研发的三站合一企业级产品《友点企业网站管理系统》。以公司核心技术为依托，形成了针对不同行业、不同规模、不同应用的系列产品和解决方案。@@@0731-84037726@@@长沙市星沙经济开发区板仓路尚都花园城6栋1单元904@@@@@@@@@123@@@@@@',NULL,'1'),
('5','你最想去哪里旅游?','5','调查','99','/Public/tpl/wx/images/research.png@@@感谢您参与此次调查，本调查目的在于了解产品对消费者购物选择的影响。您对本问卷的所有回答都是以匿名形式进行并且答案得到严格保密，研究结果将是结论性质的报告，不会泄漏您的任何相关信息。每位参与调研的朋友都将获得我们送出的尊贵礼品，同时你还有机会获得大奖。\r\n                                @@@尊敬的客户：\r\n感谢您的耐心参与，您的选择，将对我们起到重要的指导作用，我们在此向您表示诚挚的谢意。\r\n同时，为了回馈您的贡献，我们将从所有参与调研的客户中，随机抽取几位幸运奖得主。您将有机会获得我们为您精心准备的礼品一份，中奖名单将在近期公布，敬请关注。\r\n祝您生活愉快。\r\n                                @@@2014-10-30 17:00:30@@@2018-01-28 17:00:30@@@@@@赶快来参与吧，还有机会中大奖！@@@0',NULL,'1');

INSERT INTO `youdian_wx_apptype` VALUES
('1','微活动','1','1'),
('2','微投票','2','1'),
('3','微工具','3','1'),
('4','地理位置服务','4','1'),
('5','微调查','5','1'),
('6','微会员卡','6','1');

INSERT INTO `youdian_wx_menu` VALUES
('1','0','一级菜单1','1','0',NULL,NULL,NULL,NULL,'1'),
('2','0','一级菜单2','1','2',NULL,NULL,NULL,NULL,'1'),
('3','0','一级菜单3','1','3',NULL,NULL,NULL,NULL,'1'),
('4','2','二级菜单25','1','4','这里填写二级菜单25返回消息！','3',NULL,NULL,'1'),
('5','2','二级菜单23','1','3','这里填写二级菜单23返回消息！','22',NULL,NULL,'1'),
('6','1','二级菜单15','1','2','这里填写二级菜单15返回消息！','2',NULL,NULL,'1'),
('10','2','二级菜单22','1','2','这里填写二级菜单22返回消息！',NULL,NULL,NULL,'1'),
('11','1','二级菜单14','1','1','这里填写二级菜单14返回消息！',NULL,NULL,NULL,'1'),
('15','2','二级菜单21','1','1','这里填写二级菜单21返回消息！',NULL,NULL,NULL,'1'),
('16','3','二级菜单31','1','1','这里填写二级菜单31返回消息！',NULL,NULL,NULL,'1'),
('17','2','二级菜单24','1','3','这里填写二级菜单24返回消息！',NULL,NULL,NULL,'1'),
('21','1','二级菜单11','1','0','这里填写二级菜单11返回消息！',NULL,NULL,NULL,'1'),
('22','1','二级菜单12','1','0','这里填写二级菜单12返回消息！','3',NULL,NULL,'1'),
('23','3','二级菜单32','1','2','这里填写二级菜单32返回消息！','3',NULL,NULL,'1'),
('24','1','二级菜单13','1','0','这里填写二级菜单13返回消息！',NULL,NULL,NULL,'1');

INSERT INTO `youdian_wx_reply` VALUES
('1','1','subscribe','0','1','0',NULL,NULL,NULL,NULL,'1'),
('2','2','default','2','1','0',NULL,NULL,NULL,NULL,'1'),
('3','4','lbs','4','1','0',NULL,NULL,NULL,NULL,'1');

INSERT INTO `youdian_wx_type` VALUES
('1','微信文本消息','1','1','1'),
('2','微信图文消息','1','2','1'),
('3','微信音乐消息','1','3','1'),
('4','打开频道主页','0','4','1'),
('5','微应用','1','5','1'),
('6','外部链接','0','6','1');

