/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.tracker;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppWebService;

public class WebServiceTracker<S, T>
extends ServiceTracker<S, T> {
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int REMOVED = 3;
    private BundleContext context;

    public WebServiceTracker(BundleContext bundleContext) {
        super(bundleContext, AppWebService.class.getName(), null);
        this.context = bundleContext;
    }

    @Override
    public T addingService(ServiceReference<S> serviceReference) {
        AppWebService appWebService = (AppWebService)this.context.getService(serviceReference);
        this.processComponent(1, serviceReference, appWebService);
        return (T)appWebService;
    }

    @Override
    public void modifiedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(2, serviceReference, (AppWebService)t);
    }

    @Override
    public void removedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(3, serviceReference, (AppWebService)t);
    }

    private void processComponent(int n, ServiceReference<S> serviceReference, AppWebService appWebService) {
        switch (n) {
            case 2: {
                ASAF.getWebserviceManager().removeWebService(appWebService);
            }
            case 1: {
                ASAF.getWebserviceManager().addWebService(appWebService);
                break;
            }
            case 3: {
                ASAF.getWebserviceManager().removeWebService(appWebService);
                this.context.ungetService(serviceReference);
            }
        }
    }
}

