/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.tracker;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.frame.menu.ShowViewMenu;

public class ViewTracker<S, T>
extends ServiceTracker<S, T> {
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int REMOVED = 3;
    private BundleContext context;

    public ViewTracker(BundleContext bundleContext) {
        super(bundleContext, AppView.class.getName(), null);
        this.context = bundleContext;
    }

    @Override
    public T addingService(ServiceReference<S> serviceReference) {
        AppView appView = (AppView)this.context.getService(serviceReference);
        this.processComponent(1, serviceReference, appView);
        return (T)appView;
    }

    @Override
    public void modifiedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(2, serviceReference, (AppView)t);
    }

    @Override
    public void removedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(3, serviceReference, (AppView)t);
    }

    private void processComponent(int n, ServiceReference<S> serviceReference, AppView appView) {
        switch (n) {
            case 2: {
                ASAF.getComponentManager().removeView(appView);
                ((ShowViewMenu)ASAF.getMenu("showView")).removeView(appView.getUniqueId());
            }
            case 1: {
                ASAF.getComponentManager().addView(appView);
                ((ShowViewMenu)ASAF.getMenu("showView")).addView(appView);
                break;
            }
            case 3: {
                ASAF.getComponentManager().removeView(appView);
                ((ShowViewMenu)ASAF.getMenu("showView")).removeView(appView.getUniqueId());
                this.context.ungetService(serviceReference);
            }
        }
    }
}

