/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.tracker;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppMenu;

public class MenuTracker<S, T>
extends ServiceTracker<S, T> {
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int REMOVED = 3;
    private BundleContext context;

    public MenuTracker(BundleContext bundleContext) {
        super(bundleContext, AppMenu.class.getName(), null);
        this.context = bundleContext;
    }

    @Override
    public T addingService(ServiceReference<S> serviceReference) {
        AppMenu appMenu = (AppMenu)this.context.getService(serviceReference);
        this.processComponent(1, serviceReference, appMenu);
        return (T)appMenu;
    }

    @Override
    public void modifiedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(2, serviceReference, (AppMenu)t);
    }

    @Override
    public void removedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(3, serviceReference, (AppMenu)t);
    }

    private void processComponent(int n, ServiceReference<S> serviceReference, AppMenu appMenu) {
        switch (n) {
            case 2: {
                ASAF.getMainView().getComponentManager().removeMenu(appMenu);
            }
            case 1: {
                ASAF.getMainView().getComponentManager().addMenu(appMenu);
                break;
            }
            case 3: {
                ASAF.getMainView().getComponentManager().removeMenu(appMenu);
                this.context.ungetService(serviceReference);
            }
        }
    }
}

