/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.tracker;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppAction;

public class ActionTracker<S, T>
extends ServiceTracker<S, T> {
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int REMOVED = 3;
    private BundleContext context;

    public ActionTracker(BundleContext bundleContext) {
        super(bundleContext, AppAction.class.getName(), null);
        this.context = bundleContext;
    }

    @Override
    public T addingService(ServiceReference<S> serviceReference) {
        AppAction appAction = (AppAction)this.context.getService(serviceReference);
        this.processComponent(1, serviceReference, appAction);
        return (T)appAction;
    }

    @Override
    public void modifiedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(2, serviceReference, (AppAction)t);
    }

    @Override
    public void removedService(ServiceReference<S> serviceReference, T t) {
        this.processComponent(3, serviceReference, (AppAction)t);
    }

    private void processComponent(int n, ServiceReference<S> serviceReference, AppAction appAction) {
        switch (n) {
            case 2: {
                ASAF.getMainView().getComponentManager().removeAction(appAction);
            }
            case 1: {
                ASAF.getMainView().getComponentManager().addAction(appAction);
                break;
            }
            case 3: {
                ASAF.getMainView().getComponentManager().removeAction(appAction);
                this.context.ungetService(serviceReference);
            }
        }
    }
}

