/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.task;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.yaoqiang.asaf.task.AbstractBean;
import org.yaoqiang.asaf.task.Journal;
import org.yaoqiang.asaf.task.Task;

public class TaskService
extends AbstractBean {
    public static final String DEFAULT_NAME = "default";
    private final String name;
    private final ExecutorService executorService;
    private final Journal tasks;
    private final PropertyChangeListener taskPCL;

    public TaskService(String string, ExecutorService executorService) {
        if (string == null) {
            throw new IllegalArgumentException("null name");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
        this.name = string;
        this.executorService = executorService;
        this.tasks = new Journal();
        this.taskPCL = new TaskPCL();
    }

    public TaskService(String string) {
        this(string, new ThreadPoolExecutor(3, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public TaskService() {
        this(DEFAULT_NAME);
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task<?, ?> task) {
        List<Task<?, ?>> list;
        List<Task<?, ?>> list2;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        if (!task.isPending() || task.getTaskService() != null) {
            throw new IllegalArgumentException("task has already been executed");
        }
        task.setTaskService(this);
        task.addPropertyChangeListener(this.taskPCL);
        Journal journal = this.tasks;
        synchronized (journal) {
            list2 = this.tasks.getList();
            this.tasks.addLast(task);
            list = this.tasks.getList();
        }
        this.firePropertyChange(new TaskPropertyChangeEvent(list2, list, null, task));
        this.executorService.execute(task);
    }

    public List<Task<?, ?>> getTasks() {
        return this.tasks.getList();
    }

    public final void shutdown() {
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Runnable> shutdownNow() {
        List<Task<?, ?>> list;
        List<Task<?, ?>> list2;
        List<Runnable> list3 = this.executorService.shutdownNow();
        Journal journal = this.tasks;
        synchronized (journal) {
            list2 = this.tasks.getList();
            for (Runnable runnable : list3) {
                if (!(runnable instanceof Task)) continue;
                Task task = (Task)runnable;
                this.tasks.remove(task);
                task.removePropertyChangeListener(this.taskPCL);
            }
            list = this.tasks.getList();
        }
        this.firePropertyChange("tasks", list2, list);
        return list3;
    }

    public final boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public final boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.executorService.awaitTermination(l, timeUnit);
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Task task;
            String string = propertyChangeEvent.getPropertyName();
            if ("done".equals(string) && (task = (Task)propertyChangeEvent.getSource()).isDone()) {
                List<Task<?, ?>> list;
                List<Task<?, ?>> list2;
                task.removePropertyChangeListener(TaskService.this.taskPCL);
                Journal journal = TaskService.this.tasks;
                synchronized (journal) {
                    list2 = TaskService.this.tasks.getList();
                    TaskService.this.tasks.remove(task);
                    list = TaskService.this.tasks.getList();
                }
                TaskService.this.firePropertyChange(new TaskPropertyChangeEvent(list2, list, task, null));
            }
        }
    }

    final class TaskPropertyChangeEvent
    extends PropertyChangeEvent {
        boolean armed;
        final Task<?, ?> removed;
        final Task<?, ?> added;

        public TaskPropertyChangeEvent(List<Task<?, ?>> list, List<Task<?, ?>> list2, Task<?, ?> task, Task<?, ?> task2) {
            super(TaskService.this, "tasks", list, list2);
            this.armed = false;
            this.removed = task;
            this.added = task2;
        }

        @Override
        public Object getNewValue() {
            return super.getNewValue();
        }

        @Override
        public Object getOldValue() {
            return super.getOldValue();
        }

        public Task getRemoved() {
            return this.removed;
        }

        public Task getAdded() {
            return this.added;
        }
    }
}

