/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.task;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingWorker;
import org.yaoqiang.asaf.task.AbstractBean;
import org.yaoqiang.asaf.task.Journal;
import org.yaoqiang.asaf.task.Task;
import org.yaoqiang.asaf.task.TaskService;

public class TaskMonitor
extends AbstractBean {
    public static final String PROP_FOREGROUND_TASK = "foregroundTask";
    private final PropertyChangeListener taskServicePCL = new TaskServicePCL();
    private final PropertyChangeListener taskPCL = new TaskPCL();
    private final Journal taskQueue = new Journal();
    private boolean autoUpdateForegroundTask = true;
    private Task foregroundTask = null;

    public TaskMonitor(TaskService taskService) {
        taskService.addPropertyChangeListener(this.taskServicePCL);
    }

    public void setForegroundTask(Task task) {
        Task task2;
        Task task3 = this.foregroundTask;
        if (task3 != null) {
            task3.removePropertyChangeListener(this.taskPCL);
        }
        if ((task2 = (this.foregroundTask = task)) != null) {
            task2.addPropertyChangeListener(this.taskPCL);
        }
        this.firePropertyChange(PROP_FOREGROUND_TASK, task3, task2);
    }

    public Task getForegroundTask() {
        return this.foregroundTask;
    }

    public boolean getAutoUpdateForegroundTask() {
        return this.autoUpdateForegroundTask;
    }

    public void setAutoUpdateForegroundTask(boolean bl) {
        boolean bl2 = this.autoUpdateForegroundTask;
        this.autoUpdateForegroundTask = bl;
        this.firePropertyChange("autoUpdateForegroundTask", bl2, this.autoUpdateForegroundTask);
    }

    public List<Task<?, ?>> getTasks() {
        return this.taskQueue.getList();
    }

    /*
     * WARNING - void declaration
     */
    private void updateTasks(List<Task> list, List<Task> list2) {
        boolean bl = false;
        List<Task<?, ?>> list3 = this.taskQueue.getList();
        for (Task object2 : list) {
            if (!object2.isDone() && list2.contains(object2) || !this.taskQueue.remove(object2)) continue;
            bl = true;
        }
        for (Task task : list2) {
            if (task.isCancelled() || task.isDone() || this.taskQueue.getList().contains(task)) continue;
            this.taskQueue.addLast(task);
            bl = true;
        }
        if (bl) {
            List<Task<?, ?>> list4 = this.taskQueue.getList();
            this.firePropertyChange("tasks", list3, list4);
        }
        if (this.autoUpdateForegroundTask && this.getForegroundTask() == null) {
            void var5_13;
            Object var5_11 = null;
            List<Task<?, ?>> list4 = this.taskQueue.getList();
            if (!list4.isEmpty()) {
                Task task = (Task)list4.get(list4.size() - 1);
            }
            this.setForegroundTask((Task)var5_13);
        }
    }

    private void updateTasks(Task task, Task task2) {
        List<Task<?, ?>> list = this.taskQueue.getList();
        if (task != null) {
            this.taskQueue.remove(task);
        }
        if (task2 != null) {
            this.taskQueue.addLast(task2);
        }
        List<Task<?, ?>> list2 = this.taskQueue.getList();
        this.firePropertyChange("tasks", list, list2);
        if (this.autoUpdateForegroundTask && this.getForegroundTask() == null) {
            Task<?, ?> task3 = null;
            List<Task<?, ?>> list3 = this.taskQueue.getList();
            if (!list3.isEmpty()) {
                task3 = list3.get(list3.size() - 1);
            }
            this.setForegroundTask(task3);
        }
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        private void fireStateChange(Task task, String string) {
            TaskMonitor.this.firePropertyChange(new PropertyChangeEvent(task, string, false, true));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Task task = (Task)propertyChangeEvent.getSource();
            if (task != null && task == TaskMonitor.this.getForegroundTask()) {
                Object object;
                TaskMonitor.this.firePropertyChange(propertyChangeEvent);
                if ("state".equals(string)) {
                    object = (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue());
                    switch (object) {
                        case PENDING: {
                            this.fireStateChange(task, "pending");
                            break;
                        }
                        case STARTED: {
                            this.fireStateChange(task, "started");
                            break;
                        }
                        case DONE: {
                            this.fireStateChange(task, "done");
                        }
                    }
                }
                if ("completed".equals(string) && TaskMonitor.this.autoUpdateForegroundTask) {
                    object = null;
                    List<Task<?, ?>> list = TaskMonitor.this.taskQueue.getList();
                    if (!list.isEmpty()) {
                        object = list.get(list.size() - 1);
                    }
                    TaskMonitor.this.setForegroundTask((Task)object);
                }
            }
        }
    }

    private class TaskServicePCL
    implements PropertyChangeListener {
        private TaskServicePCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("tasks".equals(string)) {
                if (propertyChangeEvent instanceof TaskService.TaskPropertyChangeEvent) {
                    TaskService.TaskPropertyChangeEvent taskPropertyChangeEvent = (TaskService.TaskPropertyChangeEvent)propertyChangeEvent;
                    TaskMonitor.this.updateTasks(taskPropertyChangeEvent.getRemoved(), taskPropertyChangeEvent.getAdded());
                } else {
                    List list = (List)propertyChangeEvent.getOldValue();
                    List list2 = (List)propertyChangeEvent.getNewValue();
                    TaskMonitor.this.updateTasks(list, list2);
                }
            }
        }
    }
}

