/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.task;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.task.TaskEvent;
import org.yaoqiang.asaf.task.TaskListener;
import org.yaoqiang.asaf.task.TaskService;

public abstract class Task<T, V>
extends SwingWorker<T, V> {
    private static final Logger logger = Logger.getLogger(Task.class.getName());
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_INPUTBLOCKER = "inputBlocker";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_TASKSERVICE = "taskService";
    public static final String PROP_TITLE = "title";
    public static final String PROP_USERCANCANCEL = "userCanCancel";
    public static final String PROP_COMPLETED = "completed";
    public static final String PROP_DONE = "done";
    public static final String PROP_STARTED = "started";
    private List<TaskListener<T, V>> taskListeners;
    private String title = null;
    private String description = null;
    private long messageTime = -1L;
    private String message = null;
    private long startTime = -1L;
    private long doneTime = -1L;
    private boolean userCanCancel = true;
    private boolean progressPropertyIsValid = false;
    private TaskService taskService = null;
    private Map<Object, Object> properties = null;

    private void initTask() {
        this.title = ResourceMap.getString(PROP_TITLE, new String[0]);
        this.description = ResourceMap.getString(PROP_DESCRIPTION, new String[0]);
        this.message = ResourceMap.getString(PROP_MESSAGE, new String[0]);
        if (this.message != null) {
            this.messageTime = System.currentTimeMillis();
        }
        this.addPropertyChangeListener(new StatePCL());
        this.taskListeners = new CopyOnWriteArrayList<TaskListener<T, V>>();
    }

    public Task() {
        this.initTask();
    }

    public synchronized TaskService getTaskService() {
        return this.taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setTaskService(TaskService taskService) {
        TaskService taskService2;
        TaskService taskService3;
        Task task = this;
        synchronized (task) {
            taskService3 = this.taskService;
            taskService2 = this.taskService = taskService;
        }
        this.firePropertyChange(PROP_TASKSERVICE, taskService3, taskService2);
    }

    public synchronized String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTitle(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.title;
            string2 = this.title = string;
        }
        this.firePropertyChange(PROP_TITLE, string3, string2);
    }

    public synchronized String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescription(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.description;
            string2 = this.description = string;
        }
        this.firePropertyChange(PROP_DESCRIPTION, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getExecutionDuration(TimeUnit timeUnit) {
        long l;
        long l2;
        Task task = this;
        synchronized (task) {
            l2 = this.startTime;
            l = this.doneTime;
        }
        long l3 = l2 == -1L ? 0L : (l == -1L ? System.currentTimeMillis() - l2 : l - l2);
        return timeUnit.convert(Math.max(0L, l3), TimeUnit.MILLISECONDS);
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessage(String string) {
        String string2;
        String string3;
        Task task = this;
        synchronized (task) {
            string3 = this.message;
            string2 = this.message = string;
            this.messageTime = System.currentTimeMillis();
        }
        this.firePropertyChange(PROP_MESSAGE, string3, string2);
    }

    protected final void message(String string, String ... stringArray) {
        this.setMessage(ResourceMap.getString(string, stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMessageDuration(TimeUnit timeUnit) {
        long l;
        Task task = this;
        synchronized (task) {
            l = this.messageTime;
        }
        long l2 = l == -1L ? 0L : Math.max(0L, System.currentTimeMillis() - l);
        return timeUnit.convert(l2, TimeUnit.MILLISECONDS);
    }

    Object getProperty(Object object) {
        return this.properties == null ? null : this.properties.get(object);
    }

    void removeProperty(Object object) {
        if (this.properties != null && this.properties.remove(object) != null && this.properties.isEmpty()) {
            this.properties = null;
        }
    }

    void setProperty(Object object, Object object2) {
        if (object2 != null) {
            if (this.properties == null) {
                this.properties = new HashMap<Object, Object>();
            }
            this.properties.put(object, object2);
        }
    }

    public synchronized boolean getUserCanCancel() {
        return this.userCanCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserCanCancel(boolean bl) {
        boolean bl2;
        boolean bl3;
        Task task = this;
        synchronized (task) {
            bl3 = this.userCanCancel;
            bl2 = this.userCanCancel = bl;
        }
        this.firePropertyChange(PROP_USERCANCANCEL, bl3, bl2);
    }

    public synchronized boolean isProgressPropertyValid() {
        return this.progressPropertyIsValid;
    }

    protected final void setProgress(int n, int n2, int n3) {
        if (n2 >= n3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f = (float)(n - n2) / (float)(n3 - n2);
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f) {
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("invalid percentage");
        }
        this.setProgress(Math.round(f * 100.0f));
    }

    protected final void setProgress(float f, float f2, float f3) {
        if (f2 >= f3) {
            throw new IllegalArgumentException("invalid range: min >= max");
        }
        if (f < f2 || f > f3) {
            throw new IllegalArgumentException("invalid value");
        }
        float f4 = (f - f2) / (f3 - f2);
        this.setProgress(Math.round(f4 * 100.0f));
    }

    public final boolean isPending() {
        return this.getState() == SwingWorker.StateValue.PENDING;
    }

    public final boolean isStarted() {
        return this.getState() == SwingWorker.StateValue.STARTED;
    }

    @Override
    protected void process(List<V> list) {
        this.fireProcessListeners(list);
    }

    @Override
    protected final void done() {
        this.setTaskService(null);
    }

    protected void cancelled() {
    }

    protected void succeeded(T t) {
    }

    protected void interrupted(InterruptedException interruptedException) {
    }

    protected void failed(Throwable throwable) {
        String string = String.format("%s failed: %s", this, throwable);
        logger.log(Level.SEVERE, string, throwable);
    }

    protected void finished() {
    }

    public void addTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.add(taskListener);
    }

    public void removeTaskListener(TaskListener<T, V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.taskListeners.remove(taskListener);
    }

    public TaskListener<T, V>[] getTaskListeners() {
        return this.taskListeners.toArray(new TaskListener[this.taskListeners.size()]);
    }

    private void fireProcessListeners(List<V> list) {
        TaskEvent<List<V>> taskEvent = new TaskEvent<List<V>>(this, list);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.process(taskEvent);
        }
    }

    private void fireDoInBackgroundListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.doInBackground(taskEvent);
        }
    }

    private void fireSucceededListeners(T t) {
        TaskEvent<T> taskEvent = new TaskEvent<T>(this, t);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.succeeded(taskEvent);
        }
    }

    private void fireCancelledListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.cancelled(taskEvent);
        }
    }

    private void fireInterruptedListeners(InterruptedException interruptedException) {
        TaskEvent<InterruptedException> taskEvent = new TaskEvent<InterruptedException>(this, interruptedException);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.interrupted(taskEvent);
        }
    }

    private void fireFailedListeners(Throwable throwable) {
        TaskEvent<Throwable> taskEvent = new TaskEvent<Throwable>(this, throwable);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.failed(taskEvent);
        }
    }

    private void fireFinishedListeners() {
        TaskEvent<Object> taskEvent = new TaskEvent<Object>(this, null);
        for (TaskListener<T, V> taskListener : this.taskListeners) {
            taskListener.finished(taskEvent);
        }
    }

    private void fireCompletionListeners() {
        try {
            if (this.isCancelled()) {
                this.fireCancelledListeners();
            } else {
                try {
                    this.fireSucceededListeners(this.get());
                }
                catch (InterruptedException interruptedException) {
                    this.fireInterruptedListeners(interruptedException);
                }
                catch (ExecutionException executionException) {
                    this.fireFailedListeners(executionException.getCause());
                }
            }
        }
        finally {
            this.fireFinishedListeners();
        }
    }

    private class StatePCL
    implements PropertyChangeListener {
        private StatePCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("state".equals(string)) {
                SwingWorker.StateValue stateValue = (SwingWorker.StateValue)((Object)propertyChangeEvent.getNewValue());
                switch (stateValue) {
                    case STARTED: {
                        this.taskStarted();
                        break;
                    }
                    case DONE: {
                        this.taskDone();
                    }
                }
            } else if ("progress".equals(string)) {
                Task task = Task.this;
                synchronized (task) {
                    Task.this.progressPropertyIsValid = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskStarted() {
            Task task = Task.this;
            synchronized (task) {
                Task.this.startTime = System.currentTimeMillis();
            }
            Task.this.firePropertyChange(Task.PROP_STARTED, false, true);
            Task.this.fireDoInBackgroundListeners();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void taskDone() {
            Task task = Task.this;
            synchronized (task) {
                Task.this.doneTime = System.currentTimeMillis();
            }
            try {
                Task.this.removePropertyChangeListener(this);
                Task.this.firePropertyChange(Task.PROP_DONE, false, true);
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (Task.this.isCancelled()) {
                                Task.this.cancelled();
                            } else {
                                try {
                                    Task.this.succeeded(Task.this.get());
                                }
                                catch (InterruptedException interruptedException) {
                                    Task.this.interrupted(interruptedException);
                                }
                                catch (ExecutionException executionException) {
                                    Task.this.failed(executionException.getCause());
                                }
                            }
                        }
                        finally {
                            Task.this.finished();
                            try {
                                Task.this.fireCompletionListeners();
                            }
                            finally {
                                Task.this.firePropertyChange(Task.PROP_COMPLETED, false, true);
                            }
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

