/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.splash;

import com.sun.awt.AWTUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.splash.CircleProgressBar;

public class SplashScreen {
    private static CircleProgressBar progressBar = new CircleProgressBar();
    private static JWindow logoWindow;
    private static JWindow titleWindow;
    private static Timer timer;

    static {
        timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                progressBar.repaint();
            }
        });
    }

    public static void init(Image image, final Image image2) {
        if (image != null) {
            progressBar.setIcon(image);
        }
        progressBar.setValue(0);
        logoWindow = new JWindow();
        logoWindow.add(progressBar);
        logoWindow.pack();
        logoWindow.setLocationRelativeTo(null);
        logoWindow.setAlwaysOnTop(true);
        if (SystemInfo.isJdk7Above()) {
            logoWindow.setShape(new Ellipse2D.Double(0.0, 0.0, logoWindow.getWidth(), logoWindow.getHeight()));
        } else {
            AWTUtilities.setWindowShape((Window)logoWindow, (Shape)new Ellipse2D.Double(0.0, 0.0, logoWindow.getWidth(), logoWindow.getHeight()));
        }
        if (image2 == null) {
            return;
        }
        titleWindow = new JWindow();
        if (SystemInfo.isWindows() || SystemInfo.isMacOS()) {
            if (SystemInfo.isJdk7Above()) {
                titleWindow.setBackground(new Color(0, 0, 0, 0));
            } else {
                AWTUtilities.setWindowOpaque((Window)titleWindow, (boolean)false);
            }
        } else {
            titleWindow.setBackground(Color.WHITE);
        }
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -2476886999043154577L;

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(image2, 0, 0, null);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(image2.getWidth(null), image2.getHeight(null));
            }
        };
        titleWindow.add(jPanel);
        titleWindow.pack();
        titleWindow.setAlwaysOnTop(true);
        Point point = logoWindow.getLocation();
        point.translate(0, -100);
        logoWindow.setLocation(point);
        point.translate((logoWindow.getWidth() - titleWindow.getWidth()) / 2, 100);
        titleWindow.setLocation(point);
    }

    public static void showSplash() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                timer.start();
                logoWindow.setVisible(true);
                if (titleWindow != null) {
                    titleWindow.setVisible(true);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void closeSplash() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                logoWindow.setVisible(false);
                if (titleWindow != null) {
                    titleWindow.setVisible(false);
                }
                timer.stop();
                SplashScreen.setProgress(0);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void increaseProgress() {
        progressBar.setValue(progressBar.getValue() + 2);
    }

    public static void setProgress(int n) {
        progressBar.setValue(n);
    }

    public static int getProgress() {
        return progressBar.getValue();
    }
}

