/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.splash;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class CircleProgressBar
extends JComponent {
    private static final long serialVersionUID = -1249481329041556594L;
    private int maximum = 100;
    private int value = 0;
    private int circleSize = 85;
    private int circleWidth = 11;
    private int alpha = 50;
    private Color drawColor = new Color(100, 150, 250);
    private Image icon = new ImageIcon(CircleProgressBar.class.getResource("/org/yaoqiang/asaf/resources/icons/splash_logo.png")).getImage();

    public CircleProgressBar() {
    }

    public CircleProgressBar(Image image) {
        this.icon = image;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        if (n > this.maximum) {
            n = this.maximum;
        }
        this.value = n;
    }

    public int getCircleSize() {
        return this.circleSize;
    }

    public void setCircleSize(int n) {
        this.circleSize = n;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image image) {
        this.icon = image;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.circleSize, this.circleSize);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.value <= this.maximum) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(graphics.getClip());
            if (this.value == this.maximum) {
                this.alpha -= 15;
                this.drawColor = new Color(this.drawColor.getRed(), this.drawColor.getGreen(), this.drawColor.getBlue(), Math.abs(this.alpha));
                if (Math.abs(this.alpha) > 240) {
                    this.alpha = 255;
                }
            } else {
                this.alpha += 2;
                if (this.alpha >= 255) {
                    this.alpha = 255;
                }
                this.drawColor = new Color(this.drawColor.getRed(), this.drawColor.getGreen(), this.drawColor.getBlue(), this.alpha);
            }
            graphics2D.setColor(this.drawColor);
            int n = -((int)((float)this.value / (float)this.maximum * 360.0f));
            graphics.fillArc(0, 0, this.circleSize, this.circleSize, 90, n);
            graphics2D.setColor(this.getBackground());
            graphics.fillArc(this.circleWidth, this.circleWidth, this.circleSize - this.circleWidth * 2, this.circleSize - this.circleWidth * 2, 90, n);
            graphics2D.setColor(this.drawColor);
            graphics.drawOval(0, 0, this.circleSize, this.circleSize);
            graphics.drawOval(this.circleWidth, this.circleWidth, this.circleSize - this.circleWidth * 2, this.circleSize - this.circleWidth * 2);
        }
        if (this.icon != null) {
            graphics.drawImage(this.icon, (this.circleSize - this.icon.getWidth(null)) / 2 + 2, (this.circleSize - this.icon.getHeight(null)) / 2 + 2, null);
        }
    }
}

