/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel.date;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.panel.date.DayPanel;

public class MonthPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 815227696124106369L;
    private int month;
    private DayPanel dayChooser;
    private JComboBox comboBox;
    private boolean initialized;
    private boolean localInitialize;

    public MonthPanel() {
        this.setLayout(new BorderLayout());
        Dimension dimension = new Dimension(90, 26);
        this.comboBox = new JComboBox();
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.comboBox.addItemListener(this);
        this.initNames();
        this.add(this.comboBox);
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(ASAF.getLocale());
        String[] stringArray = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        int n = 0;
        while (n < 12) {
            this.comboBox.addItem(stringArray[n]);
            ++n;
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getStateChange() == 1 && (n = this.comboBox.getSelectedIndex()) >= 0 && n != this.month) {
            this.setMonth(n, false);
        }
    }

    private void setMonth(int n, boolean bl) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int n2 = this.month;
        this.month = n;
        if (bl) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n2, this.month);
    }

    public void setMonth(int n) {
        if (n < 0 || n > 11) {
            return;
        }
        this.setMonth(n, true);
    }

    public void setDayChooser(DayPanel dayPanel) {
        this.dayChooser = dayPanel;
    }
}

