/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel.date;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.yaoqiang.asaf.ASAF;

public class DayPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8924658015657577609L;
    protected JButton[] days;
    protected JButton[] weeks;
    protected JButton selectedDay;
    protected JPanel weekPanel;
    protected JPanel dayPanel;
    protected int day;
    protected Color oldDayBackgroundColor;
    protected Color selectedColor;
    protected Color sundayForeground;
    protected Color weekdayForeground;
    protected Color decorationBackgroundColor;
    protected String[] dayNames;
    protected Calendar calendar;
    protected Calendar today;
    protected boolean initialized;
    protected boolean decorationBackgroundVisible = true;
    protected boolean decorationBordersVisible;
    private boolean alwaysFireDayProperty = true;

    public DayPanel() {
        this.setBackground(Color.blue);
        this.days = new JButton[49];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(ASAF.getLocale());
        this.today = (Calendar)this.calendar.clone();
        this.setLayout(new BorderLayout());
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = new Color(0, 90, 164);
        this.decorationBackgroundColor = new Color(210, 228, 238);
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                int n3 = n2 + 7 * n;
                if (n == 0) {
                    this.days[n3] = new JButton(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public boolean isFocusable() {
                            return false;
                        }
                    };
                    this.days[n3].setContentAreaFilled(this.decorationBackgroundVisible);
                    this.days[n3].setBorderPainted(this.decorationBordersVisible);
                    this.days[n3].setBackground(this.decorationBackgroundColor);
                } else {
                    this.days[n3] = new JButton("x");
                    this.days[n3].addActionListener(this);
                }
                this.days[n3].setMargin(new Insets(0, 0, 0, 0));
                this.dayPanel.add(this.days[n3]);
                ++n2;
            }
            ++n;
        }
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridLayout(7, 1));
        this.weeks = new JButton[7];
        n = 0;
        while (n < 7) {
            this.weeks[n] = new JButton(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isFocusable() {
                    return false;
                }
            };
            this.weeks[n].setMargin(new Insets(0, 0, 0, 0));
            this.weeks[n].setFocusPainted(false);
            this.weeks[n].setBackground(this.decorationBackgroundColor);
            this.weeks[n].setForeground(new Color(100, 100, 100));
            this.weeks[n].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[n].setBorderPainted(this.decorationBordersVisible);
            if (n != 0) {
                this.weeks[n].setText("0" + (n + 1));
            }
            this.weekPanel.add(this.weeks[n]);
            ++n;
        }
        this.init();
        this.drawWeeks();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)this.dayPanel, "Center");
        this.add((Component)this.weekPanel, "West");
        this.initialized = true;
    }

    protected void init() {
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(ASAF.getLocale());
        this.calendar.setTime(date);
        this.drawDayNames();
        this.drawDays();
    }

    private void drawDayNames() {
        int n = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(ASAF.getLocale());
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n2 = n;
        int n3 = 0;
        while (n3 < 7) {
            this.days[n3].setText(this.dayNames[n2]);
            if (n2 == 1) {
                this.days[n3].setForeground(this.sundayForeground);
            } else {
                this.days[n3].setForeground(this.weekdayForeground);
            }
            n2 = n2 < 7 ? ++n2 : (n2 -= 6);
            ++n3;
        }
    }

    protected void drawWeeks() {
        Calendar calendar = (Calendar)this.calendar.clone();
        int n = 1;
        while (n < 7) {
            calendar.set(5, n * 7 - 6);
            int n2 = calendar.get(3);
            String string = Integer.toString(n2);
            if (n2 < 10) {
                string = "0" + string;
            }
            this.weeks[n].setText(string);
            if (n == 5 || n == 6) {
                this.weeks[n].setVisible(this.days[n * 7].isVisible());
            }
            ++n;
        }
    }

    protected void drawDays() {
        Calendar calendar = (Calendar)this.calendar.clone();
        int n = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        int n2 = calendar.get(7) - n;
        if (n2 < 0) {
            n2 += 7;
        }
        int n3 = 0;
        while (n3 < n2) {
            this.days[n3 + 7].setVisible(false);
            this.days[n3 + 7].setText("");
            ++n3;
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n4 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            this.days[n3 + n4 + 7].setText(Integer.toString(n4 + 1));
            this.days[n3 + n4 + 7].setVisible(true);
            if (calendar.get(6) == this.today.get(6) && calendar.get(1) == this.today.get(1)) {
                this.days[n3 + n4 + 7].setForeground(this.sundayForeground);
            } else {
                this.days[n3 + n4 + 7].setForeground(color);
            }
            if (n4 + 1 == this.day) {
                this.days[n3 + n4 + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[n3 + n4 + 7];
            } else {
                this.days[n3 + n4 + 7].setBackground(this.oldDayBackgroundColor);
            }
            ++n4;
            calendar.add(5, 1);
            date2 = calendar.getTime();
        }
        int n5 = n4 + n3 + 7;
        while (n5 < 49) {
            this.days[n5].setVisible(false);
            this.days[n5].setText("");
            ++n5;
        }
    }

    public void setDay(int n) {
        if (n < 1) {
            n = 1;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n2 = calendar.get(5);
        if (n > n2) {
            n = n2;
        }
        int n3 = this.day;
        this.day = n;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        int n4 = 7;
        while (n4 < 49) {
            if (this.days[n4].getText().equals(Integer.toString(this.day))) {
                this.selectedDay = this.days[n4];
                this.selectedDay.setBackground(this.selectedColor);
                break;
            }
            ++n4;
        }
        if (this.alwaysFireDayProperty) {
            this.firePropertyChange("day", 0, this.day);
        } else {
            this.firePropertyChange("day", n3, this.day);
        }
    }

    public void setMonth(int n) {
        this.calendar.set(2, n);
        boolean bl = this.alwaysFireDayProperty;
        this.alwaysFireDayProperty = false;
        this.setDay(this.day);
        this.alwaysFireDayProperty = bl;
        this.drawDays();
        this.drawWeeks();
    }

    public void setYear(int n) {
        this.calendar.set(1, n);
        this.drawDays();
        this.drawWeeks();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n = new Integer(string);
        this.setDay(n);
    }

    public final boolean isAlwaysFireDayProperty() {
        return this.alwaysFireDayProperty;
    }

    public final void setAlwaysFireDayProperty(boolean bl) {
        this.alwaysFireDayProperty = bl;
    }
}

