/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel.date;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.SpinnerPanel;
import org.yaoqiang.asaf.panel.date.DayPanel;
import org.yaoqiang.asaf.panel.date.MonthPanel;

public class CalendarPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 6858386342497431402L;
    private Calendar calendar = Calendar.getInstance(ASAF.getLocale());
    protected DayPanel dayChooser = null;
    protected MonthPanel monthChooser = null;
    protected SpinnerPanel yearChooser = null;
    protected SpinnerPanel timeChooser = null;

    public CalendarPanel() {
        this((Date)null);
    }

    public CalendarPanel(Date date) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.monthChooser = new MonthPanel();
        this.yearChooser = new SpinnerPanel("year", 2011, 60);
        this.timeChooser = new SpinnerPanel("time", (int)new Date().getTime(), 85);
        JButton jButton = new JButton(ResourceMap.getString("now.Button.text", new String[0]));
        jButton.setMaximumSize(new Dimension(65, 27));
        jButton.setPreferredSize(new Dimension(65, 27));
        jButton.setToolTipText(ResourceMap.getString("now.Button.text", new String[0]));
        jButton.addActionListener(new AbstractAction("now"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel.this.calendar.setTime(new Date());
                boolean bl = CalendarPanel.this.dayChooser.isAlwaysFireDayProperty();
                CalendarPanel.this.dayChooser.setAlwaysFireDayProperty(false);
                CalendarPanel.this.setCalendar(CalendarPanel.this.calendar);
                CalendarPanel.this.dayChooser.setAlwaysFireDayProperty(bl);
            }
        });
        JButton jButton2 = new JButton(ResourceMap.getString("empty.Button.text", new String[0]));
        jButton2.setMaximumSize(new Dimension(65, 27));
        jButton2.setPreferredSize(new Dimension(65, 27));
        jButton2.setToolTipText(ResourceMap.getString("empty.Button.text", new String[0]));
        jButton2.addActionListener(new AbstractAction("empty"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel.this.calendar.setTime(new Date(0L));
                CalendarPanel.this.setCalendar(CalendarPanel.this.calendar);
            }
        });
        jPanel.add(this.monthChooser);
        jPanel.add(this.yearChooser);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.timeChooser);
        jPanel.add(Box.createHorizontalGlue());
        this.dayChooser = new DayPanel();
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.addPropertyChangeListener(this);
        this.timeChooser.addPropertyChangeListener(this);
        this.add((Component)jPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.setCalendar(this.calendar);
    }

    public DayPanel getDayChooser() {
        return this.dayChooser;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.calendar != null) {
            Calendar calendar = (Calendar)this.calendar.clone();
            int n = 0;
            if (propertyChangeEvent.getNewValue() instanceof Integer) {
                n = (Integer)propertyChangeEvent.getNewValue();
            } else if (propertyChangeEvent.getNewValue() instanceof Date && propertyChangeEvent.getPropertyName().equals("year")) {
                Calendar calendar2 = (Calendar)this.calendar.clone();
                calendar2.setTime((Date)propertyChangeEvent.getNewValue());
                n = calendar2.get(1);
            }
            if (propertyChangeEvent.getPropertyName().equals("day")) {
                calendar.set(5, n);
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("month")) {
                calendar.set(2, n);
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("year")) {
                this.getDayChooser().setYear(n);
                calendar.set(1, n);
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("time")) {
                int n2 = calendar.get(1);
                int n3 = calendar.get(2);
                int n4 = calendar.get(5);
                calendar.setTime((Date)propertyChangeEvent.getNewValue());
                calendar.set(1, n2);
                calendar.set(2, n3);
                calendar.set(5, n4);
                this.setCalendar(calendar, false);
            } else if (propertyChangeEvent.getPropertyName().equals("date")) {
                calendar.setTime((Date)propertyChangeEvent.getNewValue());
                this.setCalendar(calendar, true);
            }
        }
    }

    public void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, true);
    }

    private void setCalendar(Calendar calendar, boolean bl) {
        Calendar calendar2 = this.calendar;
        this.calendar = calendar;
        if (bl) {
            this.yearChooser.setValue(calendar.get(1));
            this.monthChooser.setMonth(calendar.get(2));
            this.dayChooser.setDay(calendar.get(5));
        }
        this.firePropertyChange("calendar", calendar2, this.calendar);
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public void setDate(Date date) {
        Date date2 = this.calendar.getTime();
        this.calendar.setTime(date);
        this.yearChooser.setValue(this.calendar.get(1));
        this.dayChooser.setYear(this.calendar.get(1));
        this.monthChooser.setMonth(this.calendar.get(2));
        this.dayChooser.setDay(this.calendar.get(5));
        this.firePropertyChange("date", date2, date);
    }
}

