/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelContainer;
import org.yaoqiang.asaf.panel.SortingTable;
import org.yaoqiang.asaf.panel.TableGenerator;

public class TablePanel
extends Panel {
    private static final long serialVersionUID = -486204914649984946L;
    protected String type;
    protected boolean hasToolbar = true;
    protected boolean readonly = false;
    protected Vector<String> columnNames;
    protected List<String> columnsToShow;
    protected TableGenerator tableGenerator;
    protected JPanel toolbox;
    protected JTable table;
    protected JPopupMenu popup = new JPopupMenu();

    public TablePanel(PanelContainer panelContainer, Object object, TableGenerator tableGenerator, String string, String string2, List<String> list, Object object2, int n, int n2, boolean bl, boolean bl2) {
        super(panelContainer, object);
        this.setLayout(new BorderLayout());
        if (string2 != null) {
            this.setBorder(BorderFactory.createTitledBorder(ResourceMap.getString(String.valueOf(string2) + ".Table.title", new String[0])));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.tableGenerator = tableGenerator;
        this.type = string;
        this.hasToolbar = bl;
        this.readonly = bl2;
        this.columnNames = this.getColumnNames(list);
        this.columnsToShow = list;
        this.table = this.createTable();
        this.tableGenerator.setSourcePanel(this);
        this.setupTable(n, n2);
        this.fillTableContent(object2);
        if (bl) {
            this.add((Component)tableGenerator.createToolbar(), "North");
        }
        this.add((Component)this.createTablePane(), "Center");
    }

    protected JScrollPane createTablePane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        return jScrollPane;
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean hasToolbar() {
        return this.hasToolbar;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public String getTableType() {
        return this.type;
    }

    public TableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected JTable createTable() {
        return new SortingTable(this, new Vector(), this.columnNames){
            private static final long serialVersionUID = -628683737729545126L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.getColumnName(n2).length() == 0;
            }
        };
    }

    @Override
    public boolean setSelectedElement(Object object) {
        int n = this.table.getRowCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                if (object == this.table.getValueAt(n2, 0)) {
                    this.table.setRowSelectionInterval(n2, n2);
                    JViewport jViewport = (JViewport)this.table.getParent();
                    Rectangle rectangle = this.table.getCellRect(n2, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public Object getSelectedObject() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            return this.table.getValueAt(n, 0);
        }
        return null;
    }

    protected void setupTable(int n, int n2) {
        int n3 = this.table.getColumnModel().getColumnCount();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        int n4 = 1;
        while (n4 < n3) {
            tableColumn = this.table.getColumnModel().getColumn(n4);
            if (tableColumn.getHeaderValue().toString().length() == 0) {
                tableColumn.setMinWidth(20);
                tableColumn.setMaxWidth(20);
                tableColumn.setPreferredWidth(20);
                tableColumn.setResizable(false);
            } else {
                this.tableGenerator.setColumnWidth(tableColumn);
            }
            ++n4;
        }
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        Dimension dimension = new Dimension(n, n2);
        this.table.setPreferredScrollableViewportSize(new Dimension(dimension));
        this.tableGenerator.addTableListener();
    }

    public void fillTableContent(Object object) {
        this.fillTableContent(object, null);
    }

    public void fillTableContent(final Object object, final Object object2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel defaultTableModel = (DefaultTableModel)TablePanel.this.table.getModel();
                while (TablePanel.this.table.getRowCount() > 0) {
                    defaultTableModel.removeRow(0);
                }
                if (object instanceof List) {
                    for (Object e : (List)object) {
                        ((DefaultTableModel)TablePanel.this.table.getModel()).addRow(TablePanel.this.getRow(e));
                    }
                } else if (object instanceof Map) {
                    for (Map.Entry entry : ((Map)object).entrySet()) {
                        ((DefaultTableModel)TablePanel.this.table.getModel()).addRow(TablePanel.this.getRow(entry));
                    }
                }
                if (object2 != null) {
                    TablePanel.this.setSelectedElement(object2);
                }
            }
        });
    }

    public void selectAllElements(boolean bl) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = defaultTableModel.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            defaultTableModel.setValueAt(new Boolean(bl), n2, 1);
            ++n2;
        }
    }

    public List<Object> getAllElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = defaultTableModel.getRowCount();
        if (n == 0) {
            return arrayList;
        }
        Vector<Vector> vector = defaultTableModel.getDataVector();
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = vector.elementAt(n2);
            arrayList.add(vector2.elementAt(0));
            ++n2;
        }
        return arrayList;
    }

    public List<Object> getCheckedElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n = defaultTableModel.getRowCount();
        if (n == 0) {
            return arrayList;
        }
        Vector<Vector> vector = defaultTableModel.getDataVector();
        int n2 = 0;
        while (n2 < n) {
            Vector vector2 = vector.elementAt(n2);
            Object e = vector2.elementAt(1);
            if (e instanceof Boolean && ((Boolean)e).booleanValue()) {
                arrayList.add(vector2.elementAt(0));
            }
            ++n2;
        }
        return arrayList;
    }

    protected Vector<Object> getRow(Object object) {
        return this.tableGenerator.createRow(this.owner, object, this.columnsToShow);
    }

    public void addRow(final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = TablePanel.this.tableGenerator.getRowIndex(object);
                if (n == -1) {
                    n = TablePanel.this.table.getRowCount();
                }
                DefaultTableModel defaultTableModel = (DefaultTableModel)TablePanel.this.table.getModel();
                Vector<Object> vector = TablePanel.this.getRow(object);
                if (n != TablePanel.this.table.getRowCount()) {
                    defaultTableModel.removeRow(n);
                }
                defaultTableModel.insertRow(n, vector);
            }
        });
    }

    public void addRow(final Object object, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel defaultTableModel = (DefaultTableModel)TablePanel.this.table.getModel();
                Vector<Object> vector = TablePanel.this.getRow(object);
                if (n != TablePanel.this.table.getRowCount()) {
                    defaultTableModel.removeRow(n);
                }
                defaultTableModel.insertRow(n, vector);
            }
        });
    }

    public void insertRow(Object object, int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        Vector<Object> vector = this.getRow(object);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(Object object) {
        int n = this.tableGenerator.getRowIndex(object);
        if (n != -1) {
            this.removeRow(n);
        }
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.removeRow(n);
    }

    public void removeAllRows() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel defaultTableModel = (DefaultTableModel)TablePanel.this.table.getModel();
                while (TablePanel.this.table.getRowCount() > 0) {
                    defaultTableModel.removeRow(0);
                }
            }
        });
    }

    protected Vector<String> getColumnNames(List<String> list) {
        Vector<String> vector = new Vector<String>();
        vector.add("RowObject");
        for (String string : list) {
            vector.add(string.length() == 0 ? "" : ResourceMap.getString(String.valueOf(string) + ".Column.title", new String[0]));
        }
        return vector;
    }

    public void addTableListener(ListSelectionListener listSelectionListener) {
        this.getTable().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeTableListener(ListSelectionListener listSelectionListener) {
        this.getTable().getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void clearSelection() {
        this.getTable().clearSelection();
    }
}

