/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.SortingTableModel;

public class SortingTable
extends JTable {
    private static final long serialVersionUID = -4845502508961246163L;
    private static final ImageIcon ARROWUP_ICON = new ImageIcon(SortingTable.class.getResource("/org/yaoqiang/asaf/resources/icons/arrowup.gif"));
    private static final ImageIcon ARROWDOWN_ICON = new ImageIcon(SortingTable.class.getResource("/org/yaoqiang/asaf/resources/icons/arrowdown.gif"));
    protected int sortedColIndex = -1;
    protected boolean ascending = true;
    protected Panel owner;

    public SortingTable(Panel panel, Vector<?> vector, Vector<?> vector2) {
        super(new SortingTableModel(vector, vector2));
        this.owner = panel;
        this.setShowGrid(true);
        this.setGridColor(Color.GRAY);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SHRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SortingTable.this.performSorting(mouseEvent);
            }
        };
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public int getSortedColumnIndex() {
        return this.sortedColIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.ascending;
    }

    public void performSorting(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortingTableModel sortingTableModel = (SortingTableModel)this.getModel();
        if (this.sortedColIndex == n && mouseEvent != null) {
            this.ascending = !this.ascending;
        }
        this.sortedColIndex = n;
        sortingTableModel.sortByColumn(n2, this.ascending);
        Object object = null;
        int n3 = this.getSelectedRow();
        if (n3 >= 0) {
            object = sortingTableModel.getValueAt(n3, 0);
        }
        if (object != null) {
            this.owner.setSelectedElement(object);
        }
        this.update(this.getGraphics());
        this.getTableHeader().update(this.getTableHeader().getGraphics());
    }

    class SHRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8390635838166112379L;

        public SHRenderer() {
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = true;
            SortingTable sortingTable = (SortingTable)jTable;
            int n3 = sortingTable.getSortedColumnIndex();
            bl3 = sortingTable.isSortedColumnAscending();
            ImageIcon imageIcon = null;
            imageIcon = bl3 ? ARROWUP_ICON : ARROWDOWN_ICON;
            if (n2 == n3) {
                this.setIcon(imageIcon);
            } else {
                this.setIcon(null);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            return this;
        }
    }
}

