/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelContainer;

public class RadioPanel
extends Panel {
    private static final long serialVersionUID = 7294054164494698822L;
    protected List<?> choices;
    protected ButtonGroup rGroup;

    public RadioPanel(PanelContainer panelContainer, Object object, String string, List<?> list) {
        this(panelContainer, object, string, list, "", false, true);
    }

    public RadioPanel(PanelContainer panelContainer, Object object, String string, List<?> list, String string2) {
        this(panelContainer, object, string, list, string2, false, true);
    }

    public RadioPanel(PanelContainer panelContainer, Object object, String string, List<?> list, String string2, boolean bl, boolean bl2) {
        super(panelContainer, object);
        if (string != null && string.length() != 0) {
            this.setBorder(BorderFactory.createTitledBorder(ResourceMap.getString(String.valueOf(string) + ".title", new String[0])));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.choices = list;
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setLayout(new GridLayout(0, 1));
        } else {
            jPanel.setLayout(new GridLayout(1, 0));
        }
        this.rGroup = new ButtonGroup();
        int n = 0;
        while (n < list.size()) {
            JRadioButton jRadioButton = new JRadioButton(ResourceMap.getString(String.valueOf(list.get(n).toString()) + ".Item.text", new String[0]));
            if (n == 0 && (string2 == null || string2.length() == 0) || list.get(n).equals(string2)) {
                jRadioButton.setSelected(true);
            }
            jRadioButton.setEnabled(bl2);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RadioPanel.this.getPanelContainer().panelChanged();
                }
            });
            this.rGroup.add(jRadioButton);
            jPanel.add(jRadioButton);
            ++n;
        }
        this.add(jPanel);
        this.add(Box.createHorizontalGlue());
    }

    public Object getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.choices.get(n);
    }

    public int getSelectedIndex() {
        Enumeration<AbstractButton> enumeration = this.rGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ButtonGroup getButtonGroup() {
        return this.rGroup;
    }

    @Override
    public void saveObjects() {
    }
}

