/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.Dialog;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelFactory;

public class PanelContainer
extends JPanel {
    private static final long serialVersionUID = 1966907830916610312L;
    protected AppView view;
    protected Dialog parentDialog;
    protected JScrollPane scrollPane;
    protected Panel viewPanel;
    protected JLabel messagePane;
    protected PanelFactory panelFactory;
    protected boolean modified = false;
    protected boolean saveRequired = true;

    public PanelContainer(AppView appView, PanelFactory panelFactory) {
        this.view = appView;
        this.panelFactory = panelFactory;
        this.panelFactory.setPanelContainer(this);
        this.init();
    }

    public PanelContainer(Dialog dialog, PanelFactory panelFactory) {
        this.parentDialog = dialog;
        this.panelFactory = panelFactory;
        this.panelFactory.setPanelContainer(this);
        this.init();
    }

    public PanelContainer() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)this.scrollPane, "Center");
        this.messagePane = new JLabel();
        this.messagePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        Dimension dimension = new Dimension(100, 27);
        this.messagePane.setMinimumSize(new Dimension(dimension));
        this.messagePane.setMaximumSize(new Dimension(dimension));
        this.messagePane.setPreferredSize(new Dimension(dimension));
    }

    public JComponent getDisplay() {
        return this;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isSaveRequired() {
        return this.saveRequired;
    }

    public void setSaveRequired(boolean bl) {
        this.saveRequired = bl;
    }

    public void panelChanged() {
        this.setModified(true);
    }

    public int showModifiedWarning() {
        int n = JOptionPane.showConfirmDialog(null, ResourceMap.getString("saveChanges.text", new String[0]), ASAF.getTitle(), 1);
        if (n == 0) {
            this.apply();
        }
        return n;
    }

    public void apply() {
        Panel panel = this.getViewPanel();
        if (panel != null) {
            panel.saveObjects();
        }
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setPanel(Object object, String string) {
        this.setModified(false);
        this.clearMessage();
        this.setViewPanel(this.getPanelFactory().createPanel(object, string));
    }

    public AppView getAppView() {
        return this.view;
    }

    public Dialog getParentDialog() {
        return this.parentDialog;
    }

    public PanelFactory getPanelFactory() {
        return this.panelFactory;
    }

    public void setErrorMessage(String string) {
        this.messagePane.setIcon(ResourceMap.getImageIcon("error.icon"));
        this.messagePane.setText(string);
    }

    public void setWarningMessage(String string) {
        this.messagePane.setIcon(ResourceMap.getImageIcon("warning.icon"));
        this.messagePane.setText(string);
    }

    public void clearMessage() {
        this.messagePane.setIcon(null);
        this.messagePane.setText(null);
    }

    public Panel getViewPanel() {
        return this.viewPanel;
    }

    public JPanel getView() {
        return (JPanel)this.scrollPane.getViewport().getView();
    }

    protected void setViewPanel(Panel panel) {
        this.viewPanel = panel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(Box.createVerticalStrut(1), "North");
        jPanel.add((Component)(panel == null ? new JPanel() : panel), "Center");
        jPanel.add((Component)this.messagePane, "South");
        this.scrollPane.setViewportView(jPanel);
    }
}

