/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelContainer;

public abstract class Dialog
extends JDialog {
    private static final long serialVersionUID = 2649536323076602437L;
    protected PanelContainer panelContainer;
    protected Panel parentPanel;
    protected JButton buttonOpt;
    protected JButton buttonOK;
    protected WindowListener close = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Dialog.this.close();
        }
    };
    protected ActionListener cancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dialog.this.close();
        }
    };
    protected ActionListener ok = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Dialog.this.save();
        }
    };

    public Dialog() {
        super((Frame)null, true);
        this.setIconImage(ASAF.getLogo());
        this.init();
    }

    protected abstract void init();

    public Dialog show(Object object) {
        return this.show(null, true, null, null, object, "");
    }

    public Dialog show(Object object, String string) {
        return this.show(null, true, null, null, object, string);
    }

    public Dialog show(Panel panel, Object object, String string) {
        return this.show(panel, true, null, null, object, string);
    }

    public Dialog show(Panel panel, boolean bl, Object object, String string) {
        return this.show(panel, bl, null, null, object, string);
    }

    public Dialog show(Panel panel, String string, Object object, String string2) {
        return this.show(panel, true, null, string, object, string2);
    }

    public Dialog show(boolean bl, Object object, String string) {
        return this.show(null, bl, null, null, object, string);
    }

    public Dialog show(boolean bl, String string, Object object, String string2) {
        return this.show(null, bl, string, null, object, string2);
    }

    public Dialog show(String string, Object object, String string2) {
        return this.show(null, true, null, string, object, string2);
    }

    public Dialog show(Panel panel, boolean bl, String string, String string2, Object object, String string3) {
        this.parentPanel = panel;
        this.panelContainer.setSaveRequired(bl);
        this.buildDialog(string, string2);
        this.editObject(object, string3);
        return this;
    }

    public void editObject(Object object, String string) {
        this.panelContainer.setPanel(object, string);
        this.setTitle(ResourceMap.getString(String.valueOf(string) + ".Dialog.title", new String[0]));
        this.setDialogVisible();
    }

    protected void setDialogVisible() {
        this.setSize(this.panelContainer.getDisplay().getSize());
        this.pack();
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
        }
    }

    protected void buildDialog(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.buttonOK = new JButton(ResourceMap.getString(string == null ? "ok.Button.text" : string, new String[0]));
        JButton jButton = new JButton(ResourceMap.getString("cancel.Button.text", new String[0]));
        if (string2 != null) {
            this.buttonOpt = new JButton(ResourceMap.getString(String.valueOf(string2) + ".Button.text", new String[0]));
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(this.buttonOpt);
        }
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.buttonOK);
        jPanel.add(Box.createHorizontalStrut(4));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(4));
        Container container = this.getContentPane();
        container.removeAll();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.panelContainer);
        container.add(Box.createVerticalStrut(5));
        container.add(jPanel);
        this.buttonOK.addActionListener(this.ok);
        jButton.addActionListener(this.cancel);
        if (!Arrays.asList(this.getWindowListeners()).contains(this.close)) {
            this.addWindowListener(this.close);
        }
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, false), "OK");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, SystemInfo.isMacOS() ? 157 : 17, false), "OK");
        this.getRootPane().getActionMap().put("OK", new AbstractAction(){
            private static final long serialVersionUID = -2256093034173353601L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.ok.actionPerformed(actionEvent);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = -2256095034193353601L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog.this.cancel.actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.buttonOK.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
    }

    public PanelContainer getPanelContainer() {
        return this.panelContainer;
    }

    public Panel getParentPanel() {
        return this.parentPanel;
    }

    public JButton getOptionButton() {
        return this.buttonOpt;
    }

    public void save() {
        this.panelContainer.apply();
        if (this.panelContainer.isModified() && this.panelContainer.isSaveRequired()) {
            ASAF.getSelectedFileTab().setModified(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void close() {
        if (this.panelContainer.isModified() && this.panelContainer.isSaveRequired() && this.isOK()) {
            int n = this.panelContainer.showModifiedWarning();
            if (n == 2 || n == -1) {
                return;
            }
            if (n == 0) {
                ASAF.getSelectedFileTab().setModified(true);
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public void setHasValidationError(boolean bl) {
        this.buttonOK.setEnabled(!bl);
    }

    public boolean isOK() {
        return this.buttonOK.isEnabled();
    }
}

