/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.panel.ComboItem;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelContainer;

public class ComboPanel
extends Panel {
    private static final long serialVersionUID = 5570431681963788416L;
    Dimension textDim = new Dimension(120, 27);
    protected JComboBox jcb;
    protected boolean hasEmpty;

    public ComboPanel(PanelContainer panelContainer, Object object, String string, Collection<?> collection, boolean bl, boolean bl2, boolean bl3) {
        super(panelContainer, object);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.hasEmpty = bl;
        JLabel jLabel = new JLabel(string == null ? "" : String.valueOf(ResourceMap.getString(String.valueOf(string) + ".Label.text", new String[0])) + ": ");
        List<ComboItem> list = this.convertToComboItemList(collection);
        this.jcb = new JComboBox<ComboItem>(new Vector<ComboItem>(list));
        this.resetComboDimension(list);
        this.jcb.setEditable(bl2);
        this.jcb.setEnabled(bl3);
        if (bl2) {
            this.jcb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ComboPanel.this.getPanelContainer().panelChanged();
                }
            });
            this.jcb.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    ComboPanel.this.getPanelContainer().panelChanged();
                }
            });
        }
        this.add((Component)jLabel, "West");
        this.add(Box.createHorizontalGlue(), "East");
        this.add((Component)this.jcb, "Center");
    }

    @Override
    public void saveObjects() {
    }

    public Object getSelectedItem() {
        Object object = null;
        object = this.jcb.isEditable() ? this.jcb.getEditor().getItem() : this.jcb.getSelectedItem();
        return object;
    }

    public int getSelectedIndex() {
        return this.jcb.getSelectedIndex();
    }

    public void resetComboDimension(Collection<?> collection) {
        double d = 0.0;
        if (collection != null) {
            double d2 = 0.0;
            for (Object obj : collection) {
                d = this.getFontMetrics(this.getFont()).stringWidth(obj.toString());
                if (!(d > d2)) continue;
                d2 = d;
            }
            d = d2 + 25.0;
        }
        if (d < (double)this.textDim.width) {
            d = this.textDim.width;
        }
        Dimension dimension = new Dimension((int)d, this.textDim.height);
        this.jcb.setMinimumSize(dimension);
        this.jcb.setMaximumSize(dimension);
        this.jcb.setPreferredSize(dimension);
    }

    public List<ComboItem> convertToComboItemList(Collection<?> collection) {
        ArrayList<ComboItem> arrayList = new ArrayList<ComboItem>();
        if (this.hasEmpty) {
            arrayList.add(new ComboItem());
        }
        for (Object obj : collection) {
            arrayList.add(new ComboItem(obj));
        }
        return arrayList;
    }

    public void refreshItem(Collection<?> collection) {
        Object object = this.getSelectedItem();
        List<ComboItem> list = this.convertToComboItemList(collection);
        this.jcb.setModel(new DefaultComboBoxModel<ComboItem>(new Vector<ComboItem>(list)));
        if (!collection.isEmpty()) {
            this.setSelectedItem(object);
        } else {
            this.jcb.setSelectedItem(new ComboItem());
        }
    }

    public JComboBox getComboBox() {
        return this.jcb;
    }

    public void setSelectedItem(Object object) {
        this.jcb.setSelectedItem(object);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.jcb.setEnabled(bl);
    }

    @Override
    public void requestFocus() {
        this.jcb.requestFocus();
    }

    public void addActionListener(ActionListener actionListener) {
        this.jcb.addActionListener(actionListener);
    }

    public boolean isEmpty() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).trim().equals("");
        }
        return false;
    }
}

