/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame.view;

import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.ResourceMap;

public class ConsoleView
extends AppView {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private JTextPane consoleArea;

    public ConsoleView() {
        super("console");
        this.activate(null, null);
    }

    @Override
    public void initView() {
        this.getContentPane().removeAll();
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DOCKABLE, LocationHint.LEFT), new DockAction[0]);
        defaultDockActionSource.add(this.createClearButtonAction());
        defaultDockActionSource.addSeparator();
        this.intern().setActionOffers(defaultDockActionSource);
        this.consoleArea = new JTextPane();
        this.consoleArea.setEditable(false);
        this.consoleArea.setCursor(new Cursor(2));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.consoleArea);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(40);
        this.add(jScrollPane);
        if (!Boolean.getBoolean("asaf.test")) {
            this.setSystemOutputStream();
        }
    }

    public void setSystemOutputStream() {
        try {
            PrintStream printStream = new PrintStream((OutputStream)new ConsoleOutputStream(this.consoleArea), true, "UTF-8");
            PrintStream printStream2 = new PrintStream((OutputStream)new ErrorConsoleOutputStream(this.consoleArea), true, "UTF-8");
            System.setOut(printStream);
            System.setErr(printStream2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void resetSystemOutputStream() {
        System.setOut(out);
        System.setErr(err);
    }

    private DockAction createClearButtonAction() {
        SimpleButtonAction simpleButtonAction = new SimpleButtonAction();
        simpleButtonAction.setText(ResourceMap.getString("clearConsole.Action.text", new String[0]));
        simpleButtonAction.setIcon(ResourceMap.getImageIcon("clearConsole.Action.icon"));
        simpleButtonAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyledDocument styledDocument = ConsoleView.this.consoleArea.getStyledDocument();
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        return simpleButtonAction;
    }

    private SimpleAttributeSet getLogStyle(int n) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        switch (n) {
            case 1: {
                StyleConstants.setForeground(simpleAttributeSet, Color.RED);
                break;
            }
            case 2: {
                StyleConstants.setForeground(simpleAttributeSet, Color.MAGENTA);
                break;
            }
            case 3: {
                StyleConstants.setForeground(simpleAttributeSet, Color.GRAY);
                break;
            }
            case 5: {
                StyleConstants.setForeground(simpleAttributeSet, Color.BLUE.darker());
            }
        }
        return simpleAttributeSet;
    }

    class ConsoleOutputStream
    extends OutputStream {
        private JTextPane consoleArea;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public ConsoleOutputStream(JTextPane jTextPane) throws IOException {
            this.consoleArea = jTextPane;
        }

        @Override
        public void write(int n) throws IOException {
            this.buffer.write(n);
        }

        @Override
        public void flush() throws IOException {
            try {
                StyledDocument styledDocument = this.consoleArea.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), this.buffer.toString("utf-8"), ConsoleView.this.getLogStyle(5));
                this.consoleArea.setCaretPosition(styledDocument.getLength());
                this.buffer.reset();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    class ErrorConsoleOutputStream
    extends OutputStream {
        private JTextPane consoleArea;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        public ErrorConsoleOutputStream(JTextPane jTextPane) throws IOException {
            this.consoleArea = jTextPane;
        }

        @Override
        public void write(int n) throws IOException {
            this.buffer.write(n);
        }

        @Override
        public void flush() throws IOException {
            try {
                StyledDocument styledDocument = this.consoleArea.getStyledDocument();
                styledDocument.insertString(styledDocument.getLength(), this.buffer.toString("utf-8"), ConsoleView.this.getLogStyle(1));
                this.consoleArea.setCaretPosition(styledDocument.getLength());
                this.buffer.reset();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

