/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame.panel;

import java.awt.event.ActionEvent;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.panel.CheckboxPanel;
import org.yaoqiang.asaf.panel.ComboItem;
import org.yaoqiang.asaf.panel.ComboPanel;
import org.yaoqiang.asaf.panel.Panel;
import org.yaoqiang.asaf.panel.PanelContainer;
import org.yaoqiang.asaf.panel.TextPanel;

public class ProxyPanel
extends Panel {
    private static final long serialVersionUID = 659897180528448383L;
    protected ComboPanel typePanel;
    protected TextPanel hostPanel;
    protected TextPanel portPanel;
    protected CheckboxPanel requireAuthPanel;
    protected TextPanel usernamePanel;
    protected TextPanel passwordPanel;

    public ProxyPanel(PanelContainer panelContainer, Object object) {
        super(panelContainer, object);
        this.setLayout(new BoxLayout(this, 1));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("HTTP");
        arrayList.add("Socks");
        this.typePanel = new ComboPanel(panelContainer, object, "type", arrayList, false, false, true);
        this.add(this.typePanel);
        String string = ASAF.getSetting("proxyType", "HTTP");
        this.typePanel.setSelectedItem(new ComboItem(string));
        this.hostPanel = new TextPanel(panelContainer, object, "host", ASAF.getSetting(String.valueOf(string.toLowerCase()) + "ProxyHost"), true);
        this.portPanel = new TextPanel(panelContainer, object, "port", false, ASAF.getSetting(String.valueOf(string.toLowerCase()) + "ProxyPort"), 50, 27, true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.hostPanel);
        jPanel.add(this.portPanel);
        this.add(jPanel);
        this.requireAuthPanel = new CheckboxPanel(panelContainer, object, "requireAuth", Boolean.parseBoolean(ASAF.getSetting("proxyRequireAuth")));
        this.add(this.requireAuthPanel);
        this.requireAuthPanel.addActionListener(new AbstractAction("requireAuth"){
            private static final long serialVersionUID = -1472948043704610174L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProxyPanel.this.requireAuthPanel.isSelected()) {
                    ProxyPanel.this.usernamePanel.setEnabled(true);
                    ProxyPanel.this.passwordPanel.setEnabled(true);
                    ProxyPanel.this.usernamePanel.setText(ASAF.getSetting("proxyUsername"));
                    ProxyPanel.this.passwordPanel.setText(ASAF.getSetting("proxyPassword"));
                } else {
                    ProxyPanel.this.usernamePanel.setEnabled(false);
                    ProxyPanel.this.passwordPanel.setEnabled(false);
                    ProxyPanel.this.usernamePanel.setText("");
                    ProxyPanel.this.passwordPanel.setText("");
                }
            }
        });
        this.usernamePanel = new TextPanel(panelContainer, object, "user", ASAF.getSetting("proxyUsername"), 100, this.requireAuthPanel.isSelected());
        this.passwordPanel = new TextPanel(panelContainer, object, "password", ASAF.getSetting("proxyPassword"), 100, this.requireAuthPanel.isSelected());
        this.add(this.usernamePanel);
        this.add(this.passwordPanel);
    }

    @Override
    public void saveObjects() {
        String string = this.typePanel.getSelectedItem().toString();
        ASAF.setSetting("proxyType", string);
        String string2 = this.hostPanel.getText();
        String string3 = this.portPanel.getText();
        final String string4 = this.usernamePanel.getText();
        final String string5 = this.passwordPanel.getText();
        if (string.equals("HTTP")) {
            ASAF.setSetting("httpProxyHost", string2);
            ASAF.setSetting("httpProxyPort", string3);
            System.setProperty("http.proxyHost", string2);
            System.setProperty("http.proxyPort", string3);
            System.setProperty("https.proxyHost", string2);
            System.setProperty("https.proxyPort", string3);
        } else if (string.equals("Socks")) {
            ASAF.setSetting("socksProxyHost", string2);
            ASAF.setSetting("socksProxyPort", string3);
            System.setProperty("socksProxyHost", string2);
            System.setProperty("socksProxyPort", string3);
        }
        ASAF.setSetting("proxyRequireAuth", Boolean.toString(this.requireAuthPanel.isSelected()));
        if (this.requireAuthPanel.isSelected()) {
            ASAF.setSetting("proxyUsername", string4);
            ASAF.setSetting("proxyPassword", string5);
            if (string.equals("HTTP")) {
                System.setProperty("http.proxyAuth", String.valueOf(string4) + ":" + string5);
            } else if (string.equals("Socks")) {
                System.setProperty("java.net.socks.username", string4);
                System.setProperty("java.net.socks.password", string5);
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(string4, string5 == null ? new char[]{} : string5.toCharArray());
                }
            });
        } else {
            ASAF.setSetting("proxyUsername", "");
            ASAF.setSetting("proxyPassword", "");
            Authenticator.setDefault(null);
        }
    }
}

