/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame.menu;

import bibliothek.gui.dock.common.SingleCDockable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.frame.FrameView;

public class ShowViewMenu
extends AppMenu {
    private static final long serialVersionUID = 5778585098933196602L;
    private FrameView frameView;
    private Map<String, JMenuItem> menuItemMap = new HashMap<String, JMenuItem>();
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            SingleCDockable singleCDockable = ShowViewMenu.this.frameView.getDockController().getSingleDockable(jMenuItem.getName());
            if (singleCDockable != null) {
                SwingUtilities.updateComponentTreeUI(singleCDockable.intern().getComponent());
                singleCDockable.setVisible(true);
                ShowViewMenu.this.frameView.getDockController().getController().setFocusedDockable(singleCDockable.intern(), true);
            }
        }
    };

    public ShowViewMenu(FrameView frameView) {
        this.frameView = frameView;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu.name", "showView");
        hashMap.put("menu.priority", 100);
        hashMap.put("menu.path", "window#900");
        this.activate(null, hashMap);
    }

    @Override
    public boolean isRemovable() {
        return true;
    }

    public void addView(AppView appView) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (appView == null || n == 3) {
            return;
        }
        this.menuItemMap.put(appView.getUniqueId(), this.addMenuItem(appView));
    }

    public void removeView(String string) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (n == 0 || n == 6 || n == 3) {
            return;
        }
        this.remove(this.menuItemMap.remove(string));
    }

    private JMenuItem addMenuItem(SingleCDockable singleCDockable) {
        JMenuItem jMenuItem = new JMenuItem(singleCDockable.intern().getTitleText());
        jMenuItem.setIcon(singleCDockable.intern().getTitleIcon());
        jMenuItem.setName(singleCDockable.getUniqueId());
        jMenuItem.addActionListener(this.listener);
        this.add(jMenuItem);
        return jMenuItem;
    }
}

