/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.frame.FrameView;

public class LookAndFeelMenu
extends AppMenu {
    private static final long serialVersionUID = 5778585098933196602L;
    private FrameView frameView;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
            try {
                ASAF.setSetting("Theme", jRadioButtonMenuItem.getName());
                UIManager.setLookAndFeel(jRadioButtonMenuItem.getName());
                SwingUtilities.updateComponentTreeUI(LookAndFeelMenu.this.frameView.getFrame());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    public LookAndFeelMenu(FrameView frameView) {
        this.frameView = frameView;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu.name", "lookAndFeel");
        hashMap.put("menu.priority", 900);
        hashMap.put("menu.path", "settings#800");
        this.activate(null, hashMap);
    }

    @Override
    public boolean isRemovable() {
        return true;
    }

    @Override
    public void initMenu() {
        this.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        String string = ASAF.getSetting("Theme", UIManager.getSystemLookAndFeelClassName());
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[n2];
            jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfo.getName());
            jRadioButtonMenuItem.setName(lookAndFeelInfo.getClassName());
            if (lookAndFeelInfo.getClassName().equals(string)) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(this.listener);
            buttonGroup.add(jRadioButtonMenuItem);
            this.add(jRadioButtonMenuItem);
            ++n2;
        }
    }
}

