/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import org.yaoqiang.asaf.Icons;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.task.TaskMonitor;

public class StatusBar
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4415004310575459801L;
    protected TaskMonitor taskMonitor;
    private int messageCount;
    private final JLabel p2pmessageLabel;
    private final Timer messageTimer;
    private JButton cancelButton;
    private final JLabel messageLabel;
    private final JProgressBar progressBar;
    private final JLabel statusAnimationLabel;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private final int busyAnimationRate = 30;
    private int busyIconIndex = 0;

    public StatusBar(TaskMonitor taskMonitor) {
        super(new BorderLayout());
        this.taskMonitor = taskMonitor;
        Dimension dimension = new Dimension(22, 15);
        this.p2pmessageLabel = new JLabel();
        this.p2pmessageLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.p2pmessageLabel.setMinimumSize(dimension);
        this.p2pmessageLabel.setMaximumSize(dimension);
        this.p2pmessageLabel.setPreferredSize(dimension);
        this.messageTimer = new Timer(800, new BlinkMessageIcon());
        this.createCancelTaskButton();
        this.messageLabel = new JLabel();
        Dimension dimension2 = new Dimension(50, 15);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setMinimumSize(dimension2);
        this.progressBar.setMaximumSize(dimension2);
        this.progressBar.setPreferredSize(dimension2);
        this.statusAnimationLabel = new JLabel();
        this.statusAnimationLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.idleIcon = ResourceMap.getImageIcon("idleIcon");
        int n = 0;
        while (n < this.busyIcons.length) {
            this.busyIcons[n] = ResourceMap.getImageIcon("busyIcons[" + n + "]");
            ++n;
        }
        this.busyIconTimer = new Timer(30, new UpdateBusyIcon());
        this.progressBar.setEnabled(false);
        this.progressBar.setVisible(false);
        this.statusAnimationLabel.setIcon(this.idleIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        dimension2 = new Dimension(320, 25);
        jPanel.setMinimumSize(dimension2);
        jPanel.setMaximumSize(dimension2);
        jPanel.setPreferredSize(dimension2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(new JSeparator(1));
        jPanel2.add(this.p2pmessageLabel);
        jPanel2.add(new JSeparator(1));
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.messageLabel);
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.progressBar);
        jPanel3.add(this.statusAnimationLabel);
        jPanel.add((Component)jPanel3, "East");
        this.add((Component)jPanel, "East");
        taskMonitor.addPropertyChangeListener(this);
    }

    public JLabel getP2PMessageLabel() {
        return this.p2pmessageLabel;
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string == null ? "" : string);
    }

    public void blinkMessage() {
        ++this.messageCount;
        this.p2pmessageLabel.setIcon(Icons.MESSAGE_ICON);
        this.p2pmessageLabel.setToolTipText(ResourceMap.getString("message.text", String.valueOf(this.messageCount)));
        if (!this.messageTimer.isRunning()) {
            this.messageTimer.start();
        }
    }

    public void stopBlinkMessage() {
        this.messageCount = 0;
        this.p2pmessageLabel.setIcon(null);
        this.p2pmessageLabel.setToolTipText(null);
        if (this.messageTimer.isRunning()) {
            this.messageTimer.stop();
        }
    }

    private void createCancelTaskButton() {
        Dimension dimension = new Dimension(25, 25);
        this.cancelButton = new JButton();
        this.cancelButton.setMinimumSize(dimension);
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setContentAreaFilled(false);
        this.cancelButton.setBorderPainted(false);
        this.cancelButton.setVisible(false);
        this.cancelButton.setRolloverEnabled(true);
        this.cancelButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -1853485340592900026L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.taskMonitor.getForegroundTask().cancel(true);
            }
        });
        this.cancelButton.getAction().putValue("SmallIcon", ResourceMap.getImageIcon("cancel.Button.icon"));
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                StatusBar.this.cancelButton.setBorderPainted(true);
                StatusBar.this.cancelButton.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                StatusBar.this.cancelButton.setBorderPainted(false);
                StatusBar.this.cancelButton.setContentAreaFilled(false);
            }
        });
    }

    public void showBusyAnimation() {
        if (!this.busyIconTimer.isRunning()) {
            this.statusAnimationLabel.setIcon(this.busyIcons[0]);
            this.busyIconIndex = 0;
            this.busyIconTimer.start();
        }
    }

    public void stopBusyAnimation() {
        this.busyIconTimer.stop();
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.setMessage("");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("started".equals(string)) {
            this.showBusyAnimation();
            this.progressBar.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.progressBar.setVisible(true);
            this.cancelButton.setVisible(true);
        } else if ("done".equals(string)) {
            this.stopBusyAnimation();
            this.progressBar.setIndeterminate(false);
            this.progressBar.setEnabled(false);
            this.progressBar.setValue(0);
            this.progressBar.setVisible(false);
            this.cancelButton.setVisible(false);
        } else if ("message".equals(string)) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            this.setMessage(string2);
        } else if ("progress".equals(string)) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.progressBar.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(n);
            this.progressBar.setVisible(true);
        }
    }

    class BlinkMessageIcon
    implements ActionListener {
        BlinkMessageIcon() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Icon icon = StatusBar.this.p2pmessageLabel.getIcon();
            if (icon == null) {
                StatusBar.this.p2pmessageLabel.setIcon(Icons.MESSAGE_ICON);
            } else {
                StatusBar.this.p2pmessageLabel.setIcon(null);
            }
        }
    }

    class UpdateBusyIcon
    implements ActionListener {
        UpdateBusyIcon() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusBar.this.busyIconIndex = (StatusBar.this.busyIconIndex + 1) % StatusBar.this.busyIcons.length;
            StatusBar.this.statusAnimationLabel.setIcon(StatusBar.this.busyIcons[StatusBar.this.busyIconIndex]);
        }
    }
}

