/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.task.Task;

public class SaveFileAction
extends AppAction {
    private static final long serialVersionUID = 3286844311379446571L;

    @Override
    public Task<?, ?> processAction(ActionEvent actionEvent) {
        File file;
        FileTab fileTab = ASAF.getSelectedFileTab();
        if (fileTab != null && (file = this.saveToFile(fileTab)) != null) {
            Utils.openFile(file);
        }
        return null;
    }

    public File saveToFile(FileTab fileTab) {
        Container container;
        Object object;
        String string = "";
        String string2 = null;
        if (SystemInfo.isMacOS()) {
            File file;
            object = fileTab.getFile().getName();
            if (((String)object).lastIndexOf(46) > 0) {
                string = ((String)object).substring(((String)object).lastIndexOf(46));
                object = ((String)object).substring(0, ((String)object).lastIndexOf(46));
            }
            container = new FileDialog(null, ResourceMap.getString("saveAs.Dialog.title", new String[0]), 1);
            ((FileDialog)container).setDirectory(fileTab.getFile().getParent());
            ((FileDialog)container).setFile((String)object);
            ((Dialog)container).setVisible(true);
            String string3 = ((FileDialog)container).getDirectory();
            String string4 = ((FileDialog)container).getFile();
            File file2 = file = string3 != null && string4 != null ? new File(String.valueOf(string3) + System.getProperty("file.separator") + string4) : null;
            if (file == null) {
                return null;
            }
            ASAF.setLastOpenDir(string3);
            if (!string.isEmpty() && !string4.toLowerCase().endsWith(string)) {
                string4 = String.valueOf(string4) + string;
            }
            if ((file = new File(String.valueOf(string3) + System.getProperty("file.separator") + string4)).exists() && this.showFileExistsDialog(fileTab, file) == null) {
                return null;
            }
            string2 = file.getAbsolutePath();
        } else {
            int n;
            object = fileTab.getAbsolutePath();
            if (fileTab.getFile().getName().lastIndexOf(46) > 0) {
                string = ((String)object).substring(((String)object).lastIndexOf(46));
                object = ((String)object).substring(0, ((String)object).lastIndexOf(46));
            }
            container = new JFileChooser(fileTab.getFile().getParentFile());
            ((JFileChooser)container).setSelectedFile(new File((String)object));
            if (!string.isEmpty()) {
                ((JFileChooser)container).setFileFilter(new DefaultFileFilter(string, String.valueOf(string.substring(1, string.length()).toUpperCase()) + " " + ResourceMap.getString("file.Label.text", new String[0]) + " (" + string + ")"));
            }
            if ((n = ((JFileChooser)container).showSaveDialog(null)) != 0) {
                return null;
            }
            ASAF.setLastOpenDir(((JFileChooser)container).getSelectedFile().getParent());
            string2 = this.getValidFileName(fileTab, (JFileChooser)container);
            if (string2 == null) {
                return null;
            }
        }
        if (fileTab.getFile().exists()) {
            fileTab.changeId();
        }
        object = new File(string2);
        fileTab.setFile((File)object);
        fileTab.initStyle();
        try {
            if (fileTab.setModified(false)) {
                ((File)object).createNewFile();
                fileTab.getTextEditorPane().saveAs(FileLocation.create((File)object));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        fileTab.closeTab();
        return object;
    }

    protected String getValidFileName(FileTab fileTab, JFileChooser jFileChooser) {
        String string = jFileChooser.getSelectedFile().getAbsolutePath();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (fileFilter instanceof DefaultFileFilter) {
            String string2 = ((DefaultFileFilter)fileFilter).getExtension();
            if (!string.toLowerCase().endsWith(string2)) {
                string = String.valueOf(string) + string2;
            }
        }
        if (new File(string).exists() && this.showFileExistsDialog(fileTab, new File(string)) == null) {
            return null;
        }
        return string;
    }

    protected String showFileExistsDialog(FileTab fileTab, File file) {
        if (fileTab.isFileExists(file)) {
            JOptionPane.showMessageDialog(null, ResourceMap.getString("cannotOverwrite.text", file.getAbsolutePath()), ResourceMap.getString("warning.Dialog.title", new String[0]), 2);
            return null;
        }
        if (JOptionPane.showConfirmDialog(null, ResourceMap.getString("replaceExistingFile.text", file.getAbsolutePath()), ASAF.getTitle(), 1) != 0) {
            return null;
        }
        return file.getAbsolutePath();
    }

    protected class DefaultFileFilter
    extends FileFilter {
        private String extension;
        private String description;

        public DefaultFileFilter(String string, String string2) {
            this.extension = string.toLowerCase();
            this.description = string2;
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName().toLowerCase();
            return file.isDirectory() || string.toLowerCase().endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

