/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CloseActionFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.editor.action.CopyAction;
import org.yaoqiang.asaf.editor.action.CutAction;
import org.yaoqiang.asaf.editor.action.DeleteAction;
import org.yaoqiang.asaf.editor.action.NewFileAction;
import org.yaoqiang.asaf.editor.action.OpenFileAction;
import org.yaoqiang.asaf.editor.action.PasteAction;
import org.yaoqiang.asaf.editor.action.PrintAction;
import org.yaoqiang.asaf.editor.action.RedoAction;
import org.yaoqiang.asaf.editor.action.ReloadAction;
import org.yaoqiang.asaf.editor.action.SaveAction;
import org.yaoqiang.asaf.editor.action.SaveAllAction;
import org.yaoqiang.asaf.editor.action.SaveAsAction;
import org.yaoqiang.asaf.editor.action.UndoAction;
import org.yaoqiang.asaf.editor.menu.RecentFileMenu;
import org.yaoqiang.asaf.editor.view.FileSystemView;
import org.yaoqiang.asaf.editor.view.NavigatorView;
import org.yaoqiang.asaf.frame.ComponentManager;
import org.yaoqiang.asaf.frame.MainToolBar;
import org.yaoqiang.asaf.frame.StatusBar;
import org.yaoqiang.asaf.frame.action.AboutAction;
import org.yaoqiang.asaf.frame.action.ExitAction;
import org.yaoqiang.asaf.frame.action.ProxyAction;
import org.yaoqiang.asaf.frame.action.ResetPerspectiveAction;
import org.yaoqiang.asaf.frame.action.SaveAsPerspectiveAction;
import org.yaoqiang.asaf.frame.action.WebServicePortAction;
import org.yaoqiang.asaf.frame.menu.DeletePerspectiveMenu;
import org.yaoqiang.asaf.frame.menu.LanguageMenu;
import org.yaoqiang.asaf.frame.menu.LookAndFeelMenu;
import org.yaoqiang.asaf.frame.menu.OpenPerspectiveMenu;
import org.yaoqiang.asaf.frame.menu.ShowViewMenu;
import org.yaoqiang.asaf.frame.theme.eclipse.EclipseThemeConnector;
import org.yaoqiang.asaf.frame.theme.eclipse.TabCloseAction;
import org.yaoqiang.asaf.frame.theme.eclipse.TabCloseButton;
import org.yaoqiang.asaf.frame.view.ConsoleView;

public class FrameView {
    private JFrame mainFrame;
    private CControl dockController;
    private CWorkingArea workingArea;
    private FileTab selectedFileTab;
    private Map<String, CPerspective> perspectives = new LinkedHashMap<String, CPerspective>();
    private Map<String, AppView> views = new ConcurrentHashMap<String, AppView>();
    private ComponentManager componentManager;
    private JToolBar toolBar;
    private StatusBar statusBar;

    public FrameView() {
        this.initMainFrame();
        this.initDockingController();
        this.initComponents();
    }

    private void initMainFrame() {
        this.mainFrame = new JFrame();
        this.mainFrame.setName("mainFrame");
        this.mainFrame.setTitle(ResourceMap.getString("App.title", new String[0]));
        this.mainFrame.setIconImage(ResourceMap.getImageIcon("App.icon").getImage());
        this.mainFrame.setDefaultCloseOperation(0);
        this.setFrameSize();
        this.setMenuBar(new JMenuBar());
        this.setToolBar(new MainToolBar());
        this.setStatusBar(this.createStatusBar());
    }

    private void setFrameSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 160;
        int n2 = 120;
        this.mainFrame.setBounds(n / 2, n2 / 2, dimension.width - n, dimension.height - n2);
    }

    private void initDockingController() {
        this.dockController = new CControl(this.mainFrame);
        this.dockController.setTheme("eclipse");
        this.dockController.putProperty(EclipseTheme.PAINT_ICONS_WHEN_DESELECTED, true);
        this.dockController.putProperty(EclipseTheme.THEME_CONNECTOR, new EclipseThemeConnector(this.dockController));
        this.dockController.getController().getActionViewConverter().putClient(TabCloseAction.FLAT_BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                TabCloseButton tabCloseButton = new TabCloseButton(basicButtonHandler, basicButtonHandler);
                tabCloseButton.setNormalBorder(null);
                tabCloseButton.setNormalSelectedBorder(null);
                tabCloseButton.setMouseOverBorder(null);
                tabCloseButton.setMouseOverSelectedBorder(null);
                tabCloseButton.setMousePressedBorder(null);
                tabCloseButton.setMousePressedSelectedBorder(null);
                basicButtonHandler.setModel(tabCloseButton.getModel());
                return basicButtonHandler;
            }
        });
        this.dockController.putProperty(CControl.CLOSE_ACTION_FACTORY, new CloseActionFactory(){

            @Override
            public CAction create(CControl cControl, CDockable cDockable) {
                return new TabCloseAction(cControl);
            }
        });
        final KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 192);
        final KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 128);
        this.dockController.addGlobalKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.processKeyEvent(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.processKeyEvent(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                this.processKeyEvent(keyEvent);
            }

            private void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.isConsumed()) {
                    return;
                }
                if (KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke) || KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke2)) {
                    FileTab fileTab;
                    FileTab fileTab2 = FrameView.this.getSelectedFileTab();
                    if (fileTab2 != null && (fileTab = fileTab2.getFileTab(KeyStroke.getKeyStrokeForEvent(keyEvent).equals(keyStroke2))) != null) {
                        fileTab.toFront();
                    }
                    keyEvent.consume();
                }
            }
        });
        this.workingArea = this.dockController.createWorkingArea("work");
        this.mainFrame.add(this.dockController.getContentArea());
        this.loadDockSettings();
    }

    private void loadDockSettings() {
        try {
            File file = new File(ASAF.PERSPECTIVES_FILE);
            if (file.exists()) {
                this.dockController.readXML(file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private StatusBar createStatusBar() {
        final StatusBar statusBar = new StatusBar(ASAF.getTaskMonitor());
        statusBar.getP2PMessageLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                statusBar.stopBlinkMessage();
                ASAF.fireViewEvent("openMessage", null);
                mouseEvent.consume();
            }
        });
        return statusBar;
    }

    private void initComponents() {
        this.componentManager = new ComponentManager(this);
        this.componentManager.addAction(new NewFileAction(this));
        this.componentManager.addAction(new OpenFileAction());
        this.componentManager.addAction(new SaveAction(this));
        this.componentManager.addAction(new SaveAsAction(this));
        this.componentManager.addAction(new SaveAllAction(this));
        this.componentManager.addAction(new ReloadAction(this));
        this.componentManager.addAction(new PrintAction(this));
        this.componentManager.addAction(new ExitAction(this));
        this.componentManager.addAction(new CutAction(this));
        this.componentManager.addAction(new CopyAction(this));
        this.componentManager.addAction(new PasteAction(this));
        this.componentManager.addAction(new DeleteAction(this));
        this.componentManager.addAction(new UndoAction(this));
        this.componentManager.addAction(new RedoAction(this));
        this.componentManager.addAction(new ProxyAction());
        this.componentManager.addAction(new WebServicePortAction());
        this.componentManager.addAction(new ResetPerspectiveAction(this));
        this.componentManager.addAction(new SaveAsPerspectiveAction(this));
        this.componentManager.addAction(new AboutAction());
        this.componentManager.addMenu(new LanguageMenu());
        this.componentManager.addMenu(new LookAndFeelMenu(this));
        this.componentManager.addMenu(new RecentFileMenu(this));
        this.componentManager.addMenu(new ShowViewMenu(this));
        this.componentManager.addMenu(new OpenPerspectiveMenu(this));
        this.componentManager.addMenu(new DeletePerspectiveMenu(this));
        NavigatorView navigatorView = new NavigatorView(this);
        this.componentManager.addView(navigatorView);
        ((ShowViewMenu)this.componentManager.getMenu("showView")).addView(navigatorView);
        FileSystemView fileSystemView = new FileSystemView(this);
        this.componentManager.addView(fileSystemView);
        ((ShowViewMenu)this.componentManager.getMenu("showView")).addView(fileSystemView);
        ConsoleView consoleView = new ConsoleView();
        this.componentManager.addView(consoleView);
        ((ShowViewMenu)this.componentManager.getMenu("showView")).addView(consoleView);
    }

    public void saveDockSettings() {
        try {
            this.dockController.save();
            this.dockController.writeXML(new File(ASAF.PERSPECTIVES_FILE));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    public void setFrameTitle(String string, File file) {
        this.mainFrame.setTitle(String.valueOf(string == null ? "" : String.valueOf(string) + " - ") + ASAF.getTitle());
        this.mainFrame.getRootPane().putClientProperty("Window.documentFile", file);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public CControl getDockController() {
        return this.dockController;
    }

    public CWorkingArea getWorkingArea() {
        return this.workingArea;
    }

    public String getCurrentPerspective() {
        return this.dockController.intern().getCurrentSetting();
    }

    public void saveCurrentPerspective(String string) {
        this.dockController.save(string);
        this.componentManager.getMenu("openPerspective").initMenu();
        this.componentManager.getMenu("deletePerspective").initMenu();
    }

    public void refreshCurrentPerspective() {
        String string = this.getCurrentPerspective();
        if (string != null) {
            this.loadPerspective();
        }
    }

    public void resetCurrentPerspective() {
        String string = this.getCurrentPerspective();
        CPerspective cPerspective = this.perspectives.get(string);
        if (cPerspective != null) {
            this.dockController.getPerspectives().setPerspective(string, cPerspective);
            this.loadPerspective(string);
        }
    }

    public void loadPerspective() {
        String string = this.getCurrentPerspective();
        if (string == null) {
            if (Boolean.getBoolean("asaf.yaoqiang")) {
                string = "Yaoqiang";
                if (this.dockController.getPerspectives().getPerspective(string) == null) {
                    string = "Default";
                }
            } else {
                string = "Default";
            }
            this.loadPerspective(string);
            this.componentManager.getMenu("openPerspective").initMenu();
        } else {
            this.loadPerspective(string);
        }
    }

    public void loadPerspective(String string) {
        this.dockController.load(string);
        try {
            UIManager.setLookAndFeel(ASAF.getSetting("Theme", UIManager.getSystemLookAndFeelClassName()));
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception2) {}
        }
        if (SystemInfo.isMacOS()) {
            UIManager.put("FileChooser.fileNameHeaderText", ResourceMap.getString("FileChooser.fileNameHeaderText", new String[0]));
            UIManager.put("FileChooser.fileSizeHeaderText", ResourceMap.getString("FileChooser.fileSizeHeaderText", new String[0]));
            UIManager.put("FileChooser.fileDateHeaderText", ResourceMap.getString("FileChooser.fileDateHeaderText", new String[0]));
            UIManager.put("FileChooser.upFolderToolTipText", ResourceMap.getString("FileChooser.upFolderToolTipText", new String[0]));
            UIManager.put("FileChooser.refreshActionLabelText", ResourceMap.getString("FileChooser.refreshActionLabelText", new String[0]));
            UIManager.put("FileChooser.newFolderActionLabelText", ResourceMap.getString("FileChooser.newFolderActionLabelText", new String[0]));
            UIManager.put("FileChooser.viewMenuLabelText", ResourceMap.getString("FileChooser.viewMenuLabelText", new String[0]));
            UIManager.put("FileChooser.listViewActionLabelText", ResourceMap.getString("FileChooser.listViewActionLabelText", new String[0]));
            UIManager.put("FileChooser.detailsViewActionLabelText", ResourceMap.getString("FileChooser.detailsViewActionLabelText", new String[0]));
        }
        SwingUtilities.updateComponentTreeUI(this.mainFrame);
    }

    public void addBuiltinPerspective(String string, CPerspective cPerspective) {
        this.perspectives.put(string, cPerspective);
        this.componentManager.getMenu("openPerspective").initMenu();
        this.componentManager.getMenu("deletePerspective").initMenu();
    }

    public void removeBuiltinPerspective(String string) {
        this.dockController.delete(string);
        this.perspectives.remove(string);
        this.componentManager.getMenu("openPerspective").initMenu();
        this.componentManager.getMenu("deletePerspective").initMenu();
        if (this.getCurrentPerspective() == null) {
            this.loadPerspective("Default");
        }
    }

    public CPerspective getBuiltinPerspective(String string) {
        return this.perspectives.get(string);
    }

    public void addView(final AppView appView) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FrameView.this.dockController.addDockable(appView);
                FrameView.this.views.put(appView.getUniqueId(), appView);
                if (!ASAF.isStarting()) {
                    FrameView.this.refreshCurrentPerspective();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void removeView(AppView appView) {
        this.dockController.removeDockable(appView);
        this.views.remove(appView.getUniqueId());
    }

    public DockStation getMainDockStation() {
        Dockable dockable;
        DockStation dockStation = ((CWorkingArea)this.dockController.getStation("work")).getStation();
        if (dockStation.getDockableCount() > 0 && (dockable = dockStation.getDockable(0)) instanceof StackDockStation) {
            dockStation = (StackDockStation)dockable;
        }
        return dockStation;
    }

    public FileTab getFileTab(File file) {
        DockStation dockStation = this.getMainDockStation();
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            FileTab fileTab;
            Dockable dockable = dockStation.getDockable(n);
            if (dockable instanceof CommonDockable && (fileTab = (FileTab)((CommonDockable)dockable).getDockable()).getFile().equals(file)) {
                return fileTab;
            }
            ++n;
        }
        return null;
    }

    public Set<FileTab> getModifiedTabs() {
        HashSet<FileTab> hashSet = new HashSet<FileTab>();
        DockStation dockStation = this.getMainDockStation();
        int n = 0;
        while (n < dockStation.getDockableCount()) {
            FileTab fileTab;
            Dockable dockable = dockStation.getDockable(n);
            if (dockable instanceof CommonDockable && (fileTab = (FileTab)((CommonDockable)dockable).getDockable()).isModified()) {
                hashSet.add(fileTab);
            }
            ++n;
        }
        return hashSet;
    }

    public boolean hasModifiedTabs() {
        return !this.getModifiedTabs().isEmpty();
    }

    public void closeAllFileTabs() {
        for (FileTab fileTab : this.getModifiedTabs()) {
            fileTab.closeTab();
        }
    }

    public boolean canExit() {
        boolean bl = true;
        for (FileTab fileTab : this.getModifiedTabs()) {
            boolean bl2 = fileTab.closeTab();
            if (bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void showFileTab(FileTab fileTab) {
        this.workingArea.show(fileTab);
        fileTab.toFront();
    }

    public FileTab getSelectedFileTab() {
        return this.selectedFileTab;
    }

    public void setSelectedFileTab(FileTab fileTab) {
        this.selectedFileTab = fileTab;
    }

    public JMenuBar getMenuBar() {
        return this.mainFrame.getJMenuBar();
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private JRootPane getRootPane() {
        return this.mainFrame.getRootPane();
    }

    public void setToolBar(JToolBar jToolBar) {
        this.toolBar = jToolBar;
        this.getRootPane().getContentPane().add((Component)jToolBar, "North");
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setJMenuBar(jMenuBar);
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
        this.getRootPane().getContentPane().add((Component)statusBar, "South");
    }

    public void addWindowListener(WindowListener windowListener) {
        this.mainFrame.addWindowListener(windowListener);
    }

    public void show() {
        Class<? extends FileTab> clazz;
        this.loadPerspective();
        FileTab fileTab = null;
        String string = ASAF.getLastOpenFile();
        File file = new File(string);
        if (!file.exists() || string.endsWith("LICENSE")) {
            file = new File(String.valueOf(ASAF.CACHE_DIR) + File.separator + "LICENSE");
            clazz = FrameView.class.getClassLoader().getResourceAsStream("META-INF/LICENSE");
            if (clazz != null) {
                Utils.savetoFile((InputStream)((Object)clazz), file);
            }
            if ((fileTab = ASAF.getFileTab(file)) == null && file.exists()) {
                fileTab = new FileTab(file, null, false);
                fileTab.getTextEditorPane().setEditable(false);
                fileTab.getTextEditorPane().setReadOnly(true);
            }
            file.delete();
        } else {
            fileTab = ASAF.getFileTab(file);
            if (fileTab == null) {
                clazz = Utils.getFileEditor(file);
                if (clazz != null) {
                    try {
                        fileTab = clazz.getConstructor(File.class, File.class, Boolean.TYPE).newInstance(file, null, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    fileTab = new FileTab(file, null, true);
                }
            }
        }
        if (fileTab != null && fileTab.getControl() == null) {
            ASAF.showFileTab(fileTab);
        }
        ASAF.setSelectedFileTab(fileTab);
        clazz = new Runnable(){

            @Override
            public void run() {
                FrameView.this.mainFrame.setVisible(true);
                FrameView.this.mainFrame.toFront();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            clazz.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)((Object)clazz));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void close() {
        this.closeAllFileTabs();
        this.saveDockSettings();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FrameView.this.mainFrame.setVisible(false);
                if (Boolean.getBoolean("asaf.standalone")) {
                    FrameView.this.mainFrame.dispose();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

