/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.frame;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.frame.FrameView;
import org.yaoqiang.asaf.frame.ToolBarButton;

public class ComponentManager {
    private Map<String, AppAction> actionMap = new HashMap<String, AppAction>();
    private Map<String, SortedSet<AppAction>> actionGroupMap = new HashMap<String, SortedSet<AppAction>>();
    private Map<String, AppMenu> menuMap = new HashMap<String, AppMenu>();
    private Map<String, JMenuItem> menuItemMap = new HashMap<String, JMenuItem>();
    private Map<String, ToolBarButton> actionButtonMap = new HashMap<String, ToolBarButton>();
    private Map<String, AppView> viewMap = new ConcurrentHashMap<String, AppView>();
    private FrameView frameView;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getNewValue();
            Set<AppAction> set = ComponentManager.this.getGroupActions(string);
            if (set != null) {
                for (AppAction serializable : set) {
                    serializable.forwardEvent(propertyChangeEvent);
                }
            }
            for (AppMenu appMenu : ComponentManager.this.menuMap.values()) {
                appMenu.processEvent(propertyChangeEvent);
            }
        }
    };
    private PropertyChangeListener viewListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (AppView appView : ComponentManager.this.viewMap.values()) {
                appView.processEvent(propertyChangeEvent);
            }
        }
    };

    public ComponentManager(FrameView frameView) {
        this.frameView = frameView;
    }

    public void addAction(AppAction appAction) {
        JMenuItem jMenuItem;
        AbstractButton abstractButton;
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (n == 3) {
            return;
        }
        appAction.addEventListener(this.listener);
        this.actionMap.put(appAction.getActionName(), appAction);
        String string = appAction.getActionGroup();
        SortedSet<AppAction> sortedSet = this.actionGroupMap.get(string);
        if (sortedSet == null) {
            sortedSet = new TreeSet<AppAction>(new Comparator<AppAction>(){

                @Override
                public int compare(AppAction appAction, AppAction appAction2) {
                    return appAction.getActionMenuPriority() - appAction2.getActionMenuPriority();
                }
            });
            this.actionGroupMap.put(string, sortedSet);
        }
        sortedSet.add(appAction);
        if (appAction.getActionToolBarPriority() > 0) {
            abstractButton = new ToolBarButton(appAction);
            this.actionButtonMap.put(appAction.getActionName(), (ToolBarButton)abstractButton);
            appAction.addToToolBar((ToolBarButton)abstractButton, this.frameView.getToolBar());
        }
        if ((abstractButton = appAction.getParentMenu()) == null) {
            return;
        }
        if (!this.menuMap.containsValue(abstractButton)) {
            this.menuMap.put(((AppMenu)abstractButton).getMenuName(), (AppMenu)abstractButton);
        } else {
            jMenuItem = this.menuMap.get(((AppMenu)abstractButton).getMenuName());
            if (jMenuItem.getText().endsWith(".Menu.text")) {
                jMenuItem.setText(abstractButton.getText());
                ((AppMenu)jMenuItem).setMenuPriority(((AppMenu)abstractButton).getMenuPriority());
            }
            abstractButton = jMenuItem;
            appAction.setParentMenu((AppMenu)abstractButton);
        }
        jMenuItem = ((AppMenu)abstractButton).insert(appAction);
        this.menuItemMap.put(appAction.getActionName(), jMenuItem);
        this.insertMenu((AppMenu)abstractButton);
    }

    public void removeAction(AppAction appAction) {
        AppMenu appMenu;
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (n == 0 || n == 6 || n == 3) {
            return;
        }
        this.actionMap.remove(appAction.getActionName());
        Set set = this.actionGroupMap.get(appAction.getActionGroup());
        if (set != null) {
            set.remove(appAction);
        }
        if (appAction.getActionToolBarPriority() > 0) {
            appAction.removeFromToolBar(this.actionButtonMap.remove(appAction.getActionName()), this.frameView.getToolBar());
        }
        if ((appMenu = appAction.getParentMenu()) == null) {
            return;
        }
        appMenu.remove(this.menuItemMap.remove(appAction.getActionName()));
        appMenu.removeSeparators(appAction.getMenuSeparators());
        this.removeMenu(appMenu);
    }

    public void addMenu(AppMenu appMenu) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (n == 3) {
            return;
        }
        appMenu.addEventListener(this.listener);
        if (!this.menuMap.containsValue(appMenu)) {
            this.menuMap.put(appMenu.getMenuName(), appMenu);
        } else {
            AppMenu appMenu2 = this.menuMap.get(appMenu.getMenuName());
            if (appMenu2.getText().endsWith(".Menu.text")) {
                appMenu2.setText(appMenu.getText());
                appMenu2.setMenuPriority(appMenu.getMenuPriority());
            }
            appMenu = appMenu2;
        }
        this.insertMenu(appMenu);
    }

    public void removeMenu(AppMenu appMenu) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (n == 0 || n == 6 || n == 3) {
            return;
        }
        AppMenu appMenu2 = appMenu.getParentMenu();
        while (appMenu2 != null && appMenu.isRemovable()) {
            appMenu2.remove(this.menuMap.remove(appMenu.getMenuName()));
            appMenu = appMenu2;
            appMenu2 = appMenu2.getParentMenu();
        }
        if (appMenu2 == null && appMenu.isRemovable()) {
            this.menuMap.remove(appMenu.getMenuName());
            appMenu.removeFromMenuBar(this.frameView.getMenuBar());
        }
    }

    public void addView(AppView appView) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (appView == null || this.viewMap.containsKey(appView.getUniqueId()) || n == 3) {
            return;
        }
        appView.addEventListener(this.listener);
        appView.addViewEventListener(this.viewListener);
        this.viewMap.put(appView.getUniqueId(), appView);
        this.frameView.addView(appView);
    }

    public void removeView(AppView appView) {
        int n = Integer.getInteger("asaf.shutdown.mode", -1);
        if (appView == null || n == 0 || n == 6 || n == 3) {
            return;
        }
        this.viewMap.remove(appView.getUniqueId());
        this.frameView.removeView(appView);
    }

    private void insertMenu(AppMenu appMenu) {
        AppMenu appMenu2 = appMenu.getParentMenu();
        while (appMenu2 != null) {
            if (this.menuMap.containsValue(appMenu2)) {
                AppMenu appMenu3 = this.menuMap.get(appMenu2.getMenuName());
                if (appMenu3.getText().endsWith(".Menu.text")) {
                    appMenu3.setText(appMenu2.getText());
                    appMenu3.setMenuPriority(appMenu2.getMenuPriority());
                }
                appMenu2 = appMenu3;
                appMenu.setParentMenu(appMenu2);
                appMenu2.insert(appMenu);
                break;
            }
            this.menuMap.put(appMenu2.getMenuName(), appMenu2);
            appMenu2.insert(appMenu);
            appMenu = appMenu2;
            appMenu2 = appMenu2.getParentMenu();
        }
        if (appMenu2 == null) {
            appMenu.addToMenuBar(this.frameView.getMenuBar());
        }
    }

    public void refreshActions() {
        for (AppAction appAction : this.actionMap.values()) {
            appAction.reactivate();
        }
    }

    public void refreshMenus() {
        for (AppMenu appMenu : this.menuMap.values()) {
            appMenu.reactivate();
        }
    }

    public void refreshViews() {
        for (AppView appView : this.viewMap.values()) {
            appView.reactivate();
        }
    }

    public AppAction getAction(String string) {
        return this.actionMap.get(string);
    }

    public Set<AppAction> getGroupActions(String string) {
        return this.actionGroupMap.get(string);
    }

    public AppMenu getMenu(String string) {
        return this.menuMap.get(string);
    }

    public PropertyChangeListener getListener() {
        return this.listener;
    }

    public PropertyChangeListener getViewListener() {
        return this.viewListener;
    }
}

