/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.view.filesystem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.yaoqiang.asaf.ASAF;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;

public class FileExplorerUI
extends BasicFileChooserUI {
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilePane filePane;
    private JTable table;
    private boolean useShellFolder;
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 300;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 200;
    private static int MIN_HEIGHT = 226;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 300;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    static final int space = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FileExplorerUI((JFileChooser)jComponent);
    }

    public FileExplorerUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setBorder(new EmptyBorder(5, 0, 0, 0));
        jFileChooser.setLayout(new BorderLayout(0, 5));
        this.filePane = new FilePane(new MetalFileChooserUIAccessor());
        jFileChooser.addPropertyChangeListener(this.filePane);
        this.updateUseShellFolder();
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel.add((Component)jPanel2, "After");
        jFileChooser.add((Component)jPanel, "North");
        this.directoryComboBox = new JComboBox(){
            private static final long serialVersionUID = 3281594296225170330L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 150;
                return dimension;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.putClientProperty("AccessibleName", this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(3));
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        jFileChooser.add((Component)this.filePane, "Center");
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = bl != null ? bl.booleanValue() : jFileChooser.getFileSystemView().equals(FileSystemView.getFileSystemView());
    }

    public FilePane getFilePane() {
        return this.filePane;
    }

    public JTable getFileTable() {
        return this.table;
    }

    @Override
    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        JPanel jPanel = this.filePane.createDetailsView();
        this.table = FileExplorerUI.findJTable(jPanel.getComponents());
        return jPanel;
    }

    private static final JTable findJTable(Component[] componentArray) {
        int n = 0;
        while (n < componentArray.length) {
            JTable jTable;
            if (componentArray[n] instanceof JTable) {
                return (JTable)componentArray[n];
            }
            if (componentArray[n] instanceof Container && (jTable = FileExplorerUI.findJTable(((Container)componentArray[n]).getComponents())) != null) {
                return jTable;
            }
            ++n;
        }
        return null;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filePane);
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = FileExplorerUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < FileExplorerUI.PREF_SIZE.height ? FileExplorerUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, FileExplorerUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() || jFileChooser.isDirectorySelectionEnabled() && jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.clearIconCache();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            ASAF.setLastOpenDir(file.getAbsolutePath());
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    FileExplorerUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    FileExplorerUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    FileExplorerUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    FileExplorerUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    FileExplorerUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    FileExplorerUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileExplorerUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    FileExplorerUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileExplorerUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    FileExplorerUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                } else if (string == "FileChooser.useShellFolder") {
                    FileExplorerUI.this.updateUseShellFolder();
                    FileExplorerUI.this.doDirectoryChanged(propertyChangeEvent);
                } else {
                    string.equals("ancestor");
                }
            }
        };
    }

    @Override
    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.filePane.ensureFileIsVisible(jFileChooser, file);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -7944586319290024623L;

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileExplorerUI.this.directoryComboBox.hidePopup();
            File file = (File)FileExplorerUI.this.directoryComboBox.getSelectedItem();
            if (!FileExplorerUI.this.getFileChooser().getCurrentDirectory().equals(file)) {
                FileExplorerUI.this.getFileChooser().setCurrentDirectory(file);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -4899465339479988141L;
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser;
        FileSystemView fsv;

        public DirectoryComboBoxModel() {
            this.chooser = FileExplorerUI.this.getFileChooser();
            this.fsv = this.chooser.getFileSystemView();
            File file = FileExplorerUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            File[] fileArray = FileExplorerUI.this.useShellFolder ? AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return (File[])ShellFolder.get("fileChooserComboBoxFolders");
                }
            }) : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = ShellFolder.getNormalizedFile(file);
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = FileExplorerUI.this.useShellFolder ? ShellFolder.getShellFolder(file2) : file2;
                Vector<File> vector = new Vector<File>(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    file4 = (File)vector.get(n2);
                    if (this.directories.contains(file4)) {
                        int n3 = this.directories.indexOf(file4);
                        int n4 = n2 - 1;
                        while (n4 >= 0) {
                            this.directories.insertElementAt((File)vector.get(n4), n3 + n2 - n4);
                            --n4;
                        }
                        break;
                    }
                    ++n2;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int n = 0;
            while (n < this.depths.length) {
                File file = this.directories.get(n);
                File file2 = file.getParentFile();
                this.depths[n] = 0;
                if (file2 != null) {
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        if (file2.equals(this.directories.get(n2))) {
                            this.depths[n] = this.depths[n2] + 1;
                            break;
                        }
                        --n2;
                    }
                }
                ++n;
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -2253737319188137916L;
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(FileExplorerUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = FileExplorerUI.this.getFileChooser().getIcon(file);
            this.ii.depth = FileExplorerUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.ii);
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.icon != null) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
                } else {
                    this.icon.paintIcon(component, graphics, n, n2);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon == null ? 0 : this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon == null ? 0 : this.icon.getIconHeight();
        }
    }

    private class MetalFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private MetalFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return FileExplorerUI.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return FileExplorerUI.this.getModel();
        }

        @Override
        public JPanel createList() {
            return FileExplorerUI.this.createList(this.getFileChooser());
        }

        @Override
        public JPanel createDetailsView() {
            return FileExplorerUI.this.createDetailsView(this.getFileChooser());
        }

        @Override
        public boolean isDirectorySelected() {
            return FileExplorerUI.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return FileExplorerUI.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return FileExplorerUI.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return FileExplorerUI.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return FileExplorerUI.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList jList) {
            return FileExplorerUI.this.createDoubleClickListener(this.getFileChooser(), jList);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return FileExplorerUI.this.createListSelectionListener(this.getFileChooser());
        }

        public boolean usesShellFolder() {
            return FileExplorerUI.this.useShellFolder;
        }
    }
}

