/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.view.filesystem;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.plaf.ComponentUI;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.editor.action.OpenFileAction;
import org.yaoqiang.asaf.editor.view.filesystem.FileExplorerUI;

public class FileExplorer
extends JFileChooser {
    private static final long serialVersionUID = 8335790440663266352L;
    private FileExplorerUI ui;

    public FileExplorer() {
        super(ASAF.getLastOpenDir());
        this.setDragEnabled(true);
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(true);
        this.ui.getFilePane().getViewTypeAction(1).actionPerformed(null);
    }

    @Override
    public FileExplorerUI getUI() {
        return this.ui;
    }

    @Override
    public final void setUI(ComponentUI componentUI) {
        super.setUI(this.ui == null ? (this.ui = new FileExplorerUI(this)) : this.ui);
    }

    @Override
    public void approveSelection() {
        File[] fileArray = this.getSelectedFiles();
        ((OpenFileAction)ASAF.getAction("open")).openFiles(fileArray);
        this.ui.getFileTable().clearSelection();
        this.setSelectedFiles(fileArray);
        if (fileArray != null && fileArray.length > 0) {
            ASAF.setLastOpenFile(fileArray[fileArray.length - 1].getAbsolutePath());
        }
        ASAF.setLastOpenDir(this.getCurrentDirectory().getAbsolutePath());
    }
}

