/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.view;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.yaoqiang.asaf.AppView;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.editor.view.filesystem.FileExplorer;
import org.yaoqiang.asaf.frame.FrameView;

public class FileSystemView
extends AppView {
    private FileExplorer fileExplorer;
    private SimpleSelectableAction linkButton;
    private FrameView frameView;

    public FileSystemView(FrameView frameView) {
        super("filesystem");
        this.frameView = frameView;
        this.activate(null, null);
    }

    @Override
    public void processEvent(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        if (object != null) {
            if ("selectFile".equals(object.toString()) && this.linkButton.isSelected()) {
                this.fileExplorer.setSelectedFile((File)propertyChangeEvent.getNewValue());
            } else if ("started".equals(object.toString())) {
                SwingUtilities.invokeLater(new Thread("Init FileSystem View"){

                    @Override
                    public void run() {
                        FileSystemView.this.fileExplorer.getUI().getFilePane().getViewTypeAction(1).actionPerformed(null);
                    }
                });
            }
        }
    }

    @Override
    public void initView() {
        this.getContentPane().removeAll();
        DefaultDockActionSource defaultDockActionSource = new DefaultDockActionSource(new LocationHint(LocationHint.DOCKABLE, LocationHint.LEFT), new DockAction[0]);
        defaultDockActionSource.add(this.createLinkButtonAction());
        defaultDockActionSource.addSeparator();
        this.intern().setActionOffers(defaultDockActionSource);
        this.fileExplorer = new FileExplorer();
        this.add(this.fileExplorer);
    }

    private SimpleSelectableAction createLinkButtonAction() {
        this.linkButton = new SimpleSelectableAction.Check();
        this.linkButton.setText(ResourceMap.getString("linkEditor.Action.text", new String[0]));
        this.linkButton.setIcon(ResourceMap.getImageIcon("linkEditor.Action.icon"));
        this.linkButton.setEnabled(true);
        this.linkButton.addSelectableListener(new SelectableDockActionListener(){

            @Override
            public void selectedChanged(SelectableDockAction selectableDockAction, Set<Dockable> set) {
                FileTab fileTab;
                if (FileSystemView.this.linkButton.isSelected() && (fileTab = FileSystemView.this.frameView.getSelectedFileTab()) != null) {
                    FileSystemView.this.fileExplorer.setSelectedFile(fileTab.getFile());
                }
            }
        });
        return this.linkButton;
    }
}

