/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.frame.FrameView;

public class RecentFileMenu
extends AppMenu {
    private static final long serialVersionUID = 5778585098933196602L;
    private FrameView frameView;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getName();
            if (!new File(string).exists()) {
                JOptionPane.showMessageDialog(null, ResourceMap.getString("fileNotExist.text", string), ASAF.getTitle(), 2);
                RecentFileMenu.this.removeRecentFiletoList(string);
                return;
            }
            File file = new File(string);
            ASAF.setLastOpenDir(file.getParent());
            ASAF.setLastOpenFile(file.getAbsolutePath());
            FileTab fileTab = RecentFileMenu.this.frameView.getFileTab(file);
            if (fileTab == null) {
                Class<? extends FileTab> clazz = Utils.getFileEditor(file);
                if (clazz != null) {
                    try {
                        fileTab = clazz.getConstructor(File.class).newInstance(file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    fileTab = new FileTab(file);
                }
                RecentFileMenu.this.frameView.showFileTab(fileTab);
            }
            fileTab.toFront();
            RecentFileMenu.this.frameView.setFrameTitle(string, file);
            RecentFileMenu.this.addFiletoRecentOpenList(file.getAbsolutePath());
        }
    };

    public RecentFileMenu(FrameView frameView) {
        this.frameView = frameView;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("menu.name", "recentFiles");
        hashMap.put("menu.priority", 880);
        hashMap.put("menu.path", "file#100");
        this.activate(null, hashMap);
    }

    @Override
    public boolean isRemovable() {
        return true;
    }

    @Override
    public void initMenu() {
        this.removeAll();
        int n = 0;
        for (String string : Utils.getRecentFileList()) {
            this.addMenuItem(String.valueOf(n++) + ": " + string, string);
        }
    }

    private JMenuItem addMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setName(string2);
        jMenuItem.addActionListener(this.listener);
        this.add(jMenuItem);
        return jMenuItem;
    }

    public void addFiletoRecentOpenList(String string) {
        JMenuItem jMenuItem;
        int n = 0;
        while (n < this.getMenuComponentCount()) {
            jMenuItem = (JMenuItem)this.getMenuComponent(n);
            if (string.equals(jMenuItem.getName())) {
                this.remove(n);
            }
            ++n;
        }
        if (Utils.getRecentFileList().size() == 10) {
            this.remove(this.getMenuComponentCount() - 1);
        }
        JMenuItem jMenuItem2 = new JMenuItem("0: " + string);
        jMenuItem2.setName(string);
        jMenuItem2.setToolTipText(new File(string).getName());
        jMenuItem2.addActionListener(this.listener);
        this.insert(jMenuItem2, 0);
        int n2 = 0;
        while (n2 < this.getMenuComponentCount()) {
            jMenuItem = (JMenuItem)this.getMenuComponent(n2);
            jMenuItem.setText(String.valueOf(n2) + ": " + jMenuItem.getName());
            ++n2;
        }
        Utils.saveRecentFiles(this);
    }

    private void removeRecentFiletoList(String string) {
        JMenuItem jMenuItem;
        int n = 0;
        while (n < this.getMenuComponentCount()) {
            jMenuItem = (JMenuItem)this.getMenuComponent(n);
            if (string.equals(jMenuItem.getName())) {
                this.remove(n);
            }
            ++n;
        }
        n = 0;
        while (n < this.getMenuComponentCount()) {
            jMenuItem = (JMenuItem)this.getMenuComponent(n);
            jMenuItem.setText(String.valueOf(n) + ": " + jMenuItem.getName());
            ++n;
        }
        Utils.saveRecentFiles(this);
    }
}

