/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.Sides;
import javax.swing.JOptionPane;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.frame.FrameView;
import org.yaoqiang.asaf.task.Task;

public class PrintAction
extends AppAction {
    private static final long serialVersionUID = 3286844311379446571L;
    private FrameView frameView;

    public PrintAction(FrameView frameView) {
        this.frameView = frameView;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("action.name", "print");
        hashMap.put("action.group", "file");
        hashMap.put("action.menu.priority", 800);
        hashMap.put("action.menu.path", "file#100");
        hashMap.put("action.menu.separator", "#790::#810");
        hashMap.put("action.toolbar.priority", 300);
        hashMap.put("action.toolbar.separator", "#310");
        this.activate(null, hashMap);
    }

    @Override
    public boolean isEnabled() {
        FileTab fileTab = this.frameView.getSelectedFileTab();
        return fileTab != null && fileTab.isSavable();
    }

    @Override
    public Task<?, ?> processAction(ActionEvent actionEvent) {
        FileTab fileTab = this.frameView.getSelectedFileTab();
        TextEditorPane textEditorPane = fileTab.getTextEditorPane();
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new JobName(textEditorPane.getFileFullPath(), null));
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(Sides.ONE_SIDED);
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, null);
        if (printServiceArray == null || printServiceArray.length == 0) {
            JOptionPane.showMessageDialog(null, ResourceMap.getString("errorNoPrintServices.text", new String[0]), ResourceMap.getString("error.Dialog.title", new String[0]), 0);
            return null;
        }
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService printService2 = ServiceUI.printDialog(null, 200, 200, printServiceArray, printService, sERVICE_FORMATTED, hashPrintRequestAttributeSet);
        if (printService2 != null) {
            DocPrintJob docPrintJob = printService2.createPrintJob();
            SimpleDoc simpleDoc = new SimpleDoc(textEditorPane, sERVICE_FORMATTED, null);
            try {
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
            }
            catch (PrintException printException) {
                printException.printStackTrace();
            }
        }
        return null;
    }
}

