/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf.editor.action;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.ResourceMap;
import org.yaoqiang.asaf.SystemInfo;
import org.yaoqiang.asaf.Utils;
import org.yaoqiang.asaf.task.Task;

public class OpenFileAction
extends AppAction {
    private static final long serialVersionUID = 3286844311379446571L;

    public OpenFileAction() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("action.name", "open");
        hashMap.put("action.group", "file");
        hashMap.put("action.menu.priority", 200);
        hashMap.put("action.menu.path", "file#100");
        hashMap.put("action.toolbar.priority", 150);
        this.activate(null, hashMap);
    }

    @Override
    public Task<?, ?> processAction(ActionEvent actionEvent) {
        File file = null;
        if (SystemInfo.isMacOS()) {
            FileDialog fileDialog = new FileDialog(null, ResourceMap.getString("open.Dialog.title", new String[0]));
            fileDialog.setDirectory(ASAF.getLastOpenDir());
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            File file2 = file = string != null && string2 != null ? new File(String.valueOf(string) + System.getProperty("file.separator") + string2) : null;
            if (file != null) {
                ASAF.setLastOpenDir(string);
                this.openFiles(new File[]{file});
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser(ASAF.getLastOpenDir());
            jFileChooser.setMultiSelectionEnabled(true);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                ASAF.setLastOpenDir(file.getParent());
                this.openFiles(jFileChooser.getSelectedFiles());
            }
        }
        if (file != null) {
            ASAF.setLastOpenFile(file.getAbsolutePath());
        }
        return null;
    }

    public void openFiles(File[] fileArray) {
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.isFile()) {
                Utils.openFile(file);
            }
            ++n2;
        }
    }
}

