/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.AppAction;
import org.yaoqiang.asaf.AppMenu;
import org.yaoqiang.asaf.Base64Encoder;
import org.yaoqiang.asaf.FileAssociations;
import org.yaoqiang.asaf.FileTab;
import org.yaoqiang.asaf.Icons;
import org.yaoqiang.asaf.frame.MenuSeparator;
import org.yaoqiang.asaf.frame.ToolBarButton;
import org.yaoqiang.asaf.frame.ToolBarSeparator;

public class Utils {
    public static <T> T getService(BundleContext bundleContext, Class<T> clazz) {
        if (bundleContext == null) {
            return null;
        }
        ServiceReference<?> serviceReference = bundleContext.getServiceReference(clazz.getName());
        if (serviceReference == null) {
            return null;
        }
        try {
            Object obj = bundleContext.getService(serviceReference);
            return (T)obj;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public static Properties loadASAFProperties(Properties properties, String string) {
        return Utils.loadProperties(properties, new File(String.valueOf(ASAF.ASAF_USER_HOME) + File.separator + string));
    }

    public static void saveASAFProperties(Properties properties, String string) {
        Utils.saveProperties(properties, new File(String.valueOf(ASAF.ASAF_USER_HOME) + File.separator + string), "ASAF Configuration");
    }

    private static Properties loadProperties(Properties properties, File file) {
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return properties;
    }

    private static void saveProperties(Properties properties, File file, String string) {
        block12: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (fileOutputStream == null) break block12;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    public static Document parseXml(InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getItemInsertPosition(Container container, int n) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        while (n3 < container.getComponentCount()) {
            Component component = container.getComponent(n3);
            if (component instanceof AppMenu) {
                if (n <= ((AppMenu)component).getMenuPriority()) {
                    n2 = n3;
                    break;
                }
            } else if (component instanceof JMenuItem) {
                AppAction appAction = (AppAction)((JMenuItem)component).getAction();
                if (n <= appAction.getActionMenuPriority()) {
                    n2 = n3;
                    break;
                }
            } else if (component instanceof MenuSeparator) {
                if (n <= ((MenuSeparator)component).getPriority()) {
                    n2 = n3;
                    break;
                }
            } else if (component instanceof ToolBarButton) {
                if (n <= ((ToolBarButton)component).getButtonPriority()) {
                    n2 = n3;
                    break;
                }
            } else if (component instanceof ToolBarSeparator && n <= ((ToolBarSeparator)component).getPriority()) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public static AppMenu parseMenuPath(String string) {
        AppMenu appMenu = null;
        if (string != null) {
            String string2 = null;
            int n = 999;
            String[] stringArray = string.split("::");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray[n3];
                int n4 = string3.lastIndexOf(35);
                if (n4 > 0) {
                    string2 = string3.substring(0, n4);
                    n = Integer.parseInt(string3.substring(n4 + 1));
                } else {
                    string2 = string3;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("menu.name", string2);
                hashMap.put("menu.priority", n);
                appMenu = new AppMenu(appMenu, hashMap);
                n = 999;
                ++n3;
            }
        }
        return appMenu;
    }

    public static void saveRecentFiles(JMenu jMenu) {
        try {
            String string = "";
            int n = 0;
            while (n < jMenu.getMenuComponentCount()) {
                JMenuItem jMenuItem = (JMenuItem)jMenu.getMenuComponent(n);
                string = String.valueOf(string) + jMenuItem.getText().substring(3);
                if (n < jMenu.getItemCount() - 1) {
                    string = String.valueOf(string) + "\n";
                }
                ++n;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(ASAF.ASAF_USER_HOME) + File.separator + ".filelist");
            fileOutputStream.write(string.getBytes("UTF8"));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
    }

    public static void saveASAFFileList(Collection<String> collection, String string) {
        try {
            String string2 = "";
            for (String object2 : collection) {
                string2 = String.valueOf(string2) + object2;
                string2 = String.valueOf(string2) + "\n";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(ASAF.ASAF_USER_HOME) + File.separator + string);
            fileOutputStream.write(string2.getBytes("UTF8"));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
    }

    public static List<String> getRecentFileList() {
        return Utils.getASAFFileList(".filelist");
    }

    private static List<String> getASAFFileList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = Utils.getFileString(String.valueOf(ASAF.ASAF_USER_HOME) + File.separator + string);
        if (string2 != null && string2.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    private static String getFileString(String string) {
        String string2 = new String("");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            if (n > 0) {
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                string2 = new String(byArray, "UTF8");
            }
            fileInputStream.close();
        }
        catch (Exception exception) {}
        return string2;
    }

    public static Class<? extends FileTab> getFileEditor(File file) {
        Class<? extends FileTab> clazz = null;
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            if ("xml".equalsIgnoreCase(string2)) {
                string2 = Utils.guessXmlFileType(file);
            }
            clazz = FileAssociations.getEditor(string2);
        }
        return clazz;
    }

    public static Icon getFileIcon(File file) {
        Icon icon = null;
        String string = null;
        String string2 = "";
        String string3 = file.getName();
        int n = string3.lastIndexOf(46);
        if (n != -1) {
            string2 = string3.substring(string3.lastIndexOf(46) + 1);
            string = FileAssociations.getEditorStyle(string2);
            icon = FileAssociations.getEditorIcon(string2);
        }
        if (string == null) {
            string = Utils.guessFileStyle(file);
        }
        if ("text/xml".equals(string)) {
            if ("xml".equalsIgnoreCase(string2) && Utils.isAntFile(file)) {
                icon = FileAssociations.getEditorIcon("ant");
            } else {
                if (!file.exists()) {
                    icon = FileAssociations.getEditorIcon("repo_xml");
                }
                if (icon == null) {
                    icon = FileAssociations.getEditorIcon("xml");
                }
            }
        }
        return icon == null ? Icons.FILE_ICON : icon;
    }

    public static String guessFileStyle(File file) {
        String string = null;
        if (file.length() > 0L) {
            try {
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                if (string2 != null && string2.startsWith("<?xml")) {
                    string = "text/xml";
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static String guessXmlFileType(File file) {
        String string = null;
        if (file.length() > 0L) {
            try {
                Document document = Utils.parseXml(new FileInputStream(file));
                String string2 = document.getDocumentElement().getNamespaceURI();
                string = FileAssociations.getXMLType(string2);
                if (string == null) {
                    string = "xml";
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static boolean isAntFile(File file) {
        if (file.length() > 0L) {
            try {
                String string;
                Document document = Utils.parseXml(new FileInputStream(file));
                if (document != null && (string = document.getDocumentElement().getNodeName()).equals("project")) {
                    return true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return false;
    }

    public static String getAppDir() {
        File file = new File(System.getProperty("java.class.path")).getParentFile();
        String string = "";
        string = file != null && file.isDirectory() ? file.getAbsolutePath() : System.getProperty("user.dir");
        return string;
    }

    public static void deleteDirectory(File file) {
        if (file == null) {
            return;
        }
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray2[n2];
                    if (file2.isDirectory()) {
                        Utils.deleteDirectory(file2);
                    } else {
                        file2.delete();
                    }
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            long l = 0L;
            long l2 = ((FileChannel)abstractInterruptibleChannel).size();
            while ((l += ((FileChannel)abstractInterruptibleChannel2).transferFrom((ReadableByteChannel)((Object)abstractInterruptibleChannel), l, l2 - l)) < l2) {
            }
        }
        finally {
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
            if (abstractInterruptibleChannel2 != null) {
                abstractInterruptibleChannel2.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static FileTab openFile(File file) {
        Class<? extends FileTab> clazz;
        FileTab fileTab = ASAF.getFileTab(file);
        if (fileTab == null) {
            clazz = Utils.getFileEditor(file);
            if (clazz != null) {
                try {
                    fileTab = clazz.getConstructor(File.class).newInstance(file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                fileTab = new FileTab(file);
            }
            if (fileTab != null) {
                ASAF.showFileTab(fileTab);
            }
        }
        if (fileTab != null) {
            fileTab.toFront();
            clazz = file.getAbsolutePath();
            ASAF.setFrameTitle((String)((Object)clazz), file);
            ASAF.addtoRecentFileList((String)((Object)clazz));
        }
        return fileTab;
    }

    public static void openURL(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URL(string).toURI());
            }
            catch (Exception exception) {}
        }
    }

    public static void savetoFile(InputStream inputStream, File file) {
        byte[] byArray = new byte[4096];
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                int n = 0;
                while ((n = inputStream.read(byArray)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                try {
                    filterOutputStream.close();
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
        }
        finally {
            try {
                filterOutputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void setProxyAuth(URLConnection uRLConnection) throws IOException {
        String string = ASAF.getSetting("proxyUsername");
        String string2 = ASAF.getSetting("proxyPassword");
        String string3 = System.getProperty("http.proxyAuth");
        if (Boolean.parseBoolean(ASAF.getSetting("proxyRequireAuth")) && (string3 == null || string3.length() == 0)) {
            string3 = String.valueOf(string) + ":" + string2;
        }
        if (string3 != null && string3.length() > 0 && ("http".equals(uRLConnection.getURL().getProtocol()) || "https".equals(uRLConnection.getURL().getProtocol()))) {
            String string4 = Base64Encoder.base64Encode(String.valueOf(string) + ":" + string2);
            uRLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string4);
        }
    }

    /*
     * Loose catch block
     */
    public static boolean download(String string, String string2) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setConnectTimeout(5000);
        Utils.setProxyAuth(httpURLConnection);
        String string3 = httpURLConnection.getHeaderField("Location");
        while (string3 != null) {
            httpURLConnection = (HttpURLConnection)new URL(string3).openConnection();
            httpURLConnection.setConnectTimeout(5000);
            Utils.setProxyAuth(httpURLConnection);
            string3 = httpURLConnection.getHeaderField("Location");
        }
        int n = httpURLConnection.getContentLength();
        System.out.println("Downloading update, size: " + n);
        inputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        outputStream = new BufferedOutputStream(new FileOutputStream(string2));
        byte[] byArray = new byte[4096];
        int n2 = inputStream.read(byArray);
        while (n2 > 0) {
            outputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    public static SOAPMessage invokeWebService(String string, SOAPMessage sOAPMessage) {
        SOAPMessage sOAPMessage2 = null;
        SOAPConnection sOAPConnection = null;
        try {
            try {
                SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
                sOAPConnection = sOAPConnectionFactory.createConnection();
                URL uRL = new URL(string);
                sOAPMessage2 = sOAPConnection.call(sOAPMessage, (Object)uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    sOAPConnection.close();
                }
                catch (SOAPException sOAPException) {
                    sOAPException.printStackTrace();
                }
            }
        }
        finally {
            try {
                sOAPConnection.close();
            }
            catch (SOAPException sOAPException) {
                sOAPException.printStackTrace();
            }
        }
        return sOAPMessage2;
    }

    public static SOAPMessage createSOAPMessage(Document document) {
        SOAPMessage sOAPMessage = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            sOAPMessage = messageFactory.createMessage();
            sOAPMessage.getSOAPBody().addDocument(document);
            sOAPMessage.saveChanges();
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
        return sOAPMessage;
    }

    public static void htmlize(JComponent jComponent) {
        Utils.htmlize(jComponent, UIManager.getFont("Button.font"));
    }

    public static void htmlize(JComponent jComponent, Font font) {
        String string = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}";
        try {
            HTMLDocument hTMLDocument = null;
            if (jComponent instanceof JEditorPane) {
                if (((JEditorPane)jComponent).getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)((JEditorPane)jComponent).getDocument();
                }
            } else {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null && view.getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)view.getDocument();
                }
            }
            if (hTMLDocument != null) {
                hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

