/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.yaoqiang.asaf.StaticAction;
import org.yaoqiang.asaf.StaticActions;

public class StaticActionMap {
    private static Set<StaticActions> actionsClass = new HashSet<StaticActions>();
    private static Map<String, StaticAction> actionMap = new HashMap<String, StaticAction>();

    public static void addActions(StaticActions staticActions) {
        actionsClass.add(staticActions);
        Method[] methodArray = staticActions.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().endsWith("Action")) {
                String string = method.getName().substring(0, method.getName().lastIndexOf("Action"));
                StaticAction staticAction = new StaticAction(string, staticActions, method);
                actionMap.put(string, staticAction);
            }
            ++n2;
        }
    }

    public static void removeActions(StaticActions staticActions) {
        actionsClass.remove(staticActions);
        Method[] methodArray = staticActions.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().endsWith("Action")) {
                String string = method.getName().substring(0, method.getName().lastIndexOf("Action"));
                actionMap.remove(string);
            }
            ++n2;
        }
    }

    public static void resetActions() {
        for (StaticActions staticActions : actionsClass) {
            StaticActionMap.addActions(staticActions);
        }
    }

    public static StaticAction getAction(String string) {
        return actionMap.get(string);
    }

    public static Set<StaticActions> getActions() {
        return actionsClass;
    }

    public static Action createAction(String string, String string2) {
        return StaticActionMap.createAction(string, string2, null, null);
    }

    public static Action createAction(String string, String string2, Object object) {
        return StaticActionMap.createAction(string, string2, null, object);
    }

    public static Action createAction(String string, String string2, Icon icon, final Object object) {
        final StaticAction staticAction = actionMap.get(string);
        AbstractAction abstractAction = new AbstractAction(string2, icon){
            private static final long serialVersionUID = 4009748074399794382L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                staticAction.actionPerformed(new ActionEvent(object == null ? actionEvent.getSource() : object, actionEvent.getID(), actionEvent.getActionCommand()));
            }
        };
        abstractAction.putValue("ShortDescription", string2);
        return abstractAction;
    }
}

