/*
 * Decompiled with CFR 0.152.
 */
package org.yaoqiang.asaf;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.yaoqiang.asaf.ASAF;
import org.yaoqiang.asaf.SystemInfo;

public class ResourceMap {
    private static LinkedList<ResourceBundle> bundles = new LinkedList();
    private static Hashtable<String, ResourceBundle> bundleCache = new Hashtable();
    private static Hashtable<String, ClassLoader> classLoaders = new Hashtable();
    private static Hashtable<String, ImageIcon> imageCache = new Hashtable();
    private static Hashtable<String, ImageIcon> iconCache = new Hashtable();

    public static void add(String string) {
        ResourceMap.add(string, ResourceMap.class.getClassLoader());
    }

    public static void add(String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = PropertyResourceBundle.getBundle(string, ASAF.getLocale(), classLoader);
        bundles.remove(bundleCache.remove(string));
        bundles.addFirst(resourceBundle);
        bundleCache.put(string, resourceBundle);
        String string2 = string.replace('.', '/');
        string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
        classLoaders.put(string2, classLoader);
    }

    public static void remove(String string) {
        String string2 = string.replace('.', '/');
        string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
        classLoaders.remove(string2);
        ResourceBundle resourceBundle = bundleCache.remove(string);
        bundles.remove(resourceBundle);
    }

    public static Image getImage(String string) {
        ImageIcon imageIcon = ResourceMap.getImageIcon(string, false);
        return imageIcon == null ? null : imageIcon.getImage();
    }

    public static ImageIcon getImageIcon(String string) {
        return ResourceMap.getImageIcon(string, true);
    }

    public static ImageIcon getImageIcon(String string, boolean bl) {
        ImageIcon object = null;
        String string2 = ResourceMap.getString(string, new String[0]);
        object = imageCache.get(string2);
        if (object == null) {
            for (Map.Entry<String, ClassLoader> object2 : classLoaders.entrySet()) {
                URL uRL = object2.getValue().getResource(string2);
                if (uRL == null) {
                    uRL = object2.getValue().getResource(String.valueOf(object2.getKey()) + string2);
                }
                if (uRL == null) continue;
                object = new ImageIcon(uRL);
                imageCache.put(string2, object);
            }
        }
        if (object != null && bl && (object.getIconWidth() > 18 || object.getIconHeight() > 18)) {
            ImageIcon imageIcon = iconCache.get(string2);
            if (imageIcon == null) {
                object = new ImageIcon(object.getImage().getScaledInstance(18, 18, 0));
                iconCache.put(string2, object);
            } else {
                object = imageIcon;
            }
        }
        return object;
    }

    public static KeyStroke getKeyStroke(String string) {
        String string2 = ResourceMap.getResource(string);
        if (string2 == null) {
            return null;
        }
        String string3 = "shortcut";
        String string4 = "meta";
        String string5 = "control";
        String string6 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? string4 : string5;
        Pattern pattern = Pattern.compile(string3);
        if (string2.contains(string3)) {
            string2 = pattern.matcher(string2).replaceFirst(string6);
        }
        if (string2.equals("DELETE")) {
            if (SystemInfo.isMacOS()) {
                return KeyStroke.getKeyStroke("BACK_SPACE");
            }
            return KeyStroke.getKeyStroke("DELETE");
        }
        return KeyStroke.getKeyStroke(string2);
    }

    public static String getString(String string, String ... stringArray) {
        int n;
        int n2;
        StringBuffer stringBuffer;
        String string2 = ResourceMap.getResource(string);
        if (string2 == null) {
            return string;
        }
        if (string2 != null) {
            stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n2 = string2.indexOf("${", n3)) != -1) {
                if (n2 == 0 || n2 > 0 && string2.charAt(n2 - 1) != '\\') {
                    n = string2.indexOf("}", n2);
                    if (n == -1 || n <= n2 + 2) break;
                    String string3 = string2.substring(n2 + 2, n);
                    String string4 = ResourceMap.getString(string3, new String[0]);
                    stringBuffer.append(string2.substring(n3, n2));
                    if (string4 == null) {
                        string2 = "";
                        break;
                    }
                    stringBuffer.append(string4);
                    n3 = n + '\u0001';
                    continue;
                }
                stringBuffer.append(string2.substring(n3, n2 - 1));
                stringBuffer.append("${");
                n3 = n2 + 2;
            }
            stringBuffer.append(string2.substring(n3));
            string2 = stringBuffer.toString();
        }
        if (string2 != null && stringArray != null) {
            stringBuffer = new StringBuffer();
            String string5 = null;
            n2 = 0;
            while (n2 < string2.length()) {
                n = string2.charAt(n2);
                if (n == 123) {
                    string5 = "";
                } else if (string5 != null && n == 125) {
                    int n4 = Integer.parseInt(string5);
                    if (n4 >= 0 && n4 < stringArray.length) {
                        stringBuffer.append(stringArray[n4]);
                    }
                    string5 = null;
                } else if (string5 != null) {
                    string5 = String.valueOf(string5) + (char)n;
                } else {
                    stringBuffer.append((char)n);
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static String getResource(String string) {
        for (ResourceBundle resourceBundle : bundles) {
            if (!resourceBundle.containsKey(string)) continue;
            return resourceBundle.getString(string);
        }
        return null;
    }

    public static void refresh() {
        bundles.clear();
        HashSet<String> hashSet = new HashSet<String>(bundleCache.keySet());
        bundleCache.clear();
        for (String string : hashSet) {
            String string2 = string.replace('.', '/');
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            ResourceBundle resourceBundle = PropertyResourceBundle.getBundle(string, ASAF.getLocale(), classLoaders.get(string2));
            bundles.add(resourceBundle);
            bundleCache.put(string, resourceBundle);
        }
    }
}

